:userdoc.
:docprof toc=123456.

:title.LaTeX help 1.1
:h1.-Preface-
:p.:parml tsize=30 break=none compact.
:pt.:link reftype=hd refid=hd2.License:elink.:pd.Licensing information.
:pt.:link reftype=hd refid=hd3.Overview:elink.:pd.What is LaTeX?
:pt.:link reftype=hd refid=hd4.Commands:elink.:pd.Commands within a LaTeX document.
:pt.:link reftype=hd refid=hd5.Parameters:elink.:pd.The command line.

also available&dot.&dot.&dot.

:pt.:link reftype=hd refid=hd6.List of Commands:elink.:pd.An alphabetical list of all LaTex commands.
:pt.:link reftype=hd refid=hd7.Index:elink.:pd.An alphabetical "Concept Index".

:eparml.

:h1 id=hd2.Licensing Information
:lm margin=1.
:p.  The programs currently being distributed that relate to Texinfo
include two portions of GNU Emacs, plus two other separate programs
(:font facename=Courier size=12x8.texindex:font facename=default size=0x0. and :font facename=Courier size=12x8.texinfo.tex:font facename=default size=0x0.).  These programs are
:hp1.free:ehp1.; this means that everyone is free to use them and free to
redistribute them on a free basis.  The Texinfo related programs are not
in the public domain; they are copyrighted and there are restrictions on
their distribution, but these restrictions are designed to permit
everything that a good cooperating citizen would want to do.  What is
not allowed is to try to prevent others from further sharing any version
of these programs that they might get from you.
:p.  Specifically, we want to make sure that you have the right to give
away copies of the programs that relate to Texinfo, that you receive
source code or else can get it if you want it, that you can change these
programs or use pieces of them in new free programs, and that you know
you can do these things.
:p.  To make sure that everyone has such rights, we have to forbid you to
deprive anyone else of these rights.  For example, if you distribute
copies of the Texinfo related programs, you must give the recipients all
the rights that you have.  You must make sure that they, too, receive or
can get the source code.  And you must tell them their rights.
:p.  Also, for our own protection, we must make certain that everyone finds
out that there is no warranty for the programs that relate to Texinfo.
If these programs are modified by someone else and passed on, we want
their recipients to know that what they have is not what we distributed,
so that any problems introduced by others will not reflect on our
reputation.
:p.  The precise conditions of the licensees for the programs currently
being distributed that relate to Texinfo are found in the General Public
Licensees that accompany them.  The programs that are part of GNU Emacs
are covered by the GNU Emacs copying terms (see Section  of :hp1.The GNU Emacs Manual:ehp1.), 
and other programs are covered by licensees that are contained in their
source files.
:h1 id=hd3.Overview of LaTeX and Local Guide
:lm margin=1.
:p.The LaTeX command typesets a file of text using the TeX program and the
LaTeX Macro package for TeX.  To be more specific, it processes an input
file containing the text of a document with interspersed commands that
describe how the text should be formatted.  It produces at least three
files as output&colon.

:ol.:li.
A "Device Independent", or :font facename=Courier size=12x8.&apos..dvi&apos.:font facename=default size=0x0. file. This contains commands that
can be translated into commands for a variety of output devices.  You
can view the output of LaTeX by using a program such as :font facename=Courier size=12x8.xdvi:font facename=default size=0x0.,
which actually uses the :font facename=Courier size=12x8.&apos..dvi&apos.:font facename=default size=0x0. file.
:li.A "transcript" or :font facename=Courier size=12x8.&apos..log&apos.:font facename=default size=0x0. file that contains summary information and
diagnostic messages for any errors discovered in the input file.
:li.An "auxiliary" or :font facename=Courier size=12x8.&apos..aux&apos.:font facename=default size=0x0. file. This is used by LaTeX itself, for
things such as sectioning.

:eol.:lm margin=1.
:p.For a description of what goes on inside TeX, you should consult
:hp1.The TeX book:ehp1. by Donald E. Knuth, ISBN 0-201-13448-9, published
jointly by the American Mathematical Society and Addison-Wesley
Publishing Company.
:p.For a description of LaTeX, you should consult&colon.
:p.:hp1.LaTeX&colon. A Document Preparation System:ehp1., by Leslie Lamport, ISBN
0-201-15790-X, published jointly by the American Mathematical Society
and Addison-Wesley Publishing Company, 1985.
:p.:hp1.LaTeX for Engineers &amp. Scientists:ehp1., by David J. Buerger, ISBN
0-07-008845-4, McGraw-Hill, 1990.
:p.:hp1.The LaTeX Cookbook:ehp1., by F. Teagle, Informatics Department,
Rutherford Appelton Laboratory, Chilton, Didcot, Oxon, OX11 0QX, 1991.
:p.:hp1.LaTeX for Everyone:ehp1., by Jane Hahn, available from PCTeX in
California, and from the TeX Users Group, 1991.
:p.:hp1.LaTeX Line by Line&colon. Tips and Techniques for Document Processing:ehp1.
by Antoni Diller, Chichester&colon. John Wiley and Sons, 1992.
:p.:hp1.A Guide to LaTeX:ehp1., by Helmut Kopka and Patrick Daly,
Addison-Wesley, 1992.
:h1 id=hd4.Commands
:lm margin=1.
:p.A LaTeX command begins with the command name, which consists of a
:font facename=Courier size=12x8.\:font facename=default size=0x0. followed by either (a) a string of letters or (b) a single
non-letter.  Arguments contained in square brackets, :font facename=Courier size=12x8.[]:font facename=default size=0x0., are
optional while arguments contained in braces, :font facename=Courier size=12x8.{}:font facename=default size=0x0., are required.
:p.NOTE&colon.  LaTeX  is case sensitive.   Enter  all commands  in lower  case
unless explicitly directed to do otherwise.
:p.:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd8.Counters:elink.:pd.Information on internal counters.
:pt.:link reftype=hd refid=hd9.Cross References:elink.:pd.Automatic referencing.
:pt.:link reftype=hd refid=hd10.Definitions:elink.:pd.Define your own commands etc.
:pt.:link reftype=hd refid=hd11.Document Styles:elink.:pd.Some of the various styles available.
:pt.:link reftype=hd refid=hd12.Environments:elink.:pd.Such as enumerate &amp. itemize.
:pt.:link reftype=hd refid=hd13.Footnotes:elink.:pd.How to produce footnotes.
:pt.:link reftype=hd refid=hd14.Lengths:elink.:pd.The length commands.
:pt.:link reftype=hd refid=hd15.Letters:elink.:pd.The letter style.
:pt.:link reftype=hd refid=hd16.Line &amp. Page Breaking:elink.:pd.How do insert pagebreaks etc.
:pt.:link reftype=hd refid=hd17.Making Paragraphs:elink.:pd.Paragraph commands.
:pt.:link reftype=hd refid=hd18.Math Formulae:elink.:pd.How to create mathematical formulae.
:pt.:link reftype=hd refid=hd19.Modes:elink.:pd.Paragraph, Math or LR modes.
:pt.:link reftype=hd refid=hd20.Page Styles:elink.:pd.Various styles of page layout.
:pt.:link reftype=hd refid=hd21.Sectioning:elink.:pd.How to section properly.
:pt.:link reftype=hd refid=hd22.Spaces &amp. Boxes:elink.:pd.All the associated commands.
:pt.:link reftype=hd refid=hd23.Special Characters:elink.:pd.Special reserved characters.
:pt.:link reftype=hd refid=hd24.Splitting the Input:elink.:pd.Dealing with big files by splitting.
:pt.:link reftype=hd refid=hd25.Starting &amp. Ending:elink.:pd.The formal start &amp. end layouts.
:pt.:link reftype=hd refid=hd26.Table of Contents:elink.:pd.How to create a table of contents.
:pt.:link reftype=hd refid=hd27.Terminal Input/Output:elink.:pd.User interaction.
:pt.:link reftype=hd refid=hd28.Typefaces:elink.:pd.Such as bold, italics etc.

:eparml.
:h2 id=hd8.Counters
:lm margin=1.
:p.Everything LaTeX numbers for you has a counter associated with it. The
name of the counter is the same as the name of the environment or
command that produces the number, except with no :font facename=Courier size=12x8.\:font facename=default size=0x0..  (enumi -
enumiv are used for the nested enumerate environment.)  Below is a list
of the counters used in LaTeX 's standard document styles to control
numbering.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 part            paragraph       figure          enumi
 chapter         subparagraph    table           enumii
 section         page            footnote        enumiii
 subsection      equation        mpfootnote      enumiv
 subsubsection
:font facename=default size=0x0.:lm margin=1.:elines.
:p.:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd29.\addtocounter:elink.:pd.
:pt.:link reftype=hd refid=hd30.\alph:elink.:pd.
:pt.:link reftype=hd refid=hd31.\arabic:elink.:pd.
:pt.:link reftype=hd refid=hd32.\fnsymbol:elink.:pd.
:pt.:link reftype=hd refid=hd33.\newcounter:elink.:pd.
:pt.:link reftype=hd refid=hd34.\roman:elink.:pd.
:pt.:link reftype=hd refid=hd35.\setcounter:elink.:pd.
:pt.:link reftype=hd refid=hd36.\usecounter:elink.:pd.
:pt.:link reftype=hd refid=hd37.\value:elink.:pd.

:eparml.
:h3 id=hd29.\addtocounter
:lm margin=1.
:p.:font facename=Courier size=12x8.\addtocounter{counter}{value}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\addtocounter:font facename=default size=0x0. command increments the :font facename=Courier size=12x8.counter:font facename=default size=0x0. by the
amount specified by the :font facename=Courier size=12x8.value:font facename=default size=0x0. argument.  The :font facename=Courier size=12x8.value:font facename=default size=0x0.
argument can be negative.
:h3 id=hd30.\alph
:lm margin=1.
:p.:font facename=Courier size=12x8.\alph{counter}:font facename=default size=0x0.
:p.This command causes the value of the :font facename=Courier size=12x8.counter:font facename=default size=0x0. to be printed in
alphabetic characters.  The :font facename=Courier size=12x8.\alph:font facename=default size=0x0. command causes lower case
alphabetic alphabetic characters, i.e., :font facename=Courier size=12x8.a, b, c&dot.&dot.&dot.:font facename=default size=0x0. while the
:font facename=Courier size=12x8.\Alph:font facename=default size=0x0. command causes upper case alphabetic characters, i.e.,
:font facename=Courier size=12x8.A, B, C&dot.&dot.&dot.:font facename=default size=0x0..
:h3 id=hd31.\arabic
:lm margin=1.
:p.:font facename=Courier size=12x8.\arabic{counter}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\arabic:font facename=default size=0x0. command causes the value of the :font facename=Courier size=12x8.counter:font facename=default size=0x0. to be
printed in arabic numbers, i.e., :font facename=Courier size=12x8.3:font facename=default size=0x0..
:h3 id=hd32.\fnsymbol
:lm margin=1.
:p.:font facename=Courier size=12x8.\fnsymbol{counter}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\fnsymbol:font facename=default size=0x0. command causes the value of the :font facename=Courier size=12x8.counter:font facename=default size=0x0. to
be printed in a specific sequence of nine symbols that can be used for
numbering footnotes.
:p.eg. From 1-9&colon.:artwork name='fnsymbol.BMP' runin.
:p.NB. :font facename=Courier size=12x8.counter:font facename=default size=0x0. must have a value between 1 and 9 inclusive.
:h3 id=hd33.\newcounter
:lm margin=1.
:p.:font facename=Courier size=12x8.\newcounter{foo}[counter]:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\newcounter:font facename=default size=0x0. command defines a new counter named :font facename=Courier size=12x8.foo:font facename=default size=0x0..
The optional argument :font facename=Courier size=12x8.[counter]:font facename=default size=0x0. causes the counter :font facename=Courier size=12x8.foo:font facename=default size=0x0. to
be reset whenever the counter named in the optional argument is
incremented.
:h3 id=hd34.\roman
:lm margin=1.
:p.:font facename=Courier size=12x8.\roman{counter}:font facename=default size=0x0.
:p.This command causes the value of the :font facename=Courier size=12x8.counter:font facename=default size=0x0. to be printed in
roman numerals.  The :font facename=Courier size=12x8.\roman:font facename=default size=0x0. command causes lower case roman
numerals, i.e., :font facename=Courier size=12x8.i, ii, iii&dot.&dot.&dot.:font facename=default size=0x0., while the :font facename=Courier size=12x8.\Roman:font facename=default size=0x0. command
causes upper case roman numerals, i.e., :font facename=Courier size=12x8.I, II, III&dot.&dot.&dot.:font facename=default size=0x0..
:h3 id=hd35.\setcounter
:lm margin=1.
:p.:font facename=Courier size=12x8.\setcounter{counter}{value}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\setcounter:font facename=default size=0x0. command sets the value of the :font facename=Courier size=12x8.counter:font facename=default size=0x0. to
that specified by the :font facename=Courier size=12x8.value:font facename=default size=0x0. argument.
:h3 id=hd36.\usecounter
:lm margin=1.
:p.:font facename=Courier size=12x8.\usecounter{counter}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\usecounter:font facename=default size=0x0. command is used in the second argument of the
:font facename=Courier size=12x8.list:font facename=default size=0x0. environment to allow the counter specified to be used to
number the list items.
:h3 id=hd37.\value
:lm margin=1.
:p.:font facename=Courier size=12x8.\value{counter}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\value:font facename=default size=0x0. command produces the value of the :font facename=Courier size=12x8.counter:font facename=default size=0x0. named
in the mandatory argument.  It can be used where LaTeX expects an
integer or number, such as the second argument of a :font facename=Courier size=12x8.\setcounter:font facename=default size=0x0.
or :font facename=Courier size=12x8.\addtocounter:font facename=default size=0x0. command, or in&colon.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
        \hspace{\value{foo}\parindent}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.It is useful for doing arithmetic with counters.
:h2 id=hd9.Cross References
:lm margin=1.
:p.One reason for numbering things like figures and equations is to refer
the reader to them, as in "See Figure 3 for more details."
:p.:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd38.\label:elink.:pd.
:pt.:link reftype=hd refid=hd39.\pageref:elink.:pd.
:pt.:link reftype=hd refid=hd40.\ref:elink.:pd.
:eparml.
:h3 id=hd38.\label
:lm margin=1.
:p.:font facename=Courier size=12x8.\label{key}:font facename=default size=0x0.
:p.A :font facename=Courier size=12x8.\label:font facename=default size=0x0. command appearing in ordinary text assigns to the
:font facename=Courier size=12x8.key:font facename=default size=0x0. the number of the current sectional unit; one appearing
inside a numbered environment assigns that number to the :font facename=Courier size=12x8.key:font facename=default size=0x0..
:p.A :font facename=Courier size=12x8.key:font facename=default size=0x0. can consist of any sequence of letters, digits, or
punctuation characters.  Upper and lowercase letters are different.
:h3 id=hd39.\pageref
:lm margin=1.
:p.:font facename=Courier size=12x8.\pageref{key}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\pageref:font facename=default size=0x0. command produces the page number of the place in the
text where the corresponding :font facename=Courier size=12x8.\label:font facename=default size=0x0. command appears. ie. where
:font facename=Courier size=12x8.\label{key}:font facename=default size=0x0. appears.

:h3 id=hd40.\ref
:lm margin=1.
:p.:font facename=Courier size=12x8.\ref{key}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\ref:font facename=default size=0x0. command produces the number of the sectional unit,
equation number, &dot.&dot.&dot. of the corresponding :font facename=Courier size=12x8.\label:font facename=default size=0x0. command.
:h2 id=hd10.Definitions
:lm margin=1.
:p.:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd41.\newcommand:elink.:pd.
:pt.:link reftype=hd refid=hd42.\newenvironment:elink.:pd.
:pt.:link reftype=hd refid=hd43.\newtheorem:elink.:pd.
:pt.:link reftype=hd refid=hd44.\newfont:elink.:pd.
:eparml.
:h3 id=hd41.\newcommand
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \newcommand{cmd}[args]{def}
 \renewcommand{cmd}[args]{def}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.These commands define (or redefine) a command.

:parml break=fit.:pt.:font facename=Courier size=12x8.cmd:font facename=default size=12x8.:pd.
A command name beginning with a :font facename=Courier size=12x8.\:font facename=default size=0x0..  For :font facename=Courier size=12x8.\newcommand:font facename=default size=0x0. it
must not be already defined and must not begin with :font facename=Courier size=12x8.\end:font facename=default size=0x0.; for
:font facename=Courier size=12x8.\renewcommand:font facename=default size=0x0. it must already be defined.
:pt.:font facename=Courier size=12x8.args:font facename=default size=12x8.:pd.An integer from 1 to 9 denoting the number of arguments of the command
being defined.  The default is for the command to have no arguments.
:pt.:font facename=Courier size=12x8.def:font facename=default size=12x8.:pd.The text to be substituted for every occurrence of :font facename=Courier size=12x8.cmd:font facename=default size=0x0.; a
parameter of the form :font facename=Courier size=12x8.#n:font facename=default size=0x0. in :font facename=Courier size=12x8.cmd:font facename=default size=0x0. is replaced by the text of
the nth argument when this substitution takes place.

:eparml.:lm margin=1.
:h3 id=hd42.\newenvironment
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \newenvironment{nam}[args]{begdef}{enddef}
 \renewenvironment{nam}[args]{begdef}{enddef}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.These commands define or redefine an environment.

:parml break=fit.:pt.:font facename=Courier size=12x8.nam:font facename=default size=12x8.:pd.
The name of the environment.  For :font facename=Courier size=12x8.\newenvironment:font facename=default size=0x0. there must be
no currently defined environment by that name, and the command
:font facename=Courier size=12x8.\nam:font facename=default size=0x0. must be undefined.  For :font facename=Courier size=12x8.\renewenvironment:font facename=default size=0x0. the
environment must already be defined.
:pt.:font facename=Courier size=12x8.args:font facename=default size=12x8.:pd.An integer from 1 to 9 denoting the number of arguments of
the newly-defined environment.  The default is no arguments.
:pt.:font facename=Courier size=12x8.begdef:font facename=default size=12x8.:pd.The text substituted for every occurrence of :font facename=Courier size=12x8.\begin{nam}:font facename=default size=0x0.; a
parameter of the form :font facename=Courier size=12x8.#n:font facename=default size=0x0. in :font facename=Courier size=12x8.cmd:font facename=default size=0x0. is replaced by the text of
the nth argument when this substitution takes place.
:pt.:font facename=Courier size=12x8.enddef:font facename=default size=12x8.:pd.The text substituted for every occurrence of :font facename=Courier size=12x8.\end{nam}:font facename=default size=0x0..  It may
not contain any argument parameters.

:eparml.:lm margin=1.
:h3 id=hd43.\newtheorem
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \newtheorem{env_name}{caption}[within]
 \newtheorem{env_name}[numbered_like]{caption}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.This command defines a theorem-like environment.

:parml break=fit.:pt.:font facename=Courier size=12x8.env_name:font facename=default size=12x8.:pd.
The name of the environment to be defined. A string of letters.  It must
not be the name of an existing environment or counter.
:pt.:font facename=Courier size=12x8.caption:font facename=default size=12x8.:pd.The text printed at the beginning of the environment, right before the
number. This may simply say "Theorem", for example.
:pt.:font facename=Courier size=12x8.within:font facename=default size=12x8.:pd.The name of an already defined counter, usually of a sectional unit.
Provides a means of resetting the new theorem counter :hp2.within:ehp2.
the sectional unit.
:pt.:font facename=Courier size=12x8.numbered_like:font facename=default size=12x8.:pd.The name of an already defined theorem-like environment.

:eparml.:lm margin=1.
:p.The :font facename=Courier size=12x8.\newtheorem:font facename=default size=0x0. command may have at most one optional argument.
:h3 id=hd44.\newfont
:lm margin=1.
:p.:font facename=Courier size=12x8.\newfont{cmd}{font_name}:font facename=default size=0x0.
:p.Defines the command name :font facename=Courier size=12x8.cmd:font facename=default size=0x0., which must not be currently
defined, to be a declaration that selects the font named
:font facename=Courier size=12x8.font_name:font facename=default size=0x0. to be the current font.
:h2 id=hd11.Document Styles
:lm margin=1.
:p.Valid LaTeX document styles include&colon.

:ul.:li.
article
:li.report
:li.letter
:li.book

:eul.:lm margin=1.
:p.Other document styles are often available. See :link reftype=hd refid=hd3.Overview:elink., for details.
They are selected with the following command&colon.
:p.:font facename=Courier size=12x8.\documentstyle [options] {style}:font facename=default size=0x0.
:p.The options for the different styles are&colon.

:ol.:li.
:font facename=Courier size=12x8.article:font facename=default size=0x0. - 11pt, 12pt, twoside, twocolumn, draft, fleqn, leqno, acm
:li.:font facename=Courier size=12x8.report:font facename=default size=0x0.  - 11pt, 12pt, twoside, twocolumn, draft, fleqn, leqno, acm
:li.:font facename=Courier size=12x8.letter:font facename=default size=0x0.  - 11pt, 12pt, fleqn,   leqno, acm
:li.:font facename=Courier size=12x8.book:font facename=default size=0x0.    - 11pt, 12pt, twoside, twocolumn, draft, fleqn, leqno

:eol.:lm margin=1.
:p.If you specify more than one option, they must be separated by a comma.
:p.:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd45.\flushbottom:elink.:pd.
:pt.:link reftype=hd refid=hd46.\onecolumn:elink.:pd.
:pt.:link reftype=hd refid=hd47.\raggedbottom:elink.:pd.
:pt.:link reftype=hd refid=hd48.\twocolumn:elink.:pd.
:eparml.
:h3 id=hd45.\flushbottom
:lm margin=1.
:p.The :font facename=Courier size=12x8.\flushbottom:font facename=default size=0x0. declaration makes all text pages the same
height, adding extra vertical space when necessary to fill out the page.
:p.This is the standard for the book style.
:h3 id=hd46.\onecolumn
:lm margin=1.
:p.The :font facename=Courier size=12x8.\onecolumn:font facename=default size=0x0. declaration starts a new page and produces
single-column output.
:h3 id=hd47.\raggedbottom
:lm margin=1.
:p.The :font facename=Courier size=12x8.\raggedbottom:font facename=default size=0x0. declaration makes all pages the height of the
text on that page.  No extra vertical space is added.
:h3 id=hd48.\twocolumn
:lm margin=1.
:p.The :font facename=Courier size=12x8.\twocolumn:font facename=default size=0x0. declaration starts a new page and produces
two-column output.
:h2 id=hd12.Environments
:lm margin=1.
:p.LaTeX provides a number of different paragraph-making environments.
Each environment begins and ends in the same manner.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
        \begin{environment-name}
        .
        .
        .
        \end{environment-name}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd49.array:elink.:pd.
:pt.:link reftype=hd refid=hd50.center:elink.:pd.
:pt.:link reftype=hd refid=hd51.description:elink.:pd.
:pt.:link reftype=hd refid=hd52.enumerate:elink.:pd.
:pt.:link reftype=hd refid=hd53.eqnarray:elink.:pd.
:pt.:link reftype=hd refid=hd54.equation:elink.:pd.
:pt.:link reftype=hd refid=hd55.figure:elink.:pd.
:pt.:link reftype=hd refid=hd56.flushleft:elink.:pd.
:pt.:link reftype=hd refid=hd57.flushright:elink.:pd.
:pt.:link reftype=hd refid=hd58.itemize:elink.:pd.
:pt.:link reftype=hd refid=hd59.list:elink.:pd.
:pt.:link reftype=hd refid=hd60.minipage:elink.:pd.
:pt.:link reftype=hd refid=hd61.picture:elink.:pd.
:pt.:link reftype=hd refid=hd62.quotation:elink.:pd.
:pt.:link reftype=hd refid=hd63.quote:elink.:pd.
:pt.:link reftype=hd refid=hd64.tabbing:elink.:pd.
:pt.:link reftype=hd refid=hd65.table:elink.:pd.
:pt.:link reftype=hd refid=hd66.tabular:elink.:pd.
:pt.:link reftype=hd refid=hd67.thebibliography:elink.:pd.
:pt.:link reftype=hd refid=hd68.theorem:elink.:pd.
:pt.:link reftype=hd refid=hd69.titlepage:elink.:pd.
:pt.:link reftype=hd refid=hd70.verbatim:elink.:pd.
:pt.:link reftype=hd refid=hd71.verse:elink.:pd.
:eparml.
:h3 id=hd49.array
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
\begin{array}{col1col2&dot.&dot.&dot.coln}
column 1 entry &amp. column 2 entry &dot.&dot.&dot. &amp. column n entry \\
 .
 .
 .
\end{array}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.Math arrays are produced with the array environment.  It has a single
mandatory argument describing the number of columns and the alignment
within them.  Each column, :font facename=Courier size=12x8.coln:font facename=default size=0x0., is specified by a single letter
that tells how items in that row should be formatted.

:ul.:li.
:font facename=Courier size=12x8.c:font facename=default size=0x0. - for centred
:li.:font facename=Courier size=12x8.l:font facename=default size=0x0. - for flushleft
:li.:font facename=Courier size=12x8.r:font facename=default size=0x0. - for flushright

:eul.:lm margin=1.
:p.Column entries must be separated by an :font facename=Courier size=12x8.&amp.:font facename=default size=0x0..  Column entries may
include other LaTeX commands.  Each row of the array must be terminated
with the string :font facename=Courier size=12x8.\\:font facename=default size=0x0..
:h3 id=hd50.center
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{center}
 Text on line 1 \\
 Text on line 2 \\
 .
 .
 .
 \end{center}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.The :font facename=Courier size=12x8.center:font facename=default size=0x0. environment allows you to create a paragraph consisting of
lines that are centred within the left and right margins on the current
page.  Each line must be terminated with the string :font facename=Courier size=12x8.\\:font facename=default size=0x0..
:p.:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd72.\centering:elink.:pd.
:eparml.
:h4 id=hd72.\centering
:lm margin=1.
:p.This declaration corresponds to the :font facename=Courier size=12x8.center:font facename=default size=0x0. environment.  This
declaration can be used inside an environment such as :font facename=Courier size=12x8.quote:font facename=default size=0x0. or in
a :font facename=Courier size=12x8.parbox:font facename=default size=0x0..  The text of a figure or table can be centered on the
page by putting a :font facename=Courier size=12x8.\centering:font facename=default size=0x0. command at the beginning of the
figure or table environment.
:p.Unlike the :font facename=Courier size=12x8.center:font facename=default size=0x0. environment, the :font facename=Courier size=12x8.\centering:font facename=default size=0x0. command does
not start a new paragraph; it simply changes how LaTeX formats paragraph
units.  To affect a paragraph unit's format, the scope of the
declaration must contain the blank line or :font facename=Courier size=12x8.\end:font facename=default size=0x0. command (of an
environment like quote) that ends the paragraph unit.
:h3 id=hd51.description
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{description}
 \item [label] First item
 \item [label] Second item
 .
 .
 .
 \end{description}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.The :font facename=Courier size=12x8.description:font facename=default size=0x0. environment is used to make labelled lists.  The
:font facename=Courier size=12x8.label:font facename=default size=0x0. is bold face and flushed right.
:h3 id=hd52.enumerate
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{enumerate}
 \item First item
 \item Second item
 .
 .
 .
 \end{enumerate}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.The :font facename=Courier size=12x8.enumerate:font facename=default size=0x0. environment produces a numbered list.  Enumerations
can be nested within one another, up to four levels deep.  They can also
be nested within other paragraph-making environments.
:p.Each item of an enumerated list begins with an :font facename=Courier size=12x8.\item:font facename=default size=0x0. command.
There must be at least one :font facename=Courier size=12x8.\item:font facename=default size=0x0. command within the environment.
:h3 id=hd53.eqnarray
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{eqnarray}
 math formula 1 \\
 math formula 2 \\
 .
 .
 .
 \end{eqnarray}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.The :font facename=Courier size=12x8.eqnarray:font facename=default size=0x0. environment is used to display a sequence of
equations or inequalities.  It is very much like a three-column
:font facename=Courier size=12x8.array:font facename=default size=0x0. environment, with consecutive rows separated by :font facename=Courier size=12x8.\\:font facename=default size=0x0.
and consecutive items within a row separated by an :font facename=Courier size=12x8.&amp.:font facename=default size=0x0..  An
equation number is placed on every line unless that line has a
:font facename=Courier size=12x8.\nonumber:font facename=default size=0x0. command.
:h3 id=hd54.equation
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{equation}
  math formula
 \end{equation}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.The :font facename=Courier size=12x8.equation:font facename=default size=0x0. environment centres your equation on the page and places
the equation number in the right margin.
:h3 id=hd55.figure
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{figure}[placement]
  body of the figure
 \caption{figure title}
 \end{figure}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.Figures are objects that are not part of the normal text, and are
usually "floated" to a convenient place, like the top of a page.
Figures will not be split between two pages.
:p.The optional argument :font facename=Courier size=12x8.[placement]:font facename=default size=0x0. determines where LaTeX will try
to place your figure.  There are four places where LaTeX can possibly
put a float&colon.

:ol.:li.
:font facename=Courier size=12x8.h:font facename=default size=0x0. (Here) - at the position in the text where the figure
environment appears.
:li.:font facename=Courier size=12x8.t:font facename=default size=0x0. (Top) - at the top of a text page.
:li.:font facename=Courier size=12x8.b:font facename=default size=0x0. (Bottom) - at the bottom of a text page.
:li.:font facename=Courier size=12x8.p:font facename=default size=0x0. (Page of floats) - on a separate float page, which is a page
containing no text, only floats.

:eol.:lm margin=1.
:p.The standard report and article styles use the default placement
:font facename=Courier size=12x8.tbp:font facename=default size=0x0..
:p.The body of the figure is made up of whatever text, LaTeX commands, etc.
you wish.  The :font facename=Courier size=12x8.\caption:font facename=default size=0x0. command allows you to title your figure.
:h3 id=hd56.flushleft
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{flushleft}
 Text on line 1 \\
 Text on line 2 \\
 .
 .
 .
 \end{flushleft}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.The :font facename=Courier size=12x8.flushleft:font facename=default size=0x0. environment allows you to create a paragraph
consisting of lines that are flushed left, to the left-hand margin.
Each line must be terminated with the string :font facename=Courier size=12x8.\\:font facename=default size=0x0..
:p.:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd73.\raggedright:elink.:pd.
:eparml.
:h4 id=hd73.\raggedright
:lm margin=1.
:p.This declaration corresponds to the :font facename=Courier size=12x8.flushleft:font facename=default size=0x0. environment.  This
declaration can be used inside an environment such as :font facename=Courier size=12x8.quote:font facename=default size=0x0. or in
a :font facename=Courier size=12x8.parbox:font facename=default size=0x0..
:p.Unlike the :font facename=Courier size=12x8.flushleft:font facename=default size=0x0. environment, the :font facename=Courier size=12x8.\raggedright:font facename=default size=0x0. command
does not start a new paragraph; it simply changes how LaTeX formats
paragraph units.  To affect a paragraph unit's format, the scope of the
declaration must contain the blank line or :font facename=Courier size=12x8.\end:font facename=default size=0x0. command (of an
environment like quote) that ends the paragraph unit.
:h3 id=hd57.flushright
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{flushright}
 Text on line 1 \\
 Text on line 2 \\
 .
 .
 .
 \end{flushright}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.The :font facename=Courier size=12x8.flushright:font facename=default size=0x0. environment allows you to create a paragraph
consisting of lines that are flushed right, to the right-hand margin.
Each line must be terminated with the string :font facename=Courier size=12x8.\\:font facename=default size=0x0..
:p.:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd74.\raggedleft:elink.:pd.
:eparml.
:h4 id=hd74.\raggedleft
:lm margin=1.
:p.This declaration corresponds to the :font facename=Courier size=12x8.flushright:font facename=default size=0x0. environment.  This
declaration can be used inside an environment such as :font facename=Courier size=12x8.quote:font facename=default size=0x0. or in
a :font facename=Courier size=12x8.parbox:font facename=default size=0x0..
:p.Unlike the :font facename=Courier size=12x8.flushright:font facename=default size=0x0. environment, the :font facename=Courier size=12x8.\raggedleft:font facename=default size=0x0. command
does not start a new paragraph; it simply changes how LaTeX formats
paragraph units.  To affect a paragraph unit's format, the scope of the
declaration must contain the blank line or :font facename=Courier size=12x8.\end:font facename=default size=0x0. command (of an
environment like quote) that ends the paragraph unit.
:h3 id=hd58.itemize
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{itemize}
 \item First item
 \item Second item
 .
 .
 .
 \end{itemize}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.The :font facename=Courier size=12x8.itemize:font facename=default size=0x0. environment produces a "bulleted" list.  Itemizations
can be nested within one another, up to four levels deep.  They can also
be nested within other paragraph-making environments.
:p.Each item of an :font facename=Courier size=12x8.itemized:font facename=default size=0x0. list begins with an :font facename=Courier size=12x8.\item:font facename=default size=0x0. command.
There must be at least one :font facename=Courier size=12x8.\item:font facename=default size=0x0. command within the environment.
:h3 id=hd59.list
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{list}{label}{spacing}
 \item First item
 \item Second item
 .
 .
 .
 \end{list}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.The :font facename=Courier size=12x8.{label}:font facename=default size=0x0. argument specifies how items should be labelled.
This argument is a piece of text that is inserted in a box to form the
label.  This argument can and usually does contain other LaTeX commands.
:p.The :font facename=Courier size=12x8.{spacing}:font facename=default size=0x0. argument contains commands to change the spacing
parameters for the list.  This argument will most often be null, i.e.,
:font facename=Courier size=12x8.{}:font facename=default size=0x0..  This will select all default spacing which should suffice
for most cases.
:h3 id=hd60.minipage
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{minipage}[position]{width}
  text
 \end{minipage}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.The :font facename=Courier size=12x8.minipage:font facename=default size=0x0. environment is similar to a :font facename=Courier size=12x8.\parbox:font facename=default size=0x0. command.
It takes the same optional :font facename=Courier size=12x8.position:font facename=default size=0x0. argument and mandatory
:font facename=Courier size=12x8.width:font facename=default size=0x0. argument.  You may use other paragraph-making environments
inside a minipage.
:p.Footnotes in a :font facename=Courier size=12x8.minipage:font facename=default size=0x0. environment are handled in a way that is
particularly useful for putting footnotes in figures or tables.  A
:font facename=Courier size=12x8.\footnote:font facename=default size=0x0. or :font facename=Courier size=12x8.\footnotetext:font facename=default size=0x0. command puts the footnote at
the bottom of the minipage instead of at the bottom of the page, and it
uses the :font facename=Courier size=12x8.mpfootnote:font facename=default size=0x0. counter instead of the ordinary
:font facename=Courier size=12x8.footnote:font facename=default size=0x0. counter.
:p.NOTE&colon. Don't put one minipage inside another if you are using footnotes;
they may wind up at the bottom of the wrong minipage.
:h3 id=hd61.picture
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{picture}(width,height)(x offset,y offset)
 .
  picture commands
 .
 \end{picture}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.The :font facename=Courier size=12x8.picture:font facename=default size=0x0. environment allows you to create just about any kind
of picture you want containing text, lines, arrows and circles.  You
tell LaTeX where to put things in the picture by specifying their
coordinates.  A coordinate is a number that may have a decimal point and
a minus sign - a number like :font facename=Courier size=12x8.5:font facename=default size=0x0., :font facename=Courier size=12x8.2.3:font facename=default size=0x0. or :font facename=Courier size=12x8.-3.1416:font facename=default size=0x0..  A
coordinate specifies a length in multiples of the unit length
:font facename=Courier size=12x8.\unitlength:font facename=default size=0x0., so if :font facename=Courier size=12x8.\unitlength:font facename=default size=0x0. has been set to :font facename=Courier size=12x8.1cm:font facename=default size=0x0.,
then the coordinate 2.54 specifies a length of 2.54 centimeters.  You
can change the value of :font facename=Courier size=12x8.\unitlength:font facename=default size=0x0. anywhere you want, using the
:font facename=Courier size=12x8.\setlength:font facename=default size=0x0. command, but strange things will happen if you try
changing it inside the picture environment.
:p.A position is a pair of coordinates, such as :font facename=Courier size=12x8.(2.4,-5):font facename=default size=0x0., specifying
the point with x-coordinate :font facename=Courier size=12x8.2.4:font facename=default size=0x0. and y-coordinate :font facename=Courier size=12x8.-5:font facename=default size=0x0..
Coordinates are specified in the usual way with respect to an origin,
which is normally at the lower-left corner of the picture.  Note that
when a position appears as an argument, it is not enclosed in braces;
the parentheses serve to delimit the argument.
:p.The :font facename=Courier size=12x8.picture:font facename=default size=0x0. environment has one mandatory argument, which is a
:font facename=Courier size=12x8.position:font facename=default size=0x0..  It specifies the size of the picture.  The environment
produces a rectangular box with width and height determined by this
argument's x- and y-coordinates.
:p.The :font facename=Courier size=12x8.picture:font facename=default size=0x0. environment also has an optional :font facename=Courier size=12x8.position:font facename=default size=0x0.
argument, following the :font facename=Courier size=12x8.size:font facename=default size=0x0. argument, that can change the
origin.  (Unlike ordinary optional arguments, this argument is not
contained in square brackets.) The optional argument gives the
coordinates of the point at the lower-left corner of the picture
(thereby determining the origin).  For example, if :font facename=Courier size=12x8.\unitlength:font facename=default size=0x0.
has been set to :font facename=Courier size=12x8.1mm:font facename=default size=0x0., the command&dot.&dot.&dot.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
   \begin{picture}(100,200)(10,20)
:font facename=default size=0x0.:lm margin=1.:elines.
&dot.&dot.&dot.produces a picture of width 100 millimeters and height 200
millimeters, whose lower-left corner is the point (10,20) and whose
upper-right corner is therefore the point (110,220).  When you first
draw a picture, you will omit the optional argument, leaving the origin
at the lower-left corner.  If you then want to modify your picture by
shifting everything, you just add the appropriate optional argument.
:p.The environment's mandatory argument determines the nominal size of the
picture.  This need bear no relation to how large the picture really is;
LaTeX will happily allow you to put things outside the picture, or even
off the page.  The picture's nominal size is used by TeX in determining
how much room to leave for it.
:p.Everything that appears in a picture is drawn by the :font facename=Courier size=12x8.\put:font facename=default size=0x0.
command. The command&dot.&dot.&dot.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
   \put (11.3,-.3){&dot.&dot.&dot.}
:font facename=default size=0x0.:lm margin=1.:elines.
&dot.&dot.&dot.puts the object specified by :font facename=Courier size=12x8.&dot.&dot.&dot.:font facename=default size=0x0. in the picture, with its
reference point at coordinates (11.3,-.3).  The reference points for
various objects will be described below.
:p.The :font facename=Courier size=12x8.\put:font facename=default size=0x0. command creates an :font facename=Courier size=12x8.LR box:font facename=default size=0x0..  You can put anything
in the text argument of the :font facename=Courier size=12x8.\put:font facename=default size=0x0. command that you'd put into the
argument of an :font facename=Courier size=12x8.\mbox:font facename=default size=0x0. and related commands.  When you do this, the
reference point will be the lower left corner of the box.
:p.:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd75.\circle:elink.:pd.
:pt.:link reftype=hd refid=hd76.\dashbox:elink.:pd.
:pt.:link reftype=hd refid=hd77.\frame:elink.:pd.
:pt.:link reftype=hd refid=hd78.\framebox (picture):elink.:pd.
:pt.:link reftype=hd refid=hd79.\line:elink.:pd.
:pt.:link reftype=hd refid=hd80.\linethickness:elink.:pd.
:pt.:link reftype=hd refid=hd81.\makebox (picture):elink.:pd.
:pt.:link reftype=hd refid=hd82.\multiput:elink.:pd.
:pt.:link reftype=hd refid=hd83.\oval:elink.:pd.
:pt.:link reftype=hd refid=hd84.\put:elink.:pd.
:pt.:link reftype=hd refid=hd85.\shortstack:elink.:pd.
:pt.:link reftype=hd refid=hd86.\vector:elink.:pd.
:eparml.
:h4 id=hd75.\circle
:lm margin=1.
:p.:font facename=Courier size=12x8.\circle[*]{diameter}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\circle:font facename=default size=0x0. command produces a circle of the specified diameter.
If the :font facename=Courier size=12x8.*:font facename=default size=0x0.-form of the command is used, LaTeX draws a solid circle.
:h4 id=hd76.\dashbox
:lm margin=1.
:p.:font facename=Courier size=12x8.\dashbox{dash_length}(width,height){&dot.&dot.&dot.}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\dashbox:font facename=default size=0x0. has an extra argument which specifies the width of
each dash.  A dashed box looks best when the :font facename=Courier size=12x8.width:font facename=default size=0x0. and
:font facename=Courier size=12x8.height:font facename=default size=0x0. are multiples of the :font facename=Courier size=12x8.dash_length:font facename=default size=0x0..
:h4 id=hd77.\frame
:lm margin=1.
:p.:font facename=Courier size=12x8.\frame{&dot.&dot.&dot.}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\frame:font facename=default size=0x0. command puts a rectangular frame around the object
specified in the argument.  The reference point is the bottom left
corner of the frame.  No extra space is put between the frame and the
object.
:h4 id=hd78.\framebox
:lm margin=1.
:p.:font facename=Courier size=12x8.\framebox(width,height)[position]{&dot.&dot.&dot.}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\framebox:font facename=default size=0x0. command is exactly the same as the :font facename=Courier size=12x8.\makebox:font facename=default size=0x0.
command, except that it puts a frame around the outside of the box that
it creates.
:p.The :font facename=Courier size=12x8.framebox:font facename=default size=0x0. command produces a rule of thickness
:font facename=Courier size=12x8.\fboxrule:font facename=default size=0x0., and leaves a space :font facename=Courier size=12x8.\fboxsep:font facename=default size=0x0. between the rule
and the contents of the box.
:h4 id=hd79.\line
:lm margin=1.
:p.:font facename=Courier size=12x8.\line(x slope,y slope){length}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\line:font facename=default size=0x0. command draws a line of the specified :font facename=Courier size=12x8.length:font facename=default size=0x0. and
:font facename=Courier size=12x8.slope:font facename=default size=0x0..
:h4 id=hd80.\linethickness
:lm margin=1.
:p.:font facename=Courier size=12x8.\linethickness{dimension}:font facename=default size=0x0.
:p.Declares the thickness of horizontal and vertical lines in a picture
environment to be :font facename=Courier size=12x8.dimension:font facename=default size=0x0., which must be a positive length. It
does not affect the thickness of slanted lines and circles, or the
quarter circles drawn by :font facename=Courier size=12x8.\oval:font facename=default size=0x0. to form the corners of an oval.
:h4 id=hd81.\makebox
:lm margin=1.
:p.:font facename=Courier size=12x8.\makebox(width,height)[position]{&dot.&dot.&dot.}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\makebox:font facename=default size=0x0. command for the picture environment is similar to
the normal :font facename=Courier size=12x8.\makebox:font facename=default size=0x0. command except that you must specify a
:font facename=Courier size=12x8.width:font facename=default size=0x0. and :font facename=Courier size=12x8.height:font facename=default size=0x0. in multiples of :font facename=Courier size=12x8.\unitlength:font facename=default size=0x0..
:p.The optional argument, :font facename=Courier size=12x8.[position]:font facename=default size=0x0., specifies the quadrant that
your text appears in.  You may select up to two of the following&colon.

:ul.:li.
:font facename=Courier size=12x8.t:font facename=default size=0x0. - Moves the item to the top of the rectangle
:li.:font facename=Courier size=12x8.b:font facename=default size=0x0. - Moves the item to the bottom
:li.:font facename=Courier size=12x8.l:font facename=default size=0x0. - Moves the item to the left
:li.:font facename=Courier size=12x8.r:font facename=default size=0x0. - Moves the item to the right

:eul.:lm margin=1.
:p.See :link reftype=hd refid=hd87.\makebox:elink..
:h4 id=hd82.\multiput
:lm margin=1.
:p.:font facename=Courier size=12x8.\multiput(x coord,y coord)(delta x,delta y){number of copies}{object}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\multiput:font facename=default size=0x0. command can be used when you are putting the same
object in a regular pattern across a picture.
:h4 id=hd83.\oval
:lm margin=1.
:p.:font facename=Courier size=12x8.\oval(width,height)[portion]:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\oval:font facename=default size=0x0. command produces a rectangle with rounded corners.  The
optional argument, :font facename=Courier size=12x8.[portion]:font facename=default size=0x0., allows you to select part of the
oval.

:ul.:li.
:font facename=Courier size=12x8.t:font facename=default size=0x0. - Selects the top portion
:li.:font facename=Courier size=12x8.b:font facename=default size=0x0. - Selects the bottom portion
:li.:font facename=Courier size=12x8.r:font facename=default size=0x0. - Selects the right portion
:li.:font facename=Courier size=12x8.l:font facename=default size=0x0. - Selects the left portion

:eul.:lm margin=1.
:h4 id=hd84.\put
:lm margin=1.
:p.:font facename=Courier size=12x8.\put(x coord,y coord){ &dot.&dot.&dot.  }:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\put:font facename=default size=0x0. command places the item specified by the mandatory
argument at the given coordinates.
:h4 id=hd85.\shortstack
:lm margin=1.
:p.:font facename=Courier size=12x8.\shortstack[position]{&dot.&dot.&dot.  \\ &dot.&dot.&dot.  \\ &dot.&dot.&dot.}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\shortstack:font facename=default size=0x0. command produces a stack of objects.  The valid
positions are&colon.

:ul.:li.
:font facename=Courier size=12x8.r:font facename=default size=0x0. - Moves the objects to the right of the stack
:li.:font facename=Courier size=12x8.l:font facename=default size=0x0. - Moves the objects to the left of the stack
:li.:font facename=Courier size=12x8.c:font facename=default size=0x0. - Moves the objects to the center of the stack (default)

:eul.:lm margin=1.
:h4 id=hd86.\vector
:lm margin=1.
:p.:font facename=Courier size=12x8.\vector(x slope,y slope){length}:font facename=default size=0x0.
:p.The :font facename=Courier size=12x8.\vector:font facename=default size=0x0. command draws a line with an arrow of the specified
length and slope.  The :font facename=Courier size=12x8.x:font facename=default size=0x0. and :font facename=Courier size=12x8.y:font facename=default size=0x0. values must lie between -4
and +4, inclusive.
:h3 id=hd62.quotation
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{quotation}
  text
 \end{quotation}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.The margins of the :font facename=Courier size=12x8.quotation:font facename=default size=0x0. environment are indented on the left
and the right.  The text is justified at both margins and there is
paragraph indentation.  Leaving a blank line between text produces a new
paragraph.
:h3 id=hd63.quote
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{quote}
  text
 \end{quote}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.The margins of the :font facename=Courier size=12x8.quote:font facename=default size=0x0. environment are indented on the left and
the right.  The text is justified at both margins.  Leaving a blank line
between text produces a new paragraph.
:h3 id=hd64.tabbing
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{tabbing}
 text \= more text \= still more text \= last text \\
 second row \>  \> more \\
 .
 .
 .
 \end{tabbing}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.The :font facename=Courier size=12x8.tabbing:font facename=default size=0x0. environment provides a way to align text in columns.
It works by setting tab stops and tabbing to them much the way you do
with an ordinary typewriter.
:p.:parml tsize=30 break=none compact.
:pt.:link reftype=hd refid=hd96.\=              :elink.:pd.
:pt.:link reftype=hd refid=hd97.\>              :elink.:pd.
:pt.:link reftype=hd refid=hd98.\<              :elink.:pd.
:pt.:link reftype=hd refid=hd99.\+              :elink.:pd.
:pt.:link reftype=hd refid=hd100.\- (tabbing)   :elink.:pd.
:pt.:link reftype=hd refid=hd101.\'             :elink.:pd.
:pt.:link reftype=hd refid=hd102.\`             :elink.:pd.
:pt.:link reftype=hd refid=hd103.\kill          :elink.:pd.
:eparml.
:h4 id=hd96.\=
:lm margin=1.
:p.The :font facename=Courier size=12x8.\=:font facename=default size=0x0. command sets the tab stops.
:h4 id=hd97.\>
:lm margin=1.
:p.The :font facename=Courier size=12x8.\>:font facename=default size=0x0. command causes LaTeX to advance to the next tab stop.
:h4 id=hd98.\<
:lm margin=1.
:p.The :font facename=Courier size=12x8.\<:font facename=default size=0x0. command allows you to put something to the left of the
local margin without changing the margin.
:h4 id=hd99.\+
:lm margin=1.
:p.The :font facename=Courier size=12x8.\+:font facename=default size=0x0. command moves the left margin of the next and all the
following commands one tab stop to the right.
:h4 id=hd100.\-
:lm margin=1.
:p.The :font facename=Courier size=12x8.\-:font facename=default size=0x0. command moves the left margin of the next and all the
following commands one tab stop to the left.
:h4 id=hd101.\'
:lm margin=1.
:p.The :font facename=Courier size=12x8.\':font facename=default size=0x0. command moves everything that you have typed so far in the
current column, everything starting from the most recent :font facename=Courier size=12x8.\>:font facename=default size=0x0.,
:font facename=Courier size=12x8.\<:font facename=default size=0x0., :font facename=Courier size=12x8.\':font facename=default size=0x0., :font facename=Courier size=12x8.\\:font facename=default size=0x0., or :font facename=Courier size=12x8.\kill:font facename=default size=0x0. command, to the right
of the previous column, flush against the current column's tab stop.
:h4 id=hd102.\`
:lm margin=1.
:p.The :font facename=Courier size=12x8.\`:font facename=default size=0x0. command allows you to put text flushed right against any
tab stop, including tab stop 0.  However, it can't move text to the
right of the last column because there's no tab stop there.  The
:font facename=Courier size=12x8.\`:font facename=default size=0x0. command moves all the text that follows it, up to the
:font facename=Courier size=12x8.\\:font facename=default size=0x0. or :font facename=Courier size=12x8.\end{tabbing}:font facename=default size=0x0. command that ends the line, to the
right margin of the tabbing environment.  There must be no :font facename=Courier size=12x8.\>:font facename=default size=0x0. or
:font facename=Courier size=12x8.\':font facename=default size=0x0. command between the :font facename=Courier size=12x8.\`:font facename=default size=0x0. and the command that ends the
line.
:h4 id=hd103.\kill
:lm margin=1.
:p.The :font facename=Courier size=12x8.\kill:font facename=default size=0x0. command allows you to set tab stops without producing
text.  It works just like the :font facename=Courier size=12x8.\\:font facename=default size=0x0. except that it throws away the
current line instead of producing output for it.  The effect of any
:font facename=Courier size=12x8.\=:font facename=default size=0x0., :font facename=Courier size=12x8.\+:font facename=default size=0x0. or :font facename=Courier size=12x8.\-:font facename=default size=0x0. commands in that line remain in
effect.
:h3 id=hd65.table
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{table}[placement]
  body of the table
 \caption{table title}
 \end{table}
:font facename=default size=0x0.:lm margin=1.:elines.
:p.Tables  are objects  that  are not part  of the normal  text,  and are
usually  "floated"  to a convenient  place,  like  the top  of a page.
Tables will not be split between two pages.
:p.The optional argument :font facename=Courier size=12x8.[placement]:font facename=default size=0x0. determines where LaTeX will try
to place your table.  There are four places where LaTeX can possibly put
a float&colon.

:ul.:li.
:font facename=Courier size=12x8.h:font facename=default size=0x0. &colon. Here - at the position in the text where the table
environment appears.
:li.:font facename=Courier size=12x8.t:font facename=default size=0x0. &colon. Top - at the top of a text page.
:li.:font facename=Courier size=12x8.b:font facename=default size=0x0. &colon. Bottom - at the bottom of a text page.
:li.:font facename=Courier size=12x8.p:font facename=default size=0x0. &colon. Page of floats - on a separate float page, which is a page
containing no text, only floats.

:eul.:lm margin=1.
:p.The standard :font facename=Courier size=12x8.report:font facename=default size=0x0. and :font facename=Courier size=12x8.article:font facename=default size=0x0. styles use the default
placement :font facename=Courier size=12x8.[tbp]:font facename=default size=0x0..
The body of the table is made up of whatever text, LaTeX commands, etc.,
you wish.  The :font facename=Courier size=12x8.\caption:font facename=default size=0x0. command allows you to title your table.
:h3 id=hd66.tabular
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{tabular}[pos]{cols}
 column 1 entry &amp. column 2 entry &dot.&dot.&dot. &amp. column n entry \\
 .
 .
 .
 \end{tabular}
                or
 \begin{tabular*}{width}[pos]{cols}
 column 1 entry &amp. column 2 entry &dot.&dot.&dot. &amp. column n entry \\
 .
 .
 .
 \end{tabular*}
:font facename=default size=0x0.:lm margin=1.:elines.
These environments produce a box consisting of a sequence of rows of
items, aligned vertically in columns.  The mandatory and optional
arguments consist of&colon.

:parml break=fit.:pt.:font facename=Courier size=12x8.width:font facename=default size=12x8.:pd.
Specifies the width of the :font facename=Courier size=12x8.tabular*:font facename=default size=0x0. environment.  There must be
rubber space between columns that can stretch to fill out the specified
width.
:pt.:font facename=Courier size=12x8.pos:font facename=default size=12x8.:pd.Specifies the vertical position; default is alignment on the center of
the environment.

:lm margin=13.:p.:lm margin=15.1.:lm margin=18.
:font facename=Courier size=12x8.t:font facename=default size=0x0. - align on top row
:lm margin=13.:p.:lm margin=15.2.:lm margin=18.
:font facename=Courier size=12x8.b:font facename=default size=0x0. - align on bottom row

:p.:lm margin=13.
:pt.:font facename=Courier size=12x8.cols:font facename=default size=12x8.:pd.Specifies the column formatting.  It consists of a sequence of the
following specifiers, corresponding to the sequence of columns and
intercolumn material.

:lm margin=13.:p.:lm margin=15.1.:lm margin=18.
:font facename=Courier size=12x8.l:font facename=default size=0x0. - A column of left-aligned items.
:lm margin=13.:p.:lm margin=15.2.:lm margin=18.
:font facename=Courier size=12x8.r:font facename=default size=0x0. - A column of right-aligned items.
:lm margin=13.:p.:lm margin=15.3.:lm margin=18.
:font facename=Courier size=12x8.c:font facename=default size=0x0. - A column of centred items.
:lm margin=13.:p.:lm margin=15.4.:lm margin=18.
:font facename=Courier size=12x8.|:font facename=default size=0x0. - A vertical line the full height and depth of the environment.
:lm margin=13.:p.:lm margin=15.5.:lm margin=18.
:font facename=Courier size=12x8.@{text}:font facename=default size=0x0. - This inserts text in every row.  An @-expression
suppresses the intercolumn space normally inserted between columns; any
desired space between the inserted text and the adjacent items must be
included in text.  An :font facename=Courier size=12x8.\extracolsep{wd}:font facename=default size=0x0. command in an
@-expression causes an extra space of width :font facename=Courier size=12x8.wd:font facename=default size=0x0. to appear to the
left of all subsequent columns, until countermanded by another
:font facename=Courier size=12x8.\extracolsep:font facename=default size=0x0. command.  Unlike ordinary intercolumn space, this
extra space is not suppressed by an @-expression.  An
:font facename=Courier size=12x8.\extracolsep:font facename=default size=0x0. command can be used only in an @-expression in the
:font facename=Courier size=12x8.cols:font facename=default size=0x0. argument.
:lm margin=13.:p.:lm margin=15.6.:lm margin=18.
:font facename=Courier size=12x8.p{wd}:font facename=default size=0x0. - Produces a column with each item typeset in a parbox of
width :font facename=Courier size=12x8.wd:font facename=default size=0x0., as if it were the argument of a :font facename=Courier size=12x8.\parbox[t]{wd}:font facename=default size=0x0.
command.  However, a :font facename=Courier size=12x8.\\:font facename=default size=0x0. may not appear in the item, except in the
following situations&colon.

:lm margin=18.:p.:lm margin=19..&larrow.:lm margin=21.
inside an environment like :font facename=Courier size=12x8.minipage:font facename=default size=0x0., :font facename=Courier size=12x8.array:font facename=default size=0x0., or :font facename=Courier size=12x8.tabular:font facename=default size=0x0..
:lm margin=18.:p.:lm margin=19..&larrow.:lm margin=21.
inside an explicit :font facename=Courier size=12x8.\parbox:font facename=default size=0x0..
:lm margin=18.:p.:lm margin=19..&larrow.:lm margin=21.
in the scope of a :font facename=Courier size=12x8.\centering:font facename=default size=0x0., :font facename=Courier size=12x8.\raggedright:font facename=default size=0x0., or :font facename=Courier size=12x8.\raggedleft:font facename=default size=0x0.
declaration.  The latter declarations must appear inside braces or an
environment when used in a :font facename=Courier size=12x8.p-column:font facename=default size=0x0. element.

:p.:lm margin=18.
:lm margin=13.:p.:lm margin=15.7.:lm margin=18.
:font facename=Courier size=12x8.*{num}{cols}:font facename=default size=0x0. - Equivalent to :font facename=Courier size=12x8.num:font facename=default size=0x0. copies of
:font facename=Courier size=12x8.cols:font facename=default size=0x0., where :font facename=Courier size=12x8.num:font facename=default size=0x0. is any positive integer and :font facename=Courier size=12x8.cols:font facename=default size=0x0. is
any list of column-specifiers, which may contain another
:font facename=Courier size=12x8.*-expression:font facename=default size=0x0..

:p.:lm margin=13.

:eparml.:lm margin=1.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd104.\cline:elink.:pd.
:pt.:link reftype=hd refid=hd105.\hline:elink.:pd.
:pt.:link reftype=hd refid=hd106.\multicolumn:elink.:pd.
:pt.:link reftype=hd refid=hd107.\vline:elink.:pd.
:eparml.
:h4 id=hd104.\cline
:lm margin=1.
:p.:font facename=Courier size=12x8.\cline{i-j}:font
facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\cline:font facename=default size=0x0. command draws horizontal lines across the columns
specified, beginning in column :font facename=Courier size=12x8.i:font facename=default size=0x0. and ending in column :font facename=Courier size=12x8.j:font facename=default size=0x0.,
which are identified in the mandatory argument.
:h4 id=hd105.\hline
:lm margin=1.
The :font facename=Courier size=12x8.\hline:font facename=default size=0x0. command will draw a horizontal line the width of the
table.  It's most commonly used to draw a line at the top, bottom, and
between the rows of the table.
:h4 id=hd106.\multicolumn
:lm margin=1.
:font facename=Courier
size=12x8.\multicolumn{cols}{pos}{text}:font
facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\multicolumn:font facename=default size=0x0. is used to make an entry that spans several
columns.  The first mandatory argument, :font facename=Courier size=12x8.cols:font facename=default size=0x0., specifies the
number of columns to span.  The second mandatory argument, :font facename=Courier size=12x8.pos:font facename=default size=0x0.,
specifies the formatting of the entry; :font facename=Courier size=12x8.c:font facename=default size=0x0. for centred, :font facename=Courier size=12x8.l:font facename=default size=0x0.
for flushleft, :font facename=Courier size=12x8.r:font facename=default size=0x0. for flushright.  The third mandatory argument,
:font facename=Courier size=12x8.text:font facename=default size=0x0., specifies what text is to make up the entry.
:h4 id=hd107.\vline
:lm margin=1.
The :font facename=Courier size=12x8.\vline:font facename=default size=0x0. command will draw a vertical line extending the full
height and depth of its row.  An :font facename=Courier size=12x8.\hfill:font facename=default size=0x0. command can be used to
move the line to the edge of the column.  It can also be used in an
@-expression.
:h3 id=hd67.thebibliography
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{thebibliography}{widest-label}
 \bibitem[label]{cite_key}
 .
 .
 .
 \end{thebibliography}
:font facename=default size=0x0.:lm margin=1.:elines.
The :font facename=Courier size=12x8.thebibliography:font facename=default size=0x0. environment produces a bibliography or
reference list.  In the :font facename=Courier size=12x8.article:font facename=default size=0x0. style, this reference list is
labelled "References"; in the :font facename=Courier size=12x8.report:font facename=default size=0x0. style, it is labelled
"Bibliography".

:ul.:li.
:font facename=Courier size=12x8.widest-label:font facename=default size=0x0.&colon. Text that, when printed, is approximately as wide
as the widest item label produces by the :font facename=Courier size=12x8.\bibitem:font facename=default size=0x0. commands.

:eul.:lm margin=1.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd108.\bibitem:elink.:pd.
:pt.:link reftype=hd refid=hd109.\cite:elink.:pd.
:pt.:link reftype=hd refid=hd110.\nocite:elink.:pd.
:eparml.
:h4 id=hd108.\bibitem
:lm margin=1.
:p.:font facename=Courier
size=12x8.\bibitem[label]{cite_key}:font facename=default
size=0x0.
:p.
The :font facename=Courier size=12x8.\bibitem:font facename=default size=0x0. command generates an entry labelled by :font facename=Courier size=12x8.label:font facename=default size=0x0..
If the :font facename=Courier size=12x8.label:font facename=default size=0x0. argument is missing, a number is generated as the
:font facename=Courier size=12x8.label:font facename=default size=0x0., using the :font facename=Courier size=12x8.enumi:font facename=default size=0x0. counter.  The :font facename=Courier size=12x8.cite_key:font facename=default size=0x0. is
any sequence of letters, numbers, and punctuation symbols not containing
a comma.  This command writes an entry on the :font facename=Courier size=12x8.&apos..aux&apos.:font facename=default size=0x0. file
containing :font facename=Courier size=12x8.cite_key:font facename=default size=0x0. and the item's :font facename=Courier size=12x8.label:font facename=default size=0x0..  When this
:font facename=Courier size=12x8.&apos..aux&apos.:font facename=default size=0x0. file is read by the :font facename=Courier size=12x8.\begin{document}:font facename=default size=0x0. command, the
item's :font facename=Courier size=12x8.label:font facename=default size=0x0. is associated with :font facename=Courier size=12x8.cite_key:font facename=default size=0x0., causing the
reference to :font facename=Courier size=12x8.cite_key:font facename=default size=0x0. by a :font facename=Courier size=12x8.\cite:font facename=default size=0x0. command to produce the
associated :font facename=Courier size=12x8.label:font facename=default size=0x0..
:h4 id=hd109.\cite
:lm margin=1.
:p.:font facename=Courier
size=12x8.\cite[text]{key_list}:font facename=default
size=0x0.
:p.
The :font facename=Courier size=12x8.key_list:font facename=default size=0x0. argument is a list of citation keys.  This command
generates an in-text citation to the references associated with the keys
in :font facename=Courier size=12x8.key_list:font facename=default size=0x0. by entries on the :font facename=Courier size=12x8.&apos..aux&apos.:font facename=default size=0x0. file read by the
:font facename=Courier size=12x8.\begin{document}:font facename=default size=0x0. command.
:h4 id=hd110.\nocite
:lm margin=1.
:p.:font facename=Courier size=12x8.\nocite{key_list}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\nocite:font facename=default size=0x0. command produces no text, but writes :font facename=Courier size=12x8.key_list:font facename=default size=0x0.,
which is a list of one or more citation keys, on the :font facename=Courier size=12x8.&apos..aux&apos.:font facename=default size=0x0. file.
:h3 id=hd68.theorem
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{theorem}
  theorem text
 \end{theorem}
:font facename=default size=0x0.:lm margin=1.:elines.
The :font facename=Courier size=12x8.theorem:font facename=default size=0x0. environment produces "Theorem x" in boldface followed
by your theorem text.
:h3 id=hd69.titlepage
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{titlepage}
  text
 \end{titlepage}
:font facename=default size=0x0.:lm margin=1.:elines.
The :font facename=Courier size=12x8.titlepage:font facename=default size=0x0. environment creates a title page, i.e.  a page with no
printed page number or heading.  It also causes the following page to be
numbered page one.  Formatting the title page is left to you.  The
:font facename=Courier size=12x8.\today:font facename=default size=0x0. command comes in handy for title pages.
:h3 id=hd70.verbatim
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{verbatim}
  text
 \end{verbatim}
:font facename=default size=0x0.:lm margin=1.:elines.
The :font facename=Courier size=12x8.verbatim:font facename=default size=0x0. environment is a paragraph-making environment that
gets LaTeX to print exactly what you type in.  It turns LaTeX into a
typewriter with carriage returns and blanks having the same effect that
they would on a typewriter.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd111.\verb:elink.:pd.
:eparml.
:h4 id=hd111.\verb
:lm margin=1.
:font facename=Courier size=12x8.\verb char literal_text
char 
:p.
\verb*char literal_text char:font facename=default size=0x0.
:p.
Typesets :font facename=Courier size=12x8.literal_text:font facename=default size=0x0. exactly as typed, including special
characters and spaces, using a typewriter (:font facename=Courier size=12x8.\tt:font facename=default size=0x0.) type style.
There may be no space between :font facename=Courier size=12x8.\verb:font facename=default size=0x0. or :font facename=Courier size=12x8.\verb*:font facename=default size=0x0. and
:font facename=Courier size=12x8.char:font facename=default size=0x0. (space is shown here only for clarity).  The :font facename=Courier size=12x8.*-form:font facename=default size=0x0.
differs only in that spaces are printed.
:h3 id=hd71.verse
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{verse}
  text
 \end{verse}
:font facename=default size=0x0.:lm margin=1.:elines.
The :font facename=Courier size=12x8.verse:font facename=default size=0x0. environment is designed for poetry, though you may find
other uses for it.
:h2 id=hd13.Footnotes
:lm margin=1.
:p.:font facename=Courier size=12x8.Footnotes:font facename=default size=0x0. can be produced in one of two ways.  They can be
produced with one command, the :font facename=Courier size=12x8.\footnote:font facename=default size=0x0. command.  They can also
be produced with two commands, the :font facename=Courier size=12x8.\footnotemark:font facename=default size=0x0. and the
:font facename=Courier size=12x8.\footnotetext:font facename=default size=0x0. commands.  See the specific command for information
on why you would use one over the other.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd112.\footnote:elink.:pd.
:pt.:link reftype=hd refid=hd113.\footnotemark:elink.:pd.
:pt.:link reftype=hd refid=hd114.\footnotetext:elink.:pd.
:eparml.
:h3 id=hd112.\footnote
:lm margin=1.
:p.:font facename=Courier size=12x8.\footnote[number]{text}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\footnote:font facename=default size=0x0. command places the numbered footnote :font facename=Courier size=12x8.text:font facename=default size=0x0. at
the bottom of the current page.  The optional argument, :font facename=Courier size=12x8.number:font facename=default size=0x0.,
is used to change the default footnote number.  This command can only be
used in outer paragraph mode.
:h3 id=hd113.\footnotemark
:lm margin=1.
:p.The :font facename=Courier size=12x8.\footnotemark:font facename=default size=0x0. command puts the footnote :font facename=Courier size=12x8.number:font facename=default size=0x0. in the
text.  This command can be used in inner paragraph mode.  The text of
the footnote is supplied by the :font facename=Courier size=12x8.\footnotetext:font facename=default size=0x0. command.
:h3 id=hd114.\footnotetext
:lm margin=1.
:p.:font facename=Courier
size=12x8.\footnotetext[number]{text}:font facename=default
size=0x0.
:p.
The :font facename=Courier size=12x8.\footnotetext:font facename=default size=0x0. command produces the :font facename=Courier size=12x8.text:font facename=default size=0x0. to be placed
at the bottom of the page.  This command can come anywhere after the
:font facename=Courier size=12x8.\footnotemark:font facename=default size=0x0. command.  The :font facename=Courier size=12x8.\footnotetext:font facename=default size=0x0. command must
appear in outer paragraph mode.
The optional argument, :font facename=Courier size=12x8.number:font facename=default size=0x0., is used to change the default
footnote number.
:h2 id=hd14.Lengths
:lm margin=1.
A :font facename=Courier size=12x8.length:font facename=default size=0x0. is a measure of distance.  Many LaTeX commands take a
length as an argument.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd115.\newlength:elink.:pd.
:pt.:link reftype=hd refid=hd116.\setlength:elink.:pd.
:pt.:link reftype=hd refid=hd117.\addtolength:elink.:pd.
:pt.:link reftype=hd refid=hd118.\settowidth:elink.:pd.
:eparml.
:h3 id=hd115.\newlength
:lm margin=1.
:p.:font facename=Courier size=12x8.\newlength{\gnat}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\newlength:font facename=default size=0x0. command defines the mandatory argument,
:font facename=Courier size=12x8.\gnat:font facename=default size=0x0., as a :font facename=Courier size=12x8.length:font facename=default size=0x0. command with a value of :font facename=Courier size=12x8.0in:font facename=default size=0x0..  An
error occurs if a :font facename=Courier size=12x8.\gnat:font facename=default size=0x0. command already exists.
:h3 id=hd116.\setlength
:lm margin=1.
:p.:font facename=Courier size=12x8.\setlength{\gnat}{length}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\setlength:font facename=default size=0x0. command is used to set the value of a
:font facename=Courier size=12x8.length:font facename=default size=0x0. command.  The :font facename=Courier size=12x8.length:font facename=default size=0x0. argument can be expressed in
any terms of length LaTeX understands, i.e., inches (:font facename=Courier size=12x8.in:font facename=default size=0x0.),
millimeters (:font facename=Courier size=12x8.mm:font facename=default size=0x0.), points (:font facename=Courier size=12x8.pt:font facename=default size=0x0.), etc.
:h3 id=hd117.\addtolength
:lm margin=1.
:p.:font facename=Courier size=12x8.\addtolength{\gnat}{length}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\addtolength:font facename=default size=0x0. command increments a "length command" by the
amount specified in the :font facename=Courier size=12x8.length:font facename=default size=0x0. argument.  It can be a negative
amount.
:h3 id=hd118.\settowidth
:lm margin=1.
:font facename=Courier size=12x8.\settowidth{\gnat}{text}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\settowidth:font facename=default size=0x0. command sets the value of a :font facename=Courier size=12x8.length:font facename=default size=0x0. command
equal to the width of the :font facename=Courier size=12x8.text:font facename=default size=0x0. argument.
:h2 id=hd15.Letters
:lm margin=1.
You can use LaTeX to typeset letters, both personal and business.  The
:font facename=Courier size=12x8.letter:font facename=default size=0x0. document style is designed to make a number of letters at
once, although you can make just one if you so desire.
Your :font facename=Courier size=12x8.&apos..tex&apos.:font facename=default size=0x0. source file has the same minimum commands as the other
document styles, i.e., you must have the following commands as a
minimum&colon.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \documentstyle{letter}
 \begin{document}
  &dot.&dot.&dot. letters &dot.&dot.&dot.
 \end{document}
:font facename=default size=0x0.:lm margin=1.:elines.
Each letter is a :font facename=Courier size=12x8.letter:font facename=default size=0x0. environment, whose argument is the name
and address of the recipient.  For example, you might have&colon.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \begin{letter}{Mr. Joe Smith\\ 2345 Princess St. 
      \\ Edinburgh, EH1 1AA}
   &dot.&dot.&dot.
 \end{letter}
:font facename=default size=0x0.:lm margin=1.:elines.
The letter itself begins with the :font facename=Courier size=12x8.\opening:font facename=default size=0x0. command.  The text of
the letter follows.  It is typed as ordinary LaTeX input.  Commands that
make no sense in a letter, like :font facename=Courier size=12x8.\chapter:font facename=default size=0x0., don't work.  The letter
closes with a :font facename=Courier size=12x8.\closing:font facename=default size=0x0. command.
After the :font facename=Courier size=12x8.closing:font facename=default size=0x0., you can have additional material.  The
:font facename=Courier size=12x8.\cc:font facename=default size=0x0. command produces the usual "cc&colon. &dot.&dot.&dot.".  There's also a similar
:font facename=Courier size=12x8.\encl:font facename=default size=0x0. command for a list of enclosures.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd119.\opening:elink.:pd.
:pt.:link reftype=hd refid=hd120.\closing:elink.:pd.
:pt.:link reftype=hd refid=hd121.Declarations:elink.:pd.
:eparml.
:h3 id=hd119.\opening
:lm margin=1.
:p.:font facename=Courier size=12x8.\opening{text}:font facename=default size=0x0.
:p.
The letter begins with the :font facename=Courier size=12x8.\opening:font facename=default size=0x0. command.  The mandatory
argument, :font facename=Courier size=12x8.text:font facename=default size=0x0., is whatever text you wish to start your letter,
i.e.,
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \opening{Dear Joe,}
:font facename=default size=0x0.:lm margin=1.:elines.
:h3 id=hd120.\closing
:lm margin=1.
:p.:font facename=Courier size=12x8.\closing{text}:font facename=default size=0x0.
:p.
The letter closes with a :font facename=Courier size=12x8.\closing:font facename=default size=0x0. command, i.e.,
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \closing{Best Regards,}
:font facename=default size=0x0.:lm margin=1.:elines.
:h3 id=hd121.Declarations
:lm margin=1.
:p.The following commands are declarations which take a single argument.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd122.\address:elink.:pd.
:pt.:link reftype=hd refid=hd123.\signature:elink.:pd.
:pt.:link reftype=hd refid=hd124.\location:elink.:pd.
:pt.:link reftype=hd refid=hd125.\telephone:elink.:pd.
:eparml.
:h3 id=hd122.\address
:lm margin=1.
:font facename=Courier size=12x8.\address{Return address}:font facename=default size=0x0.
:p.
The return address, as it should appear on the letter and the envelope.
Separate lines of the address should be separated by :font facename=Courier size=12x8.\\:font facename=default size=0x0. commands.
If you do not make an :font facename=Courier size=12x8.\address:font facename=default size=0x0. declaration, then the letter will
be formatted for copying onto your organisation's standard letterhead.
(See :link reftype=hd refid=hd3.Overview:elink., for details on your local implementation).  If you
give an :font facename=Courier size=12x8.\address:font facename=default size=0x0. declaration, then the letter will be formatted
as a personal letter.
:h3 id=hd123.\signature
:lm margin=1.
:p.:font facename=Courier size=12x8.\signature{Your name}:font facename=default size=0x0.
:p.
Your name, as it should appear at the end of the letter underneath the
space for your signature.  Items that should go on separate lines should
be separated by :font facename=Courier size=12x8.\\:font facename=default size=0x0. commands.
:h3 id=hd124.\location
:lm margin=1.
:p.:font facename=Courier size=12x8.\location{address}:font facename=default size=0x0.
:p.
This modifies your organisation's standard address.  This only appears
if the :font facename=Courier size=12x8.firstpage:font facename=default size=0x0. pagestyle is selected.
:h3 id=hd125.\telephone
:lm margin=1.
:font facename=Courier size=12x8.\telephone{number}:font facename=default size=0x0.
:p.
This is your telephone number.  This only appears if the
:font facename=Courier size=12x8.firstpage:font facename=default size=0x0. pagestyle is selected.
:h2 id=hd16.Line &amp. Page Breaking
:lm margin=1.
:p.The first thing LaTeX does when processing ordinary text is to
translate your input file into a string of glyphs and spaces.  To
produce a printed document, this string must be broken into lines, and
these lines must be broken into pages.  In some environments, you do the
line breaking yourself with the :font facename=Courier size=12x8.\\:font facename=default size=0x0. command, but LaTeX usually
does it for you.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd126.\\:elink.:pd.
:pt.:link reftype=hd refid=hd127.\- (hyphenation):elink.:pd.
:pt.:link reftype=hd refid=hd128.\cleardoublepage:elink.:pd.
:pt.:link reftype=hd refid=hd129.\clearpage:elink.:pd.
:pt.:link reftype=hd refid=hd130.\hyphenation:elink.:pd.
:pt.:link reftype=hd refid=hd131.\linebreak:elink.:pd.
:pt.:link reftype=hd refid=hd132.\newline:elink.:pd.
:pt.:link reftype=hd refid=hd133.\newpage:elink.:pd.
:pt.:link reftype=hd refid=hd134.\nolinebreak:elink.:pd.
:pt.:link reftype=hd refid=hd135.\nopagebreak:elink.:pd.
:pt.:link reftype=hd refid=hd136.\pagebreak:elink.:pd.
:eparml.
:h3 id=hd126.\\
:lm margin=1.
:p.:font facename=Courier size=12x8.\\[*][extra-space]:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\\:font facename=default size=0x0. command tells LaTeX to start a new line.  It has an
optional argument, :font facename=Courier size=12x8.extra-space:font facename=default size=0x0., that specifies how much extra
vertical space is to be inserted before the next line.  This can be a
negative amount.
The :font facename=Courier size=12x8.\\*:font facename=default size=0x0. command is the same as the ordinary :font facename=Courier size=12x8.\\:font facename=default size=0x0. command
except that it tells LaTeX not to start a new page after the line.
:h3 id=hd127.\-
:lm margin=1.
:p.The :font facename=Courier size=12x8.\-:font facename=default size=0x0. command tells LaTeX that it may hyphenate the word at that
point.  LaTeX is very good at hyphenating, and it will usually find all
correct hyphenation points.  The :font facename=Courier size=12x8.\-:font facename=default size=0x0. command is used for the
exceptional cases.
:h3 id=hd128.\cleardoublepage
:lm margin=1.
The :font facename=Courier size=12x8.\cleardoublepage:font facename=default size=0x0. command ends the current page and causes all
figures and tables that have so far appeared in the input to be printed.
In a two-sided printing style, it also makes the next page a right-hand
(odd-numbered) page, producing a blank page if necessary.
:h3 id=hd129.\clearpage
:lm margin=1.
:p.The :font facename=Courier size=12x8.\clearpage:font facename=default size=0x0. command ends the current page and causes all
figures and tables that have so far appeared in the input to be printed.
:h3 id=hd130.\hyphenation
:lm margin=1.
:p.:font facename=Courier size=12x8.\hyphenation{words}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\hyphenation:font facename=default size=0x0. command declares allowed hyphenation points,
where :font facename=Courier size=12x8.words:font facename=default size=0x0. is a list of words, separated by spaces, in which
each hyphenation point is indicated by a :font facename=Courier size=12x8.-:font facename=default size=0x0. character.
:h3 id=hd131.\linebreak
:lm margin=1.
:p.:font facename=Courier size=12x8.\linebreak[number]:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\linebreak:font facename=default size=0x0. command tells LaTeX to break the current line at
the point of the command.  With the optional argument, :font facename=Courier size=12x8.number:font facename=default size=0x0.,
you can convert the :font facename=Courier size=12x8.\linebreak:font facename=default size=0x0. command from a demand to a
request.  The number must be a number from 0 to 4.  The higher the
number, the more insistent the request is.
The :font facename=Courier size=12x8.\linebreak:font facename=default size=0x0. command causes LaTeX to stretch the line so it
extends to the right margin.
:h3 id=hd132.\newline
:lm margin=1.
The :font facename=Courier size=12x8.\newline:font facename=default size=0x0. command breaks the line right where it is.  The
:font facename=Courier size=12x8.\newline:font facename=default size=0x0. command can be used only in paragraph mode.
:h3 id=hd133.\newpage
:lm margin=1.
:p.The :font facename=Courier size=12x8.\newpage:font facename=default size=0x0. command ends the current page.
:h3 id=hd134.\nolinebreak
:lm margin=1.
:p.:font facename=Courier size=12x8.\nolinebreak[number]:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\nolinebreak:font facename=default size=0x0. command prevents LaTeX from breaking the current
line at the point of the command.  With the optional argument,
:font facename=Courier size=12x8.number:font facename=default size=0x0., you can convert the :font facename=Courier size=12x8.\nolinebreak:font facename=default size=0x0. command from a
demand to a request.  The number must be a number from 0 to 4.  The
higher the number, the more insistent the request is.
:h3 id=hd135.\nopagebreak
:lm margin=1.
:font facename=Courier size=12x8.\nopagebreak[number]:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\nopagebreak:font facename=default size=0x0. command prevents LaTeX from breaking the current
page at the point of the command.  With the optional argument,
:font facename=Courier size=12x8.number:font facename=default size=0x0., you can convert the :font facename=Courier size=12x8.\nopagebreak:font facename=default size=0x0. command from a
demand to a request.  The number must be a number from 0 to 4.  The
higher the number, the more insistent the request is.
:h3 id=hd136.\pagebreak
:lm margin=1.
:font facename=Courier size=12x8.\pagebreak[number]:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\pagebreak:font facename=default size=0x0. command tells LaTeX to break the current page at
the point of the command.  With the optional argument, :font facename=Courier size=12x8.number:font facename=default size=0x0.,
you can convert the :font facename=Courier size=12x8.\pagebreak:font facename=default size=0x0. command from a demand to a
request.  The number must be a number from 0 to 4.  The higher the
number, the more insistent the request is.
:h2 id=hd17.Making Paragraphs
:lm margin=1.
:p.A paragraph is ended by one or more completely blank lines -- lines not
containing even an :font facename=Courier size=12x8.%:font facename=default size=0x0..  A blank line should not appear where a new
paragraph cannot be started, such as in math mode or in the argument of
a sectioning command.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd137.\indent:elink.:pd.
:pt.:link reftype=hd refid=hd138.\noindent:elink.:pd.
:pt.:link reftype=hd refid=hd139.\par:elink.:pd.
:eparml.
:h3 id=hd137.\indent
:lm margin=1.
:font facename=Courier size=12x8.\indent:font facename=default size=0x0.
This produces a horizontal space whose width equals the width of the
paragraph indentation.  It is used to add paragraph indentation where it
would otherwise be suppressed.
:h3 id=hd138.\noindent
:lm margin=1.
:font facename=Courier size=12x8.\noindent:font facename=default size=0x0.
When used at the beginning of the paragraph, it suppresses the paragraph
indentation.  It has no effect when used in the middle of a paragraph.
:h3 id=hd139.\par
:lm margin=1.
:p.Equivalent to a blank line; often used to make command or environment
definitions easier to read.
:h2 id=hd18.Math Formulae
:lm margin=1.
:p.There are three environments that put LaTeX in math mode&colon.

:parml break=fit.:pt.:font facename=Courier size=12x8.math:font facename=default size=12x8.:pd.
For Formulae that appear right in the text.
:pt.:font facename=Courier size=12x8.displaymath:font facename=default size=12x8.:pd.For Formulae that appear on their own line.
:pt.:font facename=Courier size=12x8.equation:font facename=default size=12x8.:pd.The same as the displaymath environment except that it adds an equation
number in the right margin.

:eparml.:lm margin=1.
The :font facename=Courier size=12x8.math:font facename=default size=0x0. environment can be used in both paragraph and LR mode,
but the :font facename=Courier size=12x8.displaymath:font facename=default size=0x0. and :font facename=Courier size=12x8.equation:font facename=default size=0x0. environments can be used
only in paragraph mode.  The :font facename=Courier size=12x8.math:font facename=default size=0x0. and :font facename=Courier size=12x8.displaymath:font facename=default size=0x0.
environments are used so often that they have the following short forms&colon.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
    \(&dot.&dot.&dot.\)     instead of     \begin{math}&dot.&dot.&dot.\end{math}
    \[&dot.&dot.&dot.\]     instead of     \begin{displaymath}&dot.&dot.&dot.\end{displaymath}
:font facename=default size=0x0.:lm margin=1.:elines.
In fact, the :font facename=Courier size=12x8.math:font facename=default size=0x0. environment is so common that it has an even
shorter form&colon.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
    $ &dot.&dot.&dot. $     instead of     \(&dot.&dot.&dot.\)
:font facename=default size=0x0.:lm margin=1.:elines.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd140.Subscripts &amp. Superscripts:elink.:pd.
:pt.:link reftype=hd refid=hd141.Math Symbols:elink.:pd.
:pt.:link reftype=hd refid=hd142.Spacing in Math Mode:elink.:pd.
:pt.:link reftype=hd refid=hd143.Math Miscellany:elink.:pd.
:eparml.
:h3 id=hd140.Subscripts &amp. Superscripts
:lm margin=1.
To get an expression :font facename=Courier size=12x8.exp:font facename=default size=0x0. to appear as a subscript, you just type
:font facename=Courier size=12x8._{exp}:font facename=default size=0x0..  To get :font facename=Courier size=12x8.exp:font facename=default size=0x0. to appear as a superscript, you type
:font facename=Courier size=12x8.^{exp}:font facename=default size=0x0.. LaTeX handles superscripted superscripts and all of
that stuff in the natural way.  It even does the right thing when
something has both a subscript and a superscript.
:h3 id=hd141.Math Symbols
:lm margin=1.
:p.LaTeX provides almost any mathematical symbol you're likely to need. The
commands for generating them can be used only in math mode.  For
example, if you include :font facename=Courier size=12x8.$\pi$:font facename=default size=0x0. in your source, you will get the
symbol &pi. 
in your output.
:h3 id=hd142.Spacing in Math Mode
:lm margin=1.
In a :font facename=Courier size=12x8.math:font facename=default size=0x0. environment, LaTeX ignores the spaces you type and puts
in the spacing that it thinks is best.  LaTeX formats mathematics the
way it's done in mathematics texts.  If you want different spacing,
LaTeX provides the following four commands for use in math mode&colon.

:ol.:li.
:font facename=Courier size=12x8.\;:font facename=default size=0x0. - a thick space
:li.:font facename=Courier size=12x8.\&colon.:font facename=default size=0x0. - a medium space
:li.:font facename=Courier size=12x8.\,:font facename=default size=0x0. - a thin space
:li.:font facename=Courier size=12x8.\!:font facename=default size=0x0. - a negative thin space

:eol.:lm margin=1.
:h3 id=hd143.Math Miscellany
:lm margin=1.

:parml break=fit.:pt.:font facename=Courier size=12x8.\cdots:font facename=default size=12x8.:pd.
The :font facename=Courier size=12x8.\cdots:font facename=default size=0x0. command produces a horizontal ellipsis where the dots
are raised to the center of
the line.
:p.
eg. :artwork name='cdots.BMP' runin.
 
:pt.:font facename=Courier size=12x8.\ddots:font
facename=default size=12x8.:pd.The :font facename=Courier
size=12x8.\ddots:font facename=default size=0x0.  command
produces a diagonal ellipsis.  
:p.  
eg.:artwork name='ddots.BMP' runin.

:pt.:font facename=Courier size=12x8.\frac:font facename=default size=12x8.:pd.:font facename=Courier size=12x8.\frac{num}{den}:font facename=default size=0x0.
The :font facename=Courier size=12x8.\frac:font facename=default size=0x0. command produces the fraction :font facename=Courier size=12x8.num:font facename=default size=0x0. divided by :font facename=Courier size=12x8.den:font facename=default size=0x0..
:p.
eg.:artwork name='frac.BMP' runin.


:pt.:font facename=Courier size=12x8.\ldots:font facename=default size=12x8.:pd.The :font facename=Courier size=12x8.\ldots:font facename=default size=0x0. command produces an ellipsis.  This command works in
any mode, not just math mode.
:p.
eg.:artwork name='ldots.BMP' runin.

:pt.:font facename=Courier size=12x8.\overbrace:font facename=default size=12x8.:pd.:font facename=Courier size=12x8.\overbrace{text}:font facename=default size=0x0.
The :font facename=Courier size=12x8.\overbrace:font facename=default size=0x0. command generates a brace over text.
:p.
eg.:artwork name='overbrace.BMP' runin.

:pt.:font facename=Courier size=12x8.\overline:font facename=default size=12x8.:pd.:font facename=Courier size=12x8.\overline{text}:font facename=default size=0x0.
The :font facename=Courier size=12x8.\overline:font facename=default size=0x0. command causes the argument text to be overlined.
:p.
eg. :artwork name='overline.BMP' runin.

:pt.:font facename=Courier size=12x8.\sqrt:font facename=default size=12x8.:pd.:font facename=Courier size=12x8.\sqrt[root]{arg}:font facename=default size=0x0.
The :font facename=Courier size=12x8.\sqrt:font facename=default size=0x0. command produces the square root of its argument.  The
optional argument, :font facename=Courier size=12x8.root:font facename=default size=0x0., determines what root to produce, i.e.,
the cube root of :font facename=Courier size=12x8.x+y:font facename=default size=0x0. would be typed as :font facename=Courier size=12x8.$\sqrt[3]{x+y}$:font facename=default size=0x0..
:p.
eg.:artwork name='sqrt.BMP' runin.

:pt.:font facename=Courier size=12x8.\underbrace:font facename=default size=12x8.:pd.:font facename=Courier size=12x8.\underbrace{text}:font facename=default size=0x0.
The :font facename=Courier size=12x8.\underbrace:font facename=default size=0x0. command generates text with a brace underneath.
:p.
eg. :artwork name='underbrace.BMP' runin.

:pt.:font facename=Courier size=12x8.\underline:font facename=default size=12x8.:pd.:font facename=Courier size=12x8.\underline{text}:font facename=default size=0x0.
The :font facename=Courier size=12x8.\underline:font facename=default size=0x0. command causes the argument text to be underlined.
This command can also be used in paragraph and LR modes.
:p.
eg.:artwork name='underline.BMP' runin.

:pt.:font facename=Courier size=12x8.\vdots:font facename=default size=12x8.:pd.The :font facename=Courier size=12x8.\vdots:font facename=default size=0x0. command produces a vertical ellipsis.
:p.
eg. :artwork name='vdots.BMP' runin.

:eparml.:lm margin=1.
:h2 id=hd19.Modes
:lm margin=1.
:p.When LaTeX is processing your input text, it is always in one of three
modes&colon.

:ul.:li.
Paragraph mode
:li.Math mode
:li.Left-to-right mode, called LR mode for short

:eul.:lm margin=1.
:p.LaTeX changes mode only when it goes up or down a staircase to a
different level, though not all level changes produce mode changes.
Mode changes occur only when entering or leaving an environment, or when
LaTeX is processing the argument of certain text-producing commands.
"Paragraph mode" is the most common; it's the one LaTeX is in when
processing ordinary text.  In that mode, LaTeX breaks your text into
lines and breaks the lines into pages.  LaTeX is in "math mode" when
it's generating a mathematical formula.  In "LR mode", as in paragraph
mode, LaTeX considers the output that it produces to be a string of
words with spaces between them.  However, unlike paragraph mode, LaTeX
keeps going from left to right; it never starts a new line in LR mode.
Even if you put a hundred words into an :font facename=Courier size=12x8.\mbox:font facename=default size=0x0., LaTeX would keep
typesetting them from left to right inside a single box, and then
complain because the resulting box was too wide to fit on the line.
LaTeX is in LR mode when it starts making a box with an :font facename=Courier size=12x8.\mbox:font facename=default size=0x0.
command.  You can get it to enter a different mode inside the box - for
example, you can make it enter math mode to put a formula in the box.
There are also several text-producing commands and environments for
making a box that put LaTeX in paragraph mode.  The box make by one of
these commands or environments will be called a :font facename=Courier size=12x8.parbox:font facename=default size=0x0..  When
LaTeX is in paragraph mode while making a box, it is said to be in
"inner paragraph mode".  Its normal paragraph mode, which it starts out
in, is called "outer paragraph mode".
:h2 id=hd20.Page Styles
:lm margin=1.
The :font facename=Courier size=12x8.\documentstyle:font facename=default size=0x0. command determines the size and position of
the page's head and foot.  The page style determines what goes in them.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd144.\maketitle:elink.:pd.
:pt.:link reftype=hd refid=hd145.\pagenumbering:elink.:pd.
:pt.:link reftype=hd refid=hd146.\pagestyle:elink.:pd.
:pt.:link reftype=hd refid=hd147.\thispagestyle:elink.:pd.
:eparml.
:h3 id=hd144.\maketitle
:lm margin=1.
:p.:font facename=Courier size=12x8.\maketitle:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\maketitle:font facename=default size=0x0. command generates a title on a separate title page
- except in the :font facename=Courier size=12x8.article:font facename=default size=0x0. style, where the title normally goes at
the top of the first page.  Information used to produce the title is
obtained from the following declarations&colon.
See :link reftype=hd refid=hd20.Page Styles:elink. for the commands to give the information.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd148.\author:elink.:pd.
:pt.:link reftype=hd refid=hd149.\date:elink.:pd.
:pt.:link reftype=hd refid=hd150.\thanks:elink.:pd.
:pt.:link reftype=hd refid=hd151.\title:elink.:pd.
:eparml.
:h3 id=hd148.\author
:lm margin=1.
:p.:font facename=Courier size=12x8.\author{names}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\author:font facename=default size=0x0. command declares the author(s), where :font facename=Courier size=12x8.names:font facename=default size=0x0. is
a list of authors separated by :font facename=Courier size=12x8.\and:font facename=default size=0x0. commands.  Use :font facename=Courier size=12x8.\\:font facename=default size=0x0. to
separate lines within a single author's entry -- for example, to give
the author's institution or address.
NOTE&colon. The :font facename=Courier size=12x8.milstd:font facename=default size=0x0. and :font facename=Courier size=12x8.book-form:font facename=default size=0x0. styles have re-defined the
:font facename=Courier size=12x8.\maketitle:font facename=default size=0x0. command.  The :font facename=Courier size=12x8.\title:font facename=default size=0x0. declaration is the only
command of those shown below that has any meaning.
:h3 id=hd149.\date
:lm margin=1.
:p.:font facename=Courier size=12x8.\date{text}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\date:font facename=default size=0x0. command declares text to be the document's date.  With
no :font facename=Courier size=12x8.\date:font facename=default size=0x0. command, the current date is used.
:h3 id=hd150.\thanks
:lm margin=1.
:p.:font facename=Courier size=12x8.\thanks{text}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\thanks:font facename=default size=0x0. command produces a :font facename=Courier size=12x8.footnote:font facename=default size=0x0. to the title.
:h3 id=hd151.\title
:lm margin=1.
:p.:font facename=Courier size=12x8.\title{text}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\title:font facename=default size=0x0. command declares :font facename=Courier size=12x8.text:font facename=default size=0x0. to be the title.  Use
:font facename=Courier size=12x8.\\:font facename=default size=0x0. to tell LaTeX where to start a new line in a long title.
:h3 id=hd145.\pagenumbering
:lm margin=1.
:p.:font facename=Courier size=12x8.\pagenumbering{num_style}:font facename=default size=0x0.
Specifies the style of page numbers.  Possible values of :font facename=Courier size=12x8.num_style:font facename=default size=0x0. are&colon.

:ul.:li.
:font facename=Courier size=12x8.arabic:font facename=default size=0x0. - Arabic numerals
:li.:font facename=Courier size=12x8.roman:font facename=default size=0x0. - Lowercase roman numerals
:li.:font facename=Courier size=12x8.Roman:font facename=default size=0x0. - Uppercase roman numerals
:li.:font facename=Courier size=12x8.alph:font facename=default size=0x0. - Lowercase letters
:li.:font facename=Courier size=12x8.Alph:font facename=default size=0x0. - Uppercase letters

:eul.:lm margin=1.
:h3 id=hd146.\pagestyle
:lm margin=1.
:p.:font facename=Courier size=12x8.\pagestyle{option}:font facename=default size=0x0.
The :font facename=Courier size=12x8.\pagestyle:font facename=default size=0x0. command changes the style from the current page on
throughout the remainder of your document.
The valid options are&colon.

:ul.:li.
:font facename=Courier size=12x8.plain:font facename=default size=0x0. - Just a plain page number.
:li.:font facename=Courier size=12x8.empty:font facename=default size=0x0. - Produces empty heads and feet - no page numbers.
:li.:font facename=Courier size=12x8.headings:font facename=default size=0x0. - Puts running headings on each page.  The document
style specifies what goes in the headings.
:li.:font facename=Courier size=12x8.myheadings:font facename=default size=0x0. - You specify what is to go in the heading with the
:font facename=Courier size=12x8.\markboth:font facename=default size=0x0. or the :font facename=Courier size=12x8.\markright:font facename=default size=0x0. commands.

:eul.:lm margin=1.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd152.\mark:elink.:pd.
:eparml.
:h3 id=hd152.\mark
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
\markboth{left head}{right head} 
\markright{right head}
:font facename=default size=0x0.:lm margin=1.:elines.
The :font facename=Courier size=12x8.\markboth:font facename=default size=0x0. and :font facename=Courier size=12x8.\markright:font facename=default size=0x0. commands are used in
conjunction with the page style :font facename=Courier size=12x8.myheadings:font facename=default size=0x0. for setting either
both or just the right heading.  In addition to their use with the
:font facename=Courier size=12x8.myheadings:font facename=default size=0x0. page style, you can use them to override the normal
headings in the :font facename=Courier size=12x8.headings:font facename=default size=0x0. style, since LaTeX uses these same
commands to generate those heads.  You should note that a "left-hand
heading" is generated by the last :font facename=Courier size=12x8.\markboth:font facename=default size=0x0. command before the
end of the page, while a "right-hand heading" is generated by the first
:font facename=Courier size=12x8.\markboth:font facename=default size=0x0. or :font facename=Courier size=12x8.\markright:font facename=default size=0x0. that comes on the page if there is
one, otherwise by the last one before the page.
:h3 id=hd147.\thispagestyle
:lm margin=1.
:font facename=Courier size=12x8.\thispagestyle{option}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\thispagestyle:font facename=default size=0x0. command works in the same manner as the
:font facename=Courier size=12x8.\pagestyle:font facename=default size=0x0. command except that it changes the style for the
current page only.
:h2 id=hd21.Sectioning
:lm margin=1.
:p.Sectioning commands provide the means to structure your text into units.

:ul.:li.
:font facename=Courier size=12x8.\part:font facename=default size=0x0.
:li.:font facename=Courier size=12x8.\chapter:font facename=default size=0x0. (report style only)
:li.:font facename=Courier size=12x8.\section:font facename=default size=0x0.
:li.:font facename=Courier size=12x8.\subsection:font facename=default size=0x0.
:li.:font facename=Courier size=12x8.\subsubsection:font facename=default size=0x0.
:li.:font facename=Courier size=12x8.\paragraph:font facename=default size=0x0.
:li.:font facename=Courier size=12x8.\subparagraph:font facename=default size=0x0.
:li.:font facename=Courier size=12x8.\subsubparagraph:font facename=default size=0x0. (milstd and book-form styles only)
:li.:font facename=Courier size=12x8.\subsubsubparagraph:font facename=default size=0x0. (milstd and book-form styles only)

:eul.:lm margin=1.
All sectioning commands take the same general form, i.e.,
:font facename=Courier size=12x8.\chapter[optional]{title}:font facename=default size=0x0.
In addition to providing the heading in the text, the mandatory argument
of the sectioning command can appear in two other places&colon.

:ol.:li.
The table of contents
:li.The running head at the top of the page

:eol.:lm margin=1.
You may not want the same thing to appear in these other two places as
appears in the text heading.  To handle this situation, the sectioning
commands have an :font facename=Courier size=12x8.optional:font facename=default size=0x0. argument that provides the text for
these other two purposes.
The "sectioning commands" have :font facename=Courier size=12x8.*-forms:font facename=default size=0x0. that print a :font facename=Courier size=12x8.title:font facename=default size=0x0.,
but do not include a number and do not make an entry in the table of
contents.  For example, the :font facename=Courier size=12x8.*-form:font facename=default size=0x0. of the :font facename=Courier size=12x8.\subsection:font facename=default size=0x0.
command could look like&colon.
:font facename=Courier size=12x8.\subsection*{Example subsection}:font facename=default size=0x0.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd153.\appendix:elink.:pd.
:eparml.
:h3 id=hd153.\appendix
:lm margin=1.
:p.:font facename=Courier size=12x8.\appendix:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\appendix:font facename=default size=0x0. command changes the way sectional units are
numbered.  The :font facename=Courier size=12x8.\appendix:font facename=default size=0x0. command generates no text and does not
affect the numbering or parts.
:h2 id=hd22.Spaces &amp. Boxes
:lm margin=1.
:p.:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd154.\addvspace:elink.:pd.
:pt.:link reftype=hd refid=hd155.\bigskip:elink.:pd.
:pt.:link reftype=hd refid=hd156.\dotfill:elink.:pd.
:pt.:link reftype=hd refid=hd157.\fbox:elink.:pd.
:pt.:link reftype=hd refid=hd158.\framebox:elink.:pd.
:pt.:link reftype=hd refid=hd159.\hfill:elink.:pd.
:pt.:link reftype=hd refid=hd160.\hrulefill:elink.:pd.
:pt.:link reftype=hd refid=hd161.\hspace:elink.:pd.
:pt.:link reftype=hd refid=hd87.\makebox:elink.:pd.
:pt.:link reftype=hd refid=hd162.\mbox:elink.:pd.
:pt.:link reftype=hd refid=hd163.\medskip:elink.:pd.
:pt.:link reftype=hd refid=hd164.\newsavebox:elink.:pd.
:pt.:link reftype=hd refid=hd165.\parbox:elink.:pd.
:pt.:link reftype=hd refid=hd166.\raisebox:elink.:pd.
:pt.:link reftype=hd refid=hd167.\rule:elink.:pd.
:pt.:link reftype=hd refid=hd168.\savebox:elink.:pd.
:pt.:link reftype=hd refid=hd169.\smallskip:elink.:pd.
:pt.:link reftype=hd refid=hd170.\usebox:elink.:pd.
:pt.:link reftype=hd refid=hd171.\vfill:elink.:pd.
:pt.:link reftype=hd refid=hd172.\vspace:elink.:pd.
:eparml.
:h3 id=hd154.\addvspace
:lm margin=1.
:p.:font facename=Courier size=12x8.\addvspace{length}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\addvspace:font facename=default size=0x0. command normally adds a vertical space of height
length.  However, if vertical space has already been added to the same
point in the output by a previous :font facename=Courier size=12x8.\addvspace:font facename=default size=0x0. command, then this
command will not add more space than needed to make the natural length
of the total vertical space equal to :font facename=Courier size=12x8.length:font facename=default size=0x0..
:h3 id=hd155.\bigskip
:lm margin=1.
:p.The :font facename=Courier size=12x8.\bigskip:font facename=default size=0x0. command is equivalent to
:font facename=Courier size=12x8.\vspace{bigskipamount}:font facename=default size=0x0. where :font facename=Courier size=12x8.bigskipamount:font facename=default size=0x0. is determined
by the document style.
:h3 id=hd156.\dotfill
:lm margin=1.
:p.The :font facename=Courier size=12x8.\dotfill:font facename=default size=0x0. command produces a "rubber length" that produces dots
instead of just spaces.
:h3 id=hd157.\fbox
:lm margin=1.
:p.:font facename=Courier size=12x8.\fbox{text}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\fbox:font facename=default size=0x0. command is exactly the same as the :font facename=Courier size=12x8.\mbox:font facename=default size=0x0.
command, except that it puts a frame around the outside of the box that
it creates.
:h3 id=hd158.\framebox
:lm margin=1.
:p.:font facename=Courier size=12x8.\framebox[width][position]{text}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\framebox:font facename=default size=0x0. command is exactly the same as the :font facename=Courier size=12x8.\makebox:font facename=default size=0x0.
command, except that it puts a frame around the outside of the box that
it creates.
The framebox command produces a rule of thickness :font facename=Courier size=12x8.\fboxrule:font facename=default size=0x0., and
leaves a space :font facename=Courier size=12x8.\fboxsep:font facename=default size=0x0. between the rule and the contents of the
box.
:h3 id=hd159.\hfill
:lm margin=1.
:p.The :font facename=Courier size=12x8.\hfill:font facename=default size=0x0. fill command produces a "rubber length" which can
stretch or shrink horizontally.  It will be filled with spaces.
:h3 id=hd160.\hrulespace
:lm margin=1.
:p.The :font facename=Courier size=12x8.\hrulefill:font facename=default size=0x0. fill command produces a "rubber length" which can
stretch or shrink horizontally.  It will be filled with a horizontal
rule.
:h3 id=hd161.\hspace
:lm margin=1.
:p.:font facename=Courier size=12x8.\hspace[*]{length}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\hspace:font facename=default size=0x0. command adds horizontal space.  The length of the
space can be expressed in any terms that LaTeX understands, i.e.,
points, inches, etc.  You can add negative as well as positive space
with an :font facename=Courier size=12x8.\hspace:font facename=default size=0x0. command.  Adding negative space is like
backspacing.
LaTeX removes horizontal space that comes at the end of a line.  If you
don't want LaTeX to remove this space, include the optional :font facename=Courier size=12x8.*:font facename=default size=0x0.
argument.  Then the space is never removed.
:h3 id=hd87.\makebox
:lm margin=1.
:p.:font facename=Courier size=12x8.\makebox[width][position]{text}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\makebox:font facename=default size=0x0. command creates a box just wide enough to contain
the :font facename=Courier size=12x8.text:font facename=default size=0x0. specified.  The width of the box is specified by the
optional :font facename=Courier size=12x8.width:font facename=default size=0x0. argument.  The position of the text within the box
is determined by the optional :font facename=Courier size=12x8.position:font facename=default size=0x0. argument.

:ul.:li.
:font facename=Courier size=12x8.c:font facename=default size=0x0. - centered (default)
:li.:font facename=Courier size=12x8.l:font facename=default size=0x0. - flushleft
:li.:font facename=Courier size=12x8.r:font facename=default size=0x0. - flushright

:eul.:lm margin=1.
See :link reftype=hd refid=hd81.\makebox (picture):elink..
:h3 id=hd162.\mbox
:lm margin=1.
:font facename=Courier size=12x8.\mbox{text}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\mbox:font facename=default size=0x0. command creates a box just wide enough to hold the text
created by its argument.
:h3 id=hd163.\medskip
:lm margin=1.
:p.The :font facename=Courier size=12x8.\medskip:font facename=default size=0x0. command is equivalent to
:font facename=Courier size=12x8.\vspace{medskipamount}:font facename=default size=0x0. where :font facename=Courier size=12x8.medskipamount:font facename=default size=0x0. is determined
by the document style.
:h3 id=hd164.\newsavebox
:lm margin=1.
:p.:font facename=Courier size=12x8.\newsavebox{cmd}:font facename=default size=0x0.
:p.
Declares :font facename=Courier size=12x8.cmd:font facename=default size=0x0., which must be a command name that is not already
defined, to be a bin for saving boxes.
:h3 id=hd165.\parbox
:lm margin=1.
:p.:font facename=Courier size=12x8.\parbox[position]{width}{text}:font facename=default size=0x0.
:p.
A :font facename=Courier size=12x8.parbox:font facename=default size=0x0. is a box whose contents are created in :font facename=Courier size=12x8.paragraph:font facename=default size=0x0.
mode.  The :font facename=Courier size=12x8.\parbox:font facename=default size=0x0. has two mandatory arguments&colon.

:ul.:li.
:font facename=Courier size=12x8.width:font facename=default size=0x0. - specifies the width of the parbox, and
:li.:font facename=Courier size=12x8.text:font facename=default size=0x0. - the text that goes inside the parbox.

:eul.:lm margin=1.
LaTeX will position a :font facename=Courier size=12x8.parbox:font facename=default size=0x0. so its center lines up with the center of
the text line.  An optional first argument, :font facename=Courier size=12x8.position:font facename=default size=0x0., allows you
to line up either the top or bottom line in the parbox.
A :font facename=Courier size=12x8.\parbox:font facename=default size=0x0. command is used for a parbox containing a small piece
of text, with nothing fancy inside.  In particular, you shouldn't use
any of the paragraph-making environments inside a :font facename=Courier size=12x8.\parbox:font facename=default size=0x0.
argument.  For larger pieces of text, including ones containing a
paragraph-making environment, you should use a :font facename=Courier size=12x8.minipage:font facename=default size=0x0.
environment.
:h3 id=hd166.\raisebox
:lm margin=1.
:p.:font facename=Courier size=12x8.\raisebox{distance}[extend-above][extend-below]{text}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\raisebox:font facename=default size=0x0. command is used to raise or lower text.  The first
mandatory argument specifies how high the text is to be raised (or
lowered if it is a negative amount).  The text itself is processed in
:font facename=Courier size=12x8.LR mode:font facename=default size=0x0..
Sometimes it's useful to make LaTeX think something has a different
size than it really does - or a different size than LaTeX would
normally think it has.  The :font facename=Courier size=12x8.\raisebox:font facename=default size=0x0. command lets you tell
LaTeX how tall it is.
The first optional argument, :font facename=Courier size=12x8.extend-above:font facename=default size=0x0., makes LaTeX think
that the text extends above the line by the amount specified.  The
second optional argument, :font facename=Courier size=12x8.extend-below:font facename=default size=0x0., makes LaTeX think that
the text extends below the line by the amount specified.
:h3 id=hd167.\rule
:lm margin=1.
:p.:font facename=Courier size=12x8.\rule[raise-height]{width}{thickness}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\rule:font facename=default size=0x0. command is used to produce horizontal lines.  The
arguments are defined as follows&colon.

:ul.:li.
:font facename=Courier size=12x8.raise-height:font facename=default size=0x0. - specifies how high to raise the rule (optional)
:li.:font facename=Courier size=12x8.width:font facename=default size=0x0. - specifies the length of the rule (mandatory)
:li.:font facename=Courier size=12x8.thickness:font facename=default size=0x0. - specifies the thickness of the rule (mandatory)

:eul.:lm margin=1.
:h3 id=hd168.\savebox
:lm margin=1.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \sbox{cmd}[text]
 \savebox{cmd}[width][pos]{text}
:font facename=default size=0x0.:lm margin=1.:elines.
These commands typeset :font facename=Courier size=12x8.text:font facename=default size=0x0. in a box just as for :font facename=Courier size=12x8.\mbox:font facename=default size=0x0. or
:font facename=Courier size=12x8.\makebox:font facename=default size=0x0..  However, instead of printing the resulting box, they
save it in bin :font facename=Courier size=12x8.cmd:font facename=default size=0x0., which must have been declared with
:font facename=Courier size=12x8.\newsavebox:font facename=default size=0x0..
:h3 id=hd169.\smallskip
:lm margin=1.
:p.:font facename=Courier size=12x8.\smallskip:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\smallskip:font facename=default size=0x0. command is equivalent to
:font facename=Courier size=12x8.\vspace{smallskipamount}:font facename=default size=0x0. where :font facename=Courier size=12x8.smallskipamount:font facename=default size=0x0. is
determined by the document style.
:h3 id=hd170.\usebox
:lm margin=1.
:p.:font facename=Courier size=12x8.\usebox{cmd}:font facename=default size=0x0.
:p.
Prints the box most recently saved in bin :font facename=Courier size=12x8.cmd:font facename=default size=0x0. by a
:font facename=Courier size=12x8.\savebox:font facename=default size=0x0. command.
:h3 id=hd171.\vfill
:lm margin=1.
:p.The :font facename=Courier size=12x8.\vfill:font facename=default size=0x0. fill command produces a rubber length which can
stretch or shrink vertically.
:h3 id=hd172.\vspace
:lm margin=1.
:p.:font facename=Courier size=12x8.\vspace[*]{length}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\vspace:font facename=default size=0x0. command adds vertical space.  The length of the space
can be expressed in any terms that LaTeX understands, i.e., points,
inches, etc.  You can add negative as well as positive space with an
:font facename=Courier size=12x8.\vspace:font facename=default size=0x0. command.
LaTeX removes vertical space that comes at the end of a page.  If you
don't want LaTeX to remove this space, include the optional :font facename=Courier size=12x8.*:font facename=default size=0x0.
argument.  Then the space is never removed.
:h2 id=hd23.Special Characters
:lm margin=1.
:p.The following characters play a special role in LaTeX and are called
"special printing characters", or simply "special characters".
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
                          # $ % &amp. ~ _ ^ \ { }
:font facename=default size=0x0.:lm margin=1.:elines.
Whenever you put one of these special characters into your file, you are
doing something special.  If you simply want the character to be printed
just as any other letter, include a :font facename=Courier size=12x8.\:font facename=default size=0x0. in front of the character.
For example, :font facename=Courier size=12x8.\$:font facename=default size=0x0. will produce :font facename=Courier size=12x8.$:font facename=default size=0x0. in your output.
The exception to the rule is the :font facename=Courier size=12x8.\:font facename=default size=0x0. itself because :font facename=Courier size=12x8.\\:font facename=default size=0x0. has
its own special meaning.  A :font facename=Courier size=12x8.\:font facename=default size=0x0. is produced by typing
:font facename=Courier size=12x8.$\backslash$:font facename=default size=0x0. in your file.
:h2 id=hd24.Splitting the Input
:lm margin=1.
:p.A large document requires a lot of input.  Rather than putting the whole
input in a single large file, it's more efficient to split it into
several smaller ones.  Regardless of how many separate files you use,
there is one that is the root file; it is the one whose name you type
when you run LaTeX.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd173.\include:elink.:pd.
:pt.:link reftype=hd refid=hd174.\includeonly:elink.:pd.
:pt.:link reftype=hd refid=hd175.\input:elink.:pd.
:eparml.
:h3 id=hd173.\include
:lm margin=1.
:p.:font facename=Courier size=12x8.\include{file}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\include:font facename=default size=0x0. command is used in conjunction with the
:font facename=Courier size=12x8.\includeonly:font facename=default size=0x0. command for selective inclusion of files.  The
:font facename=Courier size=12x8.file:font facename=default size=0x0. argument is the first name of a file, denoting
:font facename=Courier size=12x8.&apos.file.tex&apos.:font facename=default size=0x0..  If :font facename=Courier size=12x8.file:font facename=default size=0x0. is one the file names in the file list
of the :font facename=Courier size=12x8.\includeonly:font facename=default size=0x0. command or if there is no :font facename=Courier size=12x8.\includeonly:font facename=default size=0x0.
command, the :font facename=Courier size=12x8.\include:font facename=default size=0x0. command is equivalent to
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
\clearpage \input{file} \clearpage
:font facename=default size=0x0.:lm margin=1.:elines.
except that if the file :font facename=Courier size=12x8.&apos.file.tex&apos.:font facename=default size=0x0. does not exist, then a warning
message rather than an error is produced.  If the file is not in the
file list, the :font facename=Courier size=12x8.\include:font facename=default size=0x0. command is equivalent to :font facename=Courier size=12x8.\clearpage:font facename=default size=0x0..
The :font facename=Courier size=12x8.\include:font facename=default size=0x0. command may not appear in the preamble or in a file
read by another :font facename=Courier size=12x8.\include:font facename=default size=0x0. command.
:h3 id=hd174.\includeonly
:lm margin=1.
:p.:font facename=Courier size=12x8.\includeonly{file_list}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\includeonly:font facename=default size=0x0. command controls which files will be read in by
an :font facename=Courier size=12x8.\include:font facename=default size=0x0. command.  It can only appear in the preamble.
:h3 id=hd175.\input 
:lm margin=1. 
:font facename=Courier size=12x8.\input{file}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\input :font facename=default size=0x0. command causes the indicated :font facename=Courier size=12x8.file:font facename=default size=0x0. to be read and
processed, exactly as if its contents had been inserted in the current
file at that point.  The file name may be a complete file name with
extension or just a first name, in which case the file :font facename=Courier size=12x8.&apos.file.tex&apos.:font facename=default size=0x0.
is used.
:h2 id=hd25.Starting &amp. Ending
:lm margin=1.
:p.Your input file must contain the following commands as a minimum&dot.&dot.&dot.
:lines align=left.:lm margin=11.:font facename=Courier size=12x8.
 \documentstyle{style}
 \begin{document}
   &dot.&dot.&dot. your text goes here &dot.&dot.&dot.
 \end{document}
:font facename=default size=0x0.:lm margin=1.:elines.
&dot.&dot.&dot.where the :font facename=Courier size=12x8.style:font facename=default size=0x0. selected is one the valid styles for LaTeX.
See :link reftype=hd refid=hd11.Document Styles:elink., and also see :link reftype=hd refid=hd3.Overview:elink., for details of the
various document styles available locally.
You may include other LaTeX commands between the :font facename=Courier size=12x8.\documentstyle:font facename=default size=0x0.
and the :font facename=Courier size=12x8.\begin{document}:font facename=default size=0x0. commands.
:h2 id=hd26.Table of Contents
:lm margin=1.
:p.A table of contents is produced with the :font facename=Courier size=12x8.\tableofcontents:font facename=default size=0x0.
command. You put the command right where you want the table of contents
to go; LaTeX does the rest for you.  It produces a heading, but it does
not automatically start a new page.  If you want a new page after the
table of contents, include a :font facename=Courier size=12x8.\newpage:font facename=default size=0x0. command after the
:font facename=Courier size=12x8.\tableofcontents:font facename=default size=0x0. command.
There are similar commands :font facename=Courier size=12x8.\listoffigures:font facename=default size=0x0. and
:font facename=Courier size=12x8.\listoftables:font facename=default size=0x0. for producing a list of figures and a list of
tables, respectively.  Everything works exactly the same as for the
table of contents.
NOTE&colon. If you want any of these  items  to be generated,  you cannot
have the :font facename=Courier size=12x8.\nofiles:font facename=default size=0x0. command in your document.
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd176.\addcontentsline:elink.:pd.
:pt.:link reftype=hd refid=hd177.\addtocontents:elink.:pd.
:eparml.
:h3 id=hd176.\addcontentsline
:lm margin=1.
:p.:font facename=Courier size=12x8.\addcontentsline{file}{sec_unit}{entry}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\addcontentsline:font facename=default size=0x0. command adds an entry to the specified list
or table where&dot.&dot.&dot.

:ul.:li.
:font facename=Courier size=12x8.file:font facename=default size=0x0. is the extension of the file on which information is to be
written&colon. :font facename=Courier size=12x8.toc:font facename=default size=0x0. (table of contents), :font facename=Courier size=12x8.lof:font facename=default size=0x0. (list of figures),
or :font facename=Courier size=12x8.lot:font facename=default size=0x0. (list of tables).
:li.:font facename=Courier size=12x8.sec_unit:font facename=default size=0x0. controls the formatting of the entry.  It should be one
of the following, depending upon the value of the file argument&colon.

:ol.:li.
:font facename=Courier size=12x8.toc:font facename=default size=0x0. - the name of the sectional unit, such as part or subsection.
:li.:font facename=Courier size=12x8.lof:font facename=default size=0x0. - figure
:li.:font facename=Courier size=12x8.lot:font facename=default size=0x0. - table

:eol.:lm margin=6.
:li.:font facename=Courier size=12x8.entry:font facename=default size=0x0. is the text of the entry.

:eul.:lm margin=1.
:h3 id=hd177.\addtocontents
:lm margin=1.
:p.:font facename=Courier size=12x8.\addtocontents{file}{text}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\addtocontents:font facename=default size=0x0. command adds text (or formatting commands) directly
to the file that generates the table of contents or list of figures or
tables.

:ul.:li.
:font facename=Courier size=12x8.file:font facename=default size=0x0. is the extension of the file on which information is to be
written&colon. :font facename=Courier size=12x8.toc:font facename=default size=0x0. (table of contents), :font facename=Courier size=12x8.lof:font facename=default size=0x0. (list of figures),
or :font facename=Courier size=12x8.lot:font facename=default size=0x0. (list of tables).
:li.:font facename=Courier size=12x8.text:font facename=default size=0x0. is the information to be written.

:eul.:lm margin=1.
:h2 id=hd27.Terminal Input/Output
:lm margin=1.
:p.:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd178.\typeout:elink.:pd.
:pt.:link reftype=hd refid=hd179.\typein:elink.:pd.
:eparml.
:h3 id=hd178.\typeout
:lm margin=1.
:p.:font facename=Courier size=12x8.\typeout{msg}:font facename=default size=0x0.
:p.
Prints :font facename=Courier size=12x8.msg:font facename=default size=0x0. on the terminal and in the :font facename=Courier size=12x8.log:font facename=default size=0x0. file.  Commands
in :font facename=Courier size=12x8.msg:font facename=default size=0x0. that are defined with :font facename=Courier size=12x8.\newcommand:font facename=default size=0x0. or
:font facename=Courier size=12x8.\renewcommand:font facename=default size=0x0. are replaced by their definitions before being
printed.
LaTeX's usual rules for treating multiple spaces as
a single space and ignoring spaces after a command name apply to
:font facename=Courier size=12x8.msg:font facename=default size=0x0..  A :font facename=Courier size=12x8.\space:font facename=default size=0x0. command in :font facename=Courier size=12x8.msg:font facename=default size=0x0. causes a single space
to be printed.
:h3 id=hd179.\typein
:lm margin=1.
:p.:font facename=Courier size=12x8.\typein[cmd]{msg}:font facename=default size=0x0.
:p.
Prints :font facename=Courier size=12x8.msg:font facename=default size=0x0. on the terminal and causes LaTeX to stop and wait for
you to type a line of input, ending with return.  If the :font facename=Courier size=12x8.cmd:font facename=default size=0x0.
argument is missing, the typed input is processed as if it had been
included in the input file in place of the :font facename=Courier size=12x8.\typein:font facename=default size=0x0. command.  If
the :font facename=Courier size=12x8.cmd:font facename=default size=0x0. argument is present, it must be a command name.  This
command name is then defined or redefined to be the typed input.
:h2 id=hd28.Typefaces
:lm margin=1.
:p.The :font facename=Courier size=12x8.typeface:font facename=default size=0x0. is specified by giving the "size" and "style".  A
typeface is also called a "font".
:parml tsize=30 break=none compact.:pt.:link reftype=hd refid=hd180.Styles:elink.:pd.
:pt.:link reftype=hd refid=hd181.Sizes:elink.:pd.
:eparml.
:h3 id=hd180.Styles
:lm margin=1.
:p.The following type style commands are supported by LaTeX.

:parml break=fit.
:pt.:font facename=Courier size=12x8.\rm:font facename=default 
size=12x8.:pd.Roman.:artwork align=left name='rm.BMP'.
:pt.:font facename=Courier size=12x8.\it:font facename=default
size=12x8.:pd.Italics. :artwork align=left name='it.BMP'.
:pt.:font facename=Courier size=12x8.\em:font facename=default 
size=12x8.:pd.Emphasis (toggles between \it and \rm).
:pt.:font facename=Courier size=12x8.\bf:font facename=default
size=12x8.:pd.Boldface. :artwork align=left name='bf.BMP'.
:pt.:font facename=Courier size=12x8.\sl:font facename=default
size=12x8.:pd.Slanted. :artwork align=left name='sl.BMP'.
:pt.:font facename=Courier size=12x8.\sf:font facename=default
size=12x8.:pd.Sans serif. :artwork align=left name='sf.BMP'.
:pt.:font facename=Courier size=12x8.\sc:font facename=default
size=12x8.:pd.Small caps. :artwork align=left name='sc.BMP'.
:pt.:font facename=Courier size=12x8.\tt:font facename=default
size=12x8.:pd.Typewriter. :artwork align=left name='tt.BMP'.
:eparml.:lm margin=1.
:h3 id=hd181.Sizes
:lm margin=1.
:p.The following type size commands are supported by LaTeX.

:parml break=fit.
:pt.:font facename=Courier size=12x8.\tiny:font facename=default
size=12x8.:artwork name='tiny.BMP' align=left.:pd.
:pt.:font facename=Courier size=12x8.\scriptsize:font facename=default
size=12x8.:artwork name='scriptsize.BMP' align=left.:pd.
:pt.:font facename=Courier size=12x8.\footnotesize:font
facename=default size=12x8.:artwork name='footnotesize.BMP' align=left.:pd.
:pt.:font facename=Courier size=12x8.\small:font facename=default
size=12x8.:artwork name='small.BMP' align=left.:pd.
:pt.:font facename=Courier size=12x8.\normalsize:font facename=default size=12x8.:artwork name='normalsize.BMP' align=left.:pd.
:pt.:font facename=Courier size=12x8.\large:font facename=default
size=12x8.:artwork name='large.BMP' align=left.:pd.
:pt.:font facename=Courier size=12x8.\Large:font facename=default
size=12x8. :artwork name='llarge.BMP' align=left.:pd.
:pt.:font facename=Courier size=12x8.\LARGE:font facename=default
size=12x8. :artwork name='lllarge.BMP' align=left.:pd.
:pt.:font facename=Courier size=12x8.\huge:font facename=default
size=12x8.:artwork name='huge.BMP' align=left.:pd.
:pt.:font facename=Courier size=12x8.\Huge:font facename=default
size=12x8. :artwork name='hhuge.BMP' align=left.:pd.

:eparml.:lm margin=1.
:h1 id=hd5.Parameters
:lm margin=1.
:p.The input file specification indicates the file to be formatted; TeX
uses :font facename=Courier size=12x8.&apos..tex&apos.:font facename=default size=0x0. as a default file extension.  If you omit the input file
entirely, TeX accepts input from the terminal.  You specify command
options by supplying a string as a parameter to the
command. eg.
:p.
:font facename=Courier size=12x8.
latex "\scrollmode\input foo.tex
:font facename=default size=0x0.
:p.
&dot.&dot.&dot.will process :font facename=Courier size=12x8.&apos.foo.tex&apos.:font facename=default size=0x0. without pausing after every error.
Output files are always created in the current directory. When you fail
to specify an input file name, TeX bases the output names on the file
specification associated with the logical name TEX_OUTPUT, typically
:font facename=Courier size=12x8.texput.log:font facename=default size=0x0..
:h1 id=hd6.Alphabetical List of Commands
:lm margin=1.
:p.:parml tsize=30 break=none compact.
:pt.:link reftype=hd refid=hd182._exp (subscript):elink.:pd.
:pt.:link reftype=hd refid=hd183.^exp (superscript):elink.:pd.
:pt.:link reftype=hd refid=hd126.\\:elink.:pd.
:pt.:link reftype=hd refid=hd127.\- (hyphenation):elink.:pd.
:pt.:link reftype=hd refid=hd184.\;:elink.:pd.
:pt.:link reftype=hd refid=hd185.\&colon.:elink.:pd.
:pt.:link reftype=hd refid=hd186.\,:elink.:pd.
:pt.:link reftype=hd refid=hd187.\!:elink.:pd.
:pt.:link reftype=hd refid=hd96.\=:elink.:pd.
:pt.:link reftype=hd refid=hd97.\>:elink.:pd.
:pt.:link reftype=hd refid=hd98.\<:elink.:pd.
:pt.:link reftype=hd refid=hd99.\+:elink.:pd.
:pt.:link reftype=hd refid=hd100.\- (tabbing):elink.:pd.
:pt.:link reftype=hd refid=hd101.\':elink.:pd.
:pt.:link reftype=hd refid=hd102.\`:elink.:pd.
:pt.:link reftype=hd refid=hd176.\addcontentsline:elink.:pd.
:pt.:link reftype=hd refid=hd177.\addtocontents:elink.:pd.
:pt.:link reftype=hd refid=hd29.\addtocounter:elink.:pd.
:pt.:link reftype=hd refid=hd122.\address:elink.:pd.
:pt.:link reftype=hd refid=hd117.\addtolength:elink.:pd.
:pt.:link reftype=hd refid=hd154.\addvspace:elink.:pd.
:pt.:link reftype=hd refid=hd30.\alph:elink.:pd.
:pt.:link reftype=hd refid=hd153.\appendix:elink.:pd.
:pt.:link reftype=hd refid=hd31.\arabic:elink.:pd.
:pt.:link reftype=hd refid=hd49.array:elink.:pd.
:pt.:link reftype=hd refid=hd148.\author:elink.:pd.
:pt.:link reftype=hd refid=hd188.\bf:elink.:pd.
:pt.:link reftype=hd refid=hd108.\bibitem:elink.:pd.
:pt.:link reftype=hd refid=hd155.\bigskip:elink.:pd.
:pt.:link reftype=hd refid=hd189.\cdots:elink.:pd.
:pt.:link reftype=hd refid=hd50.center:elink.:pd.
:pt.:link reftype=hd refid=hd72.\centering:elink.:pd.
:pt.:link reftype=hd refid=hd75.\circle:elink.:pd.
:pt.:link reftype=hd refid=hd109.\cite:elink.:pd.
:pt.:link reftype=hd refid=hd128.\cleardoublepage:elink.:pd.
:pt.:link reftype=hd refid=hd129.\clearpage:elink.:pd.
:pt.:link reftype=hd refid=hd104.\cline:elink.:pd.
:pt.:link reftype=hd refid=hd120.\closing:elink.:pd.
:pt.:link reftype=hd refid=hd76.\dashbox:elink.:pd.
:pt.:link reftype=hd refid=hd149.\date:elink.:pd.
:pt.:link reftype=hd refid=hd190.\ddots:elink.:pd.
:pt.:link reftype=hd refid=hd51.description:elink.:pd.
:pt.:link reftype=hd refid=hd156.\dotfill:elink.:pd.
:pt.:link reftype=hd refid=hd191.\em:elink.:pd.
:pt.:link reftype=hd refid=hd52.enumerate:elink.:pd.
:pt.:link reftype=hd refid=hd53.eqnarray:elink.:pd.
:pt.:link reftype=hd refid=hd54.equation:elink.:pd.
:pt.:link reftype=hd refid=hd55.figure:elink.:pd.
:pt.:link reftype=hd refid=hd157.\fbox:elink.:pd.
:pt.:link reftype=hd refid=hd45.\flushbottom:elink.:pd.
:pt.:link reftype=hd refid=hd56.flushleft:elink.:pd.
:pt.:link reftype=hd refid=hd57.flushright:elink.:pd.
:pt.:link reftype=hd refid=hd32.\fnsymbol:elink.:pd.
:pt.:link reftype=hd refid=hd112.\footnote:elink.:pd.
:pt.:link reftype=hd refid=hd113.\footnotemark:elink.:pd.
:pt.:link reftype=hd refid=hd192.\footnotesize:elink.:pd.
:pt.:link reftype=hd refid=hd114.\footnotetext:elink.:pd.
:pt.:link reftype=hd refid=hd193.\frac:elink.:pd.
:pt.:link reftype=hd refid=hd77.\frame:elink.:pd.
:pt.:link reftype=hd refid=hd158.\framebox:elink.:pd.
:pt.:link reftype=hd refid=hd159.\hfill:elink.:pd.
:pt.:link reftype=hd refid=hd105.\hline:elink.:pd.
:pt.:link reftype=hd refid=hd160.\hrulefill:elink.:pd.
:pt.:link reftype=hd refid=hd161.\hspace:elink.:pd.
:pt.:link reftype=hd refid=hd194.\huge:elink.:pd.
:pt.:link reftype=hd refid=hd195.\Huge (capital "h"):elink.:pd.
:pt.:link reftype=hd refid=hd130.\hyphenation:elink.:pd.
:pt.:link reftype=hd refid=hd173.\include:elink.:pd.
:pt.:link reftype=hd refid=hd174.\includeonly:elink.:pd.
:pt.:link reftype=hd refid=hd137.\indent:elink.:pd.
:pt.:link reftype=hd refid=hd175.\input:elink.:pd.
:pt.:link reftype=hd refid=hd196.\it:elink.:pd.
:pt.:link reftype=hd refid=hd58.itemize:elink.:pd.
:pt.:link reftype=hd refid=hd103.\kill:elink.:pd.
:pt.:link reftype=hd refid=hd38.\label:elink.:pd.
:pt.:link reftype=hd refid=hd197.\large:elink.:pd.
:pt.:link reftype=hd refid=hd198.\Large (capital "l"):elink.:pd.
:pt.:link reftype=hd refid=hd199.\LARGE (all caps):elink.:pd.
:pt.:link reftype=hd refid=hd200.\ldots:elink.:pd.
:pt.:link reftype=hd refid=hd79.\line:elink.:pd.
:pt.:link reftype=hd refid=hd131.\linebreak:elink.:pd.
:pt.:link reftype=hd refid=hd80.\linethickness:elink.:pd.
:pt.:link reftype=hd refid=hd59.list:elink.:pd.
:pt.:link reftype=hd refid=hd124.\location:elink.:pd.
:pt.:link reftype=hd refid=hd87.\makebox:elink.:pd.
:pt.:link reftype=hd refid=hd144.\maketitle:elink.:pd.
:pt.:link reftype=hd refid=hd152.\mark:elink.:pd.
:pt.:link reftype=hd refid=hd162.\mbox:elink.:pd.
:pt.:link reftype=hd refid=hd163.\medskip:elink.:pd.
:pt.:link reftype=hd refid=hd60.minipage:elink.:pd.
:pt.:link reftype=hd refid=hd106.\multicolumn:elink.:pd.
:pt.:link reftype=hd refid=hd82.\multiput:elink.:pd.
:pt.:link reftype=hd refid=hd41.\newcommand:elink.:pd.
:pt.:link reftype=hd refid=hd33.\newcounter:elink.:pd.
:pt.:link reftype=hd refid=hd42.\newenvironment:elink.:pd.
:pt.:link reftype=hd refid=hd44.\newfont:elink.:pd.
:pt.:link reftype=hd refid=hd115.\newlength:elink.:pd.
:pt.:link reftype=hd refid=hd132.\newline:elink.:pd.
:pt.:link reftype=hd refid=hd133.\newpage:elink.:pd.
:pt.:link reftype=hd refid=hd164.\newsavebox:elink.:pd.
:pt.:link reftype=hd refid=hd43.\newtheorem:elink.:pd.
:pt.:link reftype=hd refid=hd110.\nocite:elink.:pd.
:pt.:link reftype=hd refid=hd138.\noindent:elink.:pd.
:pt.:link reftype=hd refid=hd134.\nolinebreak:elink.:pd.
:pt.:link reftype=hd refid=hd201.\normalsize:elink.:pd.
:pt.:link reftype=hd refid=hd135.\nopagebreak:elink.:pd.
:pt.:link reftype=hd refid=hd46.\onecolumn:elink.:pd.
:pt.:link reftype=hd refid=hd119.\opening:elink.:pd.
:pt.:link reftype=hd refid=hd83.\oval:elink.:pd.
:pt.:link reftype=hd refid=hd202.\overbrace:elink.:pd.
:pt.:link reftype=hd refid=hd203.\overline:elink.:pd.
:pt.:link reftype=hd refid=hd136.\pagebreak:elink.:pd.
:pt.:link reftype=hd refid=hd145.\pagenumbering:elink.:pd.
:pt.:link reftype=hd refid=hd39.\pageref:elink.:pd.
:pt.:link reftype=hd refid=hd146.\pagestyle:elink.:pd.
:pt.:link reftype=hd refid=hd139.\par:elink.:pd.
:pt.:link reftype=hd refid=hd165.\parbox:elink.:pd.
:pt.:link reftype=hd refid=hd61.picture:elink.:pd.
:pt.:link reftype=hd refid=hd84.\put:elink.:pd.
:pt.:link reftype=hd refid=hd62.quotation:elink.:pd.
:pt.:link reftype=hd refid=hd63.quote:elink.:pd.
:pt.:link reftype=hd refid=hd47.\raggedbottom:elink.:pd.
:pt.:link reftype=hd refid=hd74.\raggedleft:elink.:pd.
:pt.:link reftype=hd refid=hd73.\raggedright:elink.:pd.
:pt.:link reftype=hd refid=hd166.\raisebox:elink.:pd.
:pt.:link reftype=hd refid=hd40.\ref:elink.:pd.
:pt.:link reftype=hd refid=hd204.\rm:elink.:pd.
:pt.:link reftype=hd refid=hd34.\roman:elink.:pd.
:pt.:link reftype=hd refid=hd167.\rule:elink.:pd.
:pt.:link reftype=hd refid=hd168.\savebox:elink.:pd.
:pt.:link reftype=hd refid=hd205.\sc:elink.:pd.
:pt.:link reftype=hd refid=hd206.\scriptsize:elink.:pd.
:pt.:link reftype=hd refid=hd35.\setcounter:elink.:pd.
:pt.:link reftype=hd refid=hd116.\setlength:elink.:pd.
:pt.:link reftype=hd refid=hd118.\settowidth:elink.:pd.
:pt.:link reftype=hd refid=hd207.\sf:elink.:pd.
:pt.:link reftype=hd refid=hd85.\shortstack:elink.:pd.
:pt.:link reftype=hd refid=hd123.\signature:elink.:pd.
:pt.:link reftype=hd refid=hd208.\sl:elink.:pd.
:pt.:link reftype=hd refid=hd209.\small:elink.:pd.
:pt.:link reftype=hd refid=hd169.\smallskip:elink.:pd.
:pt.:link reftype=hd refid=hd210.\sqrt:elink.:pd.
:pt.:link reftype=hd refid=hd64.tabbing:elink.:pd.
:pt.:link reftype=hd refid=hd65.table:elink.:pd.
:pt.:link reftype=hd refid=hd66.tabular:elink.:pd.
:pt.:link reftype=hd refid=hd125.\telephone:elink.:pd.
:pt.:link reftype=hd refid=hd150.\thanks:elink.:pd.
:pt.:link reftype=hd refid=hd67.thebibliography:elink.:pd.
:pt.:link reftype=hd refid=hd68.theorem:elink.:pd.
:pt.:link reftype=hd refid=hd147.\thispagestyle:elink.:pd.
:pt.:link reftype=hd refid=hd211.\tiny:elink.:pd.
:pt.:link reftype=hd refid=hd151.\title:elink.:pd.
:pt.:link reftype=hd refid=hd69.titlepage:elink.:pd.
:pt.:link reftype=hd refid=hd212.\tt:elink.:pd.
:pt.:link reftype=hd refid=hd48.\twocolumn:elink.:pd.
:pt.:link reftype=hd refid=hd178.\typeout:elink.:pd.
:pt.:link reftype=hd refid=hd179.\typein:elink.:pd.
:pt.:link reftype=hd refid=hd213.\underbrace:elink.:pd.
:pt.:link reftype=hd refid=hd214.\underline:elink.:pd.
:pt.:link reftype=hd refid=hd170.\usebox:elink.:pd.
:pt.:link reftype=hd refid=hd36.\usecounter:elink.:pd.
:pt.:link reftype=hd refid=hd37.\value:elink.:pd.
:pt.:link reftype=hd refid=hd215.\vdots:elink.:pd.
:pt.:link reftype=hd refid=hd86.\vector:elink.:pd.
:pt.:link reftype=hd refid=hd111.\verb:elink.:pd.
:pt.:link reftype=hd refid=hd70.verbatim:elink.:pd.
:pt.:link reftype=hd refid=hd71.verse:elink.:pd.
:pt.:link reftype=hd refid=hd171.\vfill:elink.:pd.
:pt.:link reftype=hd refid=hd107.\vline:elink.:pd.
:pt.:link reftype=hd refid=hd172.\vspace:elink.:pd.
:eparml.
:h2 id=hd182._{exp} (subscript)
:lm margin=1.
:p.To get an expression :font facename=Courier size=12x8.exp:font facename=default size=0x0. to appear as a subscript, you just type
:font facename=Courier size=12x8._{exp}:font facename=default size=0x0..  Use in math mode.
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd140.Subscripts &amp. Superscripts:elink..
:h2 id=hd183.^{exp} (superscript)
:lm margin=1.
:p.To get an expression :font facename=Courier size=12x8.exp:font facename=default size=0x0. to appear as a superscript, you just
type :font facename=Courier size=12x8.^{exp}:font facename=default size=0x0..  Use in math mode.
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd140.Subscripts &amp. Superscripts:elink..
:h2 id=hd184.\;
:lm margin=1.
:p.Include a thick space in math mode.
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd142.Spacing in Math Mode:elink..
:h2 id=hd185.\&colon.
:lm margin=1.
:p.Include a medium space in math mode.
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd142.Spacing in Math Mode:elink..
:h2 id=hd186.\,
:lm margin=1.
:p.Include a thin space in math mode.
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd142.Spacing in Math Mode:elink..
:h2 id=hd187.\!
:lm margin=1.
:p.Include a negative thin space in math mode.
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd142.Spacing in Math Mode:elink..
:h2 id=hd188.\bf
:lm margin=1.
:p.Boldface typeface.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd180.Styles:elink..
:h2 id=hd189.\cdots
:lm margin=1.
:p.The :font facename=Courier size=12x8.\cdots:font facename=default size=0x0. command produces a horizontal ellipsis where the dots
are raised to the center of the line.
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd143.Math Miscellany:elink..
:h2 id=hd190.\ddots
:lm margin=1.
:p.The :font facename=Courier size=12x8.\ddots:font facename=default size=0x0. command produces a diagonal ellipsis.
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd143.Math Miscellany:elink..
:h2 id=hd191.\em
:lm margin=1.
:p.Emphasis (toggles between :font facename=Courier size=12x8.\it:font facename=default size=0x0. and :font facename=Courier size=12x8.\rm:font facename=default size=0x0.).
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd180.Styles:elink..
:h2 id=hd192.\footnotesize
:lm margin=1.
:p.Third smallest of 10 typefaces available.  This is the default size for
footnotes.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd181.Sizes:elink..
:h2 id=hd193.\frac
:lm margin=1.
:p.:font facename=Courier size=12x8.\frac{num}{den}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\frac:font facename=default size=0x0. command produces the fraction :font facename=Courier size=12x8.num:font facename=default size=0x0. divided by
:font facename=Courier size=12x8.den:font facename=default size=0x0..
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd143.Math Miscellany:elink..
:h2 id=hd194.\huge
:lm margin=1.
:p.Second largest of 10 typefaces available.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd181.Sizes:elink..
:h2 id=hd195.\Huge
:lm margin=1.
:p.Largest of 10 typefaces available.  All fonts may not be available in
this size.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd181.Sizes:elink..
:h2 id=hd196.\it
:lm margin=1.
:p.Italics typeface.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd180.Styles:elink..
:h2 id=hd197.\large
:lm margin=1.
:p.Slightly larger than default typeface size.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd181.Sizes:elink..
:h2 id=hd198.\Large
:lm margin=1.
:p.Fourth largest of typefaces available.  Is generally the default for
titles.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd181.Sizes:elink..
:h2 id=hd199.\LARGE
:lm margin=1.
:p.Third largest of typefaces available.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd181.Sizes:elink..
:h2 id=hd200.\ldots
:lm margin=1.
:p.The :font facename=Courier size=12x8.\ldots:font facename=default size=0x0. command produces an ellipsis.  This command works in
any mode, not just math mode.
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd143.Math Miscellany:elink..
:h2 id=hd201.\normalsize
:lm margin=1.
:p.The size of :font facename=Courier size=12x8.\normalsize:font facename=default size=0x0. is defined by as 10pt unless the 11pt or
12pt document style option is used.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd181.Sizes:elink..
:h2 id=hd202.\overbrace
:lm margin=1.
:p.:font facename=Courier size=12x8.\overbrace{text}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\overbrace:font facename=default size=0x0. command generates a brace over text.
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd143.Math Miscellany:elink..
:h2 id=hd203.\overline
:lm margin=1.
:p.:font facename=Courier size=12x8.\overline{text}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\overline:font facename=default size=0x0. command causes the argument text to be overlined.
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd143.Math Miscellany:elink..
:h2 id=hd204.\rm
:lm margin=1.
:p.Roman typeface (default).
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd180.Styles:elink..
:h2 id=hd205.\sc
:lm margin=1.
:p.Small caps typeface.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd180.Styles:elink..
:h2 id=hd206.\scriptsize
:lm margin=1.
:p.Second smallest of 10 typefaces available.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd181.Sizes:elink..
:h2 id=hd207.\sf
:lm margin=1.
:p.Sans serif typeface.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd180.Styles:elink..
:h2 id=hd208.\sl
:lm margin=1.
:p.Slanted typeface.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd180.Styles:elink..
:h2 id=hd209.\small
:lm margin=1.
:p.Slightly smaller than default typeface size.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd181.Sizes:elink..
:h2 id=hd210.\sqrt
:lm margin=1.
:p.:font facename=Courier size=12x8.\sqrt[root]{arg}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\sqrt:font facename=default size=0x0. command produces the square root of its argument.  The
optional argument, :font facename=Courier size=12x8.root:font facename=default size=0x0., determines what root to produce, i.e.
the cube root of :font facename=Courier size=12x8.x+y:font facename=default size=0x0. would be typed as :font facename=Courier size=12x8.$\sqrt[3]{x+y}$:font facename=default size=0x0..
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd143.Math Miscellany:elink..
:h2 id=hd211.\tiny
:lm margin=1.
:p.Smallest of 10 typefaces available.  All fonts may not be available in
this size.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd181.Sizes:elink..
:h2 id=hd212.\tt
:lm margin=1.
:p.Typewriter typeface.
See :link reftype=hd refid=hd28.Typefaces:elink..
See :link reftype=hd refid=hd180.Styles:elink..
:h2 id=hd213.\underbrace
:lm margin=1.
:p.:font facename=Courier size=12x8.\underbrace{text}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\underbrace:font facename=default size=0x0. command generates text with a brace underneath.
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd143.Math Miscellany:elink..
:h2 id=hd214.\underline
:lm margin=1.
:p.:font facename=Courier size=12x8.\underline{text}:font facename=default size=0x0.
:p.
The :font facename=Courier size=12x8.\underline:font facename=default size=0x0. command causes the argument text to be underlined.
This command can also be used in paragraph and LR modes.
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd143.Math Miscellany:elink..
:h2 id=hd215.\vdots
:lm margin=1.
:p.The :font facename=Courier size=12x8.\vdots:font facename=default size=0x0. command produces a vertical ellipsis.
See :link reftype=hd refid=hd18.Math Formulae:elink..
See :link reftype=hd refid=hd143.Math Miscellany:elink..
:h1 id=hd7.Index
:lm margin=1.
:parml tsize=50 break=none compact.
:pt.Appendix, creating
:pd.:link reftype=hd refid=hd153.\appendix:elink.
:pt.Arrays
:pd.:link reftype=hd refid=hd49.array:elink.
:pt.article style
:pd.:link reftype=hd refid=hd11.Document Styles:elink.
:pt.Author, for titlepage
:pd.:link reftype=hd refid=hd148.\author:elink.
:pt.Bibliography, creating
:pd.:link reftype=hd refid=hd67.thebibliography:elink.
:pt.book style
:pd.:link reftype=hd refid=hd11.Document Styles:elink.
:pt.Centering text
:pd.:link reftype=hd refid=hd50.center:elink.
.br
:link reftype=hd refid=hd72.\centering:elink.
:pt.chapter, Sectioning
:pd.:link reftype=hd refid=hd21.Sectioning:elink.
:pt.Characters, special
:pd.:link reftype=hd refid=hd23.Special Characters:elink.
:pt.Commands, defining new ones
:pd.:link reftype=hd refid=hd41.\newcommand:elink.
:pt.Counters, a list of
:pd.:link reftype=hd refid=hd8.Counters:elink.
:pt.Counters, adding to
:pd.:link reftype=hd refid=hd29.\addtocounter:elink.
:pt.Counters, creating
:pd.:link reftype=hd refid=hd33.\newcounter:elink.
:pt.Counters, setting
:pd.:link reftype=hd refid=hd35.\setcounter:elink.
:pt.Counters, use of
:pd.:link reftype=hd refid=hd36.\usecounter:elink.
.br
:link reftype=hd refid=hd37.\value:elink.
:pt.Creating Letters
:pd.:link reftype=hd refid=hd15.Letters:elink.
:pt.Creating pictures
:pd.:link reftype=hd refid=hd61.picture:elink.
:pt.Cross referencing
:pd.:link reftype=hd refid=hd9.Cross References:elink.
.br
:link reftype=hd refid=hd38.\label:elink.
.br
:link reftype=hd refid=hd39.\pageref:elink.
.br
:link reftype=hd refid=hd40.\ref:elink.
:pt.Date, for titlepage
:pd.:link reftype=hd refid=hd149.\date:elink.
:pt.Defining a new command
:pd.:link reftype=hd refid=hd41.\newcommand:elink.
:pt.Defining new environments
:pd.:link reftype=hd refid=hd42.\newenvironment:elink.
:pt.Defining new fonts
:pd.:link reftype=hd refid=hd44.\newfont:elink.
:pt.Defining new theorems
:pd.:link reftype=hd refid=hd43.\newtheorem:elink.
:pt.description Environments
:pd.:link reftype=hd refid=hd51.description:elink.
:pt.Document Styles
:pd.:link reftype=hd refid=hd11.Document Styles:elink.
:pt.Ending &amp. Starting
:pd.:link reftype=hd refid=hd25.Starting &amp. Ending:elink.
:pt.enumerate Environment
:pd.:link reftype=hd refid=hd52.enumerate:elink.
:pt.Environment
:pd.:link reftype=hd refid=hd66.tabular:elink.
.br
:link reftype=hd refid=hd70.verbatim:elink.
:pt.Environments
:pd.:link reftype=hd refid=hd12.Environments:elink.
.br
:link reftype=hd refid=hd51.description:elink.
.br
:link reftype=hd refid=hd52.enumerate:elink.
.br
:link reftype=hd refid=hd53.eqnarray:elink.
.br
:link reftype=hd refid=hd54.equation:elink.
.br
:link reftype=hd refid=hd55.figure:elink.
.br
:link reftype=hd refid=hd56.flushleft:elink.
.br
:link reftype=hd refid=hd73.\raggedright:elink.
.br
:link reftype=hd refid=hd58.itemize:elink.
.br
:link reftype=hd refid=hd59.list:elink.
.br
:link reftype=hd refid=hd60.minipage:elink.
.br
:link reftype=hd refid=hd61.picture:elink.
.br
:link reftype=hd refid=hd62.quotation:elink.
.br
:link reftype=hd refid=hd63.quote:elink.
.br
:link reftype=hd refid=hd64.tabbing:elink.
.br
:link reftype=hd refid=hd65.table:elink.
.br
:link reftype=hd refid=hd67.thebibliography:elink.
.br
:link reftype=hd refid=hd68.theorem:elink.
.br
:link reftype=hd refid=hd69.titlepage:elink.
.br
:link reftype=hd refid=hd71.verse:elink.
:pt.Environments, defining
:pd.:link reftype=hd refid=hd42.\newenvironment:elink.
:pt.eqnarray Environment
:pd.:link reftype=hd refid=hd53.eqnarray:elink.
:pt.equation Environment
:pd.:link reftype=hd refid=hd54.equation:elink.
:pt.figure Environment
:pd.:link reftype=hd refid=hd55.figure:elink.
:pt.Flushing a page
:pd.:link reftype=hd refid=hd128.\cleardoublepage:elink.
.br
:link reftype=hd refid=hd129.\clearpage:elink.
:pt.Font Sizes
:pd.:link reftype=hd refid=hd181.Sizes:elink.
:pt.Font Styles
:pd.:link reftype=hd refid=hd180.Styles:elink.
:pt.Fonts
:pd.:link reftype=hd refid=hd28.Typefaces:elink.
:pt.Fonts, new commands for
:pd.:link reftype=hd refid=hd44.\newfont:elink.
:pt.Footnotes, creating
:pd.:link reftype=hd refid=hd13.Footnotes:elink.
:pt.Formatting text
:pd.:link reftype=hd refid=hd50.center:elink.
.br
:link reftype=hd refid=hd72.\centering:elink.
:pt.Formulae, maths
:pd.:link reftype=hd refid=hd18.Math Formulae:elink.
:pt.Hyphenation
:pd.:link reftype=hd refid=hd127.\-:elink.
.br
:link reftype=hd refid=hd130.\hyphenation:elink.
:pt.Input file, splitting
:pd.:link reftype=hd refid=hd24.Splitting the Input:elink.
:pt.Input/Output
:pd.:link reftype=hd refid=hd27.Terminal Input/Output:elink.
:pt.Inserting figures
:pd.:link reftype=hd refid=hd55.figure:elink.
:pt.itemize Environment
:pd.:link reftype=hd refid=hd58.itemize:elink.
:pt.LaTeX overview
:pd.:link reftype=hd refid=hd3.Overview of LaTeX and Local Guide:elink.
:pt.Left-to-right mode
:pd.:link reftype=hd refid=hd19.Modes:elink.
:pt.Lengths, defining and using
:pd.:link reftype=hd refid=hd14.Lengths:elink.
.br
:link reftype=hd refid=hd115.\newlength:elink.
.br
:link reftype=hd refid=hd116.\setlength:elink.
.br
:link reftype=hd refid=hd117.\addtolength:elink.
.br
:link reftype=hd refid=hd118.\settowidth:elink.
:pt.letter style
:pd.:link reftype=hd refid=hd11.Document Styles:elink.
:pt.Letters
:pd.:link reftype=hd refid=hd15.Letters:elink.
.br
:link reftype=hd refid=hd119.\opening:elink.
.br
:link reftype=hd refid=hd120.\closing:elink.
.br
:link reftype=hd refid=hd121.Declarations:elink.
.br
:link reftype=hd refid=hd122.\address:elink.
.br
:link reftype=hd refid=hd123.\signature:elink.
.br
:link reftype=hd refid=hd124.\location:elink.
.br
:link reftype=hd refid=hd125.\telephone:elink.
:pt.Line Breaking
:pd.:link reftype=hd refid=hd16.Line &amp. Page Breaking:elink.
:pt.Line Breaks
:pd.:link reftype=hd refid=hd131.\linebreak:elink.
:pt.list Environment
:pd.:link reftype=hd refid=hd59.list:elink.
:pt.Lists of items
:pd.:link reftype=hd refid=hd52.enumerate:elink.
.br
:link reftype=hd refid=hd58.itemize:elink.
.br
:link reftype=hd refid=hd59.list:elink.
:pt.LR mode
:pd.:link reftype=hd refid=hd19.Modes:elink.
:pt.Making a title page
:pd.:link reftype=hd refid=hd69.titlepage:elink.
:pt.Making Paragraphs
:pd.:link reftype=hd refid=hd17.Making Paragraphs:elink.
:pt.Math Formulae
:pd.:link reftype=hd refid=hd18.Math Formulae:elink.
:pt.Math mode
:pd.:link reftype=hd refid=hd18.Math Formulae:elink.
.br
:link reftype=hd refid=hd140.Subscripts &amp. Superscripts:elink.
.br
:link reftype=hd refid=hd141.Math Symbols:elink.
.br
:link reftype=hd refid=hd143.Math Miscellany:elink.
.br
:link reftype=hd refid=hd19.Modes:elink.
:pt.Math mode, spacing
:pd.:link reftype=hd refid=hd142.Spacing in Math Mode:elink.
:pt.Maths Miscellany
:pd.:link reftype=hd refid=hd143.Math Miscellany:elink.
:pt.Maths symbols
:pd.:link reftype=hd refid=hd141.Math Symbols:elink.
:pt.minipage Environment
:pd.:link reftype=hd refid=hd60.minipage:elink.
:pt.Modes
:pd.:link reftype=hd refid=hd19.Modes:elink.
:pt.Multicolumn text
:pd.:link reftype=hd refid=hd48.\twocolumn:elink.
:pt.New Page
:pd.:link reftype=hd refid=hd133.\newpage:elink.
:pt.Newline
:pd.:link reftype=hd refid=hd126.\\:elink.
.br
:link reftype=hd refid=hd132.\newline:elink.
:pt.Overview of LaTeX
:pd.:link reftype=hd refid=hd3.Overview of LaTeX and Local Guide:elink.
:pt.Page Breaking
:pd.:link reftype=hd refid=hd16.Line &amp. Page Breaking:elink.
.br
:link reftype=hd refid=hd136.\pagebreak:elink.
:pt.Page Formatting
:pd.:link reftype=hd refid=hd16.Line &amp. Page Breaking:elink.
:pt.Page styles
:pd.:link reftype=hd refid=hd20.Page Styles:elink.
.br
:link reftype=hd refid=hd145.\pagenumbering:elink.
.br
:link reftype=hd refid=hd146.\pagestyle:elink.
:pt.Page Styles, changing
:pd.:link reftype=hd refid=hd146.\pagestyle:elink.
:pt.Pagenumbering
:pd.:link reftype=hd refid=hd145.\pagenumbering:elink.
:pt.Paragraph mode
:pd.:link reftype=hd refid=hd19.Modes:elink.
:pt.paragraph, Sectioning
:pd.:link reftype=hd refid=hd21.Sectioning:elink.
:pt.Paragraphs
:pd.:link reftype=hd refid=hd17.Making Paragraphs:elink.
.br
:link reftype=hd refid=hd137.\indent:elink.
.br
:link reftype=hd refid=hd138.\noindent:elink.
.br
:link reftype=hd refid=hd139.\par:elink.
:pt.picture Environment
:pd.:link reftype=hd refid=hd61.picture:elink.
:pt.Poetry, an environment for
:pd.:link reftype=hd refid=hd71.verse:elink.
:pt.quotation Environment
:pd.:link reftype=hd refid=hd62.quotation:elink.
:pt.report style
:pd.:link reftype=hd refid=hd11.Document Styles:elink.
:pt.Sectioning
:pd.:link reftype=hd refid=hd21.Sectioning:elink.
:pt.Sizes of text
:pd.:link reftype=hd refid=hd181.Sizes:elink.
:pt.Spaces &amp. Boxes
:pd.:link reftype=hd refid=hd22.Spaces &amp. Boxes:elink.
.br
:link reftype=hd refid=hd154.\addvspace:elink.
.br
:link reftype=hd refid=hd155.\bigskip:elink.
.br
:link reftype=hd refid=hd156.\dotfill:elink.
.br
:link reftype=hd refid=hd157.\fbox:elink.
.br
:link reftype=hd refid=hd158.\framebox:elink.
.br
:link reftype=hd refid=hd159.\hfill:elink.
.br
:link reftype=hd refid=hd160.\hrulespace:elink.
.br
:link reftype=hd refid=hd161.\hspace:elink.
.br
:link reftype=hd refid=hd87.\makebox:elink.
.br
:link reftype=hd refid=hd162.\mbox:elink.
.br
:link reftype=hd refid=hd163.\medskip:elink.
.br
:link reftype=hd refid=hd164.\newsavebox:elink.
.br
:link reftype=hd refid=hd165.\parbox:elink.
.br
:link reftype=hd refid=hd166.\raisebox:elink.
.br
:link reftype=hd refid=hd167.\rule:elink.
.br
:link reftype=hd refid=hd168.\savebox:elink.
.br
:link reftype=hd refid=hd169.\smallskip:elink.
.br
:link reftype=hd refid=hd170.\usebox:elink.
.br
:link reftype=hd refid=hd171.\vfill:elink.
.br
:link reftype=hd refid=hd172.\vspace:elink.
:pt.Spacing, within Math mode
:pd.:link reftype=hd refid=hd142.Spacing in Math Mode:elink.
:pt.Special Characters
:pd.:link reftype=hd refid=hd23.Special Characters:elink.
:pt.Splitting the input file
:pd.:link reftype=hd refid=hd24.Splitting the Input:elink.
:pt.Starting &amp. Ending
:pd.:link reftype=hd refid=hd25.Starting &amp. Ending:elink.
:pt.Styles of document
:pd.:link reftype=hd refid=hd11.Document Styles:elink.
:pt.Styles of text
:pd.:link reftype=hd refid=hd180.Styles:elink.
:pt.Styles, pages
:pd.:link reftype=hd refid=hd20.Page Styles:elink.
:pt.subparagraph, Sectioning
:pd.:link reftype=hd refid=hd21.Sectioning:elink.
:pt.Subscript
:pd.:link reftype=hd refid=hd140.Subscripts &amp. Superscripts:elink.
:pt.subsection, Sectioning
:pd.:link reftype=hd refid=hd21.Sectioning:elink.
:pt.subsubparagraph, Sectioning
:pd.:link reftype=hd refid=hd21.Sectioning:elink.
:pt.subsubsection, Sectioning
:pd.:link reftype=hd refid=hd21.Sectioning:elink.
:pt.subsubsubparagraph, Sectioning
:pd.:link reftype=hd refid=hd21.Sectioning:elink.
:pt.Superscript
:pd.:link reftype=hd refid=hd140.Subscripts &amp. Superscripts:elink.
:pt.Symbols
:pd.:link reftype=hd refid=hd141.Math Symbols:elink.
:pt.tabbing Environment
:pd.:link reftype=hd refid=hd64.tabbing:elink.
:pt.table Environment
:pd.:link reftype=hd refid=hd65.table:elink.
:pt.Table of Contents, creating
:pd.:link reftype=hd refid=hd26.Table of Contents:elink.
:pt.tabular Environment
:pd.:link reftype=hd refid=hd66.tabular:elink.
:pt.Terminal Input/Output
:pd.:link reftype=hd refid=hd27.Terminal Input/Output:elink.
:pt.Thanks, for titlepage
:pd.:link reftype=hd refid=hd150.\thanks:elink.
:pt.thebibliography Environment
:pd.:link reftype=hd refid=hd67.thebibliography:elink.
:pt.theorem Environment
:pd.:link reftype=hd refid=hd68.theorem:elink.
:pt.Theorems, defining
:pd.:link reftype=hd refid=hd43.\newtheorem:elink.
:pt.Title making
:pd.:link reftype=hd refid=hd144.\maketitle:elink.
:pt.Title pages, creating
:pd.:link reftype=hd refid=hd69.titlepage:elink.
:pt.Title, for titlepage
:pd.:link reftype=hd refid=hd151.\title:elink.
:pt.titlepage Environment
:pd.:link reftype=hd refid=hd69.titlepage:elink.
:pt.Typeface Sizes
:pd.:link reftype=hd refid=hd181.Sizes:elink.
:pt.Typeface Styles
:pd.:link reftype=hd refid=hd180.Styles:elink.
:pt.Typefaces
:pd.:link reftype=hd refid=hd28.Typefaces:elink.
:pt.Using Counters
:pd.:link reftype=hd refid=hd36.\usecounter:elink.
.br
:link reftype=hd refid=hd37.\value:elink.
:pt.Variables, a list of&dot.&dot.&dot. (see also Counters)
:pd.:link reftype=hd refid=hd8.Counters:elink.
:pt.verbatim Environment
:pd.:link reftype=hd refid=hd70.verbatim:elink.
.br
:link reftype=hd refid=hd111.\verb:elink.
:pt.verse Environment
:pd.:link reftype=hd refid=hd71.verse:elink.
:pt.\maketitle Style
:pd.:link reftype=hd refid=hd144.\maketitle:elink.
:pt.\quote Environment
:pd.:link reftype=hd refid=hd63.quote:elink.
:eparml.
:euserdoc.
