/**/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs


parse arg language texmf source options



if language = '049' then do

  msg.1  = 'msg:LaTeX2e: Bereite die Installation des Basispaketes vor'
  msg.2  = 'msg:LaTeX2e: Entpacke Dateien'
  msg.3  = 'msg:LaTeX2e: unpack.ins'
  msg.4  = 'msg:LaTeX2e: cmextra.ins'
  msg.5  = 'msg:LaTeX2e: ec.ins - Vorbereitung fr die EC Zeichenstze'
  msg.6  = 'msg:LaTeX2e: Erstelle Dokumentation'
  msg.7  = 'msg:LaTeX2e: Erzeuge Formatdatei latex.fmt mit Englischen Trennmustern'
  msg.8  = 'msg:LaTeX2e: Erzeuge'
  msg.9  = 'Lauf'
  msg.10 = 'von'
  msg.11 = 'msg:LaTeX2e: Erzeuge WPS-Objekt'

  docu.title.1  = 'Users Guide'
  docu.title.2  = 'Font Guide'
  docu.title.3  = 'Class Guide'
  docu.title.4  = 'Configurations Guide'
  docu.title.5  = 'Modus Guide'
  docu.title.6  = 'LaTeX News 1'
  docu.title.7  = 'LaTeX News 2'
  docu.title.8  = 'LaTeX News 3'
  docu.title.9  = 'LaTeX News 4'
  docu.title.10 = 'LaTeX News 5'
  docu.title.11 = 'LaTeX News 6'
  docu.title.12 = 'LaTeX News 7'

end
else do

  msg.1  = 'msg:LaTeX2e: preparing for the installation of the base package'
  msg.2  = 'msg:LaTeX2e: installing files'
  msg.3  = 'msg:LaTeX2e: unpack.ins'
  msg.4  = 'msg:LaTeX2e: cmextra.ins'
  msg.5  = 'msg:LaTeX2e: ec.ins - preparing for EC fonts'
  msg.6  = 'msg:LaTeX2e: creating documentations'
  msg.7  = 'msg:LaTeX2e: creating format file latex.fmt enclosing English hyphenations'
  msg.8  = 'msg:LaTeX2e: creating'
  msg.9  = 'run'
  msg.10 = 'of'
  msg.11 = 'msg:LaTeX2e: creating WPS object'

  docu.title.1  = 'Users Guide'
  docu.title.2  = 'Font Guide'
  docu.title.3  = 'Class Guide'
  docu.title.4  = 'Configurations Guide'
  docu.title.5  = 'Mode Guide'
  docu.title.6  = 'LaTeX News 1'
  docu.title.7  = 'LaTeX News 2'
  docu.title.8  = 'LaTeX News 3'
  docu.title.9  = 'LaTeX News 4'
  docu.title.10 = 'LaTeX News 5'
  docu.title.11 = 'LaTeX News 6'
  docu.title.12 = 'LaTeX News 7'

end




documents = 12


docu.fname.1 = 'usrguide.tex'
docu.fndvi.1 = 'usrguide.dvi'
docu.loops.1 = 3
docu.fname.2 = 'fntguide.tex'
docu.fndvi.2 = 'fntguide.dvi'
docu.loops.2 = 3
docu.fname.3 = 'clsguide.tex'
docu.fndvi.3 = 'clsguide.dvi'
docu.loops.3 = 3
docu.fname.4 = 'cfgguide.tex'
docu.fndvi.4 = 'cfgguide.dvi'
docu.loops.4 = 2
docu.fname.5 = 'modguide.tex'
docu.fndvi.5 = 'modguide.dvi'
docu.loops.5 = 3
docu.fname.6 = 'ltnews01.tex'
docu.fndvi.6 = 'ltnews01.dvi'
docu.loops.6 = 1
docu.fname.7 = 'ltnews02.tex'
docu.fndvi.7 = 'ltnews02.dvi'
docu.loops.7 = 1
docu.fname.8 = 'ltnews03.tex'
docu.fndvi.8 = 'ltnews03.dvi'
docu.loops.8 = 1
docu.fname.9 = 'ltnews04.tex'
docu.fndvi.9 = 'ltnews04.dvi'
docu.loops.9 = 1
docu.fname.10 = 'ltnews05.tex'
docu.fndvi.10 = 'ltnews05.dvi'
docu.loops.10 = 1
docu.fname.11 = 'ltnews06.tex'
docu.fndvi.11 = 'ltnews06.dvi'
docu.loops.11 = 1
docu.fname.12 = 'ltnews07.tex'
docu.fndvi.12 = 'ltnews07.dvi'
docu.loops.12 = 1




bin         = texmf||'\os2tex\bin'
tfm         = texmf||'\fonts\tfm'
tex         = texmf||'\tex'
doc         = texmf||'\doc'
fmt         = bin

target   = texmf||'\tex\latex\base'
install  = texmf||'\os2tex\install'

exec     = bin||'\tex.exe'


if Pos("InstallFiles", options) > 0 then do

   say msg.1



   install||'\kdir '||target                     /* Altes VZ loeschen, falls vorhanden */


   'md '||tex                              /* TDS Verzeichnisstruktur erzeugen   */
   'md '||tex||'\latex'
   'md '||tex||'\latex\base'

   'md '||doc
   'md '||doc||'\latex'
   'md '||doc||'\latex\base'



   say msg.2



   call directory texmf||'\tex\latex'

   install||'\unzip '||source||'\l2base.zip'


   say msg.3

   exec||' -i -po '||target||' -pi '||target||';'||bin||' '||'unpack.ins'


   say msg.4

   exec||' -i -po '||target||' -a '||source||'\l2base.ans -pi '||target||';'||bin||' '||'cmextra.ins'


/*
say msg.5

exec||' -i -po '||target||' -a '||source||'\l2base.ans -pi '||target||';'||bin||' '||'ec.ins'
*/


/* Erstellen der Dokumentation im VZ "doc\latex\base" */



   say msg.6

   install||'\kdir '||doc||'\latex\base'
   'md '||doc||'\latex\base'

   'copy '||target||'\*.txt '||doc||'\latex\base'
   'copy '||target||'\*.tex '||doc||'\latex\base'

   'del '||target||'\*.txt'
   'del '||target||'\*.tex'
   'copy '||doc||'\latex\base\docstrip.tex '||target
   'del '||doc||'\latex\base\docstrip.tex'


   say msg.7


   exec||' -i -r -po '||texmf||'\os2tex\bin -pi '||texmf||'\tex\latex\base;'||texmf||'\tex\generic\hyphen;'||bin||' -pt '||texmf||'\fonts\tfm latex.ltx \dump'

end



if SysOS2Ver() = '2.30' then
  top = '48'
else
  top = '45'



if Pos("CreateObjects", options) > 0 then do

   classname = 'WPFolder'

   if language = '049' then
      objtitle = 'Dokumentation'
   else
      objtitle = 'Documentations'

   location  = '<OS2TEX_FOLDER>'
   setup     = 'OBJECTID=<OS2TEX_DOC_FOLDER>;ICONVIEW=MINI,NONFLOWED;ALWAYSSORT=YES;ICONVIEWPOS=25,50,25,'||top
   duplicate = 'update'


   rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

   if rc = 0 then do
      exit 1
   end




   classname = 'WPFolder'
   objtitle  = 'LaTeX2e'
   location  = '<OS2TEX_DOC_FOLDER>'
   setup     = 'OBJECTID=<OS2TEX_LATEX2E_FOLDER>;ICONVIEW=MINI,NONFLOWED;ALWAYSSORT=YES;ICONVIEWPOS=50,50,25,'||top
   duplicate = 'update'


   rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

   if rc = 0 then do
      exit 1
   end

end





do k=1 to documents

  /* V  Hier muss geprueft werden, ob die Datei existiert */


   if Pos("InstallFiles", options) > 0 then do

      do i=1 to docu.loops.k
         say msg.8' 'docu.fname.k' 'msg.9' 'i' 'msg.10' 'docu.loops.k
         exec||' -r -ff latex.fmt -pf '||texmf||'\os2tex\bin -po '||texmf||'\doc\latex\base -pi '||texmf||'\doc\latex\base;'||texmf||'\tex\latex\base -pt '||texmf||'\fonts\tfm '||docu.fname.k
      end

   end




   if Pos("CreateObjects", options) > 0 then do

      classname = 'WPProgram'
      objtitle  = docu.title.k
      location  = '<OS2TEX_LATEX2E_FOLDER>'
      setup     = 'EXENAME='texmf'\os2tex\bin\dvi.exe;PROGTYPE=PM;STARTUPDIR='texmf'\os2tex\bin;OBJECTID=<OS2TEX_'docu.fname.k'>;PARAMETERS='texmf'\doc\latex\base\'docu.fndvi.k
      duplicate = 'replace'

      say msg.11' 'docu.title.k

      rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

      if rc = 0 then do
         exit 1
      end
   end

end



if Pos("InstallFiles", options) > 0 then do

   'del '||target||'\*.ins'
   'del '||target||'\*.dtx'



/* Erzeugen der der LaTeX-Kommandozeile */

   filename=texmf"\os2tex\bin\latex.cmd"

   "del "filename

   lineout(filename,"tex.exe -r -ff latex.fmt -pf "texmf"\os2tex\bin -pi .;"texmf"\tex;"texmf"\os2tex\graphics -pt "texmf"\fonts\tfm %1 %2 %3 %4 %5")
   lineout(filename)

   filename=texmf"\os2tex\bin\latexw.cmd"

   "del "filename

   lineout(filename,"set path="texmf"\os2tex\bin;%path%")
   lineout(filename)


end



if Pos("CreateObjects", options) > 0 then do

   classname = 'WPProgram'
   objtitle  = "LaTeX Kommandozeile"
   location  = '<OS2TEX_FOLDER>'
   setup     = 'EXENAME=cmd.exe;STARTUPDIR='texmf'\os2tex\bin;OBJECTID=<OS2TEX_LaTeX_Kommandozeile>;PARAMETERS=/K 'texmf'\os2tex\bin\latexw.cmd'
   duplicate = 'replace'


   rc = SysCreateObject(classname,objtitle,location,setup,duplicate)


end

