/**/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs


parse arg language texmf source options



if language = '049' then do

  msg.1 = 'msg:German: Lsche alte Verzeichnisse'
  msg.2 = 'msg:German: Entpacke Dateien'
  msg.3 = 'msg:German: german.ins'
  msg.4 = 'msg:German: Erstelle Formatdatei Englisch/Deutsch'
  msg.5 = 'msg:German: Erstelle Dokumentation Lauf'
  msg.6 = 'von'

  errdir = 'err:Verzeichniswechsel nicht mglich'

end
else do

  msg.1 = 'msg:German: Deleting directories'
  msg.2 = 'msg:German: Installing files'
  msg.3 = 'msg:German: german.ins'
  msg.4 = 'msg:German: Creating format file English/German'
  msg.5 = 'msg:German: Creating documentation run'
  msg.6 = 'of'

  errdir = 'err:Unable to change directory'

end



bin         = texmf||'\os2tex\bin'
tfm         = texmf||'\fonts\tfm'
tex         = texmf||'\tex'
doc         = texmf||'\doc'
fmt         = bin

target   = texmf||'\tex\generic\german'
install  = texmf||'\os2tex\install'

exec     = bin||'\tex.exe'




if Pos("InstallFiles", options) > 0 then do

   say msg.1



   install||'\kdir '||target                     /* Altes VZ loeschen, falls vorhanden */


   'md '||tex                              /* TDS Verzeichnisstruktur erzeugen   */
   'md '||tex||'\generic'
   'md '||tex||'\generic\german'

   install||'\kdir '||doc||'\generic\german'

   'md '||doc
   'md '||doc||'\generic'
   'md '||doc||'\generic\german'



   say msg.2


   if directory(tex||'\generic') = '' then do
      say errdir' - 'tex||'\generic'
      exit 1
   end

   install||'\unzip '||source||'\german.zip'


   say msg.3

   exec||' -pf '||bin||' -po '||target||' -pi '||target||';'||tex||'\latex\base '||'german.ins'


/* Formatdatei erstellen */



   say msg.4


   'copy '||target||'\hyphxmpl.cfg '||target||'\hyphen.cfg'

   exec||' -i -r -po '||texmf||'\os2tex\bin -pi '||target';'||tex||'\latex\base;'||texmf||'\tex\generic\hyphen;'||bin||' -pt '||texmf||'\fonts\tfm latex.ltx \dump'

   'del '||target||'\hyphen.cfg'





/* Erstellen der Dokumentation im VZ "doc\latex\base" */



   'copy '||target||'\germdoc.tex '||texmf||'\doc\generic\german'
   'del '||target||'\germdoc.tex'

end



if SysOS2Ver() = '2.30' then
  top = '48'
else
  top = '45'



if Pos("CreateObjects", options) > 0 then do


   classname = 'WPFolder'

   if language = '049' then
      objtitle  = 'Zusatzpakete/Styles'
   else
      objtitle  = 'Packages/Styles'

   location  = '<OS2TEX_DOC_FOLDER>'
   setup     = 'OBJECTID=<OS2TEX_MISC_FOLDER>;ICONVIEW=MINI,NONFLOWED;ALWAYSSORT=YES;ICONVIEWPOS=50,50,25,'||top
   duplicate = 'update'


   rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

   if rc = 0 then do
      exit 1
   end

end


if Pos("InstallFiles", options) > 0 then do


   do i=1 to 2
      say msg.5' 'i' 'msg.6' 2'
      exec||' -r -ff latex.fmt -pf '||texmf||'\os2tex\bin -po '||texmf||'\doc\generic\german -pi '||texmf||'\doc\generic\german;'||target||';'||texmf||'\tex\latex -pt '||texmf||'\fonts\tfm germdoc.tex'
   end

end



if Pos("CreateObjects", options) > 0 then do

   classname = 'WPProgram'
   objtitle  = 'german [B. Raichle]'
   location  = '<OS2TEX_MISC_FOLDER>'
   setup     = 'EXENAME='texmf'\os2tex\bin\dvi.exe;PROGTYPE=PM;STARTUPDIR='texmf'\os2tex\bin;OBJECTID=<OS2TEX_germdoc.dvi>;PARAMETERS='texmf'\doc\generic\german\germdoc.dvi'
   duplicate = 'replace'



   rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

   if rc = 0 then do
      exit 1
   end

end


if Pos("InstallFiles", options) > 0 then do


   "del "target"\\*.dtx"
   "del "target"\\*.ins"

end





