/*******************************************************************************
	Bitmap handler resources
	 Peter Koller 1998, All Rights Reserved
*******************************************************************************/
#ifndef HAND_RESOURCES
#define HAND_RESOURCES
/*******************************************************************************
	pointers
*******************************************************************************/
/*******************************************************************************
	RC_DATA descriptions
*******************************************************************************/

/*******************************************************************************
	bitmaps
*******************************************************************************/

/*******************************************************************************
	add on menu...
*******************************************************************************/

/*******************************************************************************
	edit menu
*******************************************************************************/
#define HAND_REMOVE 		(FIRST_MENU_ID + 1)
#define HAND_CUT			(FIRST_MENU_ID + 2)
#define HAND_COPY			(FIRST_MENU_ID + 3)
#define HAND_PASTE			(FIRST_MENU_ID + 4)
#define HAND_CLEAR			(FIRST_MENU_ID + 5)

/*******************************************************************************
	button bar
*******************************************************************************/
#define 	IDB_FIRSTBUTTON 	FIRST_BBAR_ID

/*******************************************************************************
	status bar
*******************************************************************************/
#define 	IDS_HANDIDENT	FIRST_STAT_ID

/*******************************************************************************
	help table
*******************************************************************************/
#define IDHLP_HAND				1
#define IDHLP_HAND_SUBTABLE 	2

/*******************************************************************************
	string defs
*******************************************************************************/
#define IDS_HELPWINTITLE		16	//"Maul Spellcheck handler help"
#define IDS_HELPLIBRARY 		17	//"splhand.hlp"
/* dictionary errors */
#define IDS_COPYRIGHT			18	//"Spellcheck Information"
#define IDS_OUTOFMEM			19	//"insufficient memory to complete request"
#define IDS_SPELLOPTIONS		20	//"Spell &check options..."
#define IDS_HYPHOPTIONS 		21	//"&Hyphenation options..."
#define IDS_GO					22	//"&Go"
#define IDS_STOP				23	//"S&top"
#define IDS_SKIP				24	//"S&kip"
#define IDS_USRDICTIONARY		25	//"User dictionary - "
#define IDS_CURWORD				26	//"Current word - "
#define IDS_USRNONE				27	//"none"
#define IDS_CHKSUM				28	//"CHECKSUM, expected %d, got %d. File reject!"
#define	IDS_ADDHYPHOPT			29	//"Add hyphenation options"
#define IDSC_ARGNOTENOUGH		30  //"insufficient number of arguments"
#define IDSC_NOASSIGN			31  //"missing assignment"
#define IDSC_EOFFUNC			32  //"expression at eof"
#define IDSC_EOFARG 			33  //"argument at eof"
#define IDSC_EOFTEXT			34  //"text string at eof"
#define IDSC_OUTOFMEMORY		35  //"out of memory"
#define IDSC_UNTERMINATED		36  //"command terminator missing"
#define IDSC_EOFCOMMENT 		37  //"comment at eof"
#define IDSC_EOFQUOTES			38  //"quotes at eof"
#define IDSC_SCRIPTKILL 		39  //"script interrupted by user"
#define IDSC_FUNCSYNTAX 		40  //"command syntax error"
#define IDSC_EOFMATHS			41  //"mathematical expression at eof"
#define IDSC_MUSTBEVOU			42  //"expected value or unary expression"
#define IDSC_NOTTWOPART 		43  //"expected two part expression"
#define IDSC_EXPMISSING 		44  //"missing expression"
#define IDSC_MUSTBEVAL			45  //"expected a value to follow unary"
#define IDSC_EXPSYNTAX			46  //"expression syntax error"
#define IDSC_FILESYNTAX			47  //"file syntax error"
#define IDS_CRIGHTMSG		    48  //"%.*s, MySpell dictionary %.*s, Codepage %s\nFrom %.*s"
#define IDS_ACPERROR		    49  //" !no codepage!"

#define IDS_CHECKSPELL			60 //"Check Spelling"
#define IDS_CHECKSPELLWNF		61 //"Check Spelling - word not found"
#define IDS_CHECKSPELLUNK		62 //"Check Spelling - Sentence uncapitalised"
#define IDS_CHECKSPELLWRP		63 //"Check Spelling - word repeats"
#define IDS_CHECKSPELLSPC		64 //"Check Spelling - found special character"

#define IDS_DELETEDICT			65 //"Delete User Dictionary"
#define IDS_OPENUSRDICT			66 //"&Open"
#define IDS_CLOSEUSRDICT		67 //"Cl&ose"
#define IDS_USRDICTMISSING		68 //"No user Dictionary found"

#define IDS_HANDLERTYPE     	80  //"Spellcheck using MySpell & libhnj Libraries"
#define IDS_HANDLERNAME     	81  //"Spell check and hypenation"
#define IDS_DEFAULTLANG     	82  //"Deutsch"

/**** proximity dictionary errors ****/
#define IDERR_NONE				100 //"undefined"
/*
#define IDERR_ALLOC 			101 //"failed to allocate memory"
#define IDERR_OPEN				102 //"failed to open file"
#define IDERR_IO				103 //"I/O system failure"
#define IDERR_TYPE				104 //"file type not recognized"
#define IDERR_VERSION			105 //"file version incorrect"
#define IDERR_LANGUAGE			106 //"file language incorrect"
*/
#define IDERR_AFF1	 			101 //"AFFIX: Failure loading aff file %s"
#define IDERR_AFF2 				102 //"AFFIX: could not open affix description file %s"
#define IDERR_AFF3 				103 //"AFFIX: duplicate TRY strings"
#define IDERR_AFF4 				104 //"AFFIX: missing TRY information"
#define IDERR_AFF5 				105 //"AFFIX: duplicate SET strings"
#define IDERR_AFF6 				106 //"AFFIX: missing SET information"
#define IDERR_AFF7 				107 //"AFFIX: duplicate compound flags used"
#define IDERR_AFF8 				108 //"AFFIX: missing compound flag information"
#define IDERR_AFF9 				109 //"AFFIX: missing compound min information"
#define IDERR_AFF10				110 //"AFFIX: duplicate REP tables used"
#define IDERR_AFF11				111 //"AFFIX: incorrect number of entries in replacement table"
#define IDERR_AFF12				112 //"AFFIX: missing replacement table information"
#define IDERR_AFF13				113 //"AFFIX: replacement table is corrupt"
#define IDERR_AFF14				114 //"AFFIX: %c header has insufficient data in line %s"
#define IDERR_AFF15				115 //"AFFIX: %c is corrupt near line %s\n error: possible incorrect count"
#define IDERR_AFF16				116 //"AFFIX: %c is corrupt near line %s"
#define IDERR_AFF17				117 //"AFFIX: duplicate MAP tables used"
#define IDERR_AFF18				118 //"AFFIX: incorrect number of entries in MAP table"
#define IDERR_AFF19				119 //"AFFIX: missing MAP table information"
#define IDERR_AFF20				120 //"AFFIX: MAP table is corrupt"

#define IDERR_HASH1 			121 //"HASHMGR: file open error in fopen(%s)"
#define IDERR_HASH2 			122 //"HASHMGR: file get string error in fgets"
#define IDERR_HASH3 			123 //"HASHMGR: memory allocation error %d bytes in calloc"
#define IDERR_HNJ1 				124 //"HNJALLOC: memory allocation error %d bytes in alloc"
#define IDERR_HNJ2 				125 //"HNJALLOC: memory allocation error %d bytes in realloc"

/*******************************************************************************
	Dialogs
*******************************************************************************/
#define IDD_HELPBUTTON			100
#define IDD_SAVEBUTTON			101

#define IDD_SPELLCHECK			120		/*** Spell Check Dialog ***/
#define IDD_SPELLWORD			121 	/* Entry Field			  */
#define IDD_SPELLLIST			122 	/* Listbox				  */
#define IDD_SPELLSKIP			123 	/* Push Button			  */
#define IDD_SPELLCHANGE 		124 	/* Push Button			  */
#define IDD_SPELLGET			125 	/* Push Button			  */
#define IDD_SPELLGO 			126 	/* Push Button			  */
#define IDD_SPELLADD			127 	/* Push Button			  */
#define IDD_SPELLIGNORE			128 	/* Push Button			  */
#define IDD_SPELLSTAT			129 	/* Static Text			  */
#define IDD_SPELLDCST			130 	/* Group box			  */
#define IDD_SPELLCWST			131 	/* Group box			  */
#define IDD_SPELLTOP			132 	/* Check Box			  */
#define IDD_SPELLGETCWORD		133 	/* Push Button			  */

#define IDD_SPELLOPT			140 	/*** Spell Options Dlg	***/
#define IDD_SPLOPLANG			141 	/* Combobox				  */
#define IDD_SPLOPMORE			145 	/* Push Button			  */
#define IDD_SPLOPABOUT			153 	/* Push Button			  */

#define IDD_SPELLMORE			160 	/*** More Options Dlg  ***/
#define	IDD_SMFACUNCSTART		161
#define	IDD_SMFACREPEATS		162
#define	IDD_SMFACWWITHSPEC		163
#define	IDD_SMFACWBETSPEC		164
#define	IDD_SMFEFWWITHSPEC		165
#define	IDD_SMFEFWBETSPEC		166
#define	IDD_SMIACSINGLECHARS	167
#define	IDD_SMIACNUMBERS		168
#define	IDD_SMIACWWNUMBERS		169
#define	IDD_SMIACALLCAPS		170
#define	IDD_SMIACROMANS			171
#define	IDD_SMIACWWITHSPEC		172
#define	IDD_SMIEFWWITHSPEC		173
#define	IDD_SMIACSPECINWORD		174
#define	IDD_SMIEFSPECINWORD		175

#define IDD_HYPHOPT 			180 	/*** Hyph Options Dlg  ***/
#define IDD_HYPHOPTNONE			181
#define IDD_HYPHOPTGENERIC		182
#define IDD_HYPHOPTVERIFY		183
#define	IDD_HYPHOPTDICT			184
#define	IDD_HYPHOPTGRP1			185
#define	IDD_HYPHOPTGRP2			186
#define	IDD_HYPHOPTGRP3			187

#define IDD_SPELLDONE			200 	/*** Spellcheck complete ***/

#endif
