/******************************************************************************
    Main Resource Header
    (c)Peter Koller 1998
******************************************************************************/
#ifndef MAUL_RESOURCES
#define MAUL_RESOURCES

#define     EXT_MASTERPAGE      ".mmp"
#define     EXT_COLOUR          ".clr"
#define     MASTERPAGEID        '0pmm'

#define     SC_ESC          0x01

#define IDICO_MAIN              1

#define IDD_INSMAP              2
#define IDD_SPLASHMAP           3

#define IDCUR_VRSNAP            6
#define IDCUR_HRSNAP            7
#define IDCUR_NOSNAP            8
#define IDPTR_CROSSHAIR         9

#define IDBMP_MDRIVE            10
#define IDBMP_DRIVE             11
#define IDBMP_MOPFLD            12
#define IDBMP_OPFLD             13
#define IDBMP_MFOLD             14
#define IDBMP_FOLD              15

#define IDBMP_TOOLSUP           16
#define IDBMP_TOOLSDN           17
#define IDCUR_SELECT			18
#define IDPTR_PAINT				19

/*******************************************************************************
    RCDATA descriptions
*******************************************************************************/
#define IDACC_STATLOCK          30
#define IDACC_DEFLTKEYS         40
#define IDACC_NULLHAND			50

/******************************************************************************
    All Window ID's
******************************************************************************/
#define IDWIN_MAIN              1

#define IDWIN_BUTTONBAR         100
#define IDWIN_RULEMODE          101
#define IDWIN_RULESTAT          102

#define IDWIN_STATUSBAR         200
#define IDWIN_FLYINGHLP         201
#define IDWIN_VERTRULE          202
#define IDWIN_HORZRULE          203
#define IDWIN_PAGEPAGE          204
#define IDWIN_PAGESHEET         205
#define IDWIN_ZOOMSTAT          206
#define IDWIN_TOOLSBUTTON       207

#define NULL_MENU               800
#define NULL_PASTE              10241
#define NULL_SELECTMENU         10240

/******************************************************************************
    Language independant resource string
******************************************************************************/
#define IDS_LANGLIBRARY     	16  //"maul.lng"

/******************************************************************************
    All String ID's
******************************************************************************/
#define IDS_UNREG               16  //"This product is UNREGISTERED. You are entitled to use this product for"
#define IDS_UNREG1              17  //"days before registering. Please read the online manual and read.me for further information."
#define IDS_REGISTERED          18  //"This product is registered to "
#define IDS_REGISTERED1         19  //" Please read the online manual and read.me for further information."
#define IDS_HELPWINTITLE        20  //"Maul Help"
#define IDS_HELPLIBRARY         21  //"maul.hlp"
#define IDS_HELP_OPEN_ERROR     22  //"Error - Cannot find Help"
#define IDS_HELP_MNGR_ERROR     23  //"Error - Help Panel(s) Not Found"
#define IDS_PROFILE_NOT_FOUND   24  //"Error - Required profile setting(s) not found"
#define IDS_FILE_CHECKSUM_BAD   25  //"Error - Bad file checksum in document header (struct.chksum)"
#define IDS_PRINTFORM_MISMATCH  26  //"Error - Printer forms do not match. Choose a new form"
#define IDS_ADDPRINTPAGE        27  //"add printer page"
#define IDS_DELPRINTPAGE        28  //"delete printer page"
#define IDS_EDITPRINTPAGE       29  //"paste printer page"
#define IDS_SETNPAGES           30  //"change page settings"
#define IDS_PASTEFRAME          31  //"paste frame"
#define IDS_ADDFRAME            32  //"add frame"
#define IDS_DELFRAME            33  //"delete frame"
#define IDS_FRAMETOBACK         34  //"move frame to back"
#define IDS_FRAMETOFRONT        35  //"move frame to front"
#define IDS_ADDOBJHEAD          36  //"add handler"
#define IDS_DELOBJHEAD          37  //"remove handler"
#define IDS_ADDOBJDATA          38  //"add handler data"
#define IDS_DELOBJDATA          39  //"remove handler data"
#define IDS_LINKOBJECT          40  //"link object"
#define IDS_UNLINKOBJECT        41  //"unlink object"
#define IDS_CHANGEFRAME         42  //"delete frame"
#define IDS_FRAMESTROKEWIDTH    43  //"change frame border width"
#define IDS_SETMARGINS          44  //"change page margins"
#define IDS_LINKAGE_ERROR       45  //"Error - Corrupted frame linkage information"
#define IDS_MPAGE_MISMATCH      46  //"Master page does not match this page shape or size. Use it anyway?"
#define IDS_MANUALPRINTFORM     47  //"Manual printer form. Select the correct printer form in the following dialog and ensure that the form is present"
#define IDS_VERSIONMISMATCH     48  //"Incompatible handler version found"
#define IDS_HANDLISTFAIL        49  //"Handler list load has failed - Exit"
#define IDS_BADPRINTPAGE        50  //"Bad printer page. Maul cannot continue"
#define IDS_BADSCREEN           51  //"Bad screen parameters. Maul cannot continue"
#define IDS_BADPRINTER          52  //"Printer not found. Maul cannot continue"
#define IDS_FILE_BAD            53  //"Error - Bad file type in document header (struct.fileid)"
#define IDS_FILE_OPENNEWCHK     54  //"Open in new window"
#define IDST_FILESTRUCT         55  //"File structure integrity check failed. Make a note of what you did, and report the error to maul technical support (see manual)."
#define IDST_ACCVIOL            56  //"SIGSEGV:- Memory Access Violation. Forced File Integrity Dump and Exit."
#define IDST_PROCTITLE          57  //"Processing:- <ESC> to exit"
#define IDST_HANDLERNOTFOUND    58  //"Warning - expected handler not found. Handler ignored."
#define IDST_HANDLERFOPENERR    59  //"Error - runtime failure in fopen"
#define IDST_PRINTERPROBLEM     60  //"Error - You appear to have a printer problem. Read the problem page for this program before proceeding."
#define IDS_MINIFONT            61  //"Helvetica Bold"
#define IDS_UNDOPLACEMARKER     62  //"set undo placemarker"
#define IDS_EDITSNAP            63  //"set custom snap marker"
//modify flying help & title string id's if required!!!

#define IDS_RESTART             64  //"Language changed - Exit to restart?"
#define IDST_MASTERPAGES        65  //"Save master page"

#define IDST_PROJECTFILES       66  //"Project files"
#define IDST_PROJECTTYPES       67  //"Projects+*.prj"

#define IDST_PROJECTEXISTS      68  //"This project exists, you cannot overwrite existing projects"
#define IDST_COLORTABLES       	69  //"All files+*.*+Colour Tables (*.clr)+*.clr"
#define IDST_COMMONPATH       	70  //"[ .\etc... ]"

//This is defined in maulclass.h
//#define IDST_EMPTYOBJECT      71  //"Note:- An empty object has been created"

#define IDST_PROJECTINVALID     72  //"Incompatible files in project - cannot print"
#define IDST_DELETEEMBFONT      73  //"Delete embedded fonts?"
#define IDST_INSTALLEMBFONT     74  //"Install embedded fonts?"

#define IDS_RGKEYSUM            76  //"bad checksum - this key is not valid"
#define IDS_RGPROGSUM           77  //"bad checksum - you must re-install this program"
#define IDS_RGNAMEMATCH         78  //"name not found in key, please re-spell it"
#define IDS_RGIDMATCH           79  //"id not found in key, please check your spelling"
#define IDS_RGCUSTOMERNUM       80  //"Please keep this number in a safe place, quote this number when you need a new key"
#define IDS_RGREGRESET          81  //"Operation completed successfully"
#define IDS_RGPOESTRING			82	//"Ok - Proof of entitlement(POE) = %d"
#define IDS_LANGMINVER			83	//"302"
#define IDS_AUTOREFORMATWARN	84	//"Warning - STRCIDL failure during autoreformat"

#define IDST_MAINTYPES       	100 //"All files+*.*+Maul document (*.mpb)+*.mpb+Maul project (*.mpj)+*.mpj"
#define IDS_NOTRASHCAN       	101 //"Error - Object delete failure, attempt permanent delete?"
#define IDS_REREGISTER       	102 //"Please re-register using your original registration key. This is required..." 

/******************************************************************************
    All Title string ID's
******************************************************************************/

/* dlgserv.c */
#define IDST_STYLEFILE_EXISTS   110  //"Stylefile exists, overwrite"
#define IDST_STYLEFILE_DELETE   111  //"Delete this stylefile"
#define IDST_STYLE_EXISTS       112  //"Stylesheet exists, override"
#define IDST_STYLE_DELETE       113  //"Delete this stylesheet"

/* filedlg.c */
#define IDST_NEWFORM            114  //"New_Printer_Form"
#define IDST_OPEN               115  //"~Open"
#define IDST_SAVE               116  //"~Save"
#define IDST_EDIT               117  //"~Edit"

/* fileio.c */
#define IDST_FILE_NOT_SAVED     118  //"File not saved, save now ?"
#define IDST_FILE_ALREADY_SAV   119  //"Already saved, save anyway ?"
#define IDST_FILE_NOWT_SAVE     120  //"Nothing to save"
#define IDST_FILE_TYPE_SOMAT    121  //" until you alter something."
#define IDST_FILE_EXISTS        122  //"Warning - File Exists, save anyway ?"
#define IDST_PAGE_MISMATCH      123  //"Page shape mismatch"
#define IDST_FORMAT_WARN        124  //"Warning - Importing older file format"

#define IDS_EVALMSG             125  //"This is an evaluation copy...."
#define IDS_EVALMSGCONT         126  //"....Maison Anglais. All Rights Reserved."
#define IDS_DIVZERO             127  //"DIV_ZERO:- Divide by 0. Forced File Integrity Dump and Exit."

//**** in "dllinfo.h"  #define IDS_SMALLFONT           128  //"8.Helv"

#define IDS_DEMOMSG             129 //"This is a demonstration copy...."

/* gencmd.c */
#define IDST_DUP_COMMAND        130  //"Error duplicate invocation parameter"

/* genfim.c */
#define IDST_UNTITLED           131  //"UNTITLED"

/* genprnt.c */
#define IDST_PPI_ERROR          132  //"x/y dpi missing"
#define IDST_SIZE_ERROR         133  //"x/y size missing"
#define IDST_PRFORM_LIST        134  //"%s, %dmm wide x %dmm long"
#define IDST_PRFORM_FNF         135  //"%s, form not found"
#define IDST_FILE_NOWT_PRINT    136  //"Nothing to print"

/* handler.c */
#define IDST_SEL_CONTENTS       140  //"Select Contents Handler"
#define IDST_SEL_BACKGROUND     141  //"Select Background Handler"
#define IDST_SEL_BORDER         142  //"Select Border Handler"

/* maul.c */
#define IDST_ADDHAND            143  //"Add %.*s"
#define IDST_DUMPOK             144  //"File Dumped"

/* message.c */
#define IDST_AREYOU_SURE        145  //"Are You Sure ?"
#define IDST_GMSGBOXERR         146  //"Maul Error!! - %s"
#define IDST_GMSGBOXINF         147  //"Information - %s"
#define IDST_GMSGBOXWRN         148  //"Warning! - %s"
#define IDST_GMSGBOXQST         149  //"What to do? - %s"
#define IDST_GMSGBOXDEF         150  //"Hmmm... - %s"
#define IDST_FILESUMBADX        151  //"Unexpected file magic marker"

#define IDST_PRODUCTCTRY        152  //"0x44"
#define IDST_PRODUCTLANG        153  //"0x13"
#define IDST_DLGCODEPAGE        154  //"850"

#define IDS_PRINTORPHAN         155  //"This page is single sided. Please remove it from your printer now. Then press Ok."
#define IDS_PRINTFLIP           156  //"Please remove the stack of printed pages, turn them over, and put them back in your printer."
#define IDS_PRINTMESSAGE		157	 //"Print page %d of %d"

/* memman.c */
#define IDS_FRAMETOPAGE			158	 //"move frame to page"

/* pagehand.c */
#define IDST_MANUALFROMSET      160  //"Manual form setup"
#define IDST_DEFPRINTPAGE       161  //"Default printer page"
#define IDST_FORMEXISTS         162  //"Form exists, overwrite"
#define IDST_FORMDELETE         163  //"Delete this form"
#define IDST_DEFMARGINS         164  //"Default page margins"
#define IDST_FREEEDGE           165  //"Free edge"
#define IDST_FOLDEDGE           166  //"Folded edge"
#define IDST_BOUNDEDGE          167  //"Bound edge"
#define IDST_PAGEMATCH          168  //"forms match"
#define IDST_PAGENEAR           169  //"*forms almost match!"
#define IDST_PAGEPELS           170  //"*form pels match only!"
#define IDST_PAGEMISMATCH       171  //"*forms do not match!"
#define IDST_PAGEDYNMATCH       172  //"matched from file."
#define IDST_DEFPAGEDLG         173  //"Default printer page"
#define IDST_ASKAUTOSETUP       174  //"Shall I set your page and printer settings to a reasonable default?"
#define IDST_SIZEINFORM         175  //"(%s x %s)"
#define IDST_PRINTCOPIES        176  //"Print %d copies?"
#define IDST_PRINTONLY          177  //"Print:- "
#define IDST_PRINTPROJECT       178  //"Print Project:- "
#define IDST_EPDFPIPE	        179  //"\\PIPE\\ePDF"

/* pgpaint.c */
#define IDST_PAGESTAT_SHEET     180  //"s %d of %d"
#define IDST_PAGESTAT_PAGE      181  //"p %d (%d/s)"

/* profile.c */
#define IDST_FILEPROFILE        182  //"change settings"

#define IDST_NET_NOUPDATE       183  //"Maul Publisher is up to date"
#define IDST_NET_NEWVERSION     184  //"A new version of Maul Publisher is available for download and installation"
#define IDST_NET_SHUTDOWN		185  //"Maul Publisher program exit!"
#define IDST_NET_FAILURE		186  //"ERROR - Unable to connect to network!"

/* selchar.c */
#define	IDST_GROUPLIST			188  //"" 1024 chars max

/* undo.c */
#define IDST_UNDO_ALL           190  //"< Undo everything >"
#define IDST_UNDO_NONE          191  //"< nothing to undo >"
#define IDST_UNDO               192  //"~Undo "
#define IDST_REDO               193  //"~Redo "
#define IDST_UNDO_KEY           194  //"\tAlt+Backspace"
#define IDST_REDO_KEY           195  //"\tCtrl+Backspace"
#define IDST_REDO_KEY           195  //"\tCtrl+Backspace"
#define IDST_MODITITLE          196  //"File modified %d times"
#define IDS_LOCKED              197  //"Locked"

/* wincommand.c */
#define IDST_DELPRINTPAGE       200  //"Delete this printer page?"
#define IDST_DEVERROR           201  //"Device Error"
#define IDST_FILEERROR          202  //"File Error"
#define IDST_NEWPUBPRIM         203  //"<None>"
#define IDST_NEWPUBSECM         204  //"<As Above>"
#define IDST_MAULSNAME          205  //"[ Maul Publisher ]"
#define IDST_STATSMESSAGE       207  //"Page %d, Frame %d"
/*
"Available memory 2x %dkb\n
File buffer %dkb in use\n
Work buffer  %dkb in use\n
Undo size %dkb, %d items\n
File size %dkb\n
(%d Pages %d Frames %d Objects)"
*/

/* rule.c*/
#define IDST_SNAPVERTINFO       208  //"Horizontal markers"
#define IDST_SNAPHORZINFO       209  //"Vertical markers"

/* color.c */
#define IDST_COLOR_EXISTS       210  //"Colour table exists, overwrite"
#define IDST_COLOR_DELETE       211  //"Delete this colour table"
#define IDS_COLOR_HASNAMES      212  //"Overwrite exiting colours"
#define IDS_ADDSPOTCOLOR        213  //"Insert Spot Colour"
#define IDS_REMSPOTCOLOR        214  //"Delete Spot Colour"
#define IDS_EDITSPOTCOLOR       215  //"Edit Spot Colour"
#define IDS_EDITSPOTSTAT        216  //"Now:- "
#define IDS_EDITPROCESSSTAT     217  //"off"
#define IDST_COLTABREM          218  //"<This is an auto generated file, edit at your peril\n<Name, cyan (0..255), magenta (0..255), yellow (0..255), screen (0 = Process, 1 = Black, 2 = Cyan, 3 = Magenta, 4 = Yellow)\n"
#define IDST_APPLYBUTTON        219  //"~Apply"
#define IDST_EXITBUTTON         220  //"~Exit"

#define IDS_SYSSTYLETABS		221  //"Startup+Data path+Offline+Tracking Handles+Buttons+Tool tips+Boundary+Printjobs"
#define IDS_NEWFILETABS			222  //"Data path+Offline+Boundary"
#define IDS_NEWFILETITLE		223  //"Local (file) style settings"

#define IDS_MCLR_HOLLOW			228  //"Hollow"
#define IDS_MCLR_CURSEP			229  //"Cropmark"
#define IDS_SRCANGLENAMES       230  //"Process"
#define IDS_CLRBLACK			231  //"Black"
#define IDS_CLRCYAN				232  //"Cyan"
#define IDS_CLRMAGENTA			233  //"Magenta"
#define IDS_CLRYELLOW			234  //"Yellow"
#define N_SRCANGLENAMES 5
#define IDS_CLRWHITE			235  //"White"
#define IDS_CLRBLUE				236  //"Blue"
#define IDS_CLRGREEN			237  //"Green"
#define IDS_CLRRED				238  //"Red"
#define IDS_CLRGRAY				239  //"Midgrey"

/* import and export */
#define IDST_IMPORTPAGE         240  //"Import publication"
#define IDST_EXPORTPAGE         241  //"Export publication"
#define IDST_IMPORTBUTTON       242  //"Import"
#define IDST_EXPORTBUTTON       243  //"Export"
#define IDST_ALLFILES	        244  //"All files"
#define IDST_ALLTYPES	        245  //"All known file types"
#define IDST_RELOAD		        246  //"Reload %s"
#define IDS_CLIPBOARDERROR		247  //"Error - failed to save clipboard data"

/* accelerator keys */
#define IDST_ACCSTATUSOK        250  //"Shortcut"
#define IDST_ACCSTATUSUSED      251  //"Shortcut - in use"
#define IDST_ACCSTATUSLOCKED    252  //"Shortcut - locked"
#define IDST_ACCSTATUSAPPENAB   253  //"Shortcut - first, locked"
#define IDST_ACCSTATUSAPPEND    254  //"Shortcut - second"
#define IDST_RESETALLACCELS     255  //"Default all shortcuts"
#define IDST_ACCVKEYCTRL        256  //"Ctrl"
#define IDST_ACCVKEYALT         257  //"Alt"
#define IDST_ACCVKEYSHIFT       258  //"Shift"
#define IDST_ACCVKEYCONCAT      259  //"+"
#define IDST_ACCVKEYTABLE       260
/*
VK_BACK     "Backspace"
VK_SPACE    "Space"
VK_PRIOR    "Page up"
VK_NEXT     "Page down"
VK_END      "End"
VK_HOME     "Home"
VK_LEFT     "Left"
VK_UP       "Up"
VK_RIGHT    "Right"
VK_DOWN     "Down"
VK_INSERT   "Ins"
VK_DELETE   "Del"
VK_LWIN     "Win L"
VK_RWIN     "Win R"
VK_ADD      "Plus"
VK_SUBTRACT "Minus"
VK_F2       "F2"
VK_F3       "F3"
VK_F5       "F5"
VK_F6       "F6"
VK_F7       "F7"
VK_F8       "F8"
VK_F9       "F9"
VK_F10      "F10"
VK_F11      "F11"
VK_F12      "F12"
...and A to Z of course
*/

/******************************************************************************
    Flying help string ID's
******************************************************************************/
#define IDFH_FLYINGHLP          1064  //"Look here for help"
#define IDFH_BUTTONBAR          1065  //"This is the toolbar"
#define IDFH_STATUSBAR          1066  //"This is the status bar"
#define IDFH_CLIENT             1067  //"This is the main window"
#define IDFH_MENU_ID            1068  //"Select a menu item"
#define IDFH_SYSMENU_ID         1069  //"Click for the system menu"
#define IDFH_MINBUTTON          1070  //"Maximise or minimise the window"
#define IDFH_SELECT             1071  //"Select a submenu item..."
#define IDFH_CLICKON            1072  //"Click on a frame!"
#define IDFH_NULSELFRAME        1073  //"Null handler: Select a frame?"
#define IDFH_MAIN_FILE          1074  //"Select file operation"
#define IDFH_MAIN_PAGE          1075  //"Page setting tasks"
#define IDFH_MAIN_VIEW          1076  //"Select a viewing mode"
#define IDFH_MAIN_EDIT          1077  //"Select edit task"
#define IDFH_MAIN_UNDO          1078  //"Select undo or redo options"
#define IDFH_MAIN_OPTS          1079  //"Select an option"
#define IDFH_MAIN_WIND          1080  //"Select a window from list"
#define IDFH_MAIN_HELP          1081  //"Select the help required"
#define IDFH_SCROLLBAR          1082  //"Scroll window"
#define IDFH_FRAMEBUTTON        1083  //"Select frame mode"
#define IDFH_CONTENTSBUTTON     1084  //"Edit frame contents"
#define IDFH_LAYERREP           1085  //"Layer %d:- %s"
#define IDFH_BORDERBUTTON       1086  //"Edit Borders and lines"
#define IDFH_FILE_OPEN          1087  //"Open a file"
#define IDFH_FILE_SAVE          1088  //"Save file"
#define IDFH_FILE_PRINT         1089  //"Print a file"
#define IDFH_PAGE_INSERT        1090  //"Add a new page"
#define IDFH_PAGE_DELETE        1091  //"Delete current page"
#define IDFH_PAGE_NEXT          1092  //"Goto next page"
#define IDFH_PAGE_PREV          1093  //"Goto previous page"
#define IDFH_VIEW_TOOLSUP       1094  //"Show/hide tool bar"
#define IDFH_PAGE_REPAINT       1095  //"Repaint the window"
#define IDFH_DUNIT_METRIC       1096  //"Measure in inches"
#define IDFH_DUNIT_INCHES       1097  //"Measure in points (1/72\")"
#define IDFH_DUNIT_POINTS       1098  //"Measure in metric"
#define IDFH_VIEW_PAGE          1099  //"View printer page"
#define IDFH_VIEW_FULL          1100  //"View one page"
#define IDFH_VIEW_WIDTH         1101  //"Maximize view to screen"
#define IDFH_VIEW_ACTU          1102  //"View actual size"
#define IDFH_VIEW_BIGGER        1103  //"Zoom in"
#define IDFH_VIEW_SMALLER       1104  //"Zoom out"
#define IDFH_ZOOMSTAT           1105  //"Zoom factor"
#define IDFH_VERTRULE           1106  //"Vertical ruler"
#define IDFH_HORZRULE           1107  //"Horizontal ruler"
#define IDFH_PAGEPAGE           1108  //"The current page"
#define IDFH_PAGESHEET          1109  //"The current print sheet"
#define IDFH_RULESCALE          1110  //"The ruler scale factor"
#define IDFH_VIEW_FACING        1111  //"View facing pages"
#define IDFH_SELECTLAYER        1112  //"Object layer selection menu"

//***** The following is used by other handlers - do not change resource number
#define IDFH_COLORSWATCH        1113  //"Click here for more..."
#define IDFH_CLICKON2           1114  //"Ok:- now select a frame to continue"
#define IDFH_MAIN_TOOLS         1115  //"Select a tool"
#define IDFH_ADDFONTS        	1116  //"Add fonts"
#define IDFH_FILEFONTS          1117  //"Add all fonts in file"
#define IDFH_PRIORIMAGE         1118  //"Previous image"
#define IDFH_NEXTIMAGE          1119  //"Next image"
#define IDFH_PREVIEW            1120  //"Disable/enable preview"

/******************************************************************************
    Dialog Menu ID's
******************************************************************************/
#define IDMNU_DLG_MAIN	    	6999
#define IDMNU_DLG_FILE	    	7000
#define IDMNU_DLG_OPEN	    	7001
#define IDMNU_DLG_SAVE	    	7002
#define IDMNU_DLG_SAVEAS	    7003

#define IDMNU_DLG_EDIT	    	7100
#define IDMNU_DLG_COPY	    	7101
#define IDMNU_DLG_PASTE	    	7102
#define IDMNU_DLG_CUT	    	7103
#define IDMNU_DLG_CLEAR	    	7104

/******************************************************************************
    All Menu ID's
******************************************************************************/
#define IDMNU_MAIN_FREESPACE    8000

#define IDMNU_MAIN_FILE         10000
#define IDMNU_FILE_NEW          10001
#define IDMNU_FILE_OPEN         10002
#define IDMNU_FILE_IMPORT       7100
#define IDMNU_FILE_EXPORT       7200
#define IDMNU_FILE_AUTOSAVE     10003
#define IDMNU_FILE_SAVE         10005
#define IDMNU_FILE_SAVAS        10006
#define IDMNU_FILE_PRINT        10007
#define IDMNU_FILE_ACQUIRE      10008
#define IDMNU_FILE_SELSOURCE    10009
#define IDMNU_FILE_NEWPRJ       10010
#define IDMNU_FILE_OPENPRJ      10011
#define IDMNU_FILE_CLOSEPRJ     10012
#define IDMNU_FILE_EDITPRJ      10013
#define IDMNU_FILE_ADDTOPRJ     10014
#define IDMNU_FILE_PRINTPRJ     10015
#define IDMNU_FILE_PRJFILES     7300
#define IDSUBM_FILE_POPUP		10020
#define IDSUBM_FILE_DELETE		10021
#define IDMNU_FILE_STYLES		10022
#define IDMNU_FILE_PROJECT      10023

#define IDMNU_FILE_QUICKOPEN    10090

#define IDMNU_MAIN_PAGE         10100
#define IDMNU_PAGE_PAGE         10101
#define IDMNU_PAGE_MARGIN       10102
#define IDMNU_PAGE_REPAINT      10103
#define IDMNU_PAGE_MEASURE      10114
#define IDMNU_PAGE_MASTER       7400

#define IDMNU_PAGE_INSERT       10104
#define IDMNU_PAGE_INSERTDEF    10105
#define IDMNU_PAGE_INSERTFST    10106
#define IDMNU_PAGE_DELETE       10107
#define IDMNU_PAGE_GOTO         10108
#define IDMNU_PAGE_NEXT         10109
#define IDMNU_PAGE_PREV         10110
#define IDMNU_PAGE_COPY         10111
#define IDMNU_PAGE_PASTE        10112
#define IDMNU_PAGE_SAVEMASTER   10113

#define IDMNU_EDIT_NULL         10199
#define IDMNU_MAIN_EDIT         10200
#define IDMNU_EDIT_             10201

#define IDMNU_MAIN_UNDO         10220
#define IDMNU_UNDO_UNDO         10221
#define IDMNU_UNDO_REDO         10222
#define IDMNU_UNDO_LIST         10223

/**** listed elsewhere...  #define NULL_SELECTMENU         10240 ****/

#define IDMNU_MAIN_VIEW         10300
#define IDMNU_VIEW_FACING       10301
#define IDMNU_VIEW_PAGE         10302
#define IDMNU_VIEW_FULL         10303
#define IDMNU_VIEW_WIDTH        10304
#define IDMNU_VIEW_ACTU         10305
#define IDMNU_VIEW_BIGGER       10306
#define IDMNU_VIEW_SMALLER      10307
#define IDMNU_VIEW_FRAME        10308
#define IDMNU_VIEW_CONTENTS     10309
#define IDMNU_VIEW_BORDER       10310
#define IDMNU_VIEW_TOOLSUP      10311
#define IDMNU_VIEW_CONTSUB0     10320
#define IDMNU_VIEW_CONTSUB1     10321
#define IDMNU_VIEW_CONTSUB2     10322
#define IDMNU_VIEW_CONTSUB3     10323
#define IDMNU_VIEW_BORDSUB0     10330
#define IDMNU_VIEW_BORDSUB1     10331
#define IDMNU_VIEW_BORDSUB2     10332
#define IDMNU_VIEW_BORDSUB3     10333

#define IDMNU_MAIN_TOOLS        10700
#define IDMNU_TOOLS_SEARCH      10701
#define IDMNU_TOOLS_REPORT      10702
#define IDMNU_COLORTABLES       10703
#define IDMNU_COLORTUNE       	10704
#define IDMNU_EMBEDFONTS        10705

#define IDMNU_MAIN_OPTS         10780
#define IDMNU_OPTS_REGISTER     10781
#define IDMNU_OPTS_PAGE         10782
#define IDMNU_OPTS_STYLES       10783
#define IDMNU_OPTS_SHORTCUT     10784
#define IDMNU_OPTS_SNAP         10785
#define IDMNU_OPTS_SNAPON       10786
#define IDMNU_OPTS_NOUNDO       10787
#define IDMNU_OPTS_CLRLOAD      10788
#define IDMNU_OPTS_CLRMERGE     10789
#define IDMNU_OPTS_CLRSAVAS     10791
#define IDMNU_OPTS_PALETTE      10792
#define IDMNU_OPTS_END          10800

#define IDMNU_MAIN_HELP         10900
#define IDMNU_HELP_CONT         10901
#define IDMNU_HELP_INDX         10902
#define IDMNU_HELP_GENE         10903
#define IDMNU_HELP_USIN         10904
#define IDMNU_HELP_KEYS         10905
#define IDMNU_HELP_ABOU         10906
#define IDMNU_HELP_HAND         10907
#define IDMNU_HELP_INFO         10908
#define IDMNU_HELP_ADDHT        10909
#define IDMNU_HELP_STATS        10910
#define IDMNU_HELP_ERRLIST      10912
#define IDMNU_HELP_NETUPD       10913
#define IDMNU_HELP_HOWTO        10914

#define IDMNU_MAIN_WIND         11000

/*******************************************************************************
    Push Buttons for Toolbar
*******************************************************************************/
#define IDPB_FILE_OPEN          11002
#define IDPB_FILE_SAVE          11005
#define IDPB_FILE_PRINT         11007
#define IDPB_PAGE_PREV          11108
#define IDPB_PAGE_NEXT          11107
#define IDPB_PAGE_INSERT        11104
#define IDPB_PAGE_DELETE        11105
#define IDPB_VIEW_PAGE          11301
#define IDPB_VIEW_FULL          11302
#define IDPB_VIEW_WIDTH         11303
#define IDPB_VIEW_ACTU          11304
#define IDPB_VIEW_BIGGER        11305
#define IDPB_VIEW_SMALLER       11306
#define IDPB_VIEW_FRAME         11307
#define IDSUBM_CONTENTS         11308
#define IDSUBM_BORDER           11309
#define IDPB_VIEW_CONTENTS      11310
#define IDPB_VIEW_CONTSUB0      11311
#define IDPB_VIEW_CONTSUB1      11312
#define IDPB_VIEW_CONTSUB2      11313
#define IDPB_VIEW_CONTSUB3      11314
#define IDPB_VIEW_BORDER        11320
#define IDPB_VIEW_BORDSUB0      11321
#define IDPB_VIEW_BORDSUB1      11322
#define IDPB_VIEW_BORDSUB2      11323
#define IDPB_VIEW_BORDSUB3      11324

/******************************************************************************
    All Assoc ID's
******************************************************************************/
#define IDASSOC_MAIN            20000
#define IDFILEX_MAIN            "MPB"
#define IDASSOC_STRING          "Maul Publication"

/******************************************************************************
    All Help ID's
******************************************************************************/
#define IDHLP_MAIN          1
#define IDHLP_MAIN_MENU     2
#define IDHLP_MASTPAGEDLG   3
#define IDHLP_DLGONE        4
#define IDHLP_DLGTWO        5

#endif
