/******************************************************************************
    Resource Header for install
    (c)Peter Koller 1996
******************************************************************************/
#ifndef PMPE_INSTALL
#define PMPE_INSTALL

/**** String table ****/
#define IDS_CHKSUM				16	//"CHECKSUM, expected %d, got %d. File reject!"
#define IDSC_ARGNOTENOUGH		17  //"insufficient number of arguments"
#define IDSC_NOASSIGN			18  //"missing assignment"
#define IDSC_EOFFUNC			19  //"expression at eof"
#define IDSC_EOFARG 			20  //"argument at eof"
#define IDSC_EOFTEXT			21  //"text string at eof"
#define IDSC_OUTOFMEMORY		22  //"out of memory"
#define IDSC_UNTERMINATED		23  //"command terminator missing"
#define IDSC_EOFCOMMENT 		24  //"comment at eof"
#define IDSC_EOFQUOTES			25  //"quotes at eof"
#define IDSC_SCRIPTKILL 		26  //"script interrupted by user"
#define IDSC_FUNCSYNTAX 		27  //"command syntax error"
#define IDSC_EOFMATHS			28  //"mathematical expression at eof"
#define IDSC_MUSTBEVOU			29  //"expected value or unary expression"
#define IDSC_NOTTWOPART 		30  //"expected two part expression"
#define IDSC_EXPMISSING 		31  //"missing expression"
#define IDSC_MUSTBEVAL			32  //"expected a value to follow unary"
#define IDSC_EXPSYNTAX			33  //"expression syntax error"
#define IDSC_FILESYNTAX			34  //"file syntax error"

/**** Type Definitions ****/
#define RT_INSTDATA         123
#define ID_HELPFILE         10
#define ID_HELPPACK         20
#define ID_EXEPACK          30
#define ID_SUBPACK1         40
#define ID_SUBPACK2         50
#define ID_SUBPACK3         60
#define ID_SUBPACK4         70
#define ID_SUBPACK5         80

/**** Main Definitions ****/
#define IDD_MAIN            1
#define IDD_SPLASHMAP       2

#define IDD_HELPBUTTON      1000
#define IDD_INST_STATUS     1001
#define IDD_INST_FROM       1002
#define IDD_INST_CHANGE     1003
#define IDD_INST_UNINST     1004
#define IDD_INST_INSTALL    DID_OK
#define IDD_INST_REQUIRED   1005
#define IDD_INST_AVAILABLE  1006
#define IDD_INST_STATFRAME  1007
#define IDD_INST_LISTPACKS  1008
#define IDD_INST_TOTAL      1009
#define IDD_INST_RECEIVED   1010
#define IDD_INST_TOTALTIME  1011
#define IDD_INST_CURTIME    1012
#define IDD_INST_REMTIME    1013

/**** Main Dialog ****/
#define IDD_MAINDLG         1100
#define IDD_EVALSPLASH      1101
#define IDD_NETUPDATE_PB    1102
#define IDD_ADVANCEINST_PB  1103
#define IDD_SUBSYSINST_PB   1104
#define IDD_UNINST_PB       1105
#define IDD_INST_PROGRESS   1106

/**** Uninstall Dialog ****/
#define IDD_UNINSTALL       1200

/**** Network update Dialog ****/
#define IDD_NETUPDATE       1300

#define IDD_SUBSYSINST      1350

/**** Advanced install Dialog ****/
#define IDD_ADVANCEDDLG     1400
#define IDD_INST_HLPLIST    1401
#define IDD_INST_CHHELP     1402

/**** Language Dialog ****/
#define IDD_LANGUAGEDLG     1500
#define IDD_LANGUAGELIST    1501

#define IDD_KAPUTT		    1600

/*check buttons*/
#define IDCB_EXEPACK        200
#define IDCB_SUBPACK1       201
#define IDCB_SUBPACK2       202
#define IDCB_SUBPACK3       203
#define IDD_INST_CONFIG     204
#define IDD_INST_OBJECT     205
#define IDD_INST_FILES      206

/* entryfield titles */
#define IDET_EXEPATH        400
#define IDET_HELPPATH       401

/**** path setting dialog ****/
#define IDD_MAINPATHDLG     1600

/**** help path setting dialog ****/
#define IDD_HELPPATHDLG     1700

/******************************************************************************
    All Help ID's
******************************************************************************/
#define IDHLP_MAIN          1
#define IDHLP_MAINDLG       2
#define IDHLP_UNINSTALL     3
#define IDHLP_BASICINST     4
#define IDHLP_ADVANCEDDLG   5
#define IDHLP_MAINPATHDLG   6
#define IDHLP_HELPPATHDLG   7

#endif
