.******************************************************************************
.*  Maul Publisher Spell Handler Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul Install Help
:docprof toc=1234.
.******************************************************************************
:h1 res=1 id=1.Maul Installation
:i1 id=all.Maul Installation
:p.:hp2.Welcome to the installation utility for Maul Publisher.:ehp2.
:p.:hp2.IMPORTANT INFORMATION:ehp2.
:p.This version may alter the :hp2.Registration Mechanism:ehp2.. If you are 
installing over a 2.xx version, your registration will no longer work. Please 
visit :link reftype='launch' object='netscape.exe' 
data='http://www.manglais.com'. http&colon.//www.manglais.com:elink. for 
upgrade information. 
:p.In case of difficulties getting either this install utility, or the main 
program to run, please read the following 
:ul.
:li.:link reftype=hd res=310.If the install utility won't run:elink.
:li.:link reftype=hd res=320.If Maul Publisher won't run:elink.
:eul.
:p.:hp2.Archives:ehp2.
Maul is supplied in a several archives. This enables you to customise your installation.
:ul.
:li.:hp2.MAULEBINxxx.ZIP:ehp2. The binaries are the language independant bits of Maul.
:li.:hp2.MAULELENxxx.ZIP:ehp2. The language resources. the EN tells you it's 
english, if it is the german resources, it would be MAULELDExxx.ZIP.
:li.:hp2.MAULETTKxxx.ZIP:ehp2. This is the translators toolkit and is only necessary if
you wish to translate Maul to a new language. It forms no part of this installation.
:eul.
:p.You can unzip all the archives into a temporary folder, and install as many languages
as are available.
:p.:hp2.Requirements:ehp2.
:ul compact.
:li.Maul must be installed on an :hp2.HPFS:ehp2. partition, or better. The 
program requires long filename support. 
:li.You  must also have multimedia installed. The multimedia extensions are 
used to import the PhotoCd bitmap format, and should be installed even if you 
don't have a soundcard. Without them, Maul will not run. You can overcome this 
problem by manually uninstalling the PhotoCd import module. To do this, run 
'REM_PCD.cmd' found in the path where Maul Publisher is installed. 
:li.You must have a printer of some kind installed, even if it's only the 
'IBMNULL' printer. 
:li.You must have a screen resolution of at least 1024x768, or you will not 
see some of the status messages. 
:li.If you are using NewView as your help manager, please make sure that you 
upgrade to the latest version, or your help may not work properly. 
:eul.
:p.The installer should warn you if any of these problems exist.
:p.:hp2.Notes:ehp2.
:p.If you are reinstalling over an earlier version (V2.xx), and you wish to change the 
installed path, you should uninstall the previous version before performing an 
install. If you are a registered customer, you will need to purchase an 
upgrade. 
:p.This install program logs the installation process in a file called 
'install.log'. This file is found in the path where this installer was run, or 
if possible, in the destination path. If Maul Publisher does not run, have a 
look to see if a file called 'error.log' was generated in the path where Maul 
was installed. Both log files may be required if you have trouble installing. 
No 'error.log' file will be created if Maul runs correctly. 
:p.For more information about Maul's error logging system, have a look at the 
'Using Maul Publisher' manual after the installation has finished. 
:p.This program can uninstall as well as install or maintain Maul Publisher. 
You should therefore keep this program available, and not delete it. The 
installer and this help file are copied to the '\install' path where Maul 
Publisher is installed. 
:p.:hp2.Additional release notes:ehp2.
:p.Additional release notes are contained in readme.english. This file is found in 
the original zip archive. 
.br
.br
:p.Created by Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
:p. 1999 to 2005 Peter Koller, Maison Anglais. All Rights Reserved.
.******************************************************************************
.*  Installation errors...
.******************************************************************************
:h2 res=310 id=310.If the install utility won't run
:i2 refid=all.If the install utility won't run
:p.:hp2.Known problems:ehp2.
:p.Please make sure that your system has a temporary path set. this should be 
an entry something like&colon.- 
:xmp.
SET TEMP=C&colon.\VAR\TEMP;
or
SET TMP=C&colon.\VAR\TEMP;
:exmp.
:p.Then please make sure that C&colon.\VAR\TEMP (or whatever) actually exists!
:p.This version requires 'unpack2.exe'. This is not available for OS/2
versions before OS/2 Warp4.
:p.:hp2.Other problems:ehp2.
:p.The uninstall path may not be able to uninstall everything correctly. This 
is particularly true if you have used the product, and created files that the 
uninstaller does not know about. Once the uninstall has run, you may wish to 
&colon.- 
:ul.
:li.Delete the path added to the 'path=' statement in config.sys, although 
this has no detrimental effect. 
:li.Delete the directory to which maul was installed, along with all the 
subdirectories. 
:eul.
:p.Maul uses it's own folder layout to determine where to find things, so 
please don't attempt to move libraries or other files manually. The advantage 
of this arrangement is that the application does not mess around with your 
existing system, all that is done to config.sys is adding the path to maul.exe 
to the PATH statement. 
:p.:hp2.Getting Help:ehp2.
:p.This install program logs the installation process in a file called 
'install.log'. This file is found in the path where maul.exe was copied, the 
path where this installer was run, or in the 'temp' path if all else fails. 
:p.If you cannot find the help required here, please email :hp4.Maul Support 
<maulpub@gmail.com>:ehp4., with a copy of the 'install.log' file. 
:p.:hp2.See also:ehp2.&colon.- :link reftype=hd res=320.If Maul 
Publisher won't run:elink. 
.br
.br
.******************************************************************************
:h2 res=320 id=320.If Maul Publisher won't run
:i2 refid=all.If Maul Publisher won't run
:p.
:p.:hp2.The program won't run:ehp2.
:p.This installer will warn you if multimedia is not installed, and will 
remove the PhotoCd support if you continue the installation. This is 
necessary, or the program will fail with a '@DosLoadModule' error. The 
multimedia extensions are used to import the PhotoCd file format. Installing 
multimedia has the added advantage that the operation system recognises the 
graphics file types, and opens them with a double click. 
:p.There is a problem on some OS/2 systems with a corrupted printer list. Once 
Maul opens a printer device context, the runtime library gets corrupted, and 
the program fails. The failure always occurs when loading a handler list. 
:p.The most common messages for this error are&colon.-
:ul.
:li.@fopen("maul_dll.lst", "r")
:li.@LoadHandlerList
:eul.
:p.You may get the program to start up correctly by opening the properties 
notebook of the 'Maul Publisher' icon, and adding the optional parameter 
:hp4./nopdc:ehp4. on the Program page, but be aware that this may cause the 
program to fail elsewhere, such as when printing, or when attempting to load 
or save a stylesheet or master page. 
:p.Please note also, that you may have tried a number of other programs, and 
found them unreliable, particularly when printing. A surprising number of 
people have a corrupted printer list, and are unaware of the problem (Me too, 
for a while...). Maul Publisher is by no means the only program affected. 
:p.The correct solution is to set all your printers to 'IBMNULL' and to 
delete, and then re-install the latest correct printer drivers. To find out 
more about how to do this correctly please see the main user manual, as 
explained below.
:p.:hp2.Other problems:ehp2.
:p.If you are using NewView as your help manager, please make sure that you 
upgrade to the latest version, or your help may not work properly.
:p.A number of items are listed in the main user manual, 'Using Maul 
Publisher'. Have a look at the section called 'Known problems and bugs'. In 
particular, read the section on network printing, even if you are not on a 
network. 
:p.:hp2.Getting Help:ehp2.
:p.If Maul Publisher still does not run, have a look to see if a file called 
'error.log' was generated in the path where Maul was installed. No 'error.log' 
file will be created if Maul runs correctly. 
:p.If you cannot find the help required here, please email :hp4.Maul Support 
<maulpub@gmail.com>:ehp4., with a copy of the 'error.log' file. 
:p.:hp2.See also:ehp2.&colon.- :link reftype=hd res=310.If the 
install utility won't run:elink. 
.br
.br
.******************************************************************************
:h1 res=10 id=10.Automatic or remote installation
:i1 id=cmmdline.Automatic or remote installation
:p.When performing an automatic install, the language determines which files are
installed.
:p.For automatic subsystem installations the entire set of available subsystems
are installed.
:p.When automatically uninstalling the entire set of files are uninstalled.
:p.Please use the following commandline parameters to perform an automatic install&colon.-
:xmp.
/? or /h        Get a short form of this help file in a dialog.

/n              No Holdup mode ensures that the installer does not pause.
                Default = Stop with messages

/t<path>        Define target path. The path must exist or the installer will fail.
                The target filename cannot contain spaces.
                Default = /tc&colon.\maul

/l<language>    Define language. The following installer files must exist
                <language>.insr
                <language>.insl
                <language>.ipk
                packing.lst
                various *.lpk, *.pkl, and *.pk files.
                Default = /lenglish

    Select just one of the following for an automated install
/i              Install files
/u              Uninstall files
/s              Subsystem install
                Default = Wait for a button click
:exmp.
:p.So, if you are happy with all the defaults try 'install /n /i'.
.br
.br
.******************************************************************************
.*  The dialogs...
.******************************************************************************
:h1 res=2 id=2.Choosing an installation mode
:i1 id=insmode.Choosing an installation mode
:p.:hp2.Installation:ehp2.
:p.This installs Maul Publisher. Mostly, you can install this version over a 
previous one.If CONFIG.SYS is updated, you will be asked if you wish to reboot 
your machine. 
:p.:hp2.Subsystem installation:ehp2.
:p.Use this mode if you are adding or updating additional handlers for Maul 
Publisher. 
:p.The main application must be installed before you can add to it.
:p.Additional handlers are installed using a script. When you obtain the zip 
archive for the additional handler you should find a package file and an 
install script file supplied. Copy both to the install directory beneath where 
Maul was installed. This will be 'C&colon.\maul\install' on a default 
installation. Then run the installer 'install.exe' from there. 
:p.Subsystems are automatically installed and uninstalled when the relevant 
files are placed in the install source. 
:p.:hp2.Uninstall:ehp2.
:p.If you wish to remove Maul Publisher from your system, select the uninstall 
mode. You can select each category to be uninstalled, so that you can leave 
your templates intact, for example. Please take the time to read the 
categories properly to avoid deleting something you might wish to keep! 
.br
.br
.******************************************************************************
:h1 res=50 id=50.Check for updates
:i1 id=updates.Check for updates
:p.You can use this mode to check for updates on the internet.
:p.:hp2.Third party code:ehp2.
:p.This installer uses :hp2.Libcurl Version 7.16.0:ehp2. to perform file downloads.
If this application is of interest to you, you can freely download it from
:link reftype='launch' object='netscape.exe' data='http://curl.haxx.se'. http&colon.//curl.haxx.se:elink..
:p.This installer incorporates compression code by the Info-ZIP group. There are no extra charges or costs
due to the use of this code, and the original compression sources are freely available from
:link reftype='launch' object='netscape.exe' data='http://www.info-zip.org'. http&colon.//www.info-zip.org:elink..
:p.:hp2.Using:ehp2.
:p.There are a couple of prerequisites before 'Check for updates' can work. 
:ul.
:li.If you are using a proxy server, you will have to set additional proxy parameters.
Use the settings defined by curl to use a proxy. (Default port is 1080) "proxy = <host[&colon.port]>"; e.g.
:xmp.
"proxy = mypc.domain.com";
"proxy = mypc.domain.com&colon.8080";
:exmp.
:li.If a zip archive already exists in the installer directory, then you will be asked if you want to overwrite it.
If you don't want to download it again, the installer will attempt to unzip the existing file. Once a file has been
successfully unzipped, it will be deleted.
:eul.
:p.The 'Check for updates' dialog uses versioning to remove archives that are already installed from the
list of available downloads.
:p.If the archive(s) that you download are a new version, rather than a fixpack, the you will be taken
to the main install dialog instead of the subsystem install dialog when the download is completed.
Please make sure that you install major updates before attempting to install fixpack.
.******************************************************************************
:h1 res=40 id=40.Subsystem Installation
:i1 id=subsys.Subsystem Installation
:p.Use this mode if you are adding or updating additional handlers for Maul Publisher.
:p.The main application must be installed before you can add to it.
:p.Additional handlers are installed using a script. When you obtain the zip 
archive for the additional handler you should find a package file and an 
install script file supplied. Copy both to the install directory beneath where 
Maul was installed. This will be 'C&colon.\maul\install' on a default 
installation. Then run the installer 'install.exe' from there. 
:p.Subsystems are automatically installed and uninstalled when the relevant 
files are placed in the install source. :p.Make sure that the application is 
not running before attempting this install. 
.br
.br
.******************************************************************************
:h1 res=20 id=20.Installation
:i1 id=advanced.Installation
:p.This mode will perform an installation. If there is not enough room on the 
current drive, you must change the installation path. Just change the drive 
letter to the required drive. The 'Install' button will be disabled until 
sufficient space is available.
:p.:hp2.Setting the Installation Path:ehp2.
:p.Normally Maul Publisher is installed into '<bootdrive>&colon.\MAUL'. If 
OS/2 is installed in C&colon. this will be 'C&colon.\MAUL'. You can alter the 
installation path to be anything you like. Please make sure however, that you 
set a fully qualified drive and single path, such as 'd&colon.\fred'. In 
addition, it is probably not a good idea to install Maul into an existing 
path, because this can cause files from other programs to become overwritten. 
It is safe to install Maul over an older version. 
:p.Files are installed based on the main installation path. If the main 
installation path is 'C&colon.\MAUL' this will install files as 
follows&colon.- 
:p.:hp2.Core system files:ehp2.
:p.Installs or reinstalls the binaries. You can uncheck any item you don't want to install.
:ul.
:li.:hp2.Main executables:ehp2. maul.exe, and a few associated bits and pieces.
:li.:hp2.Main executable libraries:ehp2. All the handlers. Maul won't run without them.
:li.:hp2.Additional data:ehp2. A series of configuration files and tools. 
Required to make the text and spellcheck handlers work.
:li.:hp2.Basic set of dictionaries:ehp2. A number of different MySpell 
dictionaries are included by default for the most common languages. 
:li.:hp2.Example clipart:ehp2. Some examples of clipart made from frames.
:eul.
:p.:hp2.Language pack:ehp2.
:p.You must install at least one language pack, or the application will not run.
:p.:hp2.Create Desktop Folder:ehp2.
:p.If this item is checked, this creates the necessary desktop objects for 
Maul Publisher. Objects are created for all required items. If the objects 
already exist, this mode will simply refresh the existing objects without 
changing their current place on the desktop. 
:p.:hp2.Update CONFIG.SYS:ehp2. :p.If the item is checked, this updates 
CONFIG.SYS. If the system requires re-booting, you will be asked to perform a 
shutdown when you exit the installer. If the item is not checked, the 
necessary changes are saved to 'C&colon.\MAUL\CONFIG.NEW'. You will then have 
to manually apply the changes. Normally the only changes to make are the 'set 
path=' statement, and the 'set helppath=' statement. 
:p.If the install is successful, the installer will close. 
.br
.br
.******************************************************************************
:h1 res=30 id=30.Uninstalling Maul Publisher
:i1 id=uninst.Uninstalling Maul Publisher
:p.If you choose to uninstall Maul Publisher, this mode will remove all the 
files based on the current configuration. 
:p.You can select each category to be uninstalled, so that you can leave your 
templates intact, for example. Please take the time to read the categories 
properly to avoid deleting something you might wish to keep! 
.br
.br
:euserdoc.
