.******************************************************************************
.*  Maul Publisher Main Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
.*  Translation to german by Christian Hennecke
.*  Assistant translators were: Thomas Klein (, who else?)
.*  --- Translators internal version info: ---
.*  2003/2004  : ch : Pretty everything ;) except where noted
.*  2004-02-12 : tk : Getting started, Developers, Commandline,
.*                    Known problems, Toolbar
.*  2004-03-05 : tk : File Menu, Page Menu, View Menu, Edit Menu,
.*                    Undo Menu, Options Menu
.*  2004-03-06 : tk : Made all menu names be enclosed in quotes (for
.*                    German only) in order to avoid misunderstanding
.*                    e.g. "edit menu" as some way of "editing a menu"
.*                    instead of the 'edit' menu's name...
.*  2004-03-06 : tk : My "german naming" for 'torn link' was changed to 
.*                    what Christian named it: 'aufgebrochene Ketten'
.*  2004-03-07 : tk : Initial check for correct spelling and meaning
.*                    for the interim compiled .INF. The unchecked parts
.*                    that remain are: Page Menu, View Menu, Edit Menu,
.*                    Undo Menu, and Options Menu (because not compiled yet)
.*  2004-03-09 : ch : Proof-reading re. spelling and grammar. A few things
.*                    remain: How do we translate 'master page' and frame
.*                    'links'? And do we want to change the personal addressing
.*                    of the user to a more indirect one?
.******************************************************************************
:userdoc.
:title.Maul Publisher Hilfe
:docprof toc=1234.
:h1 res=1 id=intro.ber Maul Publisher
:i1 id=intro.ber Maul Publisher
:artwork name='maul.bmp' align=center.
:p.:hp2.bersetzung:ehp2.
:p.Folgende Personen haben an der deutschen bersetzung dieser Anwendung mitgewirkt:
:ul compact.
:li.Christian Hennecke: bersetzung (Dialoge, Hilfe), Korrektur und Koordination
:li.Brbel Hennecke: Korrektur
:li.Thomas Klein: bersetzung (Dialoge und Hilfe des Hauptprogramms) und Korrektur
:li.Frank Wochatz: bersetzung (Hilfe des Rahmen-Handlers)
:li.und andere
:eul.
:p.:hp2.Willkommen bei Maul Publisher,:ehp2. der weltweit einzigen professionellen
Hochprzisions-DTP-Anwendung fr **OS/2 Warp.
:p.Maul Publisher ist ganz einfach eine der leistungsfhigsten DTP-Anwendungen auf
dem Markt. Kombinieren Sie Text, Bilder und Vektorgrafiken und erstellen Sie so
in kurzer Zeit zufriedenstellende und ausgefeilte Dokumente. Vereinfachen Sie
den Arbeitsablauf mit Hilfe von Seitenvorlagen und Stilvorlagen fr konstante
Qualitt. Erzeugen Sie direkt Farbauszge fr perfekte Ergebnisse.
:p.:artwork name='picset.bmp' align=center.
:p.Funktionsumfang&colon.
:ul.
:li.Seitenmanagement fr automatische Seitennumerierung - auch fr Faltbroschren -,
manueller Duplexdruck bei einseitigen Druckern, Verwaltung von Umbrchen,
Bundstegen und Bundstegzentrierung, Neuzentrierung von Seiten auf dem Druckmedium,
benutzerdefinierte Seitenformate zur Erstellung von Dokumenten in
beliebiger Gre, automatischer Tausch von Rastern und Rndern von Seite zu
Seite, falls notwendig eigene Rasterdefinitionen pro Seite, benutzerdefinierte
Hilfslinien, Einrasten auf ausgewhlten Markierungen und Gitterlinien,
automatische Randkorrektur bei gefalteten Seiten. Mehrfache Seitenvorlagen,
automatische Rahmenverkettung zwischen Seitenvorlagen.
:li.Darstellungsverwaltung bietet Ansichten gegenberliegender Seiten, von Druckseiten,
Seiten in Druckseiten, an den Bildschirm angepaten Seiten, Seiten in
Druckerauflsung. Zoom von 16-fach bis 0,13-fach in 15 Schritten.
:li.Farbverwaltung mit direkter Farbseparation aus RGB-Bildern und Metadateien,
lad- und speicherbare Farbpaletten in einfachen Textdateien, benannte Farben,
Schmuckfarben, Farbverlufe mit Helligkeitsausgleich und Farbbergangsverwaltung
sowie Gesamttonausgleich.
:li.Leistungsfhige Mittel zur Erzeugen von Rahmen einschlielich Gruppierungsmethoden
und Export von Metadateien zur Erstellung von Firmenlogos und Clipart. Komplexe
Objekte knnen automatisch skaliert, rotiert und gespiegelt werden, wodurch sich
das Produkt zur Erstellung von Diagrammen eignet.
:li.Anordnung von Text in beliebigen Formen und Winkeln bei Umflieen beliebig
geformter, berlappender Rahmen mit der extrem leistungsfhigen, formunabhngigen
Textformatierung. Plazierung von Text entlang beliebiger Linien, Kurven und
Umrandungen, direktes Ausschneiden und Einfgen von Rahmen in Rahmenumrandungen
ohne Informationsverlust bei Textstilen und -gren. Hngende Initialen am
Absatzanfang auch bei nicht rechteckigen Rahmen. Einfgen von Bildern in Text
mit automatischem Positionsabgleich bei nderungen im Text. Bilder und
Metadateien unterliegen den gleichen formunabghngigen Regeln und knnen in
beliebigen Rahmenformen und Winkeln eingefgt werden.
:li.Serienbrieffunktionen zur Personalisierung komplexer Dokumente.
:li.Professionelle Werkzeuge zur Silbentrennung und Rechtschreibprfung kombiniert
mit anwenderspezifischen Wrterbchern und benutzerdefinierter Silbentrennung
fr perfekt ausgerichtete Textbereiche.
:li.Vollstndiges Widerrufen und Neuanwenden fr jede vorgenommene nderung.
Die Darstellung des Dokuments kann zur Reduzierung des Aufwandes beim Neuzeichnen
komplexer Dokumente zeitweise auf bestimmte Teile beschrnkt werden. Hoher
Bedienungskomfort durch anpabare Tastenkrzel. Benutzerdefinierte Stile fr
Schaltflchen, Startansichten und Gre von Griffpunkten ber globale
Stileinstellungen. Erstellung von Stilvorlagen fr Text, Texttitel, Hintergrnde,
Bitmaps, Umrandungen, Metadateien und Rahmen mit der integrierten
Stilvorlagenverwaltung.
:li.Rechnergesttzte Inhaltsverzeichnis- und Registerextraktion verringern die
Arbeitszeit bei einer der aufwendigsten Aufgaben des Desktop Publishing.
:li.Maul ist vollkommen modular mit einer ffentlich verfgbaren Schnittstelle.
Dadurch kann jeder Entwickler Maul Publisher um eigene Funktionen erweitern.
:eul.
:p.:artwork name='picset2.bmp' align=center.
:p.Erstellt von Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
:artwork name='nmehouse.bmp' align=left.
:p.:hp2.ber La Maison des Anglais:ehp2.
:p.Die obige Zeichnung stellt ein an einer mittelalterlichen Strae gelegenes Landhaus aus
dem 17. Jahrhundert dar, welches ursprnglich als Laden fr den Verkauf von Leinen und
vielleicht auch anderer Waren errichtet wurde. Dieser Landhausstil wird
'maison anglaise' genannt.
:p.Nur eine kleine Handvoll dieser von den Bretonen in einem als englisch angesehenen Stil
erbauten Huser hat bis heute berdauert. Viele davon befinden sich heute in einem Zustand
vlliger Vernachlssigung.
:p.Das Landhaus ist Heimstatt von 'Maison Anglais' und smtliche Produkte dieser Firma wurden
von Peter Koller geschaffen, einem engagierten Hardware- und Software-Ingenieur mit mehr als 25 Jahren
Erfahrung im Design von Computern, der zugehrigen Software und ihrer Schnittstellen zur
realen Welt.
:p.Die Firma Maison Anglais wurde im Vereinigten Knigreich im August 2001 registriert. Sie wurde
zur Vermarktung des Maul Publisher gegrndet, welchen es seit 1998 gibt. Der Name Maison Anglais
wird in verschiedenen Schreibweisen seit 1995 zur Vermarktung von Software-Produkten genutzt.
.br
.br
:p.:link reftype=hd res=2.Urheberrechtshinweis und Lizenzvereinbarung:elink..
.br
.br
.******************************************************************************
.*  Getting started / Schnelleinstieg
.******************************************************************************
:h1 res=17 id=quickinfo.Schnelleinstieg
:i1 id=quickinfo.Schnelleinstieg
:p.:hp2.Maul ist ein auf Rahmen basierendes DTP-Programm:ehp2.
:p.Maul ist ein DTP-Programm, welches mit Rahmen arbeitet. Das bedeutet, da
fr jegliche Objekte, die man auf einer Seite erstellen will, zunchst ein
Rahmen anlegt werden mu. Fhrt man mit dem Mauszeiger ber die Werkzeugleiste,
erscheint in der Statusanzeige (am unteren Bildschirmrand links) eine
kurze Beschreibung dessen, was die jeweilige Schaltflche bewirkt. Eventuell
mssen Sie die Schaltflche 'Rahmenmodus whlen' anklicken um fortzufahren (diese
Schaltflche wird von Maul bereits beim Start grundstzlich aktiviert).
:p.Diese kurze Anleitung soll dabei helfen, einen schnellen Einstieg in das
Arbeiten mit Maul zu finden. Sobald Sie mit den Grundlagen vertraut sind, sollten
Sie sich die Zeit nehmen zu lernen, wie die komplexeren Funktionen des
Produkts fr Ihre Zwecke eingesetzt werden knnen.
:p.:hp2.Hierarchie innerhalb von Dokumenten:ehp2.
:p.Druckseiten bestehen aus Seiten und Rahmen. Rahmen enthalten Objekte, und diese
Objekte erzeugen den eigentlichen Inhalt aus Text und Grafik...
:artwork name='hierarch.bmp' align=left.
:p.Druckseiten werden durch die Schaltflchen 'vorherige Seite' und 'nchste
Seite' ausgewhlt. Alle Dokumente bestehen aus mindestens einer Druckseite und
werden mit Anzeige der ersten Druckseite geffnet. Die Seiten einer Druckseite
enthalten Rnder und Gitter.
:p.Rahmen werden vom Rahmen-Handler verwaltet. Um einen Rahmen auszuwhlen, wird
er mit der linken Maustaste angeklickt. Rahmen knnen bis zu acht Objektebenen
enthalten, wobei fr jeden Rahmen vier Ebenen fr Inhalte und vier Ebenen fr
Umrandungen zur Verfgung stehen. Einige Rahmen, wie zum Beispiel solche fr Linien,
verfgen nicht ber Inhaltsebenen.
:p.Objekte werden durch Objekt-Handler verwaltet. Objekte sind beispielsweise
Text, Grafiken usw. Objekte werden entweder durch eine Objekt-Schaltflche
ausgewhlt oder durch Auswahl der entsprechenden Objektebene im Men 'Ansicht'.
Im Ausdruck des Dokuments erscheinen nur Objekte.
:p.:hp2.Hilfe:ehp2.
:p.Wie Sie vielleicht bemerken, befindet sich in der linken, unteren Ecke des
Programmbildschirms ein kleiner Meldungsbereich. Hierbei handelt es sich um den
Anzeigebereich der Hilfefunktion, die anstelle von Popup-Fenstern oder Tooltips
eingesetzt wird, um den Programmbildschirm von berflssigen Anzeigen frei zu
halten. Sobald man im Hauptfenster den Mauszeiger ber eine Schaltflche oder
ein Steuerungselement bewegt, erscheint im Hilfebereich eine entsprechende
Erluterung.
:p.:hp2.Einen Rahmen anlegen:ehp2.
:p.Whlen Sie eine Schaltflche aus, mit der ein Rahmen angelegt wird. Probieren
Sie es fr's erste einfach mit der Schaltflche 'Rechteck erstellen'. Sie werden
bemerken, da der Mauszeiger sich in ein Fadenkreuz ndert. Bewegen Sie nun den
Mauszeiger an die gewnschte Startposition des neuen Rechtecks. Halten Sie dann
die linke Maustaste gedrckt und ziehen Sie dabei die Maus, bis ein Rechteck in
der gewnschten Gre entsteht. Lassen Sie dann die Maustaste wieder los.
:artwork name='crefram.bmp' align=left.
:p.:hp2.Einen Text-Handler hinzufgen:ehp2.
:p.Nachdem Sie nun einen Rahmen erstellt haben, knnen Sie darin Objekt-Handler
einfgen. Klicken Sie hierzu auf die Schaltflche 'Rahmeninhalte zu Ebene 0
hinzufgen', um den Vordergrund des ausgewhlten Rahmen festzulegen. Wenn Sie die
Schaltflche erneut bettigen, ndert sich deren Funktionsbeschreibung in
'Rahmeninhalte zu Ebene 1 hinzufgen'. Sie knnen bis zu vier Ebenen angeben,
die den Rahmeninhalt bestimmen. Klicken Sie zunchst so lange auf die Schaltflche,
bis diese sich wieder auf Ebene 0 bezieht. Alternativ knnen Sie auch auf das
kleine Symbol der Ausklappliste daneben klicken und aus dem erscheinenden Men
direkt die gewnschte Ebene (in unserem Fall 0) auswhlen.
:p.Sobald Sie bei Ebene 0 angelangt sind, klicken Sie auf die Schaltflche
'Text hinzufgen' und beachten Sie, wie die Werkzeugleiste daraufhin durch den
Text-Handler bernommen wird. Nun sind Sie in der Lage, Texte einzugeben - aber
zunchst werden wir dem Rahmen noch eine Umrandung zuweisen.
:artwork name='seltxt.bmp' align=left.
:p.:hp2.Umrandung hinzufgen:ehp2.
:p.Neben den Schaltflchen fr die Inhaltsebenen finden Sie diejenigen fr die
Umrandungsebenen. Beide funktionieren nach demselben Prinzip. Klicken Sie also
auf 'Rahmenumrandung Ebene 0 hinzufgen' und dann auf 'Umrandung hinzufgen'.
Genauso wie zuvor der Text-Handler, bernimmt nun der Umrandungs-Handler die
Werkzeugleiste.
:p.Beim ersten Aufruf des Dialogs zum Hinzufgen einer Umrandung erscheint ein
Auswahldialog fr die Umrandungsbreite. Wenn Sie eine sichtbare Umrandung
erreichen wollen, mssen Sie hier einen Wert grer als Null verwenden. Die
Angabe des Wertes kann in mm, inch, Punkten oder Pixeln erfolgen.
:p.Nachdem Sie die Angabe 'mm' am Ende des Text gelscht haben, geben Sie hier
zu Testzwecken 20 ein. Damit erstellen Sie eine Umrandung mit einer Strke von
20 Pixeln.
:artwork name='sbordwid.bmp' align=left.
:p.:hp2.Handler auswhlen:ehp2.
:p.Sobald Sie einem Rahmen ein Objekt zugeteilt haben, erscheint im Hilfebereich
eine Statusmeldung, die dem Objekt entspricht. Sollte kein Rahmen ausgewhlt
sein, weil Sie in einen leeren Bereich der Seite geklickt haben, erscheint im
Hilfebereich der Hinweis 'Klicken Sie auf einen Rahmen!'. Sobald Sie einen Rahmen
ausgewhlt haben, zeigen die Schaltflchen eine Ebene und den Namen des darin
befindlichen Objekts an, beispielsweise 'Ebene 0&colon.- Text'.
:artwork name='newtext.bmp' align=left.
:p.
:p.Wenn Sie nun zurck auf die Schaltflche 'Rahmeninhalt bearbeiten' klicken,
erscheint wieder der Textobjekt-Handler. Zur Erinnerung&colon. Wenn Sie keinen Rahmen
ausgewhlt haben, weil Sie in einen leeren Bereich der Seite geklickt haben,
wird kein Handler angezeigt. Der Hilfebereich schlgt Ihnen in diesem Fall
jedoch vor: 'Klicken Sie auf einen Rahmen!'. Sie werden feststellen, da jeder
Handler sein eigenes Symbol auf der entsprechenden Auswahlschaltflche anzeigt.
Whlen Sie nun den Text-Handler aus, um mit der Texteingabe zu beginnen.
:p.:hp2.Hilfe zu einem Handler anfordern:ehp2.
:p.Der Eintrag 'Hilfe' in der Menzeile enthlt den Auswahlpunkt 'Handler
auflisten'. Hiermit erhalten Sie eine Liste der momentan installierten Handler,
aus der Sie den Handler auswhlen knnen, zu dem Sie Hilfe bentigen. Klicken
Sie dann auf die Schaltflche 'Hilfe'. Die Seitenvorlage der Hilfeinformationen zum
ausgewhlten Handler wird dann angezeigt. Eine bersicht ber die Hilfeinformationen
erhalten Sie, indem Sie im Hilfefenster zunchst den Menpunkt 'Optionen' und
dann 'Inhalt' anklicken.
:artwork name='handlist.bmp' align=left.
:p.:hp2.Weiterfhrende Informationen:ehp2.
:p.Weitere ntzliche Hinweise finden Sie in den folgenden Abschnitten&colon.
:ul.
:li.:link reftype=hd res=72.Objekte zu einem Rahmen hinzufgen:elink., fr eine
detailiertere Beschreibung, wie Texte oder Grafiken in einen Rahmen eingefgt werden.
:li.:link reftype=hd res=18.Tips und Tricks:elink., fr einige interessante Ideen,
wie man fr sich selbst das meiste aus diesem Programm herausholt und wie Sie Ihre Dokumente fr die
endgltige Ausgabe vorbereiten.
:li.:link reftype=hd res=16.Bekannte Fehler und Probleme:elink., fr detaillierte
Informationen ber mgliche auftretende Probleme und was Sie im Fall des Falles
dagegen tun knnen.
:li.Weitere Hilfethemen stehen auch unter dem Menpunkt :link reftype=hd res=113.'Hilfe -> Wie kann ich...':elink. zur Verfgung.
:li.Fr Hilfe zur Verwendung eines bestimmten Handlers beachten Sie auch die einzelnen Handler-Dokumentationen.
:li.Online-Informationen stehen ebenfalls in einem gewissen Umfang zur Verfgung unter
:link reftype='launch' object='netscape.exe'
data='http://www.manglais.com/subs/maults.html'.http&colon.//www.manglais.com/subs/maults.html:elink..,
und desweiteren knnen Sie auch die FAQ-Seite (hufig gestellte Fragen) zu
Rate ziehen. Dort ist brigens auch eine aktuelle Liste aller Fehler zu finden,
die whrend der gesamten Lebensdauer des Produkts durch Anwender gemeldet
wurden.
:eul.
.br
.br
.******************************************************************************
.*  Copyright / Urheberrechtshinweis
.******************************************************************************
:h1 res=2 id=cright.Urheberrechtshinweis und Lizenzvereinbarung
:i1 id=cright.Urheberrechtshinweis und Lizenzvereinbarung
:nt text='Hinweis:'.Diese bersetzung der Lizenzvereinbarung ist allein der
Verstndlichkeit halber beigefgt. Sie ist rechtlich nicht
verbindlich. In Zweifelsfllen gelten allein die englischen
Bestimmungen, die in der Datei CPYRIGHT enhalten sind.:ent.
:p.:hp2.Das Urheberrecht fr dieses Produkt liegt bei:ehp2.
:sl compact.
:li.Peter Koller,
:li.Maison Anglais,
:li.Trebuon,
:li.29530, Plonevez du Faou,
:li.Frankreich.
:esl.
:p.:hp2. 1998 bis 2006 Peter Koller, Maison Anglais. Alle Rechte vorbehalten.:ehp2.
:note text='Hinweis:'.
Das Urheberrecht umfat das gesamte Produkt einschlielich aller
Dateiformate, Installationsprogramme und der mitgelieferten Dokumentation.
Wo Urheberrechte dritter greifen, ist dies in der jeweiligen Bedienungsanleitung
vermerkt. In solchen Fllen knnen die Urheberrechte dritter Vorrang haben.
.br
.br
:p.:hp2.Lizenzvereinbarung:ehp2.
:p.Der Autor, Peter Koller, Maison Anglais, bleibt Eigentmer dieses Produktes.
Sie erhalten jedoch das Nutzungsrecht, wenn Sie folgende Lizenzbestimmungen
akzeptieren.
:ol.
:li.Diese Lizenz umfat das gesamte Produkt, einschlielich smtlicher Applikationen,
Module, Daten, Dateiformaten, jedes Installationsprogramms und der vollstndigen
im Lieferumfang des Produkts enthaltenen Dokumentation.
:li.Sie haben das Recht, ein einziges, unregistriertes Exemplar dieses Produkts ber
einen Zeitraum von maximal 30 Tagen zu testen. Nach Ablauf dieses Zeitraums
stellt das nicht registrierte Produkt seine Funktion ein.
:li.Dieses Produkt mu registriert werden. Sie sind zu seiner Registrierung verpflichtet,
wenn Sie es ber den Testzeitraum hinaus nutzen.
:li.Erhalten Sie einen Kundenregistrierschlssel (Customer Registration Code, CRN), darf
dieser an niemanden weitergegeben werden. Der Registrierschlssel enthlt Ihre
persnlichen Daten und es liegt in Ihrer Verantwortung, ihn vor dem Zugriff anderer
zu schtzen.
:li.Dieses Produkt darf zur gleichen Zeit nur auf einem Rechner genutzt werden. Wenn Sie
eine mehrfache Lizenz erworben haben, knnen Sie entsprechend viele Exemplare
gleichzeitig nutzen.
:li.Dieses Produkt darf nur zu Sicherungs- und Komprimierungszwecken in maschinenlesbarer
oder gedruckter Form kopiert werden.
:li.Das Produkt darf nicht in Gnze oder in Teilen nachgebaut oder disassembliert werden.
:li.Die Weitergabe nicht registrierter Exemplare des Produktes an andere ist erlaubt.
Endanwendern drfen auerdem die Vertriebskosten fr das Produkt abdeckende Entgelte
in Rechnung gestellt werden. Die Erhebung von Entgelten fr das Produkt selbst ist
ohne separate und ausdrckliche Erlaubnis verboten.
.br
:note text='Hinweis:'. Achten Sie darauf, das :hp2.vollstndige:ehp2. Paket zu vertreiben (gewhnlich ein
ZIP-Archiv mit Namen und Versionsnummer).
:li.Die Herstellung und getrennte Verffentlichung von Modulen, Applikationen und Daten
fr dieses Produkt ist unter der Bedingung erlaubt, da dadurch nicht andere Teile
dieser Lizenz und damit verbundener Urheberrechte verletzt werden. Diese Lizenz
betrifft nur die :hp2.Herstellung:ehp2. von Applikationen und Daten, solche Module, Applikationen
und Daten selbst unterliegen jedoch nicht dieser Lizenz und es wird keine Haftung
fr deren ordnungsgemes Funktionieren oder Inhalt bernommen.
:li.Wenn Sie zustzliche vom Autor hergestellt Module installieren, unterliegen auch diese
Module dieser Lizenz.
:eol.
:p.:hp2.Haftungsumfang:ehp2.
:ul.
:li.Der Autor haftet nicht fr die Eignung des Produkts oder Schden, die unmittelbar oder
mittelbar durch die Nutzung des Produktes entstehen. Dieses Produkt wird ausschlielich
"wie besehen" lizensiert. Diese Einschrnkung gilt nicht in Lndern, wo sie mit den
gesetzlichen Verbraucherrechten nicht in Einklang steht.
:li.Der Autor bernimmt keine Verantwortung und Haftung fr mit diesem Produkt hergestellte
Informationen und Dokumente.
:li.Der Autor bernimmt keine Verantwortung oder Haftung fr Module, Applikationen oder
Daten, die fr die Verwendung mit diesem Produkt hergestellt wurden, auer den
Modulen, Applikationen und Daten, die von ihm selbst hergestellt wurden.
:eul.
:p.:hp2.Support:ehp2.
:ul.
:li.Der Autor bietet derzeit Support ber das Internet. Zum Zeitpunkt der Erstellung dieses
Dokuments (Februar 2000) wird Support ber http&colon.//tech.groups.yahoo.com/group/maulpub/ geleistet.
:li.Der Autor behlt sich das Recht vor, technischen Support jederzeit und ohne Angabe von
Grnden zu verweigern.
:eul.
:p.---- Ende der Lizenzvereinbarung ----
.br
.br
.******************************************************************************
.*  Developer Information / Informationen fr Entwickler
.******************************************************************************
:h1 res=19 id=19 global.Informationen fr Entwickler
:i1 id=develop.Informationen fr Entwickler
:p.:hp2.Maul Publisher:ehp2. wurde von Grunde auf darauf ausgelegt, modular,
offen und standardisiert zu sein.
:p.Fr Entwickler bedeutet das, da, wenn sie neue, zustzliche Handler fr
Maul :hp2.erstellen und verkaufen:ehp2. mchten, sie mehr als willkommen sind,
dies zu tun.
:p.Mit zunehmender Verbreitung des Programms steigt auch der Bedarf an
Entwicklung durch Dritte und die Mglichkeit, damit Geld zu verdienen.
:p.OS/2 Warp bentigt Werkzeuge, um gedruckte Informationen zu erstellen. Indem
Sie einen Handler fr Maul erstellen, verschaffen Sie sich einen Vorteil, denn
die Ausgaben Ihrer Verarbeitung werden zusammen mit allen anderen verfgbaren
Ausgaben wie Text oder Grafiken kombiniert - dies alles gleichzeitig unter
einer konsistenten Oberflche und auf einer einzigen gedruckten Seite.
:p.Der bliche Arbeitsaufwand fr das Entwickeln einer Applikation ist im Fall
eines MAUL-Handlers viel geringer, da ein groer Teil bereits durch MAULs
eigenes API bernommen wird. Ein Vektorgrafikprogramm beispielsweise ist
hierdurch bereits zur Hlfte fertig, noch bevor Sie die erste Zeile codiert
haben. Das API stellt alle bentigten Werkzeuge zur Verfgung fr
Stilvorlagen, Cliparts, Texterstellung, Seitenanpassung, Bitmaps und Ausdruck.
Wenn Sie bereits eine separate Anwendung erstellt haben, knnen Sie deren
Mehrwert nachhaltig steigern, indem Sie dem Anwender ermglichen, die Ausgaben
des Programms in Maul einzubinden. Sei es Tabellenkalkulation oder Datenbank,
Grafikprogramm oder Textverarbeitung&colon. Alle Anwendungen knnen ihren
Nutzen daraus schpfen, mit Maul Publisher zusammenzuarbeiten. Maul
Publisher ist momentan das ultimative DTP-Werkzeug fr OS/2 Warp und wird
in Zukunft auch fr andere Betriebssysteme erhltlich sein.
:p.Um alle bentigten Informationen zu erhalten, die fr die Entwicklung eines
eigenen Handlers ntig sind, brauchen Sie nichts weiter zu tun, als mit Ihrem
Web-Browser die folgende Seite aufzurufen:
.br
:link reftype='launch' object='netscape.exe' data='http://www.manglais.com/subs/signup.html'.
http&colon.//www.manglais.com/subs/signup.html:elink.
.br
Entwickler knnen dort auch Ihren Namen und Ihre E-Mail-Adresse hinterlassen,
um stndig ber alle Neuerung auf dem Laufenden zu bleiben. Diese Angaben
werden selbstverstndlich vertraulich behandelt und in keinem Fall an Dritte
weitergegeben.
.br
.br
.******************************************************************************
.*  Command line options / Befehlszeilenparameter
.******************************************************************************
:h1 res=4 id=4 global.Befehlszeilenparameter
:i1 id=cmmd.Befehlszeilenparameter
:p.Die folgenden Optionen stehen sowohl ber die Befehlszeile zur Verfgung
als auch im Eintrag 'Optionale Parameter' im Eigenschaftendialog des 'Maul
Publisher' Objekts.
:dl tsize=30.
:dt./d:dd.Startet das Programm in einem Fenster normaler Gre. Die
Standardeinstellung startet Maul im Vollbildmodus.
:dt./h<path>:dd.Gibt den Pfad an, der zur Erzeugung der
Handler-Steuerungsliste verwendet wird. Dieser Parameter ist reserviert und
sollte nicht verwendet werden.
:dt./ignas:dd.Verhindert die gesonderte Verarbeitung von Alt+Umschalt
Tastenkombinationen fr Tastenkrzel. Dieser Parameter ist reserviert und
sollte nicht verwendet werden.
:dt./nopdc:dd.Verhindert das ffnen eines Drucker-Gertekontext beim
Programmstart. Diese Option kann auf einigen Systemen erforderlich sein.
Beachten Sie hierzu 'Drucken im Netzwerk' in :link reftype=hd
res=16.Bekannte Fehler und Probleme:elink..
:edl.
:p.Momentan stehen keine weiteren Befehlszeilenparameter zur Verfgung -
abgesehen vom Dateinamen des zu bearbeitenden Dokuments.
.br
.br
.******************************************************************************
.*  Known problems and bugs / Bekannte Fehler und Probleme
.******************************************************************************
:h1 res=16 id=16 global.Bekannte Fehler und Probleme
:i1 id=problem.Bekannte Fehler und Probleme
:p.:hp2.Geschwindigkeit und Installationsempfehlung:ehp2.
:p.Maul arbeitet im hohen Ma mit Fliekommaberechnungen. Aus diesem Grund ist
die Mindestanforderung fr ein problemloses Arbeiten ein Prozessor der
Pentium-Klasse oder hher. Man sollte sich jedoch nicht alleine darauf verlassen, denn
Maul bentigt ebenso eine gute Grafikkarte bzw. einen guten Drucker.
Hinsichtlich der Grafikkarte rate ich dringend zu Matrox-Modellen. Maul wurde
unter Verwendung einer MGA Millenium II entwickelt. Gute Druckergebnisse
erreicht man bereits mit gngigen Tintenstrahldruckern, doch fr wirklich
professionelle Qualitt empfehle ich, sich an eine Druckerei zu wenden.
Verwenden Sie dazu einen PostScript-fhigen Druckertreiber und leiten Sie die
Druckausgabe durch entsprechende Einstellung (Jobmerkmale des Druckers oder im
Druckdialog) in eine Datei um. Diese PostScript-Datei kann dann von nahezu
jeder Druckerei problemlos verwendet werden. Hier wre brigens auch eine gute
Gelegenheit fr jemanden, einen Import/Export-Handler fr EPS zu erstellen!
:p.Was die Speichergre angeht, scheint Maul schon mit 32MB gut zu arbeiten;
ich habe nicht getestet, wie es bei weniger Speicher aussieht. Wenn Ihnen Ihre
Augen lieb sind, besorgen Sie sich den grten und besten Monitor, den Sie
sich leisten knnen. Maul sollte in einer Auflsung von mindestens 1024 x 768
betrieben werden - bei niedrigeren Auflsungen riskieren Sie, da bestimmte
Statusinformationen untergehen.
:p.:hp2.Multimedia:ehp2.
:p.Der Import-Handler fr PhotoCd verwendet Multimedia-Codecs, um das
PhotoCD-Bitmap-Format zu importieren. Das Programm bentigt daher zumindest die
Basis-Multimediauntersttzung, ansonsten kann es (systembedingt) nicht
verwendet werden. Die Multimediauntersttzung kann brigens unabhngig
davon installiert werden, ob eine Soundkarte eingebaut ist - also selbst dann, wenn
Sie Multimedia zu keinem anderen Zweck als fr Maul verwenden.
:p.Wenn Sie das Programm aber unbedingt ohne Multimedia verwenden wollen,
knnen Sie dies durch Entfernen des PhotoCD-Import-Handlers erreichen. Starten
Sie hierzu im Programmverzeichnis vom Maul das Skript 'REM_PCD.cmd'.
:p.Das gleiche lt sich auch manuell bewirken, indem man im Unterverzeichnis
\bin des Programmverzeichnisses die Datei 'MAUL_DLL.LST' mit einem Editor (bspw.
dem Systemeditor 'E') ffnet und die Zeile lscht, die den Eintrag
pcdhand.dll enthlt. Danach knnen Sie das Programm verwenden, allerdings
werden Sie keine Bilder im PhotoCD-Format benutzen knnen.
:p.:hp2.Schriftarten (Fonts):ehp2.
:p.Maul beherrscht eine Vielzahl von Schrifteffekten. Bei bestimmten
Schrifttreibern kann das zu Problemen fhren. Sollten Sie ihn bisher nicht
verwenden, dann kann die neueste Version des Schrifttreibers FreeType
(http&colon.//www.freetype.org) hier fr Abhilfe sorgen. Sollten Sie Probleme
mit Schriftarten bekommen, zgern Sie bitte nicht, diese mitzuteilen (weitere
Informationen am Ende dieser Seite).
:p.Eine weitere Fehlerquelle scheinen oft auch die Schriftarten selbst zu
sein. Nicht alle Schriftarten vertragen es gleichermaen gut, fr bestimmte
Effekte wie Sperrung/Stauchen oder Scherung (Schrgstellen) eingesetzt zu
werden. Insbesondere wird die Schriftart 'Wingdings' aus Windows 3.1 nicht
korrekt ausgegeben, wenn sie um 180 Grad gedreht (also 'kopfber') verwendet
wird.
:p.Wenige bis gar keine Probleme hat man allem Anschein nach mit Adobe Type 1
Schriftarten. Zum Zeitpunkt der Drucklegung stand/steht eine groe Zahl dieser
Schriften ber die Hobbes OS/2 CD zur Verfgung&colon.
:hp4.ftp&colon.//ftp.cdrom.com/os2/fonts/:ehp4.
:p.:hp2.Ausrichtung:ehp2.
:p.Verwenden Sie eine Schriftart "Times Roman" (speziell mit der Gre 8pt oder
kleiner)? Wenn Sie feststellen, da die Ausgabe am Bildschirm zwar korrekt
ist, jedoch nicht auf den Ausdrucken, sollten Sie es mit einer anderen
Schriftart versuchen. Scheinbar liegt hier ein Fehler im
Schriftauswahl-Mechanismus des Systems vor&colon. Anstelle einer vollstndigen
Weitergabe aller FontMetrics-Strukturen an den Auswahlmechanismus wird dieser
dadurch 'berrumpelt', da unterschiedliche Bildschirm- und Druckerschriften
denselben Namen tragen. Das fhrt bei der Schriftart Times Roman MT30 zu
Problemen, die als Bestandteil von Java und Netscape ausgeliefert wurde. Die
Konturschrift fr Druck ist hierbei nicht identisch mit der Konturschrift, die
am Bildschirm verwendet wird.
:p.:hp2.Drucken im Netzwerk:ehp2.
:p.Hier liegt zwar kein wirklicher Fehler von Maul vor, sondern vielmehr nur
ein rgerlicher Umstand, der aber somit Beachtung verdient. Wenn man einen
aktualisierten Treiber auf einer Netzwerk-Arbeitsstation installiert (bei mir
ist es der OMNI-Treiber), jedoch nicht auf dem Server, scheint zunchst zwar
alles zu funktionieren, jedoch startet Maul nicht. In der Tat kann so ziemlich
alles, was die Liste der Druckwarteschlangen durcheinander bringt, zu diesem
Problem fhren. Andere Programme werden unter diesen Umstnden auch Probleme
beim Drucken melden.
:p.Der einizge mir bekannte Weg zur Lsung des Problems besteht darin, sowohl
auf dem Server als auch auf allen Arbeitsstationen smtliche Druckerobjekte
auf den IBMNULL-Treiber umzustellen, das Netzwerk neu zu starten und dann alle
betroffenen Druckertreiber zu lschen. Nach einem Neustart installiert man
nun die :hp2.gleichen:ehp2. Treiber nochmals auf allen Rechnern. Neustart. Nun
legt man das Netzwerkdruckerobjekt im Druckerordner neu an, indem man mittels
Ziehen-und-Ablegen des entsprechenden Objekts aus dem
Netzwerk-Ressourcen-Browser eine Referenz erstellt. Scheinbar mu man das
gesamte Netzwerk insgesamt dreimal neu starten und ich halte das fr eine
sehr frustrierende Prozedur. Falls Ihnen eine schnellere Methode zur Lsung
dieses Problems bekannt ist, teilen Sie sie mir bitte mit.
:p.Wenn Sie nicht an ein Netzwerk angeschlossen sind, gehen Sie ebenfalls
wie oben beschrieben vor, aber ignorieren einfach alle Schritte, die sich auf
den Server beziehen.
:p.Der eigentliche Grund, warum Maul nicht startet, ist schlichtweg, da Maul
einen Druckerkontext ffnet und danach nicht mehr in der Lage ist, seine
Laufzeitbibliothek zu finden (Fehler in "LoadHandlerList")...
:p.:hp2.Positionierung:ehp2.
:p.Wenn Sie ein Layout fr einen bestimmten Drucker angelegt haben und dieses
dann auf einem anderen Drucker ausgeben, werden Sie wahrscheinlich
Abweichungen in der Positionierung feststellen. Maul pat die Seiten zwar zu
einem gewissen Grad an abweichende Seitengren an, nimmt jedoch keine
nderung am proportionalen Verhltnis des Druckbereichs selbst vor.
:p.:hp2.Fehlerprotokoll:ehp2.
:p.Maul protokolliert alle Fehler in einer Datei, die sich im
Installationsverzeichnis befindet. Sofern Sie bei der Installation keine
nderung der Vorgaben vorgenommen haben, wre es also die Datei
'c&colon.\maul\error.log'.
:p.:hp2.Dateiintegrittsprfung:ehp2.
:p.Whrend Sie mit Maul Publisher arbeiten, prft dieser die Integritt der
Dokumentdatei. Wenn dabei ein Fehler gefunden wird, knnen Sie Ihre aktuellen
nderungen im Idealfall dadurch retten, da Sie die Datei unter einem anderen
Namen speichern. Wenn diese neue Datei nun ohne Fehler geffnet werden kann,
konnten Sie das Problem umgehen. Ein anderer Trick ist das Rckgngigmachen
der letzten Aktion: Da dies auf Dateiebene geschieht, knnte es ebenfalls zur
Wiederherstellung einer konsistenten Dokumentdatei fhren.
:p.:hp2.Speicherauszug bei Programmabsturz:ehp2.
:p.Wenn Sie eine Aktion durchfhren und Maul dabei aufgrund einer
Speicherzugriffsverletzung abstrzt, findet eine Integrittsprfung der 
Dokumentdatei statt.
:p.Sofern dabei keine Fehler gefunden wurden, wird im Programmverzeichnis von
Maul eine Datei mit dem Namen 'dump.mpb' angelegt. Sofern Sie bei der
Installation keine nderung der Vorgaben vorgenommen haben, wre es also die Datei
'c&colon.\maul\dump.mpb'. Diese Datei sollte eine 'reparierte' Kopie dessen
enthalten, was sich zum Zeitpunkt des Absturz in Ihrem Dokument befand. (Auer,
da in der Datei 'error.log' Fehler zu Seiten, Rahmen oder Objekten enthalten
sind: Dies bedeuten im Gegenzug, da die Datei nicht repariert werden konnte.)
Wenn Sie die Datei wieder ffnen wollen, mssen Sie im 'ffnen'-Dialog
zunchst den vorgegebenen Dateityp auf '<Alle Dateien>' ndern, da die Datei
ansonsten nicht in die Auswahlliste bernommen wird.
:p.Nach Abschlu der Integrittsprfung versucht Maul, den Absturz in eine
kontrollierte Beendigung zu fhren. Nachdem die Verbindung zu den DLLs
abgebaut und der verwendete Speicher freigegeben wurde, wird die
Fehlersituation an die Standard-Fehlerbehandlung weitergegeben. Diese
OS/2-Systemroutine meldet dann die bliche SYS3175-Meldung und speichert den
Systemzustand in einer Datei namens 'popuplog.os2', die sich im
Wurzelverzeichnis des OS/2-Systemlaufwerks befindet. Die in dieser Datei
enthaltenen Informationen - zusammen mit denen aus 'error.log' - werden
bentigt, wenn Sie mit der technischen Untersttzung Kontakt aufnehmen.
:p.Der Systemspeicherauszug in 'populog.os2' ist in diesem Fall enorm wichtig,
da dessen Inhalt mit einer Speicherbelegungskarte verglichen werden kann, mit
der sich die Fehlerursache relativ eng einkreisen lsst.
:p.:hp2.Fehler melden:ehp2.
:p.Eine Liste der bekannten Fehler sowie der mglichen Behebungen dazu befindet sich momentan unter
:link reftype='launch' object='netscape.exe' data='http://www.manglais.com/subs/maults.html'.
http&colon.//www.manglais.com/subs/maults.html:elink.. Sollte der bei Ihnen
aufgetretene Fehler darin nicht enthalten sein (und selbst wenn doch), melden
Sie ihn an :link reftype='launch' object='netscape.exe' data='mailto:Maul
Support <maulpub@gmail.com>'.Maul Support <maulpub@gmail.com>:elink.. Im
einzelnen sollte Ihre Fehlermeldung die folgenden Informationen (sofern
zutreffend bzw. mglich) enthalten&colon.
:dl tsize=30.
:dt.Alle Fehler
:dd.
:ul compact.
:li.Die genaue Version von Maul, bei der das Problem auftrat.
:li.Die verwendete Version von OS/2.
:li.Die verwendete Bildschirmauflsung, z.B. 800x600, sowie die verwendete Grafikkarte.
:li.Verwendeter Drucker und Druckertreiber. Um die Version des Druckertreibers
zu ermitteln, ffnen Sie die Eigenschaften des Druckersymbols im Ordner
'Drucker', wechseln zur Registerkarte der Druckertreiber und ffnen Sie die
Eigenschaften des entsprechenden Treibers. Dieselbe Information erhalten Sie
auch, wenn Sie aus einem Programm heraus die Druckereinrichtung starten. Meist
ist die Version bereits in der Titelzeile des Einstellungsdialogs angegeben.
:eul.
:dt.Dateifehler
:dd.
:ul compact.
:li.Alle oben genannten Angaben.
:li.Trat der Fehler whrend einer Dateiintegrittsprfung auf, wird der
entsprechende Eintrag aus der Datei 'error.log' bentigt. Sofern Sie bei der
Installation keine nderung der Vorgaben gemacht haben, finden Sie diese Datei
unter  'c&colon.\maul\error.log'.
:eul.
:dt.Abstrze
:dd.
:ul compact.
:li.Alle oben genannten Angaben.
:li.Der entsprechende Speicherauszugs-Eintrag aus der Datei 'popuplog.os2'.
Sofern Ihr OS/2-Startlaufwerk  'C&colon.' lautet, wre dies die Datei
'c&colon.\popuplog.os2'.
:eul.
:edl.
.br
.br
.******************************************************************************
.*  Hints and Tips / Tips und Tricks
.******************************************************************************
:h1 res=18 id=18 global.Tips und Tricks
:i1 id=hats.Tips und Tricks
:p.:hp2.Mehrere Sitzungen von Maul starten:ehp2.
:p.Es knnen mehrere Sitzungen von Maul gestartet werden. Zum ffnen eines Dokuments in einer
neuen Sitzung verwenden Sie den Dialog 'ffnen' und kreuzen Sie den
Punkt 'Neue Sitzung ffnen' an. Zwischen den einzelnen Sitzungen kann
mit Hilfe der :link reftype=hd res=100.Umschaltliste:elink.
gewechselt werden.
:p.:hp2.Maeinheiten permanent ndern:ehp2.
:p.Sie knnen die Standardvorgabe der Maeinheit fr ein einzelnes Dokument
festlegen, indem Sie im Men 'Seite' den Dialog 'Abmessungen...'
aufrufen und dort eine entsprechende Einstellung vornehmen. Beim Speichern des
Dokuments wird die Einstellung mit gespeichert.
:p.Um die Standardvorgabe fr alle neuen Dokumente zu ndern, speichern Sie
die aktuellen Druckereinstellungen mittels des Dialogs 'Druckereinstellungen
speichern' aus dem Men 'Optionen'. Diese Funktion speichert alle zu Ihrem
Drucker und den Seiteneinstellungen vorhandenen Angaben sowie die
Jobmerkmale des Druckers.
:p.:hp2.Klicken mit der rechten Maustaste:ehp2.
:p.Ein Rechtsklick auf einen Rahmen ruft das aktuelle Bearbeitungsmen auf.
Auf diese Weise kann einem Rahmen auch ein Objekt-Handler hinzugefgt werden.
:p.Whlen Sie eine der Bearbeitungsmodus-Schaltflchen aus und klicken Sie mit
der rechten Maustaste auf einen leeren Rahmen.
:artwork name='rclick.bmp' align=left.
:p.:hp2.Bilder oder Farben im Text:ehp2.
:p.Legen Sie zunchst einen Rahmen mit Text im Vordergrund an, indem Sie den
Text-Handler als Vordergrund-Handler auswhlen und Ihren Text eingeben. Sobald
Sie mit dem Text zufrieden sind, fgen Sie dem Rahmenhintergrund ein Bild oder
eine Farbe hinzu. Schalten Sie dann wieder zurck zum Rahmen-Handler. Whlen Sie
dann im Men 'Bearbeiten->Objektmodi...' den Modus 'Selbstbeschneidendes Objekt'.
:artwork name='wow.bmp' align=left.
:p.:hp2.Rahmenformen bearbeiten:ehp2.
:p.Die meisten Aktionen zum Erstellen eines Rahmens knnen beeinflut werden,
indem dabei die Umschalttaste gedrckt wird. Fr gewhnlich kann damit
sichergestellt werden, da der Rahmen in bestimmter Weise orthogonal
wird/bleibt. Lesen Sie mehr darber in der Hilfe zum Rahmen-Handler.
:p.:hp2.Hintergrund bearbeiten:ehp2.
:p.Gut, versuchen wir's doch 'mal&colon. Im obigen Beispiel fllt das als Hintergrund
eingestellte Bild den Text im Vordergrund.
:p.Beim Lschen des Bildes verschwindet der Text. Er ist zwar noch da, kann aber nicht mehr dargestellt werden!
:p.Wenn Sie nun aber den Text-Handler auswhlen und den Cursor auf den Text
stellen, erscheint er wieder. Das System hat die Selbstbeschneidung temporr
deaktiviert.
:p.Wenn Sie einen Text mit einem eingebetteten Bild bearbeiten, verschwindet
das Bild und der Text wird schwarz dargestellt. Das geschieht nur zu einer
einfacheren Bearbeitung des Text und vermeidet die unlsbare Aufgabe,
unsichtbaren Text zu bearbeiten. Auf die Druckausgabe hat dies keinen Einflu.
:p.:hp2.Layoutraster:ehp2.
:p.Verwenden Sie Raster im Seitenlayout. Es ist der beste Weg, um Objekte
przise auszurichten. Versuchen Sie bereits im Vorfeld festzustellen, welches
Layout Sie bentigen und ob Sie Rinnen (leere Streifen) zwischen den
Spalten bentigen. Fr gewhnlich ist es eine gute Idee, wenn Ihr Layoutraster
mindestens doppelt so viele Spalten hat, wie Sie eigentlich bentigen. Das
Rasterlayout knnen Sie brigens auf Seitenbasis einstellen - Sie mssen also
nicht auf allen Seiten eines Dokuments mit demselben Rasterlayout arbeiten.
Die Standardeinstellung ermglicht Ihnen eine Ausrichtung an jedem Teil des
Layoutrasters.
:artwork name='layout.bmp' align=left.
:p.:hp2.Register erstellen:ehp2.
:p.Ein Register lt sich fr ein Dokument erstellen, indem man
eine Registererstellungsdatei in einen leeren Textrahmen
importiert. Um mehr ber die Registererstellungsdateien zu erfahren, beachten Sie bitte die
Hilfe zu 'Register erstellen'.
:p.:hp2.Textrahmen mit Umrandungen:ehp2.
:p.Legen Sie zunchst den Rahmen an. Dann fgen Sie entweder den Text aus der
Zwischenablage ein oder geben ihn manuell ein.
:p.Wenn Sie dem Text jetzt eine Umrandung vergeben, werden Sie im Normalfall
feststellen, da Umrandung und Text sich unmittelbar berhren. Dies liegt in
den meisten Fllen daran, da die Abstnde fr den linken und rechten Rand auf
NULL gesetzt sind.
:p.Wechseln Sie zum Text-Handler, markieren Sie den gesamten Text durch die
enstprechende Funktion im Men 'Bearbeiten' und ndern Sie dann die Angaben
fr linken und rechten Abstand mit Hilfe des Dialogs 'Absatz' auf einen
gewnschten Wert (bspw. 2mm). Diesen Dialog brauchen Sie brigens erst zu
schlieen, wenn Sie mit dem Ergebnis zufrieden sind. Nahezu alle Dialoge sind
mittlerweile darauf ausgelegt, als eigenstndige Threads zu laufen, so da man
nderungen am Text vornehmen (und erkennen) kann, whrend die Dialoge
angezeigt bleiben.
:p.Wenn andere Rahmen in einen Textrahmen eindringen, fliet der Text um diese
eindringenden Rahmen herum. Um den Abstand des Texts zu diesen eindringenden
Rahmen zu kontrollieren, mssen Sie die Werte fr die 'Grenzauffllung' des
Textes auf denselben Wert setzen, den Sie auch fr die Randabstnde verwendet
haben (im Beispiel 2mm).
:p.Beachten Sie, da diese beiden Einstellungen zwar augenscheinlich hnliche
Auswirkungen haben, in Wirklichkeit jedoch in keinerlei Beziehung zu
einenander stehen und auch unterschiedliche Mechanismen verwenden. Rnder
bewegen den Text innerhalb eines angegebenen Weges, wohingegen die
Grenzauffllung diesen Weg selbst beeinflut. Rnder werden vom Text-Handler
berechnet, Grenzen vom Hauptprogramm.
:p.Alle diese Einstellungen lassen sich sowohl als systemweite Standardvorgabe
als auch auf Basis einer Stilvorlage speichern.
:p.:hp2.Rahmenstze und automatische Textskalierung:ehp2.
:p.Mauls Rahmen-Handler kann Rahmen erstellen, die als ein
katalogisierbarer Satz aus mehreren anderen Rahmen bestehen. Obwohl in dieser
Form noch nicht der Weisheit letzter Schlu in Sachen Objektkatalog, bringen
diese Rahmenstze bereits eine hohen Komfort mit sich. Wenn ein solcher
Rahmensatz Texte oder Umrandungen enthlt, mchten Sie bestimmt, da
eine Skalierung des Rahmensatzes automatisch eine entsprechende Skalierung der
Inhalte bewirkt. Der Rahmen-Handler erreicht dies durch Versenden einer
entsprechenden Nachricht an alle betroffenen Handler.
:p.Zunchst einmal funktioniert das nur bei einer Gruppe von Rahmen und eine
Gruppe mu aus mindestens zwei Rahmen bestehen - selbst, wenn einer davon
unsichtbar ist. Der erste Schritt ist nun das Anlegen einer Gruppe.
:p.Sobald die Gruppe angelegt wurde, knnen Sie den Modus dieser Gruppe im
Men 'Bearbeiten->Objektmodi...' des Rahmen-Handlers mit 'Gruppe automatisch skalieren'
ndern. Wenn Sie nun die Gruppe skalieren, werden die enthaltenen Texte oder
Umrandungen proportional skaliert.
:p.Die angelegte Rahmengruppe sollten Sie dann im Objektkatalog speichern,
damit Sie sie spter auch in anderen Dokumenten verwenden knnen. Die Kataloge
werden im Pfad .\etc des Programmverzeichnisses von Maul gespeichert. Um einen
neuen Katalog anzulegen, legen Sie einen neuen Ordner an und nennen Sie ihn
<ordnername>.cat. Solange der Ordner die Erweiterung '.cat' besitzt, wird er
wie ein Objektkatalog verwendet. Verwenden Sie dann den Eintrag 'Exportieren
-> Rahmenobjekte' im Men 'Datei', um den Rahmensatz im neuen Objektkatalog zu
speichern. Ein Beispielkatalog mit Rahmenstzen ist bereits vorhanden.
:p.:hp2.Drucken im Netzwerk:ehp2.
:p.Maul wurde getestet mit einem Warp 4.5 Server und einem Warp 4 Client.
Stellen Sie sicher, da sowohl auf dem Server als auch der Arbeitsstation
dieselben Schriftarten installiert sind, ansonsten knnten Sie Abweichungen in
den Druckausgaben erhalten.
:p.In der aktuellen Version von Maul knnen Sie die Druckdaten wahlweise auch
als Rohdaten ber das Netzwerk bertragen. In diesem Fall brauchen auf dem
Server zwar keine bestimmten Schriftarten vorhanden zu sein, aber seien Sie
sich bewut, da dieses Verfahren den Druckvorgang erheblich verlangsamt.
:p.:hp2.Endgltige Ausgabe:ehp2.
:p.Wenn Sie Ihr Dokument zu einer Druckerei bringen wollen, werden Sie davon
PostScript-'Abzge' machen mssen. Ein guter Weg, dies zu erreichen, ist, einen
PostScript-Druckertreiber zu installieren und dessen Ausgabe in eine Datei
umzuleiten.
:p.Die so erzeugte Datei sollte von jeder Druckerei gelesen werden knnen. Bei
mehrseitigen Dokumenten knnte es erforderlich sein, fr jede Druckseite eine
einzelne separate Datei zu erstellen.
:p.Auf diese Art knnen Sie bei Dokumenten mit farbigem Inhalt brigens auch 4
einzelne Farbabzge (einer pro CMYK-Druckfarbe) von einer Seite erstellen.
:p.Um kostspielige Fehler zu vermeiden, sollten Sie einige Dinge beachten.
Die folgende Liste soll helfen, die wichtigsten Kriterien zu erfllen.
:ul.
:li.Stellen Sie sicher, da keine dnnen Linien oder kleine Schriftarten (< 8
Punkte) in CMYK-Farben enthalten sind. Da die Druckerei zur Erzeugung der
Farbtne mit Farbseparierung arbeitet, knnte dies in einem unleserlichen
Durcheinander enden.
:li.Bei Dokumenten mit Faltung, Bindung oder Heftung mssen Sie sicherstellen,
da die Seiten in der richtigen Reihenfolge vorliegen.  Wenn Sie Mauls
Faltbroschrenmodus verwenden, geschieht dies bereits (halb-) automatisch. Denken
Sie daran, da die Seiten zwar automatisch korrekt numeriert sind, Sie aber
eventuell die falschen Inhalte darauf speichern!
:li.Stellen Sie sicher, da Ihre Druckerei die bentigten Schriftarten
untersttzt und stellen Sie sich darauf ein, da es bei Texten manchmal
passieren kann, da die Schriftarten nicht Ihren Erwartungen entsprechen.
:li.Bitmaps mssen eine ausreichende Auflsung aufweisen, um sauber gedruckt
werden zu knnen. Beachten Sie, da feine Linien oder Details auch unter der
von der Druckerei eingesetzten Farbseparierung leiden knnten.
:li.Machen Sie einen Testdruck auf Ihrem Drucker und lassen Sie das Resultat
von jemand anderem nochmals prfen - ein unvoreingenommer Betrachter kann
Fehler oft schneller bemerken, als jemand der eine geraume Zeit am selben
Dokument arbeitet.
:li.Wenn Sie automatische Datumsfelder in Ihrem Text verwenden, denken Sie
daran, da diese vor Druck aktualisiert werden und dadurch zu entsprechenden
Verschiebungen im Text fhren knnen. Wenn Sie Ihr Dokument beispielsweise im
Juli erstellt haben und dann im September ausdrucken, wird der gesamte Text
entsprechend verschoben, um die (jetzt) lngeren Datumsfelder aufnehmen zu
knnen.
:li.Es zahlt sich aus, eine gute Beziehung zu einer Druckerei aufzubauen, da
deren Erfahrung und Wissen dabei hilfreich sein kann, kostspielige Fehler zu
vermeiden.
:li.Diese Liste ist noch nicht erschpft - wenn Sie also Erfahrung im Umgang
mit Maul in dieser Hinsicht haben, teilen Sie uns diese unbedingt mit, indem
Sie eine E-Mail an den :link reftype='launch' object='netscape.exe'
data='mailto:Maul Support <maulpub@gmail.com>'.Maul Support
<maulpub@gmail.com>:elink. schreiben. Damit helfen Sie in erster Linie anderen
Anwendern.
:eul.
.br
.br
.******************************************************************************
.*
.*
.*
.*  Window Layout Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  Tool bar buttons / Werkzeugleiste
.******************************************************************************
:h1 res=800 id=800 global.Die Werkzeugleiste
:i1 id=buttonbar.Die Werkzeugleiste
:p.Die Werkzeugleiste ist der erste Ort, um nach einer bestimmten Funktion
zu suchen. Sie knnen die Werkzeugleiste temporr schlieen, indem Sie auf die
Schaltflche :artwork name='toolsup.bmp' runin. in der rechten oberen Ecke der
Menleiste klicken.
:p.Abgesehen von der Einstellung des aktuellen :link reftype=hd
res=801.Linealmastabs:elink. dient die Werkzeugleiste mit den
vorhandenen Schaltflchen dazu, Aktionen im :link reftype=hd
res=40.Men 'Seite':elink. zu wiederholen und den aktuellen
Bearbeitungsmodus zu ndern. Auerdem werden dort weitere Schaltflchen
aufgenommen, die in Abhngigkeit vom aktuell gewhlten Handler
unterschiedliche Handler-spezifische Funktionen ermglichen.
:p.Der Beabeitungsmodus wird durch drei Schaltflchen gesteuert&colon.
:ul.
:li.:artwork name='frame.bmp' runin. zur Auswahl des Bearbeitungsmodus :link
reftype=hd res=804.Rahmen:elink..
:li.:artwork name='cont.bmp' runin. zur Auswahl des Bearbeitungsmodus :link
reftype=hd res=805.Inhalt:elink.. Die kleine Schaltflche
ffnet ein ausklappbares Men zur Auswahl der Ebene.
:li.:artwork name='bord.bmp' runin. zur Auswahl des Bearbeitungsmodus  :link
reftype=hd res=807.Umrandung:elink.. Die kleine Schaltflche
ffnet ein ausklappbares Men zur Auswahl der Ebene.
:eul.
:p.Jeder Rahmen kann zu einer Inhalts- oder Umrandungsebene einen
Objekt-Handler enthalten. Es gibt vier Inhaltsebenen und vier Umrandungsebenen.
Einige Rahmen - wie beispielsweise der fr Linien - enthalten naturgem keine
Inhaltsebene.
:p.Beachten Sie hierzu auch :link reftype=hd res=72.Objekte zu
einem Rahmen hinzufgen:elink..
.******************************************************************************
:h2 res=801 id=801 global.Linealmastab whlen
:i2 refid=buttonbar.Linealmastab whlen
:p.Klicken Sie auf die Schaltflche Linealmastab :artwork name='ruler.bmp'
runin., um die Skalierung einzustellen, die fr Lineale und einige Dialoge
verwendet wird.
:p.Die drei verfgbaren Modi sind&colon. Metrisch 'm, cm, mm', Britische Inch
'in' und Punkt 'pt'. Diese Grundeinheiten werden dann jeweils auf einen
Multiplikationsfaktor skaliert, der fr die aktuelle Seitenskalierung geeignet
ist.
:p.Zu den Linealen gehrt auch ein kleiner Anzeigebereich, der ber den
gerade verwendeten Skalierungsfaktor informiert. Wenn Sie also die Lineale
beispielsweise auf Inch umstellen, werden Sie in der Linealzeile 'in' sehen
und im besagten Anzeigebereich beispielsweise 'x0.1'. Dies bedeutet, da jede
groe Einteilungseinheit einem Zehntel eines Inch entspricht.
:artwork name='ruler2.bmp' align=left.
.******************************************************************************
:h2 res=50 id=50 global.Manuelles Neuzeichnen erzwingen
:i2 refid=buttonbar.Manuelles Neuzeichnen erzwingen
:p.Es kann vorkommen, da Sie den Bildschirminhalt vielleicht einmal 'aufrumen' mchten.
:p.Das am Bildschirm angezeigte Dokument kann jederzeit durch Freisetzung des
gesamten Anzeigebereichs neu gezeichnet werden. Die Schaltflche :artwork
name='paint.bmp' runin. zeichnet den Bildschirminhalt neu.
:p.Das Neuzeichnen hat keinen Einflu auf den textlichen Inhalt oder das Dokument an sich.
.******************************************************************************
:h2 res=804 id=804 global.Umschalten in den Rahmenbearbeitungsmodus
:i2 refid=buttonbar.Umschalten in den Rahmenbearbeitungsmodus
:p.Klicken Sie auf die Schaltflche :artwork name='frame.bmp' runin., um in den
Modus Rahmenbearbeitung zu wechseln. Dies ist auch der Standardmodus, den Maul
beim Start verwendet.
.******************************************************************************
:h2 res=805 id=805 global.Rahmeninhalte bearbeiten
:i2 refid=buttonbar.Rahmeninhalte bearbeiten.
:font facename='System Monospaced' size=20x9.
:p.:hp2.Jeder geschlossene Rahmen ist in der Lage, Objekte in vier
Inhaltsebenen zu zeichnen. Um Inhaltsobjekte zu bearbeiten oder hinzuzufgen,
verwenden Sie die Schaltflchen zur Inhaltsauswahl.:ehp2.
:font facename=Helv size=0x0.
:p.:hp2.Definitionen:ehp2.
:p.Geschlossener Rahmen&colon. Dies bezeichnet einen Rahmen mit einem Innenraum -
wie z.B. ein Rechteck - im Vergleich zu einem offenen Rahmen wie
beispielsweise einer Linie. Rahmen werden vom Rahmen-Handler verwaltet.
:p.Objekt&colon. Das ist etwas, das gedruckt wird. Dabei kann es sich um Text,
Bilder oder eine simple Farbflche handeln. Objekte werden von einen Objekt-Handler
verwaltet (z.B. der Text-Handler fr Texte).
:p.Inhalte&colon. Jedes Objekt, das innerhalb eines Rahmens dargestellt wird.
Verwenden Sie den Eintrag 'Module auflisten' im Men 'Hilfe', um alle
verfgbaren Objekt-Handler fr Inhalte zu sehen.
:p.Ebenen&colon. Objekte knnen in eine von vier Ebenen gestellt werden. Ebene 0 ist
die hchste, Ebene 3 die unterste. Zur Darstellung werden die Ebenen in
umgekehrter Reihenfolge verarbeitet (von unten nach oben). Der Rahmen-Handler
ist dafr zustndig, die Darstellungsreihenfolge der Ebenen zu steuern.
:p.:hp2.Auswahlschaltflchen fr Inhalte:ehp2.
:p.Die Steuerung der Inhalte erfolgt ber die beiden Schaltflchen :artwork
name='cont.bmp' runin. der Werkzeugleiste. Die grere von beiden wird
verwendet, um schnell zwischen Inhaltsebenen zu wechseln. Die kleinere von
beiden stellt ein Ausklappmen zur direkten Anwahl einer Ebene zur Verfgung.
:p.Jeder Klick auf die grere Schaltflche schaltet zur nchsten Ebene um.
Dies ist eine Methode, um zu einer bestimmten Ebene zu gelangen - eine andere
Methode ist, die Schaltflchen im Ausklappmen zu verwenden, um direkt zu
einer bestimmten Ebene oder einem Objekt zu wechseln.
:p.Die Symbole auf den Schaltflchen wechseln in Abhngigkeit vom zugewiesenen
Objekt-Handler. Der Inhalt der Hilfeanzeige wechselt ebenfalls, um die
Bedeutung der jeweiligen Schaltflche anzuzeigen.
:p.Wenn kein Rahmen ausgewhlt ist, zeigen alle Schaltflchen das
Standardsymbol '?' an. Sobald ein Rahmen ausgewhlt ist, wird mit einem Klick
auf das Symbol '?' eine Liste der Objekte eingeblendet, die der Ebene
hinzugefgt werden knnen.
:p.Ebenen werden vom Rahmen-Handler erzeugt und vom entsprechenden Objekt-Handler gelscht.
:p.Im Moment des Hinzufgens oder Auswhlens eines Objekts schaltet die
gesamte Anwendung auf Anzeige der Mens und Schaltflchen um, die fr das
Objekt verfgbar sind.
:p.:hp2.Weitere Informationen:ehp2.
:p.:link reftype=hd res=17.Schnelleinstieg:elink.
:p.:link reftype=hd res=72.Objekte zu einem Rahmen hinzufgen:elink.
.******************************************************************************
:h2 res=807 id=807 global.Umrandungen bearbeiten
:i2 refid=buttonbar.Umrandungen bearbeiten
:font facename='System Monospaced' size=20x9.
:p.:hp2.Jeder Rahmen ist in der Lage, Objekte in vier Umrandungsebenen zu
zeichnen. Um Umrandungsobjekte zu bearbeiten oder hinzuzufgen, verwenden Sie
die Schaltflchen zur Umrandungsauswahl.:ehp2. :font facename=Helv size=0x0.
:p.:hp2.Definitionen:ehp2.
:p.Rahmen&colon. Alle Rahmen besitzen die Fhigkeit, Umrandungsobjekte zu
untersttzen. Einige Rahmentypen, wie zum Beispiel fr Linien, untersttzen nur
Umrandungsobjekte. Rahmen werden vom Rahmen-Handler verwaltet.
:p.Objekt&colon. Das ist etwas, das gedruckt wird. Dabei kann es sich um Text,
Bilder oder eine simple Farbflche handeln. Objekte werden von einen Objekt-Handler
verwaltet (z.B. dem Umrandungs-Handler fr Umrandungen).
:p.Umrandung&colon. Jedes Objekt, das entlang eines Rahmens dargestellt wird.
Verwenden Sie den Eintrag 'Module auflisten' im Men 'Hilfe', um alle
verfgbaren Objekt-Handler fr Umrandungen zu sehen.
:p.Ebenen. Objekte knnen in eine von vier Ebenen gestellt werden. Ebene 0 ist
die hchste, Ebene 3 die unterste. Zur Darstellung werden die Ebenen in
umgekehrter Reihenfolge verarbeitet (von unten nach oben). Der Rahmen-Handler
ist dafr zustndig, die Darstellungsreihenfolge der Ebenen zu steuern.
:p.:hp2.Auswahlschaltflchen fr Umrandungen:ehp2.
:p.Die Steuerung der Umrandungen erfolgt ber die beiden Schaltflchen
:artwork name='bord.bmp' runin. der Werkzeugleiste. Die grere von beiden
wird verwendet, um schnell zwischen Umrandungsebenen zu wechseln. Die kleinere
von beiden stellt ein Ausklappmen zur direkten Anwahl einer Ebene zur
Verfgung.
:p.Jeder Klick auf die grere Schaltflche schaltet zur nchsten Ebene um.
Dies ist eine Methode, um zu einer bestimmten Ebene zu gelangen - eine andere
Methode ist, die Schaltflchen im Ausklappmen zu verwenden um direkt zu
einer bestimmten Ebene oder einem Objekt zu wechseln.
:p.Die Symbole auf den Schaltflchen wechseln in Abhngigkeit vom zugewiesenen
Objekt-Handler. Der Inhalt der Hilfeanzeige wechselt ebenfalls, um die
Bedeutung der jeweiligen Schaltflche anzuzeigen.
:p.Wenn kein Rahmen ausgewhlt ist, zeigen alle Schaltflchen das
Standardsymbol '?' an. Sobald ein Rahmen ausgewhlt ist, wird mit einem Klick
auf das Symbol '?' eine Liste der Objekte eingeblendet, die der Ebene
hinzugefgt werden knnen.
:p.Ebenen werden vom Rahmenhandler erzeugt und vom entsprechenden Objekthandler gelscht.
:p.Im Moment des Hinzufgens oder Auswhlens eines Objekts schaltet die
gesamte Anwendung auf Anzeige der Mens und Schaltflchen um, die fr das
Objekt verfgbar sind.
:p.:hp2.Weitere Informationen:ehp2.
:p.:link reftype=hd res=17.Schnelleinstieg:elink.
:p.:link reftype=hd res=72.Objekte zu einem Rahmen hinzufgen:elink.
.******************************************************************************
:h1 res=803 id=803 global.Die Lineale
:i1 id=rule.Die Lineale
:p.Die Lineale ermglichen das direkte Ablesen der exakten Position, an der
sich der Cursor innerhalb der Seite befindet.
:p.Wenn Sie auf eine beliebige Anzeigeart (auer Seitenansicht) umschalten,
werden die Nullpunkte der Lineale auf den aktuellen Seitenrahmen justiert. Bei
der Seitenansicht werden die Nullpunkte der Lineale auf die linke, obere Ecke
der Druckseite eingestellt.
:p.Beim Skalieren ('Zoomen') der Seite wird die Skalierung der Lineale an die
Darstellungsgre angepat.
:p.Zu den Linealen gehrt auch ein kleiner Anzeigebereich, der ber den
gerade verwendeten Skalierungsfaktor informiert. Wenn Sie also die Lineale auf
Inch umstellen, werden Sie in der Linealzeile 'in' sehen und im besagten
Anzeigebereich beispielsweise 'x0.1'. Dies bedeutet, da jede groe
Einteilungseinheit der Lineale einem Zehntel eines Inch entspricht.
:p.Lineale knnen ebenfalls versetzt und skaliert werden. Weitere Einzelheiten siehe unter
:link reftype=hd res=51.Dialog Maeinheiten:elink..
:p.:hp2.Benutzerdefinierte Fangpunkte:ehp2.
:p.Die Lineale untersttzen benutzerdefinierte Fangpunkte fr die
Einrastfunktion. Wenn Sie den Mauszeiger auf die Lineale bewegen, ndert sich
dessen Anzeige in einen speziellen Fangpunkt-Cursor. Sie knnen eine Fanglinie
definieren, indem Sie einen Fangpunkt auf dem Lineal einrichten. Dies
geschieht durch Klicken auf einen sichtbaren Einteilungspunkt des Lineals.
Fanglinie und zugehriger Fangpunkt werden durch erneutes Anklicken auf dem
Lineal gelscht. Wenn Sie in das Dokument hineinzoomen, wird die Unterteilung
auf den Linealen feiner und Sie knnen die Fangpunkte noch prziser setzen.
Trotzdem bleibt ein Fangpunkt, der unter einem bestimmten Skalierungsfaktor gesetzt
wurde, auch in anderen Skalierungsfaktoren przise an derselben Stelle gesetzt.
:p.Durch einen Klick mit der rechten Maustaste auf die Lineale erhalten Sie
einen Dialog, mit dem Sie direkt die bentigten Fangpunkte angeben knnen. Die
in diesem Dialog untersttzten Maeinheiten sind mm, cm, m, in (inch), din
(1/10 inch), pt (Punkt) und dpt (1/10 Punkt). Ein Inch entspricht 25,4 mm und
72,2818 Punkten. In diesem Fall entspricht das Inch dem Britischen Inch. Wenn
Sie eine Eingabe ohne Maeinheit machen, wird diese als Angabe in Drucker-pels
angesehen.
:p.Verwenden Sie diese Fangpunkte, um Rahmen auszurichten. Zu jedem Fangpunkt
wird eine entsprechende Linie im Dokument angezeigt.
:p.Weitere Informationen&colon.
:p.:link reftype=hd res=92.Einrasten...:elink.
.br
.br
.******************************************************************************
:h1 res=802 id=802 global.Die Statuszeile
:i1 id=statbar.Die Statuszeile
:p.Die Statuszeile erstreckt sich ber den gesamten unteren Bildschirmrand und
wird von einer Vielzahl von Handlern verwendet, um dort entsprechende
Statusinformationen einzublenden.
:p.Der erste Eintrag - ganz links - in der Statuszeile stammt grundstzlich
von der Hilfefunktion. Hier werden Hilfeinformationen zu dem Objekt
eingeblendet, ber dem sich der Mauszeiger gerade befindet. Wenn Sie den
Mauszeiger ber eine Schaltflche bewegen, wird deren Funktion in der
Hilfeanzeige dargestellt. Das gleiche ist der Fall, wenn Sie den Mauszeiger
ber ein Lineal oder ein anderes Statusfenster bewegen.
:p.Der nchste Eintrag zeigt die Nummer der aktuellen Druckseite sowie die
Gesamtanzahl der Druckseiten an.
:p.Der dritte Eintrag stellt die aktuelle Seitennummer und die Anzahl der
Seiten pro Druckseite dar. (Eine Druckseite entspricht einer Seite eines
Papierblatts.)
Dementsprechend steht '1 (1/s)' fr Seite 1 bei einer Dokumentseite pro
Druckseite (= 1 Dokumentseite pro Seite eines Blatt Papier).
:p.Alle Eintrge ab dem dritten sind reserviert fr Statusinformationen des
jeweils gerade aktiven Handlers. Standardmig identifiziert sich der Handler
durch eine entsprechende Kennung in seinem ersten Statuseintrag.
.br
.br
.******************************************************************************
.*
.*
.*
.*  Menu Item Help / Hilfe zu Meneintrgen
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  File Menu / Men 'Datei'
.******************************************************************************
:h1 res=20 id=20 global.Men 'Datei'
:i1 id=file.Men 'Datei'
:p.Dieses Men dient dazu,
:sl.
:li.ein :link reftype=hd res=21.neues Dokument:elink. zu erstellen.
:li.ein bestehendes Dokument zu :link reftype=hd res=22.ffnen:elink..
:li.ein krzlich bearbeitetes Dokument zu :link reftype=hd res=23.ffnen:elink..
:li.:link reftype=hd res=31.Projekte:elink. zu verwalten.
:li.Daten in das aktuelle Dokument zu :link reftype=hd res=24.importieren:elink..
:li.Daten aus dem aktuellen Dokument zu :link reftype=hd res=25.exportieren:elink..
:li.ein ':link reftype=hd res=32.Bild einzulesen:elink.' mit TWAIN-Gerten wie Scannern.
:li.ein Dokument zu :link reftype=hd res=26.speichern:elink..
:li.das aktuelle Dokument zu :link reftype=hd res=27.sichern als:elink. ein neues Dokument.
:li.die :link reftype=hd res=30.automatische Sicherung:elink. zu aktivieren.
:li.ein Dokument zu :link reftype=hd res=28.drucken:elink..
:esl.
.******************************************************************************
:h2 res=21 id=21 global.Erstellen eines neuen Dokuments
:i2 refid=file.Erstellen eines neuen Dokuments
:p.Ist bereits ein Dokument geffnet, wird zunchst gefragt,
ob dieses gespeichert werden soll. Mittels 'Abbrechen' knnen Sie das Erstellen
eines neuen Dokuments zu diesem Zeitpunkt abbrechen. Falls Sie mit 'Nein'
antworten wollen, bedenken Sie, da Sie Ihre Meinung danach nicht mehr ndern
knnen.
:p.Falls Sie 'Ja' whlen, erscheint der Dialog zur Speicherung des Dokuments.
Wenn Sie den 'Speichern'-Dialog an dieser Stelle abbrechen, bricht auch die
Speicherung ab und Sie verlieren Ihr Dokument.
:p.:hp2.Der Dialog 'Neues Dokument':ehp2.
:p.Maul Publisher stellt einen Dialog zur Erstellung eines neuen Dokuments zur
Verfgung. In diesem Dialog knnen Sie Stil und Gre des neuen Dokuments
angeben. Desweiteren knnen Sie die Anzahl der zu erstellenden Druckseiten
sowie die Seitennummer fr die erste Seite angeben.
:p.Eine Druckseite kann mehr als eine 'Dokumentseite' enthalten, Sie knnen
jedoch nicht weniger als eine Druckseite erstellen bzw. drucken.
:p.:hp2.Bundstegausrichtung der ersten Seite whlen:ehp2.
:p.Wenn Sie auf ein geschlossenes Buch schauen, ist die erste Seite die
Titelseite und sie befindet sich rechts vom Bundsteg (der 'geleimten Kante').
Wenn Ihr Dokument mit einer solchen Seite beginnt (oder einer anderen Seite,
die sich rechts vom Bundsteg befindet), whlen Sie den Standard
'Rechts/Auenseite'.
:p.Manchmal beginnen Dokumente aber auch mit einer Innenseite, oder, um es am
Beispiel des Buchs zu verdeutlichen, mit einer linken Seite (die sich beim
aufgeschlagenen Buch links vom Bundsteg befindet). In diesem Fall whlen Sie
die Einstellung 'Links/Innen'.
:p.:hp2.Seitenvorlagen:ehp2.
:p.Wenn Sie bereits Seitenvorlagen erstellt haben, knnen Sie diese verwenden,
um Gre, Form und anfngliche Inhalte Ihres Dokuments festzulegen. Mehr
darber, wie Sie Seitenvorlagen erstellen knnen, finden Sie im Abschnitt :link
reftype=hd res=43.Seitenvorlagen:elink..
:p.Sie knnen wechselnde Seitenvorlagen anwenden, so da unterschiedliche
Seitenvorlagen fr die gegenberliegenden Druckseiten verwendet werden.
Stellen Sie jedoch sicher, da die Seitenvorlagen zueinander passen. Ist dies
nicht der Fall, werden Sie darauf hingewiesen, da die Seitenvorlagen nicht
zueinander passen. Sie knnen dann aber dennoch unter Verwendung der
abweichenden Seitenvorlagen fortfahren.
:p.Wenn Sie keine Seitenvorlagen verwenden mchten, wird die angegebene Folge
von leeren Seiten unter Verwendung der Standardvorgaben erstellt.
.******************************************************************************
:h2 res=22 id=22 global.Ein Dokument ffnen
:i2 refid=file.Ein Dokument ffnen
:p.Wenn Sie bereits ein Dokument geffnet haben, werden Sie zunchst zur
Speicherung des aktuellen Dokuments aufgefordert. Geben Sie eine Datei zur
Speicherung an oder whlen Sie 'Abbrechen'. Erst dann wird der Dialog zum
ffnen eines Dokuments erscheinen.
:p.Whlen Sie ein Laufwerk oder Verzeichnis mittels Doppelklick aus.
:p.Ein einfacher Klick auf einen Dateinamen whlt die Datei zunchst nur aus,
ein Doppelklick ldt die entsprechende Datei sofort und schliet den Dialog
zum ffnen eines Dokuments. Maul fhrt eine Liste der vier jeweils zuletzt
geffneten Dateien, die beim ffnen eines Dokuments entsprechend aktualisiert
wird.
:p.Wenn Sie vor dem ffnen des Dokuments die Option 'In neuer Sitzung ffnen'
ausgewhlt haben, wird das Dokument nicht im aktuellen Fenster geffnet -
stattdessen wird eine neue Instanz (Kopie) des Programms gestartet, welche
dann das gewhlte Dokument ldt. Beachten Sie hierzu auch die Hilfethemen zur
:link reftype=hd res=100.Umschaltliste:elink..
:p.Diese Funktion ist auch in der Werkzeugleiste verfgbar. Klicken Sie
einfach auf die Schaltflche :artwork name='open.bmp' runin.
.******************************************************************************
:h2 res=23 id=23 global.Schnelles ffnen
:i2 refid=file.Schnelles ffnen
:p.Maul fhrt eine Liste der vier jeweils zuletzt geffneten Dateien. Diese
ist direkt innerhalb des Mens 'Datei' enthalten. Ein Klick auf den
entsprechenden Eintrag ldt die jeweilige Datei unter Umgehung des Dialogs zum
ffnen der Datei und ist somit um einiges schneller.
.******************************************************************************
:h2 res=31 id=31 global.Projekte verwalten
:i2 refid=file.Projekte verwalten
:p.Projektdateien wurden zur Vereinfachung der Verwaltung mehrerer Dateien als ein Projekt eingefhrt.
:p.Projekte sind sehr ntzlich fr die Erstellung von Dokumenten, die aus vielen Dateien bestehen.
Ein Projekt setzt sich aus einer Projektdatei, gewhnlich "irgendetwas.prj", sowie einem damit verbundenen
Ordner "irgendetwas" zusammen. Die Projektdatei enthlt dabei nur eine Liste der einzelnen Dateien des Projekts.
Sie kann auch Dateien enthalten, die sich auerhalb des Projektordners befinden. Weil es uerst unklug wre,
in einer Projektdatei aufgefhrte Projektdateien automatisch zu lschen, bietet Maul Publisher selbst keine Mglichkeit
zum Lschen von Projektdateien. Die Projektdatei kann jedoch ohne Schwierigkeiten von Hand gelscht werden, ohne
da die Dokumente im Projektordner dadurch beschdigt wrden.
:p.Das Projektdateisystem bietet folgende Funktionen&colon.
:ul.
:li.Stil- und Seitenvorlagen knnen standardmig aus dem Projektordner geladen und dorthin gesichert werden. Diese Option
lt sich unter :link reftype=hd res=94.Globale Stileinstellungen:elink. anpassen.
:li.Die Schaltflchen fr die vorherige und nchste Seite springen automatisch zum Anfang oder Ende des vorhergehenden
oder nchsten Dokumentes, wenn eine Projektdatei geladen ist.
:li.Durch Schlieen einer Projektdatei wird auch das aktive Dokument geschlossen, sofern es Teil des Projekts ist.
:li.Ein Untermen fhrt smtliche Teildokumente eine Projekts auf. Durch Auswahl des Dateinamens kann zu einem Teildokument
gesprungen werden.
:li.Zum Bearbeiten der Reihenfolge, in der Teildokumente erscheinen, steht ein Projektdateieditor zur Verfgung. Dieser
Dialog bietet zudem Funktionen zum Einfgen und Entfernen sowie zum ffnen von Teildokumenten im Hauptfenster.
:li.Wird ein Dokument unter einem neuen Namen gesichert, wird es dem aktiven Projekt automatisch hinzugefgt.
:li.Unter der Voraussetzung, da die in den Projektdateien verwendeten Seiten bereinstimmen, kann ein Projekt als ganzes ausgedruckt werden.

:eul.
:p.Was Projekte :hp2.nicht leisten:ehp2. knnen und warum&colon.
:ul.
:li.Es gibt mehrere Grnde, warum ein Projekt eventuell nicht in seiner Gesamtheit ausgedruckt werden kann. Es ist
sicherzustellen, da smtliche Dokumente des Projekts dasselbe Seitenformat und denselben Drucker verwenden. Wenn dies
nicht der Fall ist, wird ein Fehler gemeldet. Bei manueller Herstellung beidseitig bedruckter Seiten wird fr jedes
Dokument eine Aufforderung angezeigt, die Seiten umzudrehen. Achten Sie auf die Startseite und die Seitennummern in
jeder Datei des Projektes oder es kann zu leeren Seiten oder falschen Seitennummern kommen. Beachten Sie, da ein
gewisses Risiko besteht, da die Festplatte des Spoolers die Vielzahl von groen Spool-Dateien nicht aufnehmen kann
und es dadurch zu einem Absturz des Systems kommt. Achten Sie also darauf, da gengend Speicherplatz auf der
Festplatte vorhanden ist.
:li.Es ist nicht mglich, gleichzeitig mehr als ein Dokument in Maul zu ffnen. Dies wrde auerdem dem von Projekten
zuwiderlaufen, nmlich zu vermeiden, da Dokumente geladen werden, die nicht in den verfgbaren Speicher passen.
:eul.
:p.:hp2.Dialog "Neues Projekt":ehp2.
:p.Whlen Sie einen vorhandenen Ordner aus und geben Sie den Namen des Projekts ein. Bei Eingabe des Namens einer
bereits vorhandenen Projektdatei wird der Vorgang abgebrochen.
:p.:hp2.Dialog "Projekt ffnen":ehp2.
:p.Whlen Sie eine zu ffnende Projektdatei aus. Das Projekt wird geffnet und die erste der aufgefhrten Dateien des
Projekts wird geladen. Ist noch eine nicht gesicherte Datei geladen, erfolgt eine Abfrage, ob diese erst
gesichert werden soll.
:p.:hp2.Dialog "Projekt bearbeiten":ehp2.
:p.Alle hier an der Projektdatei vorgenommen nderungen werden durch Drcken von "Sichern" gesichert.
:p.Davon ausgenommen ist die Schaltflche "Einfgen", die eine sofortige Sicherung der genderten Projektdatei zur Folge hat.
:p.:hp2.Projekt schlieen:ehp2.
:p.Das Projekt wird zusammen mit jeder Datei, die Teil des Projekts ist, geschlossen.
:p.:hp2.Dateien zum Projekt hinzufgen:ehp2.
:p.Nach ffnen oder Erstellen eines Projektes kann diesem eine Datei hinzugefgt werden. Eine Datei kann einem
Projekt nicht mehrmals hinzugefgt werden; ist sie bereits Teil des Projekts, wird der Meneintrag deaktiviert.
.br
.br
.******************************************************************************
:h2 res=24 id=24 global.Import
:i2 refid=file.Import
:p.Einige Handler untersttzen das Importieren und/oder Exportieren von
Informationen. Der Standard-Text-Handler beispielsweise im- und exportiert
simplen ASCII-Text. Die Meneintrge zum Importieren werden durch den jeweils
aktuellen Handler und die verfgbaren Import-Handler bestimmt.
:p.Einige Import-Handler beziehen sich auf eine Seite oder sogar auf das
gesamte Dokument. Die hierzu gehrigen Eintrge stehen grundstzlich im
Importmen, da sie immer verwendbar sind. Wenn keine gltigen Import-Handler
zur Verfgung stehen, ist das Men deaktiviert.
.******************************************************************************
:h2 res=25 id=25 global.Export
:i2 refid=file.Export
:p.Einige Handler untersttzen das Importieren und/oder Exportieren von
Informationen. Der Standard-Text-Handler beispielsweise im- und exportiert
simplen ASCII-Text. Die Meneintrge zum Exportieren werden durch den jeweils
aktuellen Handler und die verfgbaren Export-Handler bestimmt.
:p.Einige Export-Handler beziehen sich auf eine Seite oder sogar auf das
gesamte Dokument. Die hierzu gehrigen Eintrge stehen grundstzlich im
Exportmen, da sie immer verwendbar sind. Wenn keine gltigen Export-Handler
zur Verfgung stehen, ist das Men deaktiviert.
.******************************************************************************
:h2 res=32 id=32 global.Bilder von TWAIN-Gerten wie Scannern einlesen
:i2 refid=file.Bilder von TWAIN-Gerten wie Scannern einlesen
:p.Ist ein TWAIN-kompatibler Scanner installiert, kann Maul mit diesem
kommunizieren. Auf TWAIN beziehen sich zwei Meneintrge. Der erste ist
'Bildquelle auswhlen...', der zum Einsatz kommt, wenn mehr als ein
Scanner installiert ist, der zweite, 'Bild einlesen...', dient zum
Aufrufen des TWAIN-Scanner-Dialogs.
:p.Stehen dem Rechner keine TWAIN-Quellen zur Verfgung, sind diese
Meneintrge deaktiviert.
:p.Damit TWAIN funktionieren kann, mssen zuerst ein Rahmen und eine
leere Objektebene ausgewhlt werden, da nur so ein neues Bitmap-Objekt
erstellt werden kann. Eingescannte Bilder liegen gewhnlich als
Bitmaps vor. Daher werden die Meneintrge auch aktiviert, wenn der
Bitmap-Handler aktiv ist.
.br
.br
.******************************************************************************
:h2 res=26 id=26 global.Dokument speichern
:i2 refid=file.Dokument speichern
:p.Whlen Sie das Men 'Datei', dann darin den Eintrag 'Speichern'.
:p.Wenn Ihr Dokument noch keinen Namen trgt, werden Sie aufgefordert, einen anzugeben.
:p.Diese Funktion kann auch ber die Werkzeugleiste aufgerufen werden. Klicken
Sie dazu einfach auf die Schaltflche :artwork name='save.bmp' runin.
.******************************************************************************
:h2 res=27 id=27 global.Dokument unter neuem Namen speichern
:i2 refid=file.Dokument unter neuem Namen speichern
:p.Whlen Sie das Men 'Datei', darin den Eintrag 'Sichern als...'.
:p.Sie werden dann aufgefordert, einen Dateinamen zu vergeben. Sie knnen zu
diesem Zeitpunkt auch einen anderen Pfad angeben.
:p.Ein Doppelklick auf ein Laufwerk oder Verzeichnis ffnet dieses entsprechend.
:p.Ein einfacher Klick auf eine Datei markiert diese zunchst nur, wohingegen
ein Doppelklick diese Datei auswhlt und den Dialog beendet.
:p.Wenn Sie ein bestehendes Dokument berschreiben, werden Sie dazu
aufgefordert, dies zu besttigen, wobei die Antwort 'Ja' bedeutet, da die
Datei berschrieben werden soll, 'Nein' zur Eingabe eines Dateinamens
zurckkehrt und 'Abbrechen' den Dialog ohne Aktion beendet.
.******************************************************************************
:h2 res=30 id=30 global.Automatische Sicherung
:i2 refid=file.Automatische Sicherung
:p.Wenn die automatische Sicherung eingeschaltet ist, speichert Maul Ihr Dokument in regelmigen Abstnden.
:p.Die automatische Speicherung wird versucht, sobald die Widerrufliste
aktualisiert wird. Dies bedeutet, da die automatische Sicherung durch eine
Bearbeitungsaktion ausgelst wird und nicht durch eine einfache
Zeitberschreitung. Ob die automatische Sicherung schlielich auch
stattfindet, hngt von einer Reihe an Kriterien ab&colon.
:ul.
:li.Die automatische Sicherung mu eingeschaltet sein.
:li.Das Dokument mu gendert worden sein.
:li.Seit der letzten Sicherung mssen 60 Sekunden vergangen sein.
:li.Es drfen keine offenen Widerruflisten vorhanden sein. (Widerruflisten
beinhalten eine Abfolge von unsichtbaren Bearbeitungsaktionen. Im Dialog :link
reftype=hd res=83.Widerrufliste:elink. knnen Sie diese eingefat
in geschweifte Klammern "{..." und "...}" wiederfinden.)
:eul.
.br
.br
.******************************************************************************
:h2 res=28 id=28 global.Ein Dokument drucken
:i2 refid=file.Ein Dokument drucken
:p.Whlen Sie das Men 'Datei', darin den Eintrag 'Drucken'... Alternativ
knnen Sie auch die Schaltflche :artwork name='print.bmp' runin. verwenden.
:p.Wenn Sie kein registrierter Anwender sind, tragen alle Ihre Druckausgaben
nach der ersten Seite den Hinweis 'Unregistriert'.
:p.Der Druckdialog wird angezeigt. Dieser Dialog ermglicht die Angabe der zu
druckenden Seiten sowie die Auswahl eines anderen Druckers.
:p.:hp2.Warnung:ehp2.
:p.Maul ist auf die Nutzung von Druckseitenkoordinaten ausgelegt. Aus diesem Grunde knnen alle hier am
Drucker oder dem ausgewhlten Druckerformular vorgenommenen nderungen potentiell unangenehme Nebenwirkungen haben&colon.
:ul.
:li.Wenn die Druckseite vom Seitenformat des Dokuments abweicht, werden die Dokumentinhalte
entsprechend skaliert. Aufgrund der orthogonalen Skalierung knnen sich Abweichungen im Ausdruck ergeben.
:li.Maul versucht eventuell, nicht passende dynamische Jobeigenschaften zu verwenden. Unter Umstnden kann dies
eine falsche Seitenausrichtung zur Folge haben.
:li.Sind x- und y-Auflsung des Druckers nicht gleich, kann das Seitenlayout ber die dynamischen Jobeigenschaften
nicht ordnungsgem festgelegt werden. In diesem Fall mssen Sie die Druckjobeigenschaften von Hand festlegen.
Achten Sie dabei insbesondere auf die Seitenausrichtung.
:eul.
:p.Die Mglichkeit, auf dieser Seite Drucker und Druckerformular zu ndern, dient nur dem Ausdruck von Entwrfen
auf einem lokalen Drucker bevor der richtige Ausdruck auf einem besseren oder Netzwerkdrucker stattfindet. Format
und Drucker sollten fr ein Dokument im Dialog :link reftype=hd res=41.Format der Druckseite einstellen:elink.
so ausgewhlt werden, da sie dem Gert entsprechen, mit dem der Endausdruck durchgefhrt wird.
:p.:hp2.Dynamische Jobmerkmale:ehp2.
:p.Das Programm versucht zunchst, das Papierformat automatisch
zu whlen. Wenn Sie den korrekten Drucker installiert haben und Ihr Drucker
dynamische Jobmerkmale untersttzt, sollten Sie das korrekte Papierformat
und die Seitenausrichtung als vorgewhlt erkennen knnen. Beachten Sie, da
Sie wahrscheinlich Warp 4 oder hher bentigen, damit das funktioniert. Da
dieses Leistungsmerkmal von IBM nicht dokumentiert ist, sollten Sie
diesbezgliche Probleme an den :link reftype='launch' object='netscape.exe'
data='mailto:Maul Support <maulpub@gmail.com>'.Maul Support
<maulpub@gmail.com>:elink. melden.
:p.Wenn Sie mehr als einen Drucker installiert haben und die Formulare einfach
nicht passen wollen, knnen Sie versuchsweise einen anderen Drucker verwenden.
Dadurch erzwingen Sie eine erneute Prfung der Formularbereinstimmung durch
den Dialog.
:p.Ob die dynamischen Jobmerkmale funktionieren, knnen Sie daran
erkennen, da die Titelzeile des Dialogs in diesem Fall anzeigt
'Drucken&colon. bereinstimmung auf Dateiebene'.
:p.:hp2.Manuelle Auswahl des Druckformulars:ehp2.
:p.Versuchen Sie, ein Druckerformular auszuwhlen, da dem Seitenformat des
Dokuments mglichst genau entspricht. Der Dialog zeigt zunchst das 'am besten
passende' Druckerformular an. Die Auswahl eines anderen Druckformulars fhrt
entweder zur Deaktivierung der dynamischen Jobmerkmale oder, sofern
verfgbar, dazu, da die korrekte Seitenausrichtung bernommen wird.
:p.Wenn Sie fr Ihren Drucker eine andere Papiergre oder ein anderes
Druckformular eingestellt haben, mssen Sie das Druckformular unter Umstnden
im Dialog 'Jobmerkmale' einstellen. Mit diesem Dialog knnen Sie
beispielsweise auch die Druckqualitt einstellen. Wenn Sie Parameter ndern,
die von den dynamischen Jobmerkmalen betroffen sind - wie zum Beispiel die
Seitenausrichtung - werden diese eventuell auf einen anderen Wert
zurckgesetzt, wenn das Programm dies fr ntig befindet.
:p.:hp2.Drucken im Netzwerk und Metadatei-Druckjobs:ehp2.
:p.Fr die schnellstmgliche Druckausgabe knnen Sie die Auswahl
'Metadatei-Druckjob' auswhlen. Metadateien ermglichen eine erhebliche
Beschleunigung der Druckgeschwindigkeit. Diese Auswahl knnen Sie auf
Einzelplatzrechnern verwenden, allerdings verursachen viele Druckertreiber
schwere Probleme mit zweifarbigen Bitmaps, die stattdessen sehr hufig in
einem groen, farbigen Rechteck enden.
:p.In den meisten Fllen - speziell bei Verwendung von Netzwerkdruckern -
sollten Sie diese Option nicht verwenden.
:p.:hp2.Eine Druckausgabe abbrechen:ehp2.
:p.Die Druckstatusmeldung verfgt ber eine Schaltflche zum Abbrechen, die
dazu fhrt, da die Druckausgabe beendet wird, sobald die aktuell im Druck
befindliche Seite vollstndig bertragen wurde. Wenn Sie die Druckausgabe noch
vor der Vervollstndigung der aktuellen Seite abbrechen mchten, halten Sie
die Taste <Esc> gedrckt. <Esc> wird durchgngig in der gesamten Anwendung
verwendet, um Ablufe zu unterbrechen, die innerhalb einer Verarbeitungsskette
ausgefhrt werden.
:p.Das Gedrckthalten der Taste <Esc> fhrt zum sofortigen Beenden
der Zeichnungssequenz. Das funktioniert zwar viel schneller als das Drcken der
Schaltflche 'Abbrechen', jedoch knnen Sie damit rechnen, da Sie eine
Druckseite mit einem heillosen Durcheinander erhalten werden.
:p.:hp2.Postscript und Unicode:ehp2.
:p.Als Standart erstellt Maul neue Textobjekte mit einen Unicode Zeichensatz.
Nur auf OS/2, wenn der ausgewhlte Drucker Postscript-Technologie bentzt, wird stattdessen ein Windows Zeichensatz
verwendet. Das geschieht weil OS/2 Postscript aktuell kein Unicode untersttzt.
Dieses verhalten kann man ndern indem man eine neue Einstellung in "maul.ini" hinzufgt.
:p.Die Einstellung heit "Maul Publisher"->"PSUnicode", und sein Wert soll auf (ULONG)1 gestellt werden. Das verursacht,
dass Maul immer den Unicode Zeichensatz verwendet, egal welche Technologie der Drucker beherbergt.
:p.:hp2.Siehe auch&colon.:ehp2.
:p.:link reftype=hd res=29.Weitere Druckoptionen:elink..
.br
.br
.******************************************************************************
:h3 res=29 id=29 global.Weitere Druckoptionen
:i2 refid=file.Weitere Druckoptionen
:p.Weitere Druckoptionen ermglichen Ihnen das Verwalten von manuellem
Duplexdruck - also das beidseitige Bedrucken von Blttern auf einem Drucker,
der nur einseitigen Druck beherrscht. Normalerweise werden die Seiten
entsprechend Ihrer Reihenfolge ausgedruckt.
:p.Leider macht dies das beidseitige Drucken auf einem nicht-duplexfhigen
Drucker schwierig. Um auch hier beidseitige Drucke zu erzielen, mssen
zunchst alle Seiten mit ungeraden Seitennummern ausgedruckt werden und danach
(auf die Rckseiten) alle Seiten mit geraden Seitenzahlen.
:p.Maul macht genau das, wenn Sie die Option 'Manueller Duplexdruck' im Dialog
'Weitere Druckoptionen' verwenden. Diesen Dialog ffnen Sie durch Klicken der
Schaltflche 'Erweitert' im Dialog 'Drucken'.
:p.Maul geht davon aus, da es sich bei der ersten beidseitig zu bedruckenden
Seite um eine rechte handelt. Beginnt Ihr Dokument mit einer linken Seite, so
wird diese folglich als eine einseitige Druckseite angesehen und auf einem
separaten Blatt ausgegeben. Ebenso kann es sein, da beim Ausdrucken eines
mehrseitigen Bereichs die erste und/oder letzte Seite auf einem separaten
Blatt ausgegeben wird.
:p.Um in diesem Bereich korrekte Resultate zu ermglichen, fhrt Maul mehrere
Druckdurchlufe durch, wobei die verschiedenen Elemente in einzelne
Druckdateien geschrieben werden. Bei jedem Lauf gibt Maul Ihnen Zeit, Bltter
zu wenden oder zu entfernen. Jedesmal mssen Sie zunchst darauf warten, da
der Drucker die Seite vollstndig ausgeben konnte, bevor Sie 'OK' anklicken
und den nchsten Druckdurchlauf starten.
:p.Die Reihenfolge, in der die gegenberliegenden Seiten ausgedruckt werden
mssen, hngt davon ab, wie Ihr Drucker die gedruckten Seiten ablegt. Bei HP
Deskjet Druckern beispielsweise sollten Sie in umgekehrter Reihenfolge
drucken. Sie werden wahrscheinlich ein wenig experimentieren mssen, um den
besten Weg fr Ihre Gegebenheiten herauszufinden.
:p.Nach Abschlu des Druckdurchlaufs werden Sie unter Umstnden zunchst die
Seiten in eine korrekte Reihenfolge umsortieren mssen.
.******************************************************************************
.*  Page Menu / Men 'Seite'
.******************************************************************************
:h1 res=40 id=40 global.Men 'Seite'
:i1 id=page.Men 'Seite'
:p.Dieses Men dient dazu,
:sl.
:li.das :link reftype=hd res=41.Format der Druckseite:elink. einzustellen.
:li.die :link reftype=hd res=42.Rnder:elink. einer Seite einzustellen.
:li.die verwendeten :link reftype=hd res=51.Maeinheiten:elink. einer Seite einzustellen.
:li.:link reftype=hd res=43.Seitenvorlagen:elink. zu verwalten.
:li.Seiten in die Zwischenablage zu :link reftype=hd res=48.kopieren:elink..
:li.Seiten aus der Zwischenablage :link reftype=hd res=49.einzufgen:elink..
:li.neue Seiten :link reftype=hd res=44.einzufgen:elink..
:li.Seiten zu :link reftype=hd res=45.lschen:elink..
:li.zu einer Seite und Rahmen :link reftype=hd res=53.gehen:elink..
:li.zur :link reftype=hd res=46.vorhergehenden:elink. Seite zu wechseln.
:li.zur :link reftype=hd res=47.nchsten:elink. Seite zu wechseln.
:esl.
.******************************************************************************
:h2 res=41 id=41 global.Format der Druckseite einstellen
:i2 refid=page.Format der Druckseite einstellen
:p.:hp2.Drucker auswhlen:ehp2.
:p.Whlen Sie einen Drucker fr Ihr Dokument aus.
:p.Die Arbeitsweise von Maul Publisher ist stark druckerorientiert. Sie mssen
mindestens ein Druckerobjekt in Ihrem System installiert haben, damit Maul
berhaupt funktioniert. Der eigentliche Drucker selbst braucht dabei allerdings
gar nicht vorhanden zu sein - lediglich der Treiber wird bentigt. Sie knnen
den Treiber dann beispielsweise auf Umleitung der Druckausgaben in eine Datei
einstellen.
:p.Auerdem sollten Sie einen der Druckertreiber fr Apple Color LaserWriter
installieren (sofern verfgbar), um PostScript-Dateien erstellen zu knnen.
:p.:hp2.Format der Druckseite auswhlen:ehp2.
:p.Alle verfgbaren Druckerformulare sind aufgelistet. Sie knnen eigene Formulare
erstellen, indem Sie auf die Schaltflche 'Neues Formular' klicken. Sie knnen
ein beliebiges Formular erstellen, selbst wenn der Drucker zu dessen Ausgabe gar
nicht imstande ist. Sofern fr das ausgewhlte Druckerformular dynamische
Jobmerkmale verfgbar sind, knnen Sie mittels der entsprechenden Abbildungen
(in der Mitte des Dialogfensters) die Papierausrichtung fr die Seite auf Hoch-
bzw. Querformat einstellen.
:p.:hp2.Verwenden von Druckereinstellungen:ehp2.
:p.Grundstzlich werden die durch den Drucker bereitgestellten Formulare von
Maul weder direkt verwendet noch beeinflut. Stattdessen benutzt Maul zur
nderung von Seiteneigenschaften direkt die Einstellungsdialoge des
Druckerherstellers. Meist werden Sie darin eine betrchtliche Anzahl
interessanter Optionen finden, unter anderem auch solche, die sich auf die
Druckqualitt oder Seitenausrichtung beziehen. Wenn das Druckerformular von
Ihnen erstellt wurde, werden die Merkmale des dargestellten Formulars genau dem
entsprechen, was Sie mittels des Dialogs 'Neues Formular' angegeben hatten.
:p.Sobald Sie Ihr Dokument ausdrucken wollen, mssen Sie ein 'echtes'
Druckerformlar whlen. Auch der Druckdialog bietet Ihnen hier die Mglichkeit,
die Druckereinstellungen zu ndern. Diesmal beziehen sich eventuelle nderungen auf
die tatschlich auszugebenden Seiten.
 
:p.:hp2.Druckseiten unterteilen:ehp2.
:p.Sie knnen Druckseiten in mehrere Dokumentseiten unterteilen - bzw. mehrere
Dokumentseiten auf einer einzigen Druckseite ausgeben. Wenn Sie Ihre 
Dokumentseite so gro wie mglich auf einer einzelnen Druckseite ausgeben 
mchten, klicken Sie auf die Schaltflche 'Ganze Druckseite'. Zu diesem
Zeitpunkt knnen Sie Maul auch mitteilen, ob der Bundsteg fr Ihre Seiten sich
oben bzw. unten befindet, anstelle von rechts/links. Der Bundsteg ist die Kante,
an der alle Seiten geleimt bzw. gebunden wrden, wenn es sich um ein Buch
handelte. Die Seiten eines Wandkalenders beispielsweise sind hufig am
oberen Rand gebunden.
:p.Wenn Sie Ihre Druckseiten in mehrere (kleinere) Dokumentseiten unterteilen
wollen (das ist z.B. ntzlich, um Visitenkarten auszudrucken), klicken Sie auf
die Schaltflche 'Druckseite unterteilen'. Sie knnen die Druckseite nun in 
Abschnitte einteilen, die sich nebeneinander befinden (waagerecht trennen),
untereinander (senkrecht trennen) oder beides. Auf diese Weise knnen Sie Ihre
Druckseite in bis zu 25 Formularseiten unterteilen.
:p.Das Format 'Faltbroschre' wird grtenteils in Zusammenhang mit Zeitungen
und Zeitschriften verwendet. Bei diesem Format befinden sich die letzte und die
erste Dokumentseite auf derselben Druckseite. Die Gre einer Druckseite
enspricht dabei immer dem doppelten der gefalteten Zeitschrift/Broschre. Diese
bestehen fr gewhnlich aus mehreren Druckseiten, die senkrecht gefaltet und
schlielich an der Falz zusammengeheftet werden.
:p.Fr teure, handgemachte Einbnde wird auch das Format 'Faltbroschre'
verwendet. Dabei werden vier oder acht Druckseiten gefaltet und am Bundsteg
zu einem 'Bndel' aneinander genht. Am Ende besteht das Buch dann aus einer
Vielzahl solcher Bndel, die an der Nahtseite nochmals mit einem geleimten Bund
versehen werden. Um in Maul Druckausgaben fr diese Format zu erstellen, mssen 
Sie angeben, aus wieviel Druckseiten ein Bndel besteht (eine Druckseite hat
dabei wegen der Falz jeweils zwei Vorder- bzw. Rckseiten). Dadurch kann Maul
die einzelnen Dokumentseiten korrekt numerieren.
:p.:hp2.Seitennumerierung:ehp2.
:p.Maul numeriert die Seiten Ihres Dokuments immer korrekt und unabhngig davon,
ob sich die erste Seite links oder rechts befindet. Sie knnen mit der Numerierung
auch auf einer anderen Seite als der ersten beginnen (bis zu Seite 32768). Seiten,
die sich dann vor der Seite 1 befinden, erhalten negative Seitenzahlen (eine
Numerierung knnte dann bspw. '-2, -1, 1, 2, 3,...' usw. lauten).
:p.Beachten Sie hierzu auch&colon.
:p.:link reftype=hd res=42.Seitenrnder einstellen:elink.
:p.:link reftype=hd res=95.Druckereinstellungen sichern:elink.
.br
.br
.******************************************************************************
:h3 res=52 id=52 global.Druckrandbersteuerung
:i2 refid=page.Druckrandbersteuerung
:p.Die Druckrandbersteuerung stellt einen OS/2-spezifischen Weg dar, das Verfahren zur Angabe von Druckrndern
zu korrigieren.
:p.:hp2.Ein wenig Geschichte:ehp2.
:p.In OS/2-Anwendungen dient der Systemaufruf DevQueryHardcopyCaps() zum Lesen von Informationen bezglich des
gerade ausgewhlten Papierformats. Leider liefert dieser Systemaufruf die Informationen ber angegebene Druckrnder
nur auf den Millimeter genau. Um Objekte przise auf einer Seite anzuordnen, ist dies nicht genau genug.
:p.Die meisten aktuellen Drucker sind in der Lage, Seiten mehrfach genauer als auf 0.5mm zu positionieren - und manche
knnen dies noch wesentlich besser. Soll eine beidseitig bedruckte Seite mit deckungsgleicher Vor- und Rckseite
ausgegeben werden, ist eine prsize Ausrichtung der Seiten erforderlich. Um dies zu ermglichen, sind die Umkehrung von
Linealen und zentrierte bedruckbare Bereiche zwar hilfreich, jedoch nur, wenn die nicht bedruckbaren Seitenrnder
genau angegeben werden.
:p.:hp2.Die Korrektur:ehp2.
:p.Zum bersteuern der vom Drucker gemeldeten Rnder kann eine Datei angelegt werden. Bei der Auswahl einer Druckseite
sucht die Anwendung nach einer Datei mit dem Namen des Druckers und der Dateiendung ".txt". Ist eine solche Datei
vorhanden, werden die nicht bedruckbaren Bereiche aus dieser Datei und nicht vom Drucker gelesen.
:p.Beispiel&colon.
:p.Im Ordner 'Lokales System->Drucker' wird ein Drucker als "HP Deskjet 895C" bezeichnet. Um eine Druckrandbersteuerung
fr diesen Drucker zu erstellen, legt man eine Datei namens "HP Deskjet 895C.txt" im Unterverzeichnis etc des
Maul-Installationsverzeichnisses an.
:p.In dieser Datei definiert man die Rnder fr alle Papierformate, die man eventuell verwenden mchte. Kommentare
lassen sich durch ein # am Anfang einer Zeile hinzufgen.
:xmp.
##################################################
#
# Hp Deskjet Printer margins override
# These are tweaked margins for the 
# HP DeskJet 895C
# (portrait)form=left,right,bottom,top in 1000th mm
# not case sensitive, no spaces allowed
#
##################################################
a4=3400,3400,11760,1020
letter=6400,6400,12280,1020
legal=6400,6400,12080,1020
executive=6775,6775,11980,1020
dl envelope=3185,3185,22130,1020
:exmp.
:p.Damit diese bersteuerung schnell funktionieren kann, mute die Verarbeitungsroutine fr die Datei
sehr einfach gehalten werden. Beachten Sie bitte folgendes&colon.
:ul.
:li.Die Rnder einer Seite werden stets fr das Hochformat angegeben - also mehr hoch als breit.
:li.Die Rnder sind stets in der Reihenfolge links, rechts, unten, oben in 1000-stel mm anzugeben.
:li.Eine Zeile pro Papierformat.
:li.Es sind keine Leerzeichen erlaubt, es sei denn, sie sind Teil des Papierformatnamens.
:li.Es mssen nur die Formate angegeben werden, die man bersteuern mchte. Bei den brigen wird auf
einen mm gerundet.
:eul.
:p.:hp2.Auffinden der bentigten Informationen:ehp2.
:p.Schlielich stellt sich die Frage, wo man die korrekten Randwerte fr seinen Drucker finden kann.
Eine verzwickte Problemstellung, aber etwas Probieren kann hier weiterhelfen.
:p.Zuerst einmal knnen Sie den Dialog "Seiteneinrichtung" ffnen, dort Drucker und Seitenformat
passend auswhlen und dann "Neue Seite" drcken. Der Dialog "Neues Druckerformular" besitzt einen eingebauten
Randrechner, der auf den oberen und rechten Rndern basierend genau die Werte fr den rechten und unteren Rand
berechnet. Bei meinem eigenen Drucker lie ich die Werte so berechnen, da linker und rechter Rand gleich sind
und der obere Rand immer 1.020mm betrgt. Sie stimmten sogar gut mit den von Microsoft Windows fr diesen Drucker
ermittelten Rndern berein.
:p.Zweitens knnen Sie ein schwarzes Rechteck auf einer ganzen Druckseite zeichnen. Achten Sie darauf, da alle
Zentrierungen abgeschaltet sind und zeichnen Sie ein Rechteck mit einer 1pel breiten, schwarzen Umrandung. Legen
Sie die Gre so an, da die Umrandung mit den Grenzen der Druckseite bereinstimmt. Drucken Sie die Seite aus
und messen Sie die Rnder mit einem Lineal ab. Haben Sie die Rnder eingegeben, berprfen Sie sie, indem Sie
zuerst die Seitenzentrierung aktivieren und dann wie oben beschrieben ein neues Rechteck zeichnen. Drucken Sie
das gleiche Rechteck auf beiden Seiten der Druckseite und halten Sie das Papier gegen das Licht. So knnen Sie
sehen, wie genau die Rechtecke bereinstimmen.
.br
.br
.******************************************************************************
:h2 res=42 id=42 global.Seitenrnder einstellen
:i2 refid=page.Seitenrnder einstellen
:note text='Hinweis'.Einige Einstellungen wie Falzbreite oder Spiegelung des
Layoutraster werden erst bei Klicken der Schaltflche 'Alle setzen' bernommen,
da sich diese Einstellungen auf alle Seiten des Dokuments auswirken. Die anderen
Einstellungen knnen jeweils fr eine einzelne Seite gendert werden.
:p.:hp2.Druckseitenrnder:ehp2.
:p.Die Angaben in diesem Bereich des Dialogs dienen lediglich zur Information.
Neben der tatschlichen Papiergre werden auch die Gren der Druckseitenrnder
angezeigt. Diese Randgren ndern sich, wenn der Druckbereich innerhalb der
Druckseite zentriert wird. Fr weitere Informationen beachten Sie hierzu bitte
auch den Abschnitt :link reftype=hd res=41.Format der Druckseite einstellen:elink..
:p.:hp2.Seitenrnder:ehp2.
:p.Fr jede Seite knnen Rnder eingestellt werden, die diese Seite umgeben.
Diese Rnder dienen dazu, um die einzelnen Dokumentseiten einer Druckseite
herum leere Bereiche zu erzeugen. Diese Seitenrnder sind allerdings unabhngig
von den Seitenrndern, die der verwendete Drucker selbst bereits fr jede
Druckseite erzeugt und werden zustzlich hierzu ausgegeben. Die druckereigenen
Seitenrnder sind nicht przise definiert, jedoch kann der Drucker diese Bereiche
definitiv (aus technischen Grnden) nicht bedrucken. Wenn Sie es unbedingt
darauf anlegen, wird das Programm die hier angegeben Rnder frhlich bedrucken
(bis zur Erreichung der druckereigenen Rnder). Beachten Sie, da die hier
angegebenen Seitenrnder in erster Linie als Fangpunkte fr das Einrasten von
Rahmen dienen. Sie knnen auch benutzerdefinierte Fangpunkte anlegen, um damit
zustzliche Fanglinien einzurichten. Lesen Sie mehr dazu im Abschnitt 
:link reftype=hd res=803.Die Lineale:elink..
:p.:hp2.Layoutraster spiegeln:ehp2.
:p.Fr die Modi 'Ganze Seite' und 'Faltbroschre' knnen Sie Maul anweisen, die
Seitenrnder und das Layoutraster fr gegenberliegende Seiten jeweils 
entsprechend zu spiegeln.
:p.:hp2.Lineale spiegeln:ehp2.
:p.Bei der Spiegelung des Layoutrasters kann der Anfang des Lineals versetzt werden, so da
von gegenberliegenden Enden der Seite gemessen werden kann. Dieser Effekt wird deaktiviert, wenn
das Dokument in der Ansicht :link reftype=hd res=62.Druckseite:elink. oder 
:link reftype=hd res=61.gegenberliegende Druckseiten:elink. angezeigt wird.
:p.:hp2.Layoutraster:ehp2.
:p.Geben Sie eine Anzahl von Zeilen und Spalten an, um abgestimmte Text- und
Bildrahmen erstellen zu knnen. Eine 'Rinne' ist ganz einfach eine Lcke
zwischen Zeilen und bereinstimmende Lcke zwischen Spalten. Durch Anklicken
von 'Mittige Rinnen anzeigen' wird fr jede Rinne die entsprechende Mittellinie
angezeigt.
:p.Verwenden Sie den Modus 'Raster aus Papierformat', um das Layoutraster an das 
Format des zu bedruckenden Papiers anzupassen. Wenn Sie das Blatt dann entlang
einer Rasterlinie falten, stimmen die Blattkanten berein. Da dieser Modus nur
fr Ganzseitenlayouts wirklich sinnvoll ist, wird die entsprechende Option bei
anderen Seitenlayouts deaktiviert.
:p.:hp2.Falzbreite:ehp2.
:p.Im Modus 'Faltbroschre', bei dem mehrere Druckseiten mittig gefalzt und
geheftet werden, mu aufgrund der zunehmenden Falzstrke die uere Seite
gestreckt werden, um die inneren Seiten passend abdecken zu knnen. Maul
untersttzt dieses Streckungsverfahren, um Seite fr Seite eine Kompensierung
der Bild- und Textpositionen zu gewhrleisten. Der Streckungsfaktor der Falzbreite
schrumpft dabei, je nher das jeweilige Blatt dem Zentrum der Faltbroschre 
(also der Mittelseite) liegt. Dieses Schrumpfen kann automatisch vorgenommen
werden durch verwenden der Option 'Automatisch schrumpfen'. Die tatschliche
maximale Falzbreite variiert jedoch aufgrund unterschiedlicher Papiertypen und
-strken und kann nur durch Einsatz eines Mikrometers oder simples Ausprobieren
ermittelt werden (versuchen Sie, die Strke des Papierstoes zu messen, bevor
dieser gefaltet wrde, und multiplizieren Sie diesen Wert mit 3,14).
:p.Siehe auch&colon.
:p.:link reftype=hd res=41.Format der Druckseite einstellen:elink.
:p.:link reftype=hd res=95.Druckereinstellungen sichern:elink.
.br
.br
.******************************************************************************
:h2 res=51 id=51 global.Maeinheiten einstellen
:i2 refid=page.Maeinheiten einstellen
:p.:hp2.Maeinheiten:ehp2.
:p.Verwenden Sie diesen Dialog, um die verwendete Maeinheit anzugeben. Die hier
eingestellte Maeinheit wird von Maul innerhalb der gesamten Anwendung angewendet.
:p.Die Einstellung zur Maeinheit wird gemeinsam mit dem Dokument gespeichert.
Obwohl Sie die Einstellung jederzeit ndern knnen, wird hierdurch gewhrleistet,
da das Dokument immer unter Verwendung der gleichen Maeinheit geffnet wird.
:p.:hp2.Skalierung und Versatz:ehp2.
:p.Mit Hilfe von Skalierung und Versatz lassen sich beliebige Dimensionen fr die Bemaung nutzen.
Dies ist besonders dann wichtig, wenn mit Maul architektonische Zeichnungen angefertigt werden sollen.
Der Versatz ist ein Verfahren zum Verschieben des Linealursprungs um eine bestimmte Strecke. Diese
Einstellungen haben keinerlei Einflu auf die wirkliche Gre der Seite, auf der gezeichnet wird.
Es werden den in den Dialogen und Linealen angezeigten Dimensionen nur die Skalierungs- und Versatzwerte
hinzugefgt.
:p.Der Skalierungsfaktor wird zum Skalieren des Lineals verwendet. Legt man einen Wert von 50 fest, so werden
2cm als 1m angezeigt. Verwendet man einen Wert von 0,05, werden 2cm als 1mm angezeigt.
:p.Verstze werden dem Lineal hinzugefgt und bercksichtigen die Skalierung. Wenn mit anderen Worten
der Skalierungsfaktor 50 betrgt, dann wrde man 1m angeben, um den Linealursprung auf der Seite um 2cm
zu versetzen. Auf diese Weise lt sich der Versatz einfach festlegen. Beachten Sie jedoch, da der Versatz
des Linealursprungs auch dann noch 1m vom Seitenrand betrgt, wenn die Skalierung zurckgesetzt wird!
:p.Siehe auch :link reftype=hd res=95.Druckereinstellungen sichern:elink.
.br
.br
.******************************************************************************
:h2 res=43 id=43 global.Seitenvorlagen
:i2 refid=page.Seitenvorlagen
:p.:hp2.Men 'Seitenvorlage einfgen':ehp2.
:p.Bei diesem Meneintrag handelt es sich um eine bedingte Ausklappliste. Das
bedeutet, da Sie durch Klicken auf die kleine Schaltflche rechts des
Meneintrags eine Liste der verfbaren Seitenvorlagen erhalten. Wenn Sie bisher
noch keine Seitenvorlagen erstellt hatten, wird der komplette Meneintrag 
deaktiviert.
:p.Andernfalls wird die ausgewhlte Seitenvorlage zur Standard-Seitenvorlage.
Diese Standard-Seitenvorlage kann jederzeit durch direktes Anklicken des
Meneintrags 'Seitenvorlage einfgen' eingefgt werden. Seitenvorlagen fgen
hinter der aktuellen Seite des Dokuments weitere Druckseiten ein, die dann mit
dem Inhalt der Seitenvorlage gefllt werden (Sie bearbeiten also nicht die
Seitenvorlage selbst). Durch die Verwendung von Seitenvorlagen knnen schnell neue
Dokumente erstellt werden. Wenn Sie durch das Einfgen einer Seitenvorlage eine
leere erste Seite erhalten, knnen Sie diese lschen. Alternativ knnen Sie
auch eine vorhandene Seite kopieren und diese in die leere Seite :link reftype=hd res=49.einfgen:elink..
:p.Die Gre und Form der Seite werden auf Kompatibiltt mit der aktuellen Seite
geprft, und falls die Angaben nicht bereinstimmen, wird eine entsprechende
Warnmeldung ausgegeben.
:p.Seitenvorlagen werden grundstzlich im Verhltnis der Auflsung der
Seitenvorlage (in DPI, "dots per inch") zur Auflsung der aktuellen Seite 
skaliert. Sie knnen so viele Seitenvorlagen anlegen und verwenden, wie Sie
mchten.
:p.:hp2.Dialog 'Seitenvorlage Sichern/Lschen':ehp2.
:p.Mit diesem Dialog verwalten Sie Ihre Seitenvorlagen. Wenn Sie die aktuelle
Seite als eine Seitenvorlage speichern, werden alle Inhalte der aktuellen Seite
in die Seitenvorlage bernommen. Sofern Sie Steuerfelder fr Seitenzahlen
verwenden, werden diese auch bei spterer Verwendung der Seitenvorlage in neuen
Dokumenten korrekt sein, da Seitenzahlen grundstzlich dynamisch aktualisiert
werden.
:p.Wird eine bestimmte Seitenvorlage nicht mehr bentigt, whlen Sie sie aus
und lschen sie. Beachten Sie dabei aber, da das Lschen einer Seitenvorlage
nicht ohne weiteres rckgngig gemacht werden kann, da es sich bei den Vorlagen
um echte Dateien auf der Festplatte handelt. Seiten- und Stilvorlagen werden im
Unterverzeichnis 'etc' des Maul-Installationsverzeichnis abgelegt.
:p.:hp2.Seitenvorlagen erstellen:ehp2.
:p.Eine Seitenvorlage ist lediglich ein Dokument, das aus einer einzigen Seite
besteht. Um eine Seitenvorlage zu erstellen, fgen Sie einfach die bentigten
Rahmen zu einer Seite hinzu, bis diese alle bentigten Rahmen, Objekte und
Inhalte enthlt. Solche gngigen Rahmen knnten beispielsweise Firmenlogos,
leere Textbereiche oder Seitenzahlen enthalten.
:p.Sofern Sie Seitenzahlen einsetzen wollen, sollten Sie dafr Steuerfelder 
einsetzen. Weitere Informationen zu den Steuerfeldern sind in den Hilfethemen
zum Text-Handler enthalten.
:p.:hp2.Erweiterte Seitenvorlagen&colon. Seitenbergreifende automatische Objektverknpfungen:ehp2.
:p.Ab Version 1.22 untersttzt Maul das Konzept der 'aufgebrochenen Ketten'
innerhalb von Seitenvorlagen. Der Zweck einer aufgebrochenen Kette ist, die
Mittel zur automatischen, seitenbergreifenden Verknpfung von einzelnen Rahmen
(beispielsweise Textrahmen) in Seitenvorlagen zur Verfgung zu stellen. Ein neues
Dokument, das mit Seitenvorlagen erstellt wurde, die korrekt vorbereitete Ketten
einsetzen, enthlt dann von Beginn an bereits alle bentigten Rahmen, die
seitenbergreifend verknpft sind.
:p.Um eine Seitenvorlage mit aufgebrochenen Ketten zu erstellen, mssen Sie mit
mindestens drei Seiten beginnen: Einer ersten Seite, einer letzten Seite und der
eigentlichen Seitenvorlage als mittlerer Seite.
:p.Auf der neuen Seitenvorlage erstellen Sie nun zunchst die Textrahmen, die
verknpft (verkettet) werden sollen, sowie alle weiteren Rahmen, die auf jeder
Seite Ihres Dokuments enthalten sein sollen. Ebenso mssen dann auf der ersten
und der letzten Seite die Textrahmen erstellt werden, die mit den Textrahmen auf
der mittleren Seite verkettet werden sollen. Nachdem Sie diese Rahmen alle
erstellt haben, verketten Sie diese jeweils seitenbergreifend. Danach haben Sie quasi
ein kleines, dreiseitiges Dokument erstellt.
:p.Speichern Sie nun die mittlere Seite als neue Seitenvorlage. Das Programm
kennzeichnet alle seitenbergreifenden Verkettungen als aufgebrochene Ketten und
weist jeder Verknpfung eine interne Kennung zu. Sobald Sie auf Basis dieser
Seitenvorlage ein neues, mehrseitiges Dokument erstellen, werden alle aufgebrochenen
Ketten nach dem Generieren der Seiten automatisch wieder miteinander verbunden.
Beachten Sie aber, da dieses Verfahren nur beim Erstellen neuer Dokumente
funktioniert, jedoch nicht beim manuellen Kopieren und Einfgen von Seiten. Um
die Verkettungen manuell zu bearbeiten, stellt der Text-Handler entsprechende
Funktionen bereit.
:p.Wenn Sie im Dialog 'Neues Dokument' zwei unterschiedliche Seitenvorlagen
auswhlen, werden eventuell enthaltene Verkettungen korrekt hergestellt, sofern
die Anzahl und Kennungen der Verkettungen zueinander passen. Auf diese Weise
knnen Sie recht einfach umfangreiche Dokumente mit vielen verketteten Objekten
erstellen.
:p.:artwork name='torn.bmp' align=left.
.br
.br
.******************************************************************************
:h2 res=48 id=48 global.Eine Seite zur Zwischenablage kopieren
:i2 refid=page.Eine Seite zur Zwischenablage kopieren
:p.Verwenden Sie den Meneintrag 'Diese Seite kopieren', um die aktuelle
Druckseite in die Zwischenablage zu kopieren. Die aktuelle Druckseite wird dabei
nicht verndert.
:p.Diese Funktion untersttzt keine Grafiken, die ber externe Dateiverweise
eingebunden sind; desweiteren werden Verknpfungen zu Rahmen auf anderen Seiten
hierdurch entfernt ('aufgebrochen').
:p.Um Grafiken zu kopieren, die ber externe Dateiverweise eingebunden sind,
kopieren Sie stattdessen den entsprechenden Rahmen.
.******************************************************************************
:h2 res=49 id=49 global.Eine Seite aus der Zwischenablage einfgen
:i2 refid=page.Eine Seite aus der Zwischenablage einfgen
:p.Verwenden Sie den Meneintrag 'Seite aus Ablage einfgen', um die Druckseite
in der Zwischenablage auf die aktuelle Druckseite zu bertragen. Die aktuelle
Druckseite wird nicht gespeichert.
:p.'Seite aus Ablage einfgen' fgt keine neue Seite zu Ihrem Dokument hinzu,
sondern berschreibt vielmehr den Inhalt der aktuellen Druckseite mit dem Inhalt
der Zwischenablage. Die Gre und Form der Seite wird dabei mit den Angaben zur
aktuellen Seite verglichen, und falls diese abweichen, wird ein entsprechender
Warnhinweis ausgegeben. Dadurch sind Sie in der Lage, den Vorgang abbrechen zu
knnen.
.******************************************************************************
:h2 res=44 id=44 global.Eine neue Seite einfgen
:i2 refid=page.Eine neue Seite einfgen
:p.Verwenden Sie den Meneintrag 'Seite einfgen' oder die Schaltflche :artwork name='addpg.bmp' runin., um
eine neue Druckseite hinter der aktuellen Druckseite einzufgen.
:p.Es kann vorkommen, da Sie eine neue Druckseite :hp2.vor:ehp2. der aktuellen
Druckseite einfgen mchten. Das erreichen Sie, indem Sie im Men 'Seite' auf
die kleine Schaltflche rechts neben dem Meneintrags 'Seite einfgen' klicken
und aus der dann angezeigten Liste den Eintrag 'Seite vor der aktuellen einfgen'
verwenden.
.******************************************************************************
:h2 res=45 id=45 global.Eine Seite lschen
:i2 refid=page.Eine Seite lschen
:p.Verwenden Sie den Meneintrag 'Eine Seite lschen' oder klicken Sie auf die
Schaltflche :artwork name='delpg.bmp' runin., um die aktuelle Druckseite zu
lschen.
.******************************************************************************
:h2 res=53 id=53 global.Zu einer Seite und Rahmen springen
:i2 refid=page.Zu einer Seite und Rahmen springen
:p.Mit Hilfe dieses Dialogs kann schnell zu einer bestimmten Seite und einem
bestimmten Rahmen gesprungen werden.
:p.Jedesmal, wenn zu einer Seite gesprungen wird, wird die Auswahl aller Rahmen aufgehoben und die
Liste der Rahmen wird aktualisiert. Nach dem Sprung zur gewnschten Seite kann dann zum gewnschten
Rahmen gesprungen werden, indem dieser aus der Ausklappliste der verfgbaren Rahmen ausgewhlt
wird.
:p.Die Mglichkeit, einen bestimmten Rahmen anzuspringen ist dann am ntzlichsten, wenn ein
:link reftype=hd res=86.Druckvorstufenbericht:elink. durchgesehen wird.
.br
.br
.******************************************************************************
:h2 res=46 id=46 global.Zur vorhergehenden Seite gehen
:i2 refid=page.Zur vorhergehenden Seite gehen
:p.Verwenden Sie den Meneintrag 'Gehe zur vorhergehenden Seite' oder klicken
Sie auf die Schaltflche :artwork name='prevpg.bmp' runin., um zur Druckseite
zu gehen, die sich vor der aktuellen Druckseite befindet.
.******************************************************************************
:h2 res=47 id=47 global.Zur nchsten Seite gehen
:i2 refid=page.Zur nchsten Seite gehen
:p.Verwenden Sie den Meneintrag 'Gehe zur nchsten Seite' oder klicken Sie auf
die Schaltflche :artwork name='nextpg.bmp' runin., um zur Druckseite zu gehen,
die sich hinter der aktuellen Druckseite befindet.
.br
.br
.******************************************************************************
.*  View Menu / Men 'Ansicht'
.******************************************************************************
:h1 res=60 id=60 global.Men 'Ansicht'
:i1 id=view.Men 'Ansicht'
:p.Mit diesem Men knnen Sie den Anzeigemodus einstellen auf
:sl.
:li.:link reftype=hd res=61.gegenberliegende:elink. Druckseiten.
:li.eine :link reftype=hd res=62.einzelne Druckerseite:elink..
:li.eine :link reftype=hd res=63.ganze Dokumentseite:elink..
:li.Anpassung der Seitengre an die :link reftype=hd res=64.Fensterbreite:elink..
:li.:link reftype=hd res=65.Originalgre:elink..
:li.:link reftype=hd res=66.Vergrerung:elink. der Anzeigeskalierung.
:li.:link reftype=hd res=67.Verkleinerung:elink. der Anzeigeskalierung.
:Esl.
.******************************************************************************
:h2 res=61 id=61 global.Gegenberliegende Druckseiten
:i2 refid=view.Gegenberliegende Druckseiten
:p.Diesen Anzeigemodus stellen Sie durch Verwendung des Meneintrags
'Gegenberliegende Druckerseiten' oder durch Klicken der Schaltflche :artwork name='vpface.bmp' runin. auf
der Werkzeugleiste ein.
:p.In diesem Modus werden jeweils zwei aufeinanderfolgende Druckseiten durch 
entsprechende Skalierung am Bildschirm dargestellt. Beide Seiten werden dabei
so skaliert, da sie im korrekten Verhltnis zueinander ausgerichtet und
dargestellt werden. Dieses Verhltnis ergibt sich jeweils daraus, wo sich der
Bundsteg der ersten angezeigten Seite befindet, und ob die Seiten vertikal oder
horizontal gebunden sind.
:p.:hp2.Vorsicht:ehp2.! In diesem Modus sollten Sie nur sehr sorgfltig arbeiten,
da es mglich ist, Rahmen auf Basis der inaktiven Seite auszurichten. Wenn dies
irrtmlich geschieht und Sie das Dokument ausdrucken, werden diese Rahmen nicht
ausgegeben. Sie knnen die jeweils aktive Seite daran erkennen, da Sie mit 
einer dunkelblauen Umrandung dargestellt wird, im Gegensatz zur blablauen 
Umrandung der inaktiven Seite.
:p.Beachten Sie auch, da die Lineale in diesem Anzeigemodus nicht auf Basis
der aktuellen Seite, sondern auf Basis des gesamten druckbaren Bereichs 
dargestellt werden.
.******************************************************************************
:h2 res=62 id=62 global.Ansicht 'Druckseite'
:i2 refid=view.Ansicht 'Druckseite'
:p.Verwenden Sie den Meneintrag 'Druckseite' oder klicken Sie auf die
Schaltflche :artwork name='vppage.bmp' runin. der Werkzeugleiste.
:p.Dadurch wird die Anzeige der aktuellen Druckseite auf die Gre des
Anzeigebereichs skaliert. Die Seite wird so skaliert, da die lngere Kante
der Druckseite vollstndig in das Fenster pat. Auerdem wird die Seite
innerhalb des Fensters zentriert. Beachten Sie, da die Lineale in diesem 
Anzeigemodus auf die Abmessung der Druckseite anstelle der aktuellen 
Dokumentseite eingestellt werden.
.******************************************************************************
:h2 res=63 id=63 global.Ansicht 'Ganze Seite'
:i2 refid=view.Ansicht 'Ganze Seite'
:p.Verwenden Sie den Meneintrag 'Ganze Seite' oder klicken Sie auf die
Schaltflche :artwork name='vpage.bmp' runin. der Werkzeugleiste.
:p.Dadurch wird die Anzeige der aktuellen Dokumentseite auf die Gre des
Anzeigebereichs skaliert. Die Seite wird so skaliert, da die lngere Kante
der Dokumentseite vollstndig in das Fenster pat. Auerdem wird die Seite
innerhalb des Fensters zentriert. Beachten Sie, da die Lineale in diesem
Anzeigemodus auf die Abmessungen der aktuellen Dokumentseite anstelle der
Druckseite eingestellt werden.
.******************************************************************************
:h2 res=64 id=64 global.Ansicht 'Auf Breite anpassen'
:i2 refid=view.Ansicht 'Auf Breite anpassen'
:p.Verwenden Sie den Meneintrag 'Auf Breite anpassen' oder klicken Sie auf die
Schaltflche :artwork name='fitw.bmp' runin. der Werkzeugleiste.
:p.Dadurch wird die Anzeige der aktuellen Dokumentseite auf die Gre des
Anzeigebereichs skaliert. Die Seite wird so skaliert, da die krzere Kante
der Dokumentseite vollstndig in das Fenster pat. Auerdem wird die Seite
innerhalb des Fensters zentriert. Beachten Sie, da die Lineale in diesem
Anzeigemodus auf die Abmessungen der aktuellen Dokumentseite anstelle der
Druckseite eingestellt werden.
.******************************************************************************
:h2 res=65 id=65 global.Ansicht 'Originalgre'
:i2 refid=view.Ansicht 'Originalgre'
:p.Verwenden Sie den Meneintrag 'Originalgre' oder klicken Sie auf die
Schaltflche :artwork name='actual.bmp' runin. der Werkzeugleiste.
:p.Dadurch erhalten Sie eine optimale Ansicht des aktuellen Rahmens oder - falls
kein Rahmen ausgewhlt ist - der aktuellen Dokumentseite. Der Darstellungsmastab
ist hierbei nicht die tatschliche Gre, sondern wird so berechnet, da Sie eine
komfortable Skalierung zum Bearbeiten von Texten erhalten. Beachten Sie, da
die Lineale in diesem Anzeigemodus auf die Abmessungen der aktuellen 
Dokumentseite anstelle der Druckseite eingestellt werden.
.******************************************************************************
:h2 res=66 id=66 global.Vergrern
:i2 refid=view.Vergrern
:p.Verwenden Sie den Meneintrag 'Vergrern' oder klicken Sie auf eine der
Schaltflchen :artwork name='zoom.bmp' runin. der Werkzeugleiste.
Verwenden Sie die Schaltflche '+' zum Vergrern und die Schaltflche '-' zum
Verkleinern der Skalierungsgre.
:p.Der aktuelle Skalierungsfaktor ist rechts der beiden Schaltflchen angegeben.
Der Skalierungsfaktor ndert sich in Stufen von 2er-Potenzen.
:dl compact tsize=20.
:dt.&sqbul. 0.13:dd.(1 &colon.&colon. 8)
:dt.&sqbul. 0.18:dd.
:dt.&sqbul. 0.25:dd.(1 &colon.&colon. 4)
:dt.&sqbul. 0.35:dd.
:dt.&sqbul. 0.5:dd.(1 &colon.&colon. 2)
:dt.&sqbul. 0.71:dd.
:dt.&sqbul. 1:dd.(1 &colon.&colon. 1)
:dt.&sqbul. 1.41:dd.
:dt.&sqbul. 2:dd.(2 &colon.&colon. 1)
:dt.&sqbul. 2.83:dd.
:dt.&sqbul. 4:dd.(4 &colon.&colon. 1)
:dt.&sqbul. 5.66:dd.
:dt.&sqbul. 8:dd.(8 &colon.&colon. 1)
:dt.&sqbul. 11.31:dd.
:dt.&sqbul. 16:dd.(16 &colon.&colon. 1)
:edl.
:lm margin=1.
.br
.br
.******************************************************************************
:h2 res=67 id=67 global.Verkleinern
:i2 refid=view.Verkleinern
:p.Verwenden Sie den Meneintrag 'Verkleinern' oder klicken Sie auf einer der
Schaltflchen :artwork name='zoom.bmp' runin. der Werkzeugleiste.
Verwenden Sie die Schaltflche + zum Vergrern und die Schaltflche - zum
Verkleinern der Skalierungsgre.
:p.Der aktuelle Skalierungsfaktor ist rechts der beiden Schaltflchen angegeben.
Der Skalierungsfaktor ndert sich in Stufen von 2er-Potenzen.
:dl compact tsize=20.
:dt.&sqbul. 0.13:dd.(1 &colon.&colon. 8)
:dt.&sqbul. 0.18:dd.
:dt.&sqbul. 0.25:dd.(1 &colon.&colon. 4)
:dt.&sqbul. 0.35:dd.
:dt.&sqbul. 0.5:dd.(1 &colon.&colon. 2)
:dt.&sqbul. 0.71:dd.
:dt.&sqbul. 1:dd.(1 &colon.&colon. 1)
:dt.&sqbul. 1.41:dd.
:dt.&sqbul. 2:dd.(2 &colon.&colon. 1)
:dt.&sqbul. 2.83:dd.
:dt.&sqbul. 4:dd.(4 &colon.&colon. 1)
:dt.&sqbul. 5.66:dd.
:dt.&sqbul. 8:dd.(8 &colon.&colon. 1)
:dt.&sqbul. 11.31:dd.
:dt.&sqbul. 16:dd.(16 &colon.&colon. 1)
:edl.
:lm margin=1.
.br
.br
.******************************************************************************
.*  Edit Menu / Men 'Bearbeiten'
.******************************************************************************
:h1 res=70 id=70 global.Men 'Bearbeiten'
:i1 id=edit.Men 'Bearbeiten'
:p.Das Men 'Bearbeiten' ist dem jeweils aktiven Handler vorbehalten. Wenn Sie
den aktiven Handler wechseln, so wechseln auch die Eintrge im Men 'Bearbeiten'.
Wenn der Menpunkt nicht vorhanden ist, mssen Sie mglicherweise zunchst einen
Handler (erneut) auswhlen.
:p.Um einen leeren Rahmen mit einem Handler zu bearbeiten, beachten Sie die
Hinweise unter :link reftype=hd res=72.Objekt zu Rahmen hinzufgen:elink..
:p.Um einen leeren Rahmen mit dem Inhalt der Zwischenablage zu fllen, beachten
Sie die Hinweise unter :link reftype=hd res=71.Zwischenablage in leeren Rahmen einfgen:elink..
.br
.br
:h2 res=71 id=71 global.Zwischenablage in leeren Rahmen einfgen
:i2 refid=edit.Zwischenablage in leeren Rahmen einfgen
:p.Wenn Sie eine Objektebenen-Schaltflche verwenden (eine Schaltflche mit 
einem Fragezeichen darauf), wird der <null>-Handler aktiv. Solange Sie dann
einen Rahmen ausgewhlt haben, knnen Sie mittels des <null>-Handlers Objekte
zum Rahmen hinzufgen.
:p.Der <null>-Handler ermglicht es, von ihm erkannte Datentypen aus der 
Zwischenablage direkt in einen leeren Rahmen einzufgen. Dabei wird dem Rahmen
automatisch der fr den jeweiligen Datentyp zustndige Objekt-Handler zugewiesen,
bevor die eigentlichen Daten aus der Zwischenablage importiert werden.
:p.Der in der Zwischenablage enthaltene Datentyp bestimmt dabei den Typ des neu
anzulegenden Objekts im Rahmen. Sofern der Datentyp in der Zwischenablage
nicht eindeutig ist bzw. eine Auswahl getroffen werden kann/mu, knnen Sie
ber den kleinen Pfeil rechts des Meneintrags einen bestimmten Objekttyp fr
das Einfgen whlen.
:p.Weitere Mglichkeiten, Objekte zu einem Rahmen hinzuzufgen, werden im
Abschnitt :link reftype=hd res=72.Objekt zu Rahmen hinzufgen:elink. erlutert.
.******************************************************************************
:h2 res=72 id=72 global.Objekt zu Rahmen hinzufgen
:i2 refid=edit.Objekt zu Rahmen hinzufgen
:p.Es stehen verschiedene Wege zur Verfgung, um Objekte zu einem Rahmen
hinzuzufgen. In jedem Fall mu jedoch zunchst der betreffende Rahmen bereits
existieren, ausgewhlt worden sein und der Teil des Rahmens bestimmt worden
sein, fr den das Hinzufgen eines Objekts geschehen soll.
:p.:hp2.Objekte und Objektebenen&colon. bersicht:ehp2.
:p.Objekte werden aus Ebenen gebildet und bestehen aus zwei Teilen. Ein Teil
stellt die Rahmeninhalte dar, der andere die Rahmenumrandung. Die Darstellung 
und die Bearbeitung von Objekten erfolgt durch Objekt-Handler. Hier ein Beispiel
fr die Namen zweier Objekt-Handler (einer fr Inhalte, der andere fr 
Umrandungen)&colon.
:sl.
:li.INHALTE, Standardtext
:li.UMRANDUNG, Standardumrandung
:esl.
:p.Wrden Sie den Text-Handler auf Ebene 0 der Rahmeninhalte anwenden, wrde die
entsprechende Schaltflche das Symbol fr eine Schreibmarkierung anzeigen und
der Hilfetext fr diese Schaltflche wre dann 'Ebene 0&colon.- Standardtext'.
:p.Im Men 'Ansicht' werden den einzelnen Ebenen auerdem Namen zugewiesen,
damit man ein besseres Verstndnis darber gewinnt, wofr die einzelnen Ebenen
verwendet werden knnen.
:sl.
:li.Ebene 0. (Inhalts-/Umrandungs-) Ebene. Dies ist die oberste Ebene.
:li.Ebene 1. (Inhalts-/Umrandungs-) Hintergrundebene. Dient dazu, den Hintergrund
des jeweiligen Rahmenbestandteils (also Inhalt oder Hintergrund) darzustellen.
Wenn Textzeichen der Inhaltsebene mit einer speziellen Fllung versehen werden
sollen, wird diese Ebene zur Angabe der speziellen Fllung verwendet.
:li.Ebene 2. (Inhalts-/Umrandungs-) Basisebene. Diese Ebene stellt eine weitere
Hintergrundebene dar. Sehr ntzlich, wenn Sie die darberliegende (erste) 
Hintergrundebene zur Realisierung einer speziellen Fllung fr die Textzeichen
der Ebene 0 verwendet haben.
:li.Ebene 3. (Inhalts-/Umrandung-) Schattenebene. Diese Ebene ist ntzlich, um
fr einen Rahmen noch Schattenwurfeffekte zu definieren, wenn alle anderen
Ebenen des Rahmens bereits voll ausgeschpft wurden.
:esl.
:p.Wozu Sie die Ebenen letzlich verwenden, ist unerheblich. Es macht daher also
keinen Unterschied, ob Sie den Hintergrund auf Ebene 1, 2 oder 3 setzen. Wenn
Sie allerdings selbstbeschneidende Objekte verwenden wollen, um einen 
Hintergrund innerhalb von Texten zu erzeugen, mu sich dieser Hintergrund auf
Ebene 1 befinden. Nur Ebene 1 kann Fllhintergrnde fr Ebene 0 darstellen.
Weitere Informationen zu selbstbeschneidenden Objekten sind in der entsprechenden
Dokumentation des Rahmen-Handlers enthalten.
:p.:hp2.Objekte zu einem Rahmen hinzufgen, Schritt 1&colon. Ebene auswhlen.:ehp2.
:ul.
:li.Bei Verwendung des Mens 'Ansicht'&colon.
:ol.
:li.Whlen Sie den Rahmen aus, indem Sie ihn anklicken.
:li.ffnen Sie das Men 'Ansicht'.
:li.Klicken Sie auf den Eintrag 'Inhaltsansicht' oder auf das kleine Pfeilsymbol
rechts vom Meneintrag, um die gewnschte Ebene auszuwhlen. Wenn Sie eine
Umrandungsebene bearbeiten wollen, verwenden Sie stattdessen das Untermen
'Rahmenansicht'. Stellen Sie sicher, da Sie nicht eine Ebene auswhlen, die
bereits ein Objekt enthlt.
:eol.
:li.Bei Verwendung der Schaltflchen der Werkzeugleiste&colon.
:ol.
:li.Whlen Sie den Rahmen aus, indem Sie ihn anklicken.
:ul.
:li.Nun klicken Sie entweder auf die Schaltflche...
:artwork name='addob1.bmp'.
:li....oder...
:artwork name='addob2.bmp'. und :artwork name='addob3.bmp'.
:eul.
:eol.
:eul.
:p.:hp2.Objekte zu einem Rahmen hinzufgen, Schritt 2&colon. Objekt hinzufgen:ehp2.
:ul.
:li.Mglichkeiten, ein leeres Objekt zu erstellen&colon.
:ol.
:li.ffnen Sie das Men 'Bearbeiten'. 
Da Sie eine Ebene ohne Objekt ausgewhlt haben, wird der <null>-Handler aktiv.
Dieser Handler stellt den Meneintrag 'Handler zum Rahmen hinzufgen...' zur
Verfgung, den Sie dann anklicken. In dem nun erscheinenden, kleinen Dialog
knnen Sie das hinzuzufgende Objekt (respektive den Objekt-Handler) auswhlen.
:li.Klicken Sie auf eine der angezeigten Objektschaltflchen.
:artwork name='seltxt.bmp'.
In der obigen Abbildung wird beispielsweise gerade das Textobjekt ausgewhlt.
:eol.
:li.Mglichkeiten, ein Objekt einzufgen&colon.
:ol.
:li.Da Sie eine Ebene ohne Objekt ausgewhlt haben, wird der <null>-Handler aktiv.
Dieser Handler stellt den Meneintrag :link reftype=hd res=71.'Objekt einfgen':elink.
zur Verfgung. Der in der Zwischenablage enthaltene Datentyp bestimmt das zu
erstellende Objekt. Sofern der Inhalt der Zwischenablage eine Auswahl ermglicht,
knnen Sie das kleine Pfeilsymbol neben dem Meneintrag verwenden, um ein
bestimmtes Objekt auszuwhlen.
:li.Sie knnen den Meneintrag 'Datei->Import' verwenden, um einen Dateityp fr
das Importieren anzugeben.
:li.Mittels Ziehen-und-bergeben knnen Sie eine Datei von Ihrer Arbeitsoberflche
direkt in den Rahmen bernehmen. Allerdings werden dabei nur erkannte
Dateitypen untersttzt.
:eol.
:eul.
:p.Beachten Sie, da die Schaltflche bei Ebenen mit vorhandenen Objekten das
dem Objekt-Handler entsprechende Symbol anzeigt. Klicken Sie auf die jeweilige
Schaltflche, um das Objekt zu bearbeiten. Objekte werden gelscht, indem die
korrekte Ebene ausgewhlt und dann der Eintrag 'Handler entfernen' im Men
'Bearbeiten' benutzt wird.
:artwork name='addob5.bmp'.
:p.:hp1.Die obige Abbildung ist eine Zusammenstellung der beiden Ausklappmens
fr Ebenen und der Schaltflchensymbole. Neben den Meneintrgen erkennen Sie
leicht die Merkmale aller Ebenen.:ehp1.
.br
.br
.******************************************************************************
.*  Undo Menu / Men 'Widerrufen'
.******************************************************************************
:h1 res=80 id=80 global.Men 'Widerrufen'
:i1 id=undo.Men 'Widerrufen'
:p.Dieses Men wird verwendet, um
:sl.
:li.die letzte Aktion zu :link reftype=hd res=81.widerrufen:elink. bzw.
sie dann zu :link reftype=hd res=82.wiederholen:elink..
:li.die :link reftype=hd res=83.Widerrufliste:elink. einzublenden.
:esl.
.br
.br
.******************************************************************************
:h2 res=81 id=81 global.nderungen rckgngig machen (widerrufen)
:i2 refid=undo.nderungen rckgngig machen (widerrufen)
:p.Verwenden Sie den Eintrag 'Widerrufen' im Men 'Widerrufen' oder die
Tastenkombination Alt+Rckschritt, um die letzte Aktion rckgngig zu machen.
:p.Bestimmte Widerrufaktionen bestehen aus mehreren Schritten, beispielsweise
knnte das Einfgen aus dem Schreiben von Text und einem anschlieenden 
Lschen bestehen. Der Meneintrag zeigt daher immer die nchste Aktion an, die
widerrufen bzw. wiederholt werden kann.
:p.Da die Anzahl an widerrufbaren Aktionen nahezu unbegrenzt ist, empfiehlt
sich, das Dokument whrend der Arbeit gelegentlich zu speichern. Dadurch wird
der Speicherbereich fr die Widerruffunktion geleert und Speicher freigegeben.
Nach einer Speicherung knnen keine vorherigen Aktionen mehr widerrufen werden.
:p.Nachdem eine Aktion widerrufen wurde, kann sie wiederholt werden.
Verwenden Sie dazu den Eintrag :link reftype=hd res=82.Wiederholen:elink. im
Men 'Widerrufen' oder die Tastenkombination Strg+Rckschritt.
 
.******************************************************************************
:h2 res=82 id=82 global.Wiederholen (nach Widerruf)
:i2 refid=undo.Wiederholen (nach Widerruf)
:p.Verwenden Sie nach einem Widerruf den Eintrag 'Wiederholen' im Men
'Widerrufen' oder die Tastenkombination Strg+Rckschritt, um den Widerruf
rckgngig zu machen.
:p.Ein Widerruf kann unmittelbar danach wieder rckgngig gemacht werden. Wenn
nach dem Widerruf eine andere Bearbeitung erfolgte (z.B. eine Texteingabe), kann
das Wiederholen des Widerrufs unter Umstnden nicht mehr mglich sein. Falls ein
Wiederholen nicht mglich sein sollte, wird der Meneintrag dafr deaktiviert.
 
.******************************************************************************
:h2 res=83 id=83 global.Die Widerrufliste
:i2 refid=undo.Die Widerrufliste
:p.Anhand der Widerrufliste knnen Sie Aktionen widerrufen bzw. selbiges wieder
rckgngig machen (wiederholen). 
:p.Die Widerrufliste wird ber einen eigenen, separaten Proze gesteuert und
zeigt den Inhalt des Widerrufspeichers an. Die eingeblendete Liste wird zwar
whrend der Bearbeitung des Dokuments dynamisch aktualisiert, allerdings
belastet dies die Systemleistung und verlangsamt den Bearbeitungsproze.
:p.:hp2.Widerrufen/Wiederholen von Aktionen ber die Widerrufliste:ehp2.
:p.Die aktuell widerrufbare Aktion ist in der Liste unterlegt. Die Auswahl der
zu widerrufenden oder wiederholenden Aktion erfolgt durch einfaches Anklicken
des entsprechenden Eintrags in der Liste und Klicken der enstprechenden
Schaltflche. Unter Verwendung der Liste knnen Sie auch mehrere Aktionen
widerrufen bzw. wiederholen.
:p.Maul ignoriert dabei Kombinationen, die nicht sinnvoll erscheinen. Wenn Sie
beispielsweise einen Widerruf-Eintrag auswhlen, dann aber die Schaltflche fr
'Wiederholen' anklicken, wird lediglich ein einfaches Wiederholen erfolgen.
:p.Das Klicken der Schaltflche 'Widerruf' oder 'Wiederholen' fhrt eine
einzelne Aktion durch, sofern die ausgewhlte Aktion (unterlegt) der aktuellen
Widerrufmarkierung (rot) entspricht. Wenn eine andere Aktion ausgewhlt wird,
bewirkt ein Klicken der jeweiligen Schaltflche, da die Widerrufmarkierung
auf den ausgewhlten Eintrag verschoben wird und alle Aktionen bis zum gewhlten
Eintrag durchgefhrt werden.
.br
.br
.******************************************************************************
.*  Tools Menu
.******************************************************************************
:h1 res=84 id=84 global.Men Werkzeuge
:i1 id=tools.Men Werkzeuge
:p.Dieses Men dient dazu&colon.
:sl.
:li.Nach einem Textartikel zu :link reftype=hd res=85.suchen:elink..
:li.Einen :link reftype=hd res=86.Druckvorstufen:elink.-Bericht anzufertigen.
:li.Auf die :link reftype=hd res=204.Farbpalette:elink. zuzugreifen.
:li.:link reftype=hd res=88.Objekt-Farben anzupassen:elink..
:li.:link reftype=hd res=87.Schriftarten in ein Dokument einzubetten:elink..
:esl.
:lm margin=1.
:p.Verschiedene Handler knnen weitere Werkzeuge hinzufgen, die hier nicht beschrieben
werden. Weitere Informationen entnehmen Sie bitte der Hilfe der jeweiligen Handler.
.br
.br
.******************************************************************************
:h2 res=85 id=85 global.Nach Text suchen
:i2 refid=tools.Nach Text suchen
:p.Da ein Dokument viele Textartikel enthalten kann, wird diese Mglichkeit zur Verfgung gestellt, die
Artikel nach einer Reihe optionaler Kriterien zu durchsuchen.
:p.Wird die Suche nicht eingeschrnkt, wird jeder Artikel in der Datei aufgefhrt. Die Suche kann auf angegebene
Namen, Autoren oder Suchbegriffe eingeschrnkt werden. Nach Wunsch lassen sich einzelne, alle oder keine dieser
Einschrnkungen anwenden.
:p.:hp2.Artikelname:ehp2.
:p.Geben Sie einen Artikelnamen ein, um die Suche auf Artikel einzuschrnken, deren Name hiermit bereinstimmt
oder zumindest so beginnt.
:p.Der Artikelname wird entweder aus den ersten paar Wrtern des Textartikels oder - falls verfgbar - aus den
Artikelinformationen gewonnen. Gro- und Kleinschreibung spielen beim Vergleich keine Rolle. Gbe man das Wort
"dies" ein, wrde die Suche sowohl
:p."Dieser kleine Artikel"
.br
als auch
.br
"Dies ist ein weiterer Artikel"
:p.finden.
:p.:hp2.Artikelautor:ehp2.
:p.Geben Sie einen Artikelautor ein, um die Suche auf von diesem Autor verfate Artikel einzuschrnken.
:p.Damit die Suche erfolgreich ist, mu der Artikelautor in den Textartikelinformationen definiert sein.
Gro- und Kleinschreibung spielen beim Vergleich keine Rolle. Gbe man das Wort "George" ein, wrde die Suche
sowohl
:p."George Orwell"
.br
als auch
.br
"George Melley"
:p.finden.
:p.:hp2.Suchbegriff:ehp2.
:p.Geben Sie Text ein, nach dem gesucht werden soll. Die Suche gibt nur solche Artikel zurck, die den angegebenen
Text enthalten. Falls gewnscht kann nach Gro- und Kleinschreibung unterschieden werden. Es wird nur die erste
Fundstelle des Textes im Artikel aufgefhrt.
:p.:hp2.Auswahl eines gefundenen Artikels:ehp2.
:p.Um einen gefundenen Artikel auszuwhlen, doppelklicken Sie einfach auf dessen Listeneintrag oder fhren einen
einfach Mausklick aus und drcken "Auswhlen". Der Textartikel wird dann ausgewhlt und das Programm schaltet
zum entsprechenden Objekt-Handler.
:p.Wurde ein Suchbegriff angegeben, wird das erste Vorkommen dieses Textes hervorgehoben. Weitere Vorkommen
des Textes lassen sich ber den Meneintrag "Suchen" des Mens "Bearbeiten" des ausgewhlten Handlers auffinden.
.br
.br
.******************************************************************************
:h2 res=86 id=86 global.Druckvorstufenbericht
:i2 refid=tools.Druckvorstufenbericht
:p.Mit Hilfe des Druckvorstufenberichts lassen sich potentielle Probleme im Dokument auffinden. Dabei handelt
es sich nicht um Fehler, sondern um Dinge, die beim Ausdruck des Dokuments zu unerwarteten Ergebnissen fhren
knnen. Die meisten Probleme werden durch die Auswirkungen der Farbtrennung verursacht, wenn farbiger Text zu
klein ist oder Bilder nicht genau skaliert wurden. Der angefertigte Bericht ist nichts definitives und die
meisten Warnungen knnen ignoriert werden. Zweck dieser Funktion ist, Sie auf mgliche Probleme hinzuweisen
und durch Erluterungen Lsungshilfen anzubieten.
:p.Der angefertigte Bericht kann als Textdatei gespeichert werden, die Sie dann nach Belieben durchsehen
knnen.
:p.Nutzen Sie den Dialog :link reftype=hd res=53.'Gehe zu Seite...':elink., um die Seite und den
Rahmen zu finden, bei dem ein Problem festgestellt wurde.
.br
.br
.******************************************************************************
:h2 res=204 id=204 global.Die Farbpalette
:i2 refid=tools.Die Farbpalette
:p.Die Farbpalette dient der Speicherung hufig in einem Dokument vorkommender Farben.
Die Farben werden in der Datei gespeichert und knnen beim Start geladen werden.
Weitere Informationen siehe :link reftype=hd res=94.Globale Stileinstellungen:elink..
:p.Die Farbpalette untersttzt das Ziehen-und-bergeben-Verfahren vollstndig, so da Farben
sowohl in das Dokument hinein- als auch herausgezogen werden knnen. Mit anderen Worten
knnen Farben an ein Fenster der Arbeitsoberflche bergeben werden, genauso wie bei
der Nutzung der Systemfarbpalette.
:p.:artwork name='palette.bmp' align=left.
:p.Zur Verwaltung der Farben wird der Farbpalettendialog verwendet. Nach einen Doppelklick
auf eine Farbe lassen sich Name und Stil bearbeiten. Neue Farben lassen sich durch Doppelklick
auf einen leeren Bereich der Farbpalette hinzufgen.
Weitere Informationen siehe im Dialog :link reftype=hd res=200.Farbe bearbeiten:elink..
:p.Der Farbpalettendialog besitzt eine Reihe von Schaltflchen zum Laden und Sichern der Farben
in einer Farbtabellendatei. Diese Vorgnge lassen sich auch direkt ber das
:link reftype=hd res=90.Men Optionen:elink. durchfhren.
:p.:hp2.Laden:ehp2.
:p.Farbtabellen knnen geladen werden. Beachten Sie jedoch, da dadurch smtliche im Dokument
vorhandenen Informationen ber benannte Farben verloren gehen. Whlen Sie die
Tabelle aus und drcken Sie "Laden".
:p.:hp2.Hinzufgen:ehp2.
:p.Farbtabellen knnen den in einem Dokument vorhandenen Farben hinzugefgt werden.
Sind im Dokument bereits benannte Farben vorhanden, erhalten die Farben des Dokuments
hhere Prioritt.
:p.:hp2.Sichern:ehp2.
:p.Durch das Sichern von benannten Farben in einer Farbtabelle lt sich sicherstellen,
da Farben ber verschiedene Dokumente hinweg konsistent bleiben.
:p.:hp2.Lschen von Farbtabellen:ehp2.
:p.Der Dialog Laden/Sichern bietet die Mglichkeit, Farbtabellendateien zu lschen.
Whlen Sie dazu die zu lschende Datei in der Dateiliste aus, drcken Sie die rechte Maustaste und whlen
Sie die Option "Lschen" aus dem Kontextmen.
:p.:hp2.Bearbeiten von Farbtabellen:ehp2.
:p.Farbtabellen werden in von Menschen lesbaren, einfache Textdateien gespeichert. Auf diese Weise erhlt man
die angenehme Mglichkeit, Farbtabellendateien mit einem normalen Texteditor, wie z.B. "E", zu bearbeiten und so
schnell eine Farbtabelle zu erstellen (lassen Sie jedoch Sorgfalt walten, denn die Syntax mu korrekt sein).
:p.Alle Kommentare in der Datei beginnen mit einem "<"-Symbol.
:p.Alle Farbeintrge beginnen mit einem ">"-Symbol.
:p.Die Farbeintrge werden zeilenweise hinzugefgt, wobei jeder Eintrag folgende Form haben mu&colon.-
:xmp.
>mein_farbname, zyan (0 bis 255), magenta (0 bis 255), gelb (0 bis 255), rasterwinkel
:exmp.
:p.Der Rasterwinkel nimmt stets einen Wert zwischen 0 und 4 an, wobei gilt&colon.-
:ul.
:li.0 = Proze
:li.1 = Schwarz
:li.2 = Zyan
:li.3 = Magenta
:li.4 = Gelb
:eul.
:p.Hier eine einfache Farbtabelle&colon.-
:xmp.
<Automatisch generierte Datei, Bearbeitung auf eigene Gefahr
<Name, Zyan (0..255), Magenta (0..255), Gelb (0..255), Bildschirm (0 = Proze, 1 = Schwarz, 2 = Zyan, 3 = Magenta, 4 = Gelb)
<...Dies ist eine ganz einfache Farbtabelle...
<
>Proze_wei, 0, 0, 0, 0
>Proze_gelb, 0, 0, 255, 0
>Proze_magenta, 0, 255, 0, 0
>Proze_rot, 0, 255, 255, 0
>Proze_zyan, 255, 0, 0, 0
>Proze_grn, 255, 0, 255, 0
>Proze_blau, 255, 255, 0, 0
>Proze_grau, 51, 51, 51, 0
>Proze_dklgrau, 127, 127, 127, 0
>Proze_dklgelb, 127, 127, 255, 0
>Proze_dklmagenta, 127, 255, 127, 0
>Proze_dklrot, 127, 255, 255, 0
>Proze_dklzyan, 255, 127, 127, 0
>Proze_dklgrn, 255, 127, 255, 0
>Proze_dklblau, 255, 255, 127, 0
>Proze_schwarz, 255, 255, 255, 0
:exmp.
:p.Obige Tabelle steht in der Datei "basis.clr" zur Verfgung und ist im Pfad deutsch.nls\docs installiert.
:p.:hp2.Warnung&colon.-:ehp2. Die Farben werden als sekundre CMY-Farben definiert, nicht als RGB-Farben. Daher gilt, da
die Farben umso dunkler sind, je grer die Zahlenwerte sind. CMY-Werte lassen sich wie folgt aus RGB-Werten berechnen&colon.
:ul.
:li.zyan = 255 - rot
:li.magenta =  255 - grn
:li.gelb = 255 - blau
:eul.
.br
.br
.******************************************************************************
:h2 res=88 id=88 global.Objekt-Farben anpassen
:i2 refid=bitmap.Objekt-Farben anpassen
:p.In vorherigen Versionen von Maul Publisher, war dieser Dialog ein Teil des Bitmap-Handlers,
und konnte nur fr Bitmap-Farben bentzt werden.
:p.Benutzen Sie diesen Dialog zur Anpassung der Farbbereiche und -helligkeit eines Objektes.
Mit Hilfe der Einstellungsmglichkeiten dieses Dialogs knnen zudem einige interessante
Spezialeffekte erzielt werden.
:p.Dieser Dialog ist nicht fr jedes Objekt geeignet. Zum Beispiel, Schwarz/Wei
(1 Bit pro Pixel) Bitmap-Bilder knnen nicht bearbeited werden ohne das man sie zuerst in eine
16 Farben Bitmap umwandelt.
:p.Der Dialog setzt sich aus zwei getrennten Fenstern zusammen, die unabhngig voneinander
verschoben werden knnen. Dies ermglicht es Ihnen, das Beispielbild aus dem Weg zu schieben,
um das darunter gelegene Originalbild sehen zu knnen. Das Beispielfenster wird automatisch
geschlossen, wenn das Fenster mit den Steuerelementen geschlossen wird.
:p.Auch wenn das Beispielfenster automatisch aktualisiert wird, steht eine Schaltflche
fr die Aktualisierung des Beispielbildes zur Verfgung. Normalerweise sollte diese jedoch
nicht bentigt werden, da alles automatisch abluft.
:p.:hp2.Kontrast, Helligkeit und Farbton:ehp2.
:p.Die Bedeutung der meisten Steuerelemente ist ziemlich offensichtlich. Sie werden vielleicht
bemerken, da sich die Steuerelemente fr die Farbhelligkeit als ntzlicher erweisen, als die fr
den Farbton, wenn die Schwarz/Wei-Balance in Ordnung ist.
:p.:hp2.Farbvektoren:ehp2.
:p.Die Farbvektorkontrollen funktionieren unter Nutzung des CMYK- (:hp2.C:ehp2.yan, :hp2.M:ehp2.agenta,
:hp2.Y:ehp2.ellow, blac:hp2.K:ehp2.) Farbraums. Dies hat einige wichtige Nebenwirkungen zur Folge&colon.
:ul.
:li.Der Kanal fr schwarz und wei (K) ist nicht betroffen.
:li.Bei CMYK wird jede Farbe durch einen K-Kanal und nur zwei von drei Farbkanlen reprsentiert.
Das heit, da die Farben als x- und y-Vektoren betrachtet werden knnen.
:eul.
:p.:hp1.Farbvektoren drehen:ehp1.
:p.Man kann einzelne Farbvektoren drehen. Ein roter Vektor kann in Richtung magenta oder in Richtung
gelb gedreht werden. Das unten abgebildete Diagramm zeigt einen roten Farbvektor als Beispiel.
:p.:artwork name='colvect.bmp' align=left.
.br
Man kann&colon.
:ul.
:li.:hp2.rot:ehp2. zwischen magenta und gelb drehen,
:li.:hp2.grn:ehp2. zwischen gelb und zyan drehen,
:li.:hp2.blau:ehp2. zwischen zyan und magenta drehen.
:eul.
:p.:hp1.Farbvektoren skalieren:ehp1.
:p.Man kann einzelne Farbvektoren skalieren. Ein Vektor kann vergrert oder verkleinert werden.
Die untere Abbildung stellt die Wirkung der roten Farbhelligkeitskontrolle dar.
:p.:artwork name='redeff.bmp' align=left.
.br
:p.Beachten Sie, da die Vektoren bis zu einem gewissen Teil berlappen knnen, besonders nachdem
sie gedreht wurden. Die Kontrollen neigen dazu, sich gegenseitig zu beeinflussen, sowie einige Farben,
bei denen man es nicht erwartet. So knnen sich die roten Kontrollen beispielsweise auf bestimmte
Grnschattierungen auswirken.
:p.:hp2.Anwendungsreihenfolge:ehp2.
Alle Kontrollen werden in einer bestimmten Reihenfolge auf jedes Pixel der Bitmap angewandt. Diese
Reihenfolge kann dabei helfen, die Art und Weise zu verstehen, in der die Kontrollen in Wechselwirkung
treten.
:ol.
:li.Kontrast
:li.Helligkeit
:li.Gamma
:li.Farbkontrast (Hier kann eine reine Farbe zu einen quivalenten Grauton verstellt werden)
:li.Rote Vektoren
:ul.
:li.Roter Farbvektor
:li.Rote Farbhelligkeit
:eul.
:li.Grne Vektoren
:ul.
:li.Grner Farbvektor
:li.Grne Farbhelligkeit
:eul.
:li.Blaue Vektoren
:ul.
:li.Blauer Farbvektor
:li.Blaue Farbhelligkeit
:eul.
:li.Roter Farbton
:li.Grner Farbton
:li.Blauer Farbton
:eol.
:p.Klicken Sie auf 'Anwenden', um die neuen Farben anzuwenden, und auf 'Beenden', um den
Dialog zu verlassen, wenn Sie die Arbeit fertiggestellt haben.
.br
.br
.******************************************************************************
:h2 res=87 id=87 global.Schriftarten in Dokument einbetten
:i2 refid=tools.Schriftarten in Dokument einbetten
:p.Verwenden Sie den Dialog 'Schriftarten einbetten', um Schriftarten in ein Dokument einzubetten.
:p.:hp2.ber eingebettete Schriftarten:ehp2.
:p.Schriftarten knnen eingebettet werden, um das Betrachten oder Drucken eines Dokumentes auf einem anderen Rechner
zu ermglichen, auf dem die erforderlichen Schriftarten eventuell nicht installiert sind.
:p.Schriftarten unterliegen gewhnlichen dem Urheberrecht. Dessen Bestimmungen knnen insbesondere
den Vertrieb von Schriftarten mit
einem Dokument verbieten. Ist eine Schriftart als lizensiert markiert, so wird sie nicht in der Auswahlliste fr
einzubettende Schriftarten angezeigt.
:p.Auch wenn eine Schriftart nicht als lizensiert markiert ist, kann das Einbetten in eine Datei immer noch einen Versto gegen das Urheberrecht
darstellen. Nehmen Sie sich bitte die Zeit, dies vorher zu berprfen!
:p.:hp2.Der Dialog 'Eingebettete Schriftarten':ehp2.
:p.Der Dialog 'Eingebettete Schriftarten' besteht aus zwei Listen. Die linke fhrt smtliche verfgbaren Schriftarten auf.
Im Dokument verwendete Schriftarten werden rot dargestellt. Es werden nur Schriftarten angezeigt, die nicht in der Datei eingebettet sind.
:p.Die rechte Liste zeigt die in der Datei einzubettenden Schriftarten an.
:p.Die ausgewhlten Dateien knnen mit Hilfe der Schaltflchen von einer Liste in die andere kopiert werden. Mit dem roten Pfeil
werden smtliche rot markierten (im Dokument verwendeten) Schriftarten in die Liste der einzubettenden Schriftarten bernommen.
:p.Um ausgewhlte eingebettete Schriftarten dauerhaft auf dem Rechner zu installieren, drcken Sie 'Installieren'. Der Vorgang wird
sofort nach Bettigen der Schaltflche ausgefhrt.
:p.Nach Drcken von 'OK' werden beide Listen verarbeitet und Schriftarten entsprechend in der Datei eingebettet oder daraus entfernt.
Beim Versuch, eine eingebettete Schriftart zu entfernen, die nicht auf dem System installiert ist, wird eine Warnung angezeigt.
Ignoriert man die Warnung, steht danach die zum Betrachten oder Ausdrucken des Dokumentes erforderliche Schriftart nicht mehr
zur Verfgung, und beim Aktualisieren der Anzeige wird wahrscheinlich eine weitere Warnung angezeigt.
.br
.br
.******************************************************************************
.*  Options Menu / Men 'Optionen'
.******************************************************************************
:h1 res=90 id=90 global.Men 'Optionen'
:i1 id=options.Men 'Optionen'
:p.ber dieses Men knnen Sie
:sl.
:li.:link reftype=hd res=93.Maul registrieren:elink..
:li.:link reftype=hd res=95.Druckereinstellungen sichern:elink..
:li.:link reftype=hd res=204.Farbpaletten laden oder speichern:elink..
:li.:link reftype=hd res=94.Globale Stileinstellungen:elink. verwalten.
:li.:link reftype=hd res=96.Tastenkrzel:elink. bearbeiten.
:li.das :link reftype=hd res=91.Fangraster aktivieren:elink..
:li.das :link reftype=hd res=92.Fangraster einstellen:elink..
:esl.
:lm margin=1.
:p.Weitere Optionen knnen durch verschiedene Handler zur Laufzeit hinzugefgt
werden und sind hier nicht beschrieben. Fr weitere Informationen zu diesen
Optionen beachten Sie bitte die entsprechenden Hilfethemem der einzelnen Handler.
.br
.br
.******************************************************************************
:h2 res=93 id=93 global.Maul Publisher registrieren
:i2 refid=options.Maul Publisher registrieren
:p.Solange Sie kein registrierter Anwender sind, tragen alle Ihre Druckausgaben
nach der ersten Seite den Vermerk 'Unregistered'.
:p.Mchten Sie Maul nach Ablauf der Testperiode weiter einsetzen, ist der 
Erwerb einer Lizenz erforderlich, um einen Registrierungsschlssel zu erhalten. 
:p.Nehmen Sie sich bitte die Zeit, das Produkt zu registrieren, da dies der 
einzige Weg ist, mit dem wir in der Lage sind, das Produkt weiter zu entwickeln
und zu untersttzen. Im Normalfall sind Registrierungen solange gltig, bis 
grundliegende und umfangreiche nderungen am Produkt vorgenommen werden oder bis
eine berarbeitung des Sicherheitssystems aufgrund von Produktpiraterie ntig
wird.
:note text='Hinweis'.:hp2.Der Registrierungsschlssel ist nur fr Sie bestimmt und darf in keinem
Fall an Dritte weitergegeben werden.:ehp2.
:p.:hp2.ber Internet:ehp2.
:p.Maul Publisher fr OS/2 kann direkt ber Maison Anglais bezogen werden.
Der schnellste Weg zu einer Bestellung fhrt Sie mit Ihrem Web-Browser zu
:link reftype='launch' object='netscape.exe' data='http://www.manglais.com/subs/php/product.php?MAULE200'.
http&colon.//www.manglais.com/subs/php/product.php?MAULE200:elink., wo Sie dann
die Schaltflche 'Buy Now' anklicken. Die Abwicklung erfolgt
ber ein SSL-gesichertes Zahlungssystem, um maximale Sicherheit zu gewhrleisten.
:p.Informationen ber andere Bezugsquellen finden Sie in der Datei RESELLER.HTM,
welche whrend der Programminstallation auf Ihr System kopiert wurde.
.br
.br
.******************************************************************************
:h2 res=95 id=95 global.Druckereinstellungen sichern
:i2 refid=options.Druckereinstellungen sichern
:p.Durch Verwendung dieses Meneintrags werden die Einstellungen der aktuellen
Seite als Mauls Standardeinstellung gesichert. Bei jedem Programmstart werden
diese Einstellungen als Vorgabe geladen.
:p.:hp2.Druckername:ehp2.
:p.Der Name des verwendeten Druckers wird ebenfalls gespeichert. Dieser Drucker
wird damit zum Standarddrucker beim Programmstart. Selbstverstndlich knnen Sie
stets jederzeit einen anderen Drucker auswhlen, jedoch wird beim Start des
Programms grundstzlich der hier gesicherte Drucker voreingestellt.
:p.Normalerweise wird der Name des jeweils eingestellten bzw. verwendeten 
Druckers nicht in den Dokumenten gespeichert.
:p.:hp2.Drucker-Jobmerkmale:ehp2.
:p.Die Jobmerkmale eines Druckers beinhalten das Druckformular, Angaben zur 
Druckqualitt, Farbeinstellungen und in Prinzip alle weiteren Einstellungen, die
Sie im Dialog der Jobmerkmale vornehmen knnen. In den Dokumenten selbst werden
nur die eigentlichen Seiteneinstellungen gesichert. Es lohnt sich also, alle
von Ihnen standardmig verwendeten Jobmerkmale vor dem Speichern der 
Druckereinstellungen festzulegen.
:p.:hp2.Zustzliche Einstellungen:ehp2.
:p.ber die oben beschriebenen Einstellungen hinaus werden auch die Angaben
mitgesichert, die in folgenden Dialogen eingestellt werden&colon.
:p.:link reftype=hd res=41.Format der Druckseite:elink.
:p.:link reftype=hd res=42.Seitenrnder:elink.
:p.:link reftype=hd res=51.Maeinheiten:elink.
.br
.br
.******************************************************************************
:h2 res=94 id=94 global.Globale Stileinstellungen
:i2 refid=options.Globale Stileinstellungen
:p.Mit Hilfe dieses Dialogs lt sich die Funktionsweise des Maul Publisher
anpassen. Alle auer den Startoptionen werden unmittelbar bernommen, sobald
zum Verlassen des Dialogs auf "OK" gedrckt wird. Bei den Startoptionen ist
ein Neustart des Programms erforderlich.
:p.:hp2.Hinweise:ehp2.
:p.Einige dieser Optionen lassen sich getrennt fr einzelne Dateien festlegen.
Diese lokalen Stileinstellungen bersteuern die globalen. Zu den lokalen
Einstellungen gehren&colon.
:ul.
:li.Datenpfad-Einstellungen
:li.Auslagerungseinstellungen
:li.Grenzeinstellungen
:eul.
:p.:hp2.Start:ehp2.
:p.Die von Maul verwendete Sprache kann abhngig von den installierten Sprachen
ausgewhlt werden. Bei nderung der Sprache versucht die Anwendung, sich selbst
zu beenden.
:p.Standardmig startet Maul im Vollbildmodus. Dieses Verhalten knnen Sie
ndern, indem Sie die Option "Programmstart im Vollbild" abwhlen.
:p.Aktivieren Sie "Geteilter Bildschirmmodus", wenn Sie Maul in einer Zwei-Monitor-Konfiguration
benutzen. Diese Option reduziert die Standardbreite passend fr den ersten Monitor.
:p.:hp2.Datenpfad:ehp2.
:p.Nach der Installation werden gemeinsam verwendete Dateien im Unterverzeichnis
"etc" des Installationsverzeicnis abgelegt. Diese Verzeichniseinstellung knnen
Sie nach Belieben ndern. Das bedeutet, da Stilvorlagen, Seitenvorlagen,
Rahmen-Cliparts, Benutzerwrterbcher usw. in separaten Ordnern fr jedes
Dokument oder fr das Arbeitem im Netzwerk an einem gemeinsam genutzten Ort
abgelegt werden knnen. Der Standardbenutzerpfad wird
ursprnglich im aktuellen Verzeichnis als "DTP_data" angelegt. Sie knnen 
diesen Pfad aber auf einen beliebigen anderen Speicherort abndern.
:p.Bei Auswahl von "Aktuellen Projektordner nutzen, falls verfgbar" werden
gemeinsam verwendete Dateien zusammen mit einem Projekt abgespeichert. Weitere
Informationen siehe :link reftype=hd res=31.Projekte verwalten:elink..
:p.:hp2.Auslagerung:ehp2.
:p.Sie knnen Grafiken in separaten Verzeichnissen speichern, die denselben
Namen wie das Dokument tragen. Diese Systemeinstellung wirkt sich allerdings
nicht auf bereits existierende Dokumente aus, d.h. die verwendenten Grafiken sind
entweder eingebunden oder als externe Dateiverweise vorhanden, und eine nderung
dieses Einstellung hat darauf keine Auswirkungen. Vielmehr betrifft dies nur
Grafiken innerhalb neuer Dokumente (also Dokumente, die nach der nderung der
Einstellung neu erstellt wurden).
.br
Daher sollte dieser Modus vor Beginn der Arbeiten an einem Dokument aktiviert werden
und nicht mittendrin.
:p.:hp2.Farbpalette:ehp2.
:p.Die Farbpalette dient der Speicherung hufig in einem Dokument vorkommender Farben.
Die Farben werden in der Datei gespeichert und knnen beim Start geladen werden.
Weitere Informationen siehe :link reftype=hd res=204.Die Farbpalette:elink..
:p.Nach Farbpalettendateien lt sich durch Drcken von 'Suchen'
suchen. Darauf wird die ausgewhlte Palette fr alle neuen Dateien
automatisch geladen, solange das entsprechende Markierungsfeld
aktiviert ist. Bestehende Dateien sind hiervon nicht betroffen.
:p.:hp2.Griffpunkte:ehp2.
:p.Sie knnen die Gre der Griffpunkte ndern. Die Gre der Griffpunkte wirkt
sich auch auf die Przision aus, mit der Sie die Griffpunkte anklicken mssen.
.br
Griffpunkte werden beim Bearbeiten und Auswhlen von Rahmen benutzt.
:p.:hp2.Schriftarten:ehp2.
:p.Es stehen zwei Schriftgren zur Verfgung. Die grere Schriftart ist
"10.System Proportional", wird unter OS/2 Warp 3 und 4 verwendet und
erfllt laut IBM-Dokumentation die Standards ISO9241 or DIN66234.
:p.In jngerer Zeit wird gern die Schriftart "8.Helv" fr Dialoge eingesetzt.
Durch Auswahl von "Kleine Schrift" wird diese in allen Dialogen verwendet.
:p.:hp2.Schaltflchen:ehp2.
:p.Da die Schaltflchen der Werkzeugleiste Funktionalitt besitzen mssen,
die von den Standardsteuerelementen nicht untersttzt wird, implementiert
Maul die Schaltflchen der Werkzeugleiste ber eigendefinierte Steuerelemente.
:p.Es stehen vier verschiedene Stile fr die Darstellung der Schaltflchen
zur Verfgung&colon.
:ul.
:li.Flache Schaltflchen besitzen keine Umrandung, wenn sich der Mauszeiger nicht darber befindet.
:li.Bei den leichten Schaltflchen handelt es sich um sehr flachen Schaltflchen, die
bei frheren Maul-Versionen standardmig verwendet wurden.
:li.Retro-Schaltflchen besitzen ein tellerfrmiges Aussehen und hneln den Standardschaltflchen
von eComStation.
:li.Pluto-Schaltflchen sind gewlbt mit abgerundeten Kanten.
:eul.
:p.:hp2.Tooltips:ehp2.
:p.Durch die Option 'Tooltips aktivieren' werden kleine Hilfstexte am Mauszeiger
eingeblendet, wenn sich dieser ber einer Schaltflche oder einem anderem 
Bildschirmelement befindet.
:p.:hp2.Grenzen:ehp2.
:p.Ausgeschlossene Objektgrenzen werden standardmig anhand jedes zweiten Punkts entlang der
Hhe eines Textes berechnet. Die 'Schnelle Grenzwertberechnung' ndert dieses
Verfahren so ab, da nur noch drei Berechnungsgrundlagen (Oberkante, Mitte und
Unterkante des Textes) verwendet werden. Die Przision ist bei diesem Verfahren
etwas geringer (der Text kann dann unter Umstnden ber die Kanten 
ausgeschlossener Objekte laufen), aber es arbeitet erheblich schneller.
Enthlt das Dokument nur Rechtecke oder leicht gekrmmte Kurven, kann diese Option
ohne Bedenken aktiviert werden. Andernfalls sollten Sie berprfen, ob Text
nicht ber ausgeschlossene Objekte hinausluft.
:p.:hp2.Druckauftrge:ehp2.
:p.Deaktivieren Sie diese beiden Optionen bitte nur, wenn es zu Problemen beim Drucken 
kommt.
:p.Die Druckfortschrittsanzeige ist ein einfaches Fenster, mit dessen Hilfe sich ein
Druckauftrag abbrechen lt. Ist sie deaktiviert, kann ein Druckauftrag immer noch
abgebrochen werden, indem die Taste Escape einen Moment lang gedrckt gehalten wird.
:p.Dynamische Druckauftrge dienen dazu, fr das gegenwrtige Dokument die korrekten
Jobmerkmale auszuwhlen. Ist diese Option deaktiviert, mssen Sie bei jedem Ausdruck eines
Dokuments die "Jobmerkmale" im Dialog "Drucken..." festlegen. Bei mit lteren Maul-Versionen
erstellten Dokumenten sollte man erst die Seiteneinstellungen zurcksetzen und dann das Dokument
vor dem Ausdrucken neu speichern.
.br
.br
.******************************************************************************
:h2 res=96 id=96 global.Tastenkrzel
:i2 refid=options.Tastenkrzel
:p.:hp2.Anpassen der Tastenkrzel:ehp2.
:p.Durch Auswahl von 'Tastenkrzel bearbeiten...' lassen sich die verfgbaren Tastenkrzel
anpassen.
:p.Whlen Sie einen Handler oder das Hauptprogramm aus, indem Sie den entsprechenden Reiter des Notizbuches auswhlen.
Whlen Sie anschlieend einen Meneintrag im linken Listenfeld aus. Durch Auswahl eines Meneintrags wird im rechten
Listenfeld und den zugeordneten Markierungsfeldern das entsprechende Tastenkrzel angezeigt.
:p.Als nchstes sind die geeigneten Markierungsfelder fr Strg, Alt oder Umschalttaste auszuwhlen, mit denen festgelegt wird, welche Tasten
gleichzeitig mit der eigentlichen Taste zu drcken sind.
:p.Als letztes whlen Sie die gewnschten Krzeltaste.
:p.Whrend die Einstellungen angepat werden, berprft das Programm, ob die Auswahl nicht bereits verwendet wird. Dies kann
dazu fhren, da die Markierungsfelder erst nach Auswahl von <keins> gendert werden knnen.
:p.Beachten Sie, da Tastenkombinationen nach der Auswahl als Tastenkrzel fr einen Handler nicht mehr zum Eingeben von Text verfgbar sind.
:p.Maul enthlt sehr viele Meneintrge; Sie sollten nderungen also sorgfltig planen.
Die neuen Tasteneinstellungen werden im allgemeinen Anwenderpfad in einer Datei namens
'maulkeys.act' gesichert. Es zahlt sich aus, wenn man vor greren nderungen eine Sicherheitskopie
dieser Datei anfertigt.
:p.Sie werden feststellen, da manche Tastenkrzel gesperrt sind. Zu den offensichtlichen gehren
Strg+Alt+Entf und hnliche. Andere sind ebenfalls gesperrt, aber es kann eine zustzliche Kombination
hinzugefgt werden. Hierbei handelt es sich um die Tastenkrzel fr Kopieren, Ausschneiden, Einfgen
und Lschen.
:p.Bei Bettigung der Schaltflche 'Alle zurcksetzen' ldt das Programm die eingebauten Tastenkrzel
und sichert sie in der Datei 'maulkeys.act'. Da hierdurch smtliche angepaten Einstellungen zurckgesetzt
werden, erfolgt eine Sicherheitsabfrage.
.br
.br
.******************************************************************************
:h2 res=91 id=91 global.Raster aktivieren
:i2 refid=options.Raster aktivieren
:p.Der Meneintrag 'Raster aktivieren' aktiviert das automatische Einrasten von Rahmengrenzen
in Seitengrenzen, Hilfslinien, Abmessungen usw. Das Raster ist standardmig aktiviert.
:p.Wenn das Raster deaktiviert ist, knnen Figuren mit beliebiger Form hergestellt werden, wobei
jedoch eventuell nicht die erforderliche Genauigkeit gegeben ist.
:p.Sie knnen das Raster momentan deaktivieren, indem Sie die Leertaste gedrckt halten.
.br
.br
.******************************************************************************
:h2 res=92 id=92 global.Rastereinstellungen
:i2 refid=options.Rastereinstellungen
:p.Mit Hilfe des Dialogs 'Rastereinstellungen' lt sich festlegen, wie der Maus-Cursor in die
diversen verfgbaren Unterteilungen eingerastet wird.
:p.Bei Drcken von 'OK' werden die in diesem Dialog vorgenommenen Einstellungen in der Datei
gesichert. Auf diese Weise sind verschiedene Einstellungen fr verschiedene Dokumente mglich.
:p.Sollen die Einstellungen auf alle neuen Dokumente angewendet werden, drcken Sie die Schaltflche
'Sichern'. Dadurch werden die Einstellungen in das Initialisierungsprofil oder die Registrierdatenbank
geschrieben und alle neuen Dokumente bernehmen diese Voreinstellungen.
:p.:hp2.Einrasten in...:ehp2.
:p.Es kann in Gitterlinien und Grenzen, die derzeitigen Maheiten der
:link reftype=hd res=803.Lineale:elink., in benutzerdefinierter Markierungen oder alles
gleichzeitig eingerastet werden.
:p.:hp2.Maeinheiten...:ehp2.
:p.Wird das Einrasten in Maeinheiten aktiviert, gibt es auf dem derzeigen Linealmodus basierende
Wahlmglichkeiten.
:p.:hp2.Rasterweite:ehp2.
:p.Legen Sie eine Rasterweite fest, bevor Sie den Cursor auf eine feste Position einrasten lassen.
Rasterweite, Druckerpunkten pro Zoll und Rastertyp beeinflussen sich mitunter, weswegen es notwendig
werden kann, ein wenig herumzuprobieren.
:p.:hp2.Benutzerdefinierte Markierungen:ehp2.
:p.Durch Anklicken der Lineale knnen horizontale und vertikale benutzerdefinierte Markierungen
erzeugt werden. Damit lt sich beispiesweise eine Reihe von Figuren anordnen. Siehe
auch&colon.
:p.:link reftype=hd res=803.Die Lineale:elink.
.******************************************************************************
.*  Help Menu
.******************************************************************************
:h1 res=110 id=110 global.Men 'Hilfe'
:i1 id=help.Men 'Hilfe'
:p.:hp2.Kontextabhngiges Hilfesystem:ehp2.
:p.Maul Publisher verwendet ein kontextabhngiges Hilfesystem, welches nicht nur fr das Hauptprogramm, sondern auch
smtliche derzeit installierten Handler Hilfe bereitstellt. ber 'Inhalt der Hilfe' und 'Hilfeindex' werden
beispielsweise stets die entsprechenden Seiten des gerade ausgewhlten Handlers angezeigt. Durch Anklicken
eines leeren Teils des Hauptfensters kann die Handler-Auswahl zurckgenommen werden. Dabei werden smtliche
Rahmen deselektiert. Whlt man nun den Meneintrag 'Inhalt der Hilfe', wird das Inhaltsverzeichnis fr das
Hauptprogramm angezeigt. Das Hilfemen zeigt stets den Namen des Handlers an, dessen Hilfe gerade aktiv ist.
:artwork name='adaphlp.bmp' align=left.
:p.:hp2.Tricks&colon. Zugriff auf weitere Hilfethemen:ehp2.
:p.Plazieren Sie den Cursor ber einem Lineal, der Statuszeile oder der Werkzeugleiste und drcken Sie F1. Sie erhalten dann
Hilfestellung zum unter dem Cursor befindlichen Objekt.
:p.Hilfe zu bestimmten Schaltflchen der Werkzeugleiste kann durch Bewegen des Cursors auf die Schaltflche
aufgerufen werden. Das Hilfefenster der Statusleiste zeigt dann eine Kurzhilfe fr diese Schaltflche an.
Mit F1 kann eine ausfhrlichere Hilfe zur Schaltflche angezeigt werden.
:p.:hp2.Tricks&colon. Hilfe zu Meneintrgen:ehp2.
:p.Um Hilfe zu einem Meneintrag zu erhalten, mu der Meneintrag hervorgehoben werden. Man sollte den Meneintrag
jedoch nicht anklicken, bis man die Hilfeseite gelesen hat.
:p.Durch Anklicken eines beliebigen Untermens erhlt das Men den Fokus. Probieren Sie dies einmal mit dem Untermen
'Ansicht' aus. Bewegen Sie die Menauswahl mit Hife der Cursor-Tasten auf einen Meneintrag. Mit diesen Tasten ist es
mglich, jeden beliebigen Meneintrag oder ein Untermen anzusteuern und hervorzuheben. Drcken Sie dann F1, um Hilfe
zum Meneintrag zu erhalten.
:p.Indem nicht die Maus verwendet wurde, konnte die Auswahl des Meneintrags vor dem Hilfeaufruf vermieden werden.
Dieser Trick sollte bei den meisten OS/2-Programmen funktionieren.
.br
.br
.******************************************************************************
:h2 res=113 id=113 global.Hilfe fr 'Wie kann ich'-Hilfeeintrge
:i2 refid=help.Hilfe fr 'Wie kann ich'-Hilfeeintrge
:p.Das Untermen 'Wie kann ich' ist ein einfaches Hilfemarkierungssystem, das in der Lage ist,
die wichtigsten Hilfethemen der diversen Handbcher des Maul Publisher neu zu gruppieren.
:p.Auch eigene Hilfethemen lassen sich hier einfgen. Dazu mu die Textdatei
'favorite.txt' bearbeitet werden, die sich im Unterverzeichnis 'etc' des Maul-Installationsverzeichnisses
befindet. Alternativ kann der Dialog '"Wie kann ich"-Hilfe hinzufgen' benutzt werden.
:p.:hp2.'Wie kann ich'-Thema mit einem Texteditor hinzufgen:ehp2.
:p.Bei der Datei 'favorite.txt' handelt es sich um eine einfache Textdatei, die eine Zeile fr jeden
Eintrag des Mens 'Wie kann ich' enthlt. Eintrge im Men 'Wie kann ich' knnen nur in ihrer
Position verndert oder gelscht werden, indem Maul beendet und die Datei von Hand bearbeitet wird.
:ul.
:li.Mit < beginnende Zeilen sind Kommentare.
:li.Mit > beginnende Zeilen sind Meneintrge und bestehen aus fnf durch Kommata getrennten Eintrgen.
:li.Eintrge, die selbst Kommata enthalten, knnen durch Setzen in Anfhrungszeichen benutzt werden.
:eul.
:p.Folgende Zeile zeigt die fnf Eintrge...
.br
>name, typ, hilfeid, titelid, bibliotheksid
:p.Diese Eintrge werden wie folgt verwendet&colon.
:ol.
:li.:hp2.name:ehp2.. Diese Zeichenkette erscheint als Meneintrag.
:li.:hp2.typ:ehp2.. Kann die Bezeichnung eines Handlers sein, wie etwa "CONTENTS, Plain text".
Achten Sie auf die Verwendung der Anfhrungszeichen, denn die Zeichenkette enthlt ein Komma!
Wird dieser Eintrag leer gelassen, wird angenommen, da es sich um das Haupthandbuch
'Nutzung des Maul Publisher' handelt. Schlielich kann hier durch Voranstellen eines "!"
eine beliebige Hilfedatei angegeben werden, wie z.B. in '!maul.hlp'.
:li.:hp2.hilfeid:ehp2.. Die numerische Ressourcenkennung der gewnschten Hilfeseite.
:li.:hp2.titleid:ehp2.. Die numerische Ressourcenkennung eines Titels. Fr alle Handler
ist hier ein eindeutiger Wert erforderlich.
:li.:hp2.bibliotheksid:ehp2.. Die numerische Ressourcenkennung einer Hilfebibliothek. Fr alle Handler
ist hier ein eindeutiger Wert erforderlich.
:eol.
:p.Die originale Datei 'favorite.txt' enthlt Kommentare, welche die korrekten Ressourcenkennungen
aller Handler sowie des Hauptprogramms auffhren. Wenn eine Hilfedatei direkt angegeben wird, sollten
titelid und bibliotheksid auf -1 gesetzt werden.
:p.:hp2.'Wie kann ich'-Eintrag ber Dialog hinzufgen:ehp2.
:p.Derzeit funktioniert dieser Dialog nur mit dem originalen VIEW-Betrachter von IBM. Bei Nutzung von NEWVIEW, das mit
eComStation 1.2 ausgeliefert wird, funktioniert der Dialog nicht. Es steht zu hoffen, da dem in angemessener Zeit Abhilfe geschafft werden kann.
:p.Der Dialog stellt das einfachste Verfahren dar, dem Men 'Wie kann ich' neue Eintrge hinzuzufgen. Das
Men bleibt deaktiviert, bis die hinzuzufgende Hilfeseite geffnet worden ist. Inhaltsverzeichnisse und
Indexseiten knnen dem Men 'Wie kann ich' nicht hinzugefgt werden.
:p.Bei ffnen des Dialogs werden alle Eintrge ordnungsgem ausgefllt. Es empfiehlt sich,
die Beschreibung in etwas aussagekrftigeres zu ndern.
:p.Drcken Sie 'OK', um den Hilfeeintrag an das Ende des Mens 'Wie kann ich' anzufgen.
:p.Zum Lschen oder ndern der Reihenfolge der Eintrge mu Maul beendet und die Datei 'favorite.txt'
von Hand bearbeitet werden.
.br
.br
.******************************************************************************
:h2 res=111 id=111 global.Hilfe zu Tasten
:i2 refid=help.Hilfe zu Tasten
:p.Fr Maul stehen folgende Tastenkrzel zur Verfgung. Es werden die gebruchlichsten Tastenkrzel aufgefhrt, jedoch
keine Tastenkrzel, die fr andere Handler spezifisch sind. Whlen Sie einen Rahmen und Handler aus, fr die Sie Informationen
bentigen und rufen Sie die Hilfe nochmals auf. Das Hilfemen zeigt an, zu welchem Handler die geffnete Hilfe gehrt.
:p.Ist kein Rahmen ausgewhlt, so wird diese Tastenhilfe fr das Hauptprogramm des Maul Publisher angezeigt.
:p.Bitte beachten Sie, da Sie diese Tasten ndern knnen und da hier nur die Standardeinstellungen angezeigt werden.
:p.:hp2.Allgemeine Tastenbelegung:ehp2.
:p.Beachten Sie, da Maul zwischen Alt, Umschalt-Alt sowie Alt und AltGr unterscheidet. Wenn die Tastatur nicht mit
einer AltGr-Taste ausgestattet ist, mu eine andere Tastaturbelegung gewhlt werden, um erweiterte Zeichenkodierungen
verwenden zu knnen. Bei der Tastenbelegung USA (103) kann auf die Tastenbelegung USA International (103i) (OS/2 - ux)
umgeschaltet werden. Weitere Informationen entnehmen Sie bitte dem Warp-4-Handbuch 'Tastaturen und Zeichenstze'
(Bestellnr. 29H3183, S29H-3183-00).
:p.Ist eine AltGr-Taste vorhanden, knnen erweiterte Zeichen entweder direkt oder durch Gedrckthalten der AltGr-Taste
und Eingabe des dezimalen Zeichenkodes ber den Zahlenblock eingegeben werden. AltGr+98 entspricht beispielsweise 'b'.
Dieses Verfahren sollte unabhngig vom Status der Taste NumLock funktionieren. (Momentan leider defekt!)
:p.Wenn Sie die Tastaturbelegung nicht ndern knnen, knnen Sie stattdessen den Dialog 'Zeichen einfgen...'
des Text-Handlers verwenden, um beliebige Zeichen einer Schriftart einzufgen.
:p.Hierbei handelt es sich um die Standardeinstellungen, die mit Hilfe des Dialogs
:link reftype=hd res=96.Tastenkrzel auswhlen:elink. angepat werden knnen.
:ol.
:li.:hp2.Menauswahl:ehp2.
:dl compact tsize=16.
:dt.Alt+B:dd.Men 'Bearbeiten'
:dt.Alt+D:dd.Men 'Datei'
:dt.Alt+H:dd.Men 'Hilfe'
:dt.Alt+O:dd.Men 'Optionen'
:dt.Alt+S:dd.Men 'Seite'
:dt.Alt+W:dd.Men 'Widerrufen'
:dt.Alt+A:dd.Men 'Anzeige'
:dt.Alt+U:dd.Umschalten zu (Umschaltliste)
:edl.
:li.:hp2.Men 'Datei':ehp2.
:dl compact tsize=16.
:dt.Strg+N:dd.Neue Datei
:dt.Strg+:dd.Datei ffnen...
:dt.Strg+I:dd.Importieren...
:dt.Strg+X:dd.Exportieren...
:dt.Strg+S:dd.Datei sichern
:dt.Strg+A:dd.Datei sichern unter...
:dt.Strg+R:dd.Datei drucken...
:edl.
:li.:hp2.Men 'Seite':ehp2.
:dl compact tsize=16.
:dt.Strg+P:dd.Seitendruckeinstellungen...
:dt.Strg+M:dd.Rnder und Gitter...
:dt.Strg+Umschalt+M:dd.Seitenvorlage verwenden...
:dt.Strg+T:dd.Seitenvorlage sichern/lschen
:dt.Alt+Umschalt+Entf:dd.Eine Seite kopieren
:dt.Alt+Umschalt+Einfg:dd.Eine Seite aus der Zwischenablage einfgen
:dt.Strg+Umschalt+I:dd.Eine neue Seite einfgen
:dt.Strg+Umschalt+J:dd.Eine neue erste Seite einfgen
:dt.Strg+Umschalt+D:dd.Eine Seite lschen
:dt.Alt+G:dd.Gehe zu Seite
:dt.Strg+Umschalt+N:dd.Nchste Seite
:dt.Strg+Umschalt+P:dd.Vorherige Seite
:edl.
:li.:hp2.Men 'Anzeige':ehp2.
:dl compact tsize=16.
:dt.Strg+1:dd.Seitenanzeige Drucker
:dt.Strg+2:dd.Seitenanzeige
:dt.Strg+3:dd.Auf Breite anpassen
:dt.Strg+4:dd.Wirkliche Gre
:dt.Strg+Plus:dd.Vergrern
:dt.Strg+Minus:dd.Verkleinern
:dt.Strg+F:dd.Rahmenbearbeitungsmodus
:dt.Strg+C:dd.Inhaltsbearbeitungsmodus
:dt.Strg+G:dd.Hintergrundbearbeitungsmodus
:dt.Strg+B:dd.Umrandungsbearbeitungsmodus
:edl.
:li.:hp2.Men 'Widerrufen':ehp2.
:dl compact tsize=16.
:dt.Alt+Backspace:dd.Letzte nderung widerrufen
:dt.Strg+Backspace:dd.Letzte nderung wiederholen
:dt.Strg+U:dd.Widerrufsliste...
:edl.
:li.:hp2.Men 'Optionen':ehp2.
:dl compact tsize=16.
:dt.Strg+Umschalt+R:dd.Druckereinstellungen...
:dt.Strg+E:dd.Raster aktivieren
:dt.Strg+Umschalt+S:dd.Rastereinstellungen...
:edl.
:li.:hp2.Men 'Hilfe':ehp2.
:dl compact tsize=16.
:dt.Strg+H:dd.Inhaltsverzeichnis
:dt.Strg+Umschalt+H:dd.Hilfeindex
:dt.Strg+K:dd.Hilfe fr Tasten
:dt.Strg+L:dd.Alle Handler anzeigen
:dt.Strg+Z:dd.Produktinformation...
:edl.
:eol.
.******************************************************************************
:h2 res=112 id=112 global.Hilfe fr Handler
:i2 refid=help.Hilfe fr Handler
:p.Um Hilfe zu einem Handler zu erhalten, lassen Sie durch Auswahl des Meneintrags 'Handler auflisten'
die installierten Handler anzeigen. Whlen Sie dann einen Handler aus und drcken Sie 'Hilfe'.
:p.Maul besteht aus einer Sammlung von Handlern, die jeweils eine bestimmte Aufgabe erfllen.
Alle auer dem Null- und dem Seiten-Handler befinden sich in separaten Modulen, die nach Belieben
hinzugefgt und entfernt werden knnen. Der zum Lieferumfang Mauls gehrende Satz Standard-Handler
reicht fr grundliegende Aufgaben des Desktop Publishing aus. Natrlich ist es mglich, Maul weitere Handler
hinzuzufgen, wenn und falls diese verfgbar werden. Wenn Sie Entwickler sind, knnen Sie sogar
eigene herstellen.
:p.Die zur Herstellung eigener Handler erforderlichen Informationen erhalten Sie unter
.br
:link reftype='launch' object='netscape.exe' data='http://www.manglais.com/subs/signup.html'.
http&colon.//www.manglais.com/subs/signup.html:elink..
.br
Entwickler mssen ihren Namen und ihre E-Mail-Adresse hinterlassen, damit sie mit Neuigkeiten
versorgt werden knnen.
.br
.br
.******************************************************************************
:h2 res=115 id=115 global.Programmstatistik
:i2 refid=help.Programmstatistik
:p.Durch Auswahl des Meneintrags 'Hilfe->Statistik' erhalten Sie
Informationen ber Interna des von Maul Publisher genutzten Speichers.
:p.Titel der Benachrichtigung ist der aktuelle Dateiname.
:p.Informationen werden zu folgendem angezeigt:
:ul.
:li.Name des erforderlichen Druckers.
:li.Name und Einzelheiten des erforderlichen Druckformulars.
:li.Anzahl der Seiten, Rahmen und Objekte im Dokument.
:li.Ausrichtung und Qualittseinstellungen des erforderlichen
Druckerformulars.
:li.Informationen ber Schwierigkeiten, die mit diesem Drucker
auftauchen knnten.
:li.Gesamte Speichermenge, die jedem Speicherpuffer zur Verfgung
steht. Maul verwendet zwei groe Speicherpuffer. Einen, der die
Dateidaten und den Puffer zum Rckgngigmachen aufnimmt, und einen
weiteren, der temporre Informationen fr Import, Export, Drucken,
Zeichnen usw. enthlt. Von Zeit zu Zeit knnen kleine Speicherblcke
alloziert werden (mit malloc und free).
:li.Die Gre des Dateipuffers. Die Gre des Dateipuffers betrgt die
Gre der Datei zuzglich der Gre des Puffers fr das
Rckgngigmachen.
:li.Gre des Arbeitspuffers (normalerweise Null, da dieser nur fr
temporre Daten verwendet wird).
:li.Gre des Puffers fr das Rckgngigmachen.
:li.Gre der Datei.
:eul.
.br
.br
.******************************************************************************
.*  Switch List
.******************************************************************************
:h1 res=100 id=100 global.Die Umschaltliste
:i1 id=switchlist.Die Umschaltliste
:p.Maul erlaubt das Umschalten zu anderen Programmen. Statt eines Multidokument-Interface (MDI) nutzt
Maul die Vorteile der Multitasking-Umgebung von OS/2 Warp. Maul kann - wie jedes andere Programm auch - beliebig oft
gestartet und es kann zwischen den Programmen ber die Umschaltliste hin- und hergeschaltet werden. Bei Auswahl eines
Meneintrages aus der Umschaltliste wird die Kontrolle sofort an das entsprechende Programm bergeben. Der Eintrag der
derzeitigen Sitzung ist deaktiviert, da eine Sitzung nicht die Kontrolle an sich selbst bergeben kann.
:p.Besitzt eine andere Anwendung keine Umschaltliste, so kann eine solche durch gleichzeitiges Klicken mit der linken
und rechten Maustaste auf einen leeren Bereich der Arbeitsoberflche oder durch Drcken der Tastenkombination
Strg+Esc aufgerufen werden. Aber das wissen Sie wahrscheinlich schon.
:p.:hp2.Entspannen Sie sich, das tut nicht weh!:ehp2.
:artwork name='syringe.bmp' align=left.
:p.Zuerst mgen Sie den Eindruck haben, da das mehrmalige Betreiben eines Programms zur gleichen Zeit
extrem viel Speicherressourcen verbraucht. Tatschlich sieht die Wahrheit vollkommen anders aus.
:p.Wenn Warp eine zweite Instanz eines Programms startet, wird nur ein neuer Datenbereich initialisiert.
Derselbe ausfhrbare Code wird so oft wie ntig erneut genutzt. Dies ist mglich, weil alle modernen Compiler
sogenannten 're-entrant' Code erzeugen. Selbiges gilt fr Ressourcen wie Dialoge usw.; sie mssen nur einmal in
den Speicher geladen werden. Die Anwendung mu sich nicht darum kmmern, mit welchem Datenbereich sie gerade arbeitet
und wird dadurch viel einfacher, schneller und kleiner.
:p.Werden mehrere Instanzen eines Programms betrieben, so wird nur zwischen den Daten- und Stack-Zeigern umgeschaltet.
Technisch gesehen ist dies wesentlich effektiver als ein Multidokument-Interface. OS/2 Warp ist beim Handling
mehrerer Dokumente weit besser, als es jedes MDI jemals sein knnte. Desweiteren laufen alle Instanzen eines Programms
weiter, d.h. whrend man im Vordergrund etwas bearbeitet, knnte ein anderes Programm im Hintergrund drucken. Sollte eines
der Programme aus irgendeinem Grund abstrzen, wirkt sich dies i.a. nicht auf die anderen aus.
.br
.br
.******************************************************************************
.*
.*
.*
.*  Dialog Item Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  Color dialog
.******************************************************************************
:h1 res=200 id=200 global.Farbe bearbeiten (Standard-Handler)
:i1.Farbe bearbeiten (Standard-Handler)
:artwork name='edswatch.bmp' align=left.
:p.Diesen Dialog erreicht man ber den Dialog :link reftype=hd res=201.Farbe auswhlen:elink.. Sie
knnen es auch erreichen indem Sie auf eine blanke portion der :link reftype=hd res=204.Farbpalette:elink.
doppelklicken.
:p.Mit Hilfe dieses Dialogs kann eine Farbe direkt bearbeitet werden. Zur Festlegung der gewnschten Farbe kann
jede beliebige Mischung aus rot, grn und blau benutzt werden. Das an der linken Seite des Dialogs befindliche,
farbige Rechteck steht fr Vergleichszwecke zur Verfgung.
:p.Nutzen Sie eine Kombination der Schieberegler Helligkeit, Sttigung und Ton zur Auswahl der Farbe und anschlieend
die Drehknpfe rot, grn und blau zur Feineinstellung.
:p.:hp2.Farbpipette:ehp2.
:p.Durch Drcken der Schaltflche :artwork name='syringebut.bmp' runin. ndert sich der Mauszeiger in ein Fadenkreuz.
Farben lassen sich an belieger Stelle auf dem Bildschirm mit einem Mausklick aufnehmen.
:p.Farben setzen sich hufig aus einer Mischung ungleicher Farben zusammen, so da die Aufnahme nur eines Bildpunktes vom
Bildschirm ungeeignet ist. Ziehen Sie statt dessen mit der linken Maustaste ein Fangrechteck auf. Durch Loslassen der Taste
wird als Ergebnis die Durchschnittsfarbe des ausgewhlten Rechtecks zurckgegeben. Diese Funktion ist besonders beim Ermitteln
von Farben aus Bildern hilfreich.
:p.:hp2.Benennung von Farben:ehp2.
:p.Mit Hilfe des ausklappbaren Listenfelds knnen Farben unter Namen abgespeichert werden. Dazu berschreibt man den
automatisch vergebenen einfach mit einem eigenen Namen und bettigt die Schaltflche 'Hinzufgen'. Wurde eine benannte
Farbe vorher gesichert, kann sie ausgewhlt und entfernt werden.
:p.:hp2.Schmuckfarben:ehp2.
:p.Benannte Farben knnen als Schmuckfarben markiert werden. Wenn es der Farb-Handler untersttzt, knnen fr Schmuckfarben
eigene Farbauszge erstellt werden. Benannte Farben werden als Prozefarben (gemischt) ausgegeben, es sei denn, man legt ber
die Liste 'Anzeigen als' eine Ersatzfarbe fest. Bei der Erstellung von Farbauszgen wird fr die Schmuckfarbe dann unter
Verwendung der Ersatzfarbe ein eigener Farbauszug ausgegeben.
:p.Derzeit untersttzt Maul keine Farbverlufe mit Schmuckfarben. Schmuckfarben sollten also einfachen Fllungen
vorbehalten bleiben.
:p.Benannte Farben werden einschlielich der Schmuckfarben innerhalb des Dokumentes gespeichert, damit das Dokument
austauschbar bleibt. Die Informationen der :link reftype=hd res=204.Farbpalette:elink. knnen jedoch auch in
einer separaten Datei gesichert werden.
:p.:hp2.Drucken:ehp2.
:p.Beachten Sie, da Ihr Drucker wahrscheinlich nicht in der Lage ist, jede Farbe des RGB-Spektrums darzustellen,
da Drucker fr gewhnlich mit dem CMYK-Spektrum arbeiten, welches etwas weniger Farben umfat. Wenn kein Farb-Handler
installiert ist, knnen keine Farbauszge erstellt werden. Schmuckfarben werden nur bei der Erstellungen von Farbauszgen
als solche behandelt, ansonsten wie normale Farben.
.******************************************************************************
.*  Color list dialog
.******************************************************************************
:h1 res=201 id=201 global.Farbe auswhlen (Standard-Handler)
:i1.Farbe auswhlen (Standard-Handler)
:artwork name='selcol.bmp' align=left.
:p.Dieser Dialog verwendet ein etwas ungewhnliches Verfahren der Farbauswahl. Grundstzlich werden mit der
linken Maustaste Vordergrund- und mit der rechten Maustaste Hintergrundfarben ausgewhlt. Dies trifft
natrlich nur zu, wenn die Belegung der Maustasten nicht gendert wurde!
:p.Ist eine ganz andere Farbe erwnscht, kann diese ber den Farbkreis ausgewhlt werden. Abhngig von der
bettigten Maustaste wird die entsprechende Farbe aktualisiert.
:p.Soll eine gegebene Farbe nur abgedunkelt oder aufgehellt werden, kann die gewnschte Farbe aus dem Farbband
auf der rechten Seite ausgewhlt werden.
:p.Klicken mit der linken Maustaste auf das Farbband whlt eine Vordergrund-, Klicken mit der rechten
Maustaste eine Hintergrundfarbe aus.
:p.Der letzte Eintrag des Farbbands ist immer die Farbe 'transparent'. Diese Farbe kann nicht von allen
Handlern benutzt werden.
:p.Im oberen Bereich des Dialogs befindet sich ein Listenfeld, das die Farbnamen der derzeit geladenen
:link reftype=hd res=204.Farbpalette:elink. anzeigt (soweit vorhanden).
:p.Die farbigen Rechtecke in der rechten unteren Ecke des Dialogs zeigen die ausgewhlte Vorder- und Hintergrundfarbe
an. Durch Anklicken des gewnschten Rechtecks mit der linken Maustaste lassen sich die RGB-Komponenten der
Farbe des Rechtecks :link reftype=hd res=200.direkt bearbeiten:elink. sowie benannte Farben
laden und sichern.
:p.Beachten Sie, da die Farbe 'transparent' nicht bearbeitet werden kann (angezeigt durch ein Verlaufsmuster).
Mit Hilfe der Doppelpfeil-Schaltflche lassen sich Vorder- und Hintergrundfarbe vertauschen.
:p.:hp2.Siehe auch:ehp2.
:p.:link reftype=hd res=200.Farbe bearbeiten:elink.
:p.:link reftype=hd res=204.Farbpaletten laden und sichern:elink.
.br
.br
.******************************************************************************
.*  Common Stylesheets dialog
.******************************************************************************
:h1 res=205 id=205 global.Allgemeine Stilvorlagen
:i1.Allgemeine Stilvorlagen
:p.Maul verwendet ein allgemeines Stilvorlagenformat zur Speicherung von Stilen. Allgemeine Stilvorlagen
besitzen eine hierarchische Speicherstruktur&colon.
:ul.
:li.Stilvorlagen werden in Stildateien mit der Endung '.ssh' gesichert.
:li.Jede Stildatei kann mehrere Stilvorlagen enthalten.
:li.Jede Stilvorlage kann eine Mischung aus Stilen und Stilvorlagen enthalten.
:eul.
:p.In der Praxis bedeutet dies, da eine einzige Stilvorlage sowohl Stile fr den Hintergrund als auch
fr Text enthalten kann. Bei der Anwendung eines Stils wird die korrekte Stilvorlage aus der Datei gelesen.
:p.Eine Stilvorlage kann Kindstilvorlagen enthalten. Auf diese Weise kann beispielsweise eine Rahmenstilvorlage
Stilvorlagen fr Objekte wie Text, Hintergrnde, Umrandungen usw. enthalten. Ist der Umrandungs-Handler ausgewhlt,
kann der Umrandungsstil basierend auf der Umrandungs-Kindstilvorlage des Rahmenstils festgelegt werden.
Diese Funktion bleibt dem Anwender fast vollstndig verborgen.
:p.Wird eine neue Stilvorlage fr eine Umrandung in der gleichen Datei gespeichert, die obige Rahmenstilvorlage
enthlt, so wird die neue Umrandungsstilvorlage vom Umrandungs-Handler gelesen und die alte Umrandungs-Kindstilvorlage
vom Rahmen-Handler.
:p.Mit anderen Worten knnen Kindstilvorlagen nicht gelscht oder modifiziert, aber fr den entsprechenden Objekt-Handler
bersteuert werden.
:p.Im Dialog Allgemeine Stilvorlagen werden Kindstilvorlagen von ihren Elternstilvorlagen eingerckt dargestellt.
Es ist mglich, da mehrere Stilvorlagen mit demselben Namen angezeigt werden, und jedes besitzt ein entsprechendes
Symbol, welches anzeigt, zu welchem Handler es gehrt. Neue Stilvorlagen werden stets am Anfang der Stildateien
hinzugefgt, so da neue Stile ltere berschreiben.
:p.Mache Handler erlauben es, einen Standardstil festzulegen. Ist ein solcher Standard voreingestellt, wird der Stil
sofort angewendet, wenn der Handler sein Objekt erzeugt hat. Anstatt nach der Umrandungsbreite zu fragen, wendet
der Umrandungs-Handler sofort den ausgewhlten Standardstil an.
.br
.br
.******************************************************************************
.*  Print form dialog
.******************************************************************************
:h1 res=202 id=202 global.Bearbeiten eines Druckerformulars
:i1.Bearbeiten eines Druckerformulars
:p.Druckerformulare stellen eine Mglichkeit dar, Maul mitzuteilen, wie das Druckformat aussehen soll.
Dies gilt sogar, wenn der Drucker ein solches Format nicht untersttzt. Die Daten des
neuen Druckerformulars werden aus dem aktuellen bernommen. Alle Dokumente speichern Daten ber ihr
eigenes Druckerformular und leiten daraus die Seitengre und evtl. vorzunehmende Skalierungen ab.
:p.Druckerformulare werden :hp2.nicht beim Endausdruck eines Dokumentes benutzt:ehp2.. Sie dienen dazu,
ein Papierformat fr einen Drucker zu erstellen, den man nicht besitzt. Beim Ausdruck des Dokuments ist
dann ein echtes Format zu whlen, das dem Druckertreiber bekannt ist. Mit Druckerformularen lt sich der
Skalierungsmechanismus dazu berlisten, das Dokument beim Ausdruck neu zu skalieren. Dies ist jedoch nicht
zu empfehlen, wenn man nicht genau wei, was man tut.
:p.Betrachten wir folgendes Beispiel&colon.-
:fig.
Eine A4-Druckseite im Querformat hat 2400 x 3357 pels und 300 dpi.
Die Gre betrgt 210mm x 297mm.
Die linken und oberen Rnder betragen jeweils 11.76mm und 3.4mmm.
:efig.
:p.Legt man die Gre auf 21.0mm x 29.7mm, die linken und oberen Rnder auf 1.176mm und 0.34mm und die x- und y-Werte fr dpi auf 3000
fest, wird dadurch eine Seite von der ungefhren Gre einer Briefmarke definiert.
:p.Druckt man dies auf einem A4-Blatt aus, skaliert das System alles auf die gewnschte Gre herunter. Denken Sie bitte
daran, da es sich hier um :hp1.Schummelei:ehp1. handelt.
:p.:hp2.Formulare:ehp2.
:p.Druckerformulare sind speicherresidente, echte Dateien, die nach Wunsch gesichert und gelscht werden knnen.
Sie werden im allgemeinen Anwenderpfad abgelegt. Anfnglich erhlt das Druckerformular einen Standardformularnamen.
Man sollte Formularen einen neuen Namen geben, wenngleich es auch mglich ist, bereits vorhandene Formulare
zu berschreiben.
:p.Nach Erstellung eines Druckerformulars zeigt der Dialog "Druckereinstellungen" dieses Formular im Listenfeld an.
Wenn man zur Festlegung der Dokumentform ein Druckerformular verwendet, wird der Dialog "Druckerformular" auch
fr den Dialog "Druckereinstellungen" benutzt.
:p.:hp2.Abmessungen:ehp2.
:p.Die Gre der Druckseite und ihre nicht bedruckbaren Rnder entsprechen der tatschlichen Gre des
Blatts Papier, auf das gedruckt wird. Viele Drucker sind nicht in der Lage, bis ganz an den Rand der
Druckseite zu drucken. Dank dieser Abmessungen kann die Anwendung den druckbaren Bereich auf der Seite
zentrieren.
:p.:hp2.Pixel:ehp2.
:p.Der bedruckbare Bereich wird fr Drucker gewhnlich als Zahl in pels oder dots angegeben. Erstellt man
beispielsweise ein Dokument fr ein bestimmtes Photobelichtungsgert, kann man die Daten wahrscheinlich
genau angeben. In diesem Fall sollte die genaue Anzahl von Druckerpunkten der horizontalen und vertikalen
Ausdehnung des bedruckbaren Bereichs des Gertes angegeben werden, und ebenso die genaue Anzahl
von Druckerpunkten pro Inch (dpi).
:p.Wenn Ihnen die genaue Gre des Druckformats in pels nicht bekannt ist, knnen Sie sie in mm, Inch oder
Punkten angeben. Die Schaltflche 'Rnder neu berechnen' ermittelt dann die nderungen der Rnder.
:p.:hp2.Ausrichtung:ehp2.
:p.Zum Wechseln der Ausrichtung des Druckerformulars klicken Sie einfach die Schaltflche
'Seitenausrichtung wechseln', worauf die x- und y-Parameter gegeneinander ausgetauscht werden.
.br
.br
.******************************************************************************
:h1 res=114 id=114.Ziehen und bergeben mit Maul Publisher
:i1 id=drag.Ziehen und bergeben mit Maul Publisher
:p.Ziehen und bergeben wird von Maul seit V2.22 untersttzt.
:p.:hp2.Dokumente bergeben:ehp2.
:p.Durch Ziehen und bergeben von Maul-Dokumenten an das Anwendungsfenster wird eine neue
Instanz von Maul gestartet, die dann das Dokument ffnet.
:p.:hp2.ber den <NULL>-Handler:ehp2.
:p.Der <NULL>-Handler wird immer dann verwendet, wenn kein anderer zur Verfgung steht. Im allgemeinen
liegt es in der Verantwortung des <NULL>-Handlers, Objekt-Handler mit Rahmen zu verknpfen. Die kleinen
'?'-Symbole werden vom <NULL>-Handler auf die unbenutzten Ebenenschaltflchen gezeichnet.
:p.Erstellt man einen Rahmen und bettigt dann eine der unbenutzten Ebenenschaltflchen, kann man
Dateien von Maul bekannten Typen an den ausgewhlten Rahmen bergeben. Wenn kein Rahmen ausgewhlt
ist, ist das Ziehen und bergeben auf die Hauptanwendung beschrnkt.
:p.:hp2.An einen vorhandenen Objekt-Handler:ehp2.
:p.Vom aktiven Objekt-Handler erkannte Dateitypen knnen von der Arbeitsoberflche an den ausgewhlten
Rahmen bergeben werden. Pat der Dateityp auf den momentan aktiven Objekt-Handler, so werden die
Daten im Rahmen durch die Daten in der Datei ersetzt.
.******************************************************************************
:h1 res=203 id=203 global.Seitenformat stimmt nicht berein. Was nun?
:i1.Seitenformat stimmt nicht berein. Was nun?
:p.:hp2.Abweichung beim Seitenformat:ehp2.
:p.Wird versucht, eine Seite in das Dokument zu laden, die aus einem Dokument mit einer anderen Seitenform
oder -gre stammt, erfolgt eine Abfrage, wie damit verfahren werden soll.
:p.Wenn die Seite ungefhr die gleiche Form besitzt, wird Maul die Seite normalerweise erfolgreich skalieren
knnen. Besitzt die Seite jedoch ein vollkommen anderes Format, steht Ihnen eine Menge Aufrumarbeit bevor.
Alternativ kann das Laden der Seite abgebrochen werden.
:euserdoc.
 
