# Generic LyX layout support for alfa.sty

# Define the special macros for alphanumeric support.
Preamble 
\usepackage{alfa}
EndPreamble

# Standard style definition
Style Standard
  Margin  		Static
  LatexType 		Paragraph
  LatexName 		dummy
  ParIndent		""
  ParSkip 		0.2
  Align 		Block
  AlignPossible 	Block, Left, Right, Center
End

Input stdlists.inc

# Modify Description
Style Description
  LabelFont
    Family              Sans
  EndFont
End

# Labeling style definition
Style Labeling
  Margin		Manual
  LatexType		List_Environment
  LatexName   labeling
  NextNoindent		1
  LabelSep		xxx
  ParSkip		0.4
  TopSep		0.7
  BottomSep		0.7
  ParSep		0.5
  Align			Block
  AlignPossible		Block, Left
  LabelType		Manual
  LabelString		00.00.0000
End

# Sachverhalt style definition
Style Sachverhalt
  Margin		Static
  LatexType		Environment
  LatexName		sachverhalt
  LabelType		Top_Environment
  LabelString		"Sachverhalt"
  # label font definition
  LabelFont 
    Series		Bold
    Size		Larger
    EndFont
End

Input stdsections.inc

# Modify Part
Style Part
  Font
    Family              Sans
  EndFont
End

# Modify Chapter
Style Chapter
  LabelString           ""
  Font
    Family              Sans
    Size                Largest
  EndFont
End

# Modify Section
Style Section
  Font
    Family              Sans
  EndFont
End

# Modify Subsection
Style Subsection
  Font
    Family              Sans
  EndFont
End

# Modify Subsubsection
Style Subsubsection
  Font
    Family              Sans
  EndFont
End

# Modify Paragraph
Style Paragraph
  Font
    Family              Sans
  EndFont
End

# Modify Subparagraph
Style Subparagraph
  LeftMargin            ""
  Font
    Family              Sans
  EndFont
End

Input stdstarsections.inc

# Addchap Style Definition
Style Addchap
  CopyStyle             Chapter*
  LatexName             addchap
End

# Addsec Style Definition
Style Addsec
  CopyStyle             Section*
  LatexName             addsec
End

# Addchap* Style Definition
Style Addchap*
  CopyStyle             Chapter*
  LatexName             addchap*
End

# Addsec* Style Definition
Style Addsec*
  CopyStyle             Section*
  LatexName             addsec*
End

# Minisec style definition
Style Minisec
  LatexType             Command
  LatexName             minisec
  NeedProtect           1
  NextNoIndent          1
  LabelSep              xxx
  ParSkip               0.4
  TopSep                0.4
  ParSep                0.4
  AlignPossible         Block, Left

  Font 
    Family              Sans
    Series              Bold
  EndFont
End

Input stdstruct.inc

# Modify Title
Style Title
  Font
    Family              Sans
    Series              Bold
  EndFont
End

# Modify Author
Style Author
  Font
    Size                Larger
  EndFont
End

# Modify Date
Style Date
  Font
    Size                Larger
  EndFont
End

# Modify Abstract
Style Abstract
  LabelFont
    Family              Sans
  EndFont
End

# Modify Bibliography
Style Bibliography
  LabelFont
    Family              Sans
  EndFont
End

# JuraBibliography style definition
Style JuraBibliography
  Margin		First_Dynamic
  LatexType		Item_Environment
  LatexName		jurabibliography
  NextNoIndent		1
  LeftMargin		MM
  ParSkip		0.4
  ItemSep		0
  TopSep		0.7
  BottomSep		0.7
  ParSep		0.5
  Align			Block
  AlignPossible		Block, Left
  LabelType		Bibliography
  LabelString		References
  LabelBottomSep    0.7

  # label font definition
  LabelFont 
    Series		Bold
    Size		Larger
  EndFont
End

# Subject style definition
Style Subject
  CopyStyle             Author
  LatexName             subject
End

# Publishers style definition
Style Publishers
  CopyStyle             Author
  LatexName             publishers
End

# Dedication style definition
Style Dedication
  CopyStyle             Author
  LatexName             dedication
End

# Titlehead style definition
Style Titlehead
  CopyStyle             Author
  LatexName             titlehead
  Align                 Left
  AlignPossible         Left

  Font 
    Size                Normal
  EndFont
End

# Uppertitleback style definition
Style Uppertitleback
  CopyStyle             Titlehead
  LatexName             uppertitleback
End

# Lowertitleback style definition
Style Lowertitleback
  CopyStyle             Titlehead
  LatexName             lowertitleback
End

# Extratitle style definition
Style Extratitle
  CopyStyle             Titlehead
  LatexName             extratitle
End

Input stdlayouts.inc
Input lyxmacros.inc

# toc style definition
Style Toc
  Margin		Dynamic
  LatexType		Command
  LatexName		toc
  NeedProtect		1
  NextNoIndent		1
  ParSkip		0.4
  TopSep		0.9
  BottomSep		0.5
  ParSep		0.5
  Align			Block
  AlignPossible		Block, Left
  LabelType		Counter_Chapter
  LabelString		"<Alf-Numb.> "
  
  # standard font definition
  Font 
    Series 		Bold
    Size		Large
  EndFont
End


# toc* style definition
Style Toc*
  Margin		Static
  LatexType		Command
  LatexName		toc*
  NeedProtect		1
  NextNoIndent		1
  ParSkip		0.4
  TopSep		0.9
  BottomSep		0.5
  ParSep		0.5
  Align			Left
  AlignPossible		Block, Left
  LabelType		No_Label

  # standard font definition
  Font 
    Series 		Bold
    Size		Large
  EndFont
End

# sub style definition
Style Sub
  Margin		Dynamic
  LatexType		Command
  LatexName		sub
  NeedProtect		1
  NextNoIndent		1
  ParSkip		0.4
  TopSep		0.9
  BottomSep		0.5
  ParSep		0.5
  Align			Left
  AlignPossible		Block, Left
  LabelType		Counter_Subsection
  LabelString		"<SubAlf-Numb.> "

  # standard font definition
  Font 
    Series 		Bold
    Size		Large
  EndFont
End


# levelup style definition
Style Up
  CopyStyle		Toc
  LatexName		up
  LabelType		Counter_Section
  LabelString		"<UpAlf-Numb.> "

  # standard font definition
  Font 
    Series 		Bold
    Size		Large
  EndFont
End

# levelup# style definition
Style Up2
  CopyStyle		Up
  LatexName		uptwo
  LabelString		"<Up2-Numb.> "
End

# levelup# style definition
Style Up3
  CopyStyle		Up
  LatexName		upthree
  LabelString		"<Up3-Numb.> "
End
 
# levelup# style definition
Style Up4
  CopyStyle		Up
  LatexName		upfour
  LabelString		"<Up4-Numb.> "
End

# levelup# style definition
Style Up5
  CopyStyle		Up
  LatexName		upfive
  LabelString		"<Up5-Numb.> "
End
  
# levelup# style definition
Style Up6
  CopyStyle		Up
  LatexName		upsix
  LabelString		"<Up6-Numb.> "
End
  
# levelup# style definition
Style Up7
  CopyStyle		Up
  LatexName		upseven
  LabelString		"<Up7-Numb.> "
End
  
# levelup# style definition
Style Up8
  CopyStyle		Up
  LatexName		upeight
  LabelString		"<Up8-Numb.> "
End

# levelup# style definition
Style Up9
  CopyStyle		Up
  LatexName		upnine
  LabelString		"<Up9-Numb.> "
End  

# levelup# style definition
Style Up10
  CopyStyle		Up
  LatexName		upten
  LabelString		"<Up10-Numb.> "
End

# levelup# style definition
Style Up11
  CopyStyle		Up
  LatexName		upeleven
  LabelString		"<Up11-Numb.> "
End

# Addchap Style 
Style Addchap
  CopyStyle             Section*
  LatexName             addchap
  LabelType		Counter_Chapter
End

# Addsec Style
Style Addsec
  CopyStyle             Section*
  LatexName             addsec
  LabelType		Counter_Section
End

# List style definition
Style List
  Margin		Manual
  LatexType		List_Environment
  LatexName		lyxlist
  NextNoindent		1
  LabelSep		xxx
  ParSkip		0.4
  TopSep		0.7
  BottomSep		0.7
  ParSep		0.5
  Align			Block
  AlignPossible		Block, Left
  LabelType		Manual
  LabelString		00.00.0000

  #define the environment lyxlist
  Preamble
  \newenvironment{lyxlist}[1]
    {\begin{list}{}
      {\settowidth{\labelwidth}{#1}
       \setlength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \renewcommand{\makelabel}[1]{##1 \hfill}}}
    {\end{list}}
  EndPreamble
End

Style RomanNo
  LatexType		Command
  LatexName		frontmatter
  LabelType		Centered_Top_Environment
  LabelString	"RomanPagination (insert some text)"
  LabelFont
    Shape		Smallcaps
    Series	Bold
    Color		green
  EndFont
End

Style ArabNo
  LatexType		Command
  LatexName		mainmatter
  LabelType		Centered_Top_Environment
  LabelString	"ArabicPagination (insert some text)"
  LabelFont
    Shape		Smallcaps
    Series	Bold
    Color		green
  EndFont
End

