/* A REXX COMMAND FILE TO INVOKE gX TRANSFORMATION STUFF*/
ECHO OFF
PARSE ARG filePathIn fileRootNameIn targetFormat styleSheetNameIn viewerCommandIn

/*SET THE USER'S CUSTOM VALUES FOR THE GX_ ENVIRONMENT*/
'CALL setGxEnv.cmd'

/*SET UP THE DIRECTORY PATHS FROM ENVIRONMENT IF POSSIBLE*/
/*A Java runtime appropriate for gX, settable by the user*/
javaRuntimeEngine = VALUE('GX_JAVA_RUNTIME',,'OS2ENVIRONMENT')
if javaRuntimeEngine="" then
  DO
    javaRuntimeEngine = 'g:\java13\jre\bin\java' 
    /*javaRuntimeEngine = 'c:\java11\bin\jre'  */ 
    VALUE('GX_JAVA_RUNTIME',javaRuntimeEngine,'OS2ENVIRONMENT')
  END

/*The paths which depend on GX_HOME_DIRECTORY*/
gxHomeDirectory = VALUE('GX_HOME_DIRECTORY',,'OS2ENVIRONMENT')
if gxHomeDirectory="" then  gxHomeDirectory='C:\gX\'

/*The transform repository*/
pathToTransforms= VALUE('GX_TRANSFORM_REPOSITORY',,'OS2ENVIRONMENT')
if pathToTransforms="" then
  pathToTransforms=gxHomeDirectory'Docs\XSL\'

/*The Saxon JAR Directory*/
saxonClassPath = VALUE('GX_SAXON_PATH',,'OS2ENVIRONMENT')
if saxonClassPath="" then
  saxonClassPath=gxHomeDirectory'bin\Saxon\saxon.jar;'

/*The FOP path and command file*/
fopPath = VALUE('GX_FOP_PATH',,'OS2ENVIRONMENT')
if fopPath="" then
  fopPath=gxHomeDirectory'bin\fop\fop-0.20.5\'

fopCommand = VALUE('GX_FOP_COMMAND',,'OS2ENVIRONMENT')
if fopCommand="" then
  fopCommand='fop.cmd'

fopClassPathAndCommand=fopPath''fopCommand





/*PUT QUOTES AROUND LONG FILE NAMES WHICH MAY HAVE SPACES*/
if (filePathIn="" | fileRootNameIn="") then
  NOP
else
  DO
    /*Clear away double quotes*/
    filePathIn = removeQuotes(filePathIn) 
    fileRootNameIn = removeQuotes(fileRootNameIn)
    /*Add them back*/
    outputFileName =  filePathIn''fileRootNameIn'.xml'
    outputFileName = encloseInQuotes(outputFileName)
  END


if viewerCommandIn="" then
    SELECT
       when targetFormat="HTML" then
         DO
           viewerName = 'os2web.exe'
         END
       when targetFormat="PDF" then 
          DO
           viewerName = 'C:\ACROBATREADER\AROS2.EXE'
         END
       when targetFormat="XML" then 
         DO
           viewerName = 'XMLParse.exe'
         END
       when targetFormat="IPF" then 
         DO
           viewerName = 'view.exe'
         END
    otherwise
       viewerName='epm.exe'
    end  /* select */
  else DO 
     viewerName = viewerCommandIn
  end /* do */

     SELECT
       when targetFormat="HTML" then
         DO
           viewerInputFile=filePathIn''fileRootNameIn'.html'
           viewerInputFile=encloseInQuotes(viewerInputFile)
         END
       when targetFormat="PDF" then 
          DO
           viewerInputFile=filePathIn''fileRootNameIn'.pdf'
           viewerInputFile=encloseInQuotes(viewerInputFile)
           xfoFileName=filePathIn''fileRootNameIn'.xfo'
           xfoFileName=encloseInQuotes(xfoFileName)
         END
       when targetFormat="XML" then 
         DO
           viewerInputFile=filePathIn''fileRootNameIn'.xml'
           viewerInputFile=encloseInQuotes(viewerInputFile)
         END
       when targetFormat="IPF" then 
         DO
           viewerInputFile=filePathIn''fileRootNameIn'.hlp'
           viewerInputFile=encloseInQuotes(viewerInputFile)
           ipfFileName=filePathIn''fileRootNameIn'.ipf'
           ipfFileName=encloseInQuotes(ipfFileName)
         END
    otherwise
       viewerInputFile=filePathIn''fileRootNameIn'.txt'
       viewerInputFile=encloseInQuotes(viewerInputFile)
    end  /* select */


transformIsToPDF=0
if targetFormat ='PDF' 
  then transformIsToPDF=1

/*
if transformIsToPDF then
  DO
    viewerName='C:\tvoice\wiseprog\adobe\reados2\acroread.exe'
    xfoFileName=filePathIn''fileRootNameIn'.xfo'
    xfoFileName=encloseInQuotes(xfoFileName)
  END
*/

SAY '******************** gXTrans ****************************'
SAY ''
SAY 'File path is:              ' filePathIn
SAY 'File to transform is:      ' fileRootNameIn
SAY 'Target format is:          ' targetFormat
SAY 'Viewer input file name is: ' viewerInputFile
SAY 'Viewer name is:            ' viewerName
SAY 'Java runtime call is:      ' javaRuntimeEngine

if styleSheetNameIn = ""
  then DO
     styleSheetName = pathToTransforms'ToHTML.xsl'
     styleSheetName = encloseInQuotes(styleSheetName)
     END
  else DO
     styleSheetName = removeQuotes(styleSheetNameIn)
     styleSheetName = pathToTransforms''styleSheetName
     styleSheetName = encloseInQuotes(styleSheetName)
  end /* do */
   

SAY 'Stylesheet name is:        ' styleSheetName
SAY ''
SAY '*********************************************************'

if  fileRootNameIn = "" then
  errorExit('input file name was not provided')

/*ECHO ON*/

/*'SET CLASSPATH='saxonClassPath''VALUE('CLASSPATH',,'OS2ENVIRONMENT') */
SAY '...submitting XML file to Saxon with stylesheet: 'styleSheetName

SELECT
when targetFormat='PDF' then
  DO
    /*ECHO ON */
    javaRuntimeEngine '-cp' saxonClassPath 'com.icl.saxon.StyleSheet' '-o'  xfoFileName outputFileName styleSheetName
    IF RC=0 then
      NOP
    else
      errorExit( 'it could not complete the Transform to 'xfoFileName' from 'outputFileName' using the stylesheet 'styleSheetName'. Java runtime is settable through OS2 Environment Variable GX_JAVA_RUNTIME.' )
    SAY '...submitting 'xfoFileName' to FOP to create 'viewerInputFile'.'
    fopClassPathAndCommand = encloseInQuotes(fopClassPathAndCommand)
    SAY '...Command line is: 'fopClassPathAndCommand xfoFileName viewerInputFile
    'CALL' fopClassPathAndCommand xfoFileName viewerInputFile
  END
when targetFormat='IPF' then
  DO
     
    /*ECHO ON */
    javaRuntimeEngine '-cp' saxonClassPath 'com.icl.saxon.StyleSheet' '-o'  ipfFileName outputFileName styleSheetName
    IF RC=0 then
      NOP
    else
      errorExit( 'it could not complete the Transform to 'ipfFileName' from 'outputFileName' using the stylesheet 'styleSheetName'. Java runtime is settable through OS2 Environment Variable GX_JAVA_RUNTIME.' )
    SAY '...submitting 'ipfFileName' to IPFC to create 'viewerInputFile'.'
    SAY '...Command line is: 'fopClassPathAndCommand ipfFileName
    'CALL IPFC ' ipfFileName
  END
otherwise
    javaRuntimeEngine '-cp' saxonClassPath 'com.icl.saxon.StyleSheet' '-o'  viewerInputFile outputFileName styleSheetName
end /*SELECT*/

IF RC=0 then
  NOP
else
  errorExit( 'it could not complete the Transform to 'viewerInputFile' from 'outputFileName' using the stylesheet 'styleSheetName'. Java runtime is settable through OS2 Environment Variable GX_JAVA_RUNTIME.' )

/*PAUSE */


SAY '...starting viewer 'viewerName' with input file 'viewerInputFile

start viewerName viewerInputFile

EXIT

/*PLACE DOUBLE QUOTES AROUND A STRING, e.g. a file name*/
encloseInQuotes: procedure
  parse arg stringIn
  quotedStr = INSERT( stringIn, '"', 0)
  quotedStr = INSERT( '"', quotedStr, 0)
  RETURN quotedStr

/*REMOVE DOUBLE QUOTES FROM A STRING, e.g. a long file name*/
removeQuotes: procedure
  parse arg stringIn
  if SUBSTR(stringIn,1,1) = '"'
    then DO
      lastPos = LENGTH(stringIn) - 1
      stringIn = SUBSTR(stringIn,2,LastPos)
    END
  lastPos = LENGTH(stringIn)
  if SUBSTR(stringIn,lastPos,1) = '"'
    then DO
      newLast = LENGTH(stringIn) - 1
      stringIn = SUBSTR(stringIn,1,newLast)
    END
  return stringIn

/*EXIT WITH AN ERROR*/
errorExit:
  parse arg reasonMessage
  SAY 'ERROR: gXTrans cannot continue because' reasonMessage'.'
  EXIT


/*EXTRACT THE FILE NAME EXTENSION*/
getFileExtension: procedure
  parse arg fileName
  length = length(fileName)                        
  extensionStartPos = length-3
  ext = SUBSTR(fileName,extensionStartPos)
  SAY 'extension is: ' ext
  IF SUBSTR(ext,1,1)='.' THEN
    return ext
  ELSE
    return ''



