//@line 37 "I:/kompozer/composer/components/prefwindow/content/pref-advanced.js"

const nsIFilePicker     = Components.interfaces.nsIFilePicker;
const FILEPICKER_CONTRACTID     = "@mozilla.org/filepicker;1";
var gPrefs;

function GetPrefsService()
{
  if (gPrefsService)
    return gPrefsService;

  try {
    gPrefsService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
  }
  catch(ex) {
    dump("failed to get prefs service!\n");
  }

  return gPrefsService;
}

function GetPrefs()
{
  if (gPrefsBranch)
    return gPrefsBranch;

  try {
    var prefService = GetPrefsService();
    if (prefService)
      gPrefsBranch = prefService.getBranch(null);

    if (gPrefsBranch)
      return gPrefsBranch;
    else
      dump("failed to get root prefs!\n");
  }
  catch(ex) {
    dump("failed to get root prefs!\n");
  }
  return null;
}

function Startup()
{
  /* Kaze: see pref-helpers.*
   *gDialog.useSystemSettingsHelpers = document.getElementById("useSystemSettingsHelpers");
   *gDialog.externalBrowser          = document.getElementById("externalBrowser");
   *gDialog.browserChooseFile        = document.getElementById("browserChooseFile");
   *gDialog.externalImageEditor      = document.getElementById("externalImageEditor");
   *gDialog.imageEditorChooseFile    = document.getElementById("imageEditorChooseFile");
   */

  try {
    gPrefs = GetPrefs();
  }
  catch (e) {
    dump("can't get pref service!");
  }

/* Kaze: see pref-helpers.*
 *#ifdef 0
 *#ifdef XP_UNIX
 *  if (gDialog.useSystemSettingsHelpers.value)
 *    UseSystemBrowser();
 *  else
 *    UseOwnBrowser();
 *#endif
 *#endif
 */
}

/* Kaze: see pref-helpers.*
 *#ifdef 0
 *function UseSystemBrowser()
 *{
 *  gDialog.externalBrowser.setAttribute("disabled", true);
 *  gDialog.browserChooseFile.setAttribute("disabled", true);
 *  if (gPrefs)
 *  {
 *    gPrefs.setCharPref("network.protocol-handler.app.http", "");
 *    gPrefs.setCharPref("network.protocol-handler.app.https", "");
 *    gPrefs.setCharPref("network.protocol-handler.app.ftp", "");
 *    gPrefs.setCharPref("network.protocol-handler.app.file", "");
 *  }
 *}
 *
 *function UpdateExternalBrowser()
 *{
 *  if (gPrefs)
 *  {
 *    var filePath = gDialog.externalBrowser.value;
 *    gPrefs.setCharPref("network.protocol-handler.app.http",  filePath);
 *    gPrefs.setCharPref("network.protocol-handler.app.https", filePath);
 *    gPrefs.setCharPref("network.protocol-handler.app.ftp",   filePath);
 *    gPrefs.setCharPref("network.protocol-handler.app.file",  filePath);
 *  }
 *}
 *
 *function UseOwnBrowser()
 *{
 *  gDialog.externalBrowser.removeAttribute("disabled");
 *  gDialog.browserChooseFile.removeAttribute("disabled");
 *  UpdateExternalBrowser();
 *}
 *#endif
 */

function showConnections()
{
  openDialog("chrome://editor/content/pref-connection.xul", "", "centerscreen,chrome,modal=yes,dialog=yes");
}

function selectFile(e)
{
  if (!e.hasAttribute("location"))
    return;

  var fp = Components.classes[FILEPICKER_CONTRACTID]
                     .createInstance(nsIFilePicker);

  var prefutilitiesBundle = document.getElementById("bundle_prefutilities");
  var title = prefutilitiesBundle.getString("choosefile");
  fp.init(window, title, nsIFilePicker.modeOpen);
  fp.appendFilters(nsIFilePicker.filterAll);

  var ret = fp.show();
  if (ret == nsIFilePicker.returnOK) {
    var folderField = document.getElementById(e.getAttribute("location"));
    var filePath = unescape(fp.fileURL.filePath);
//@line 168 "I:/kompozer/composer/components/prefwindow/content/pref-advanced.js"
    folderField.value = filePath;
  }
}
