/*********************************************************************

 This REXX script will install the Firefox Drag & Drop folder object
 on your WPS desktop. Just drop any Firefox zip file on the object and
 it automatically unzips and installs firefox. It has two options,

 1) update existing installation and
 2) specify install location for firefox.

 **********************************************************************/

call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs


Parse arg String var1 var2

Date        = '06.19.2016'
Version     ='0.388'

FileName    = var1
Location    = String

FoxDirNew   = ''
MozillaDir  = ''

Currentdir  = Directory()
ProgramsDir = VALUE('PROGRAMS',,'OS2ENVIRONMENT')

CALL CodeColor

IF ProgramsDir = '' THEN CALL Warp


MozDir =  ProgramsDir

BootDrive = GetOS2BootDrive()


IF FileName = "" then CALL Banner2

  ELSE CALL StartupBanner


theSelect=getSelection()

SELECT
  WHEN theSelect=1 THEN DO
	SAY ""
	call MozUpgr
        Exit 0;
  END
  WHEN theSelect=2 THEN DO
	SAY ""
	call MozAdv
        Exit 0;
  END
  WHEN theSelect=3 THEN DO
	SAY ""
	call MultiPass
        Exit 0;
  END
  WHEN theSelect=4 THEN DO
	SAY ""
        call Moz31runtime
  END
  WHEN theSelect=5 THEN DO
	SAY ""
        call FoxHelp

  END
OTHERWISE
	NOP
END

Exit 0;


/***********************************************************************
 *   Update eCS default Firefox or Thunderbird installations
 */


MozUpgr:

NewVer = FileName
parse var NewVer  FileName "-" .

                         /* if you want to capitalize the first letter */
FileName = translate(left(FileName,1)) || substr(FileName,2)

ADDRESS cmd 'attrib -r ' ||MozDir || '\' || FileName || '\*.dll';
pause

CALL DefaultBanner

fDir = ProgramsDir || '\' || FileName || '-BAK'

CALL BackupMoz
pause

IF FileName = 'Firefox'             THEN CALL DeleteFox

   ELSE IF FileName = 'Thunderbird' THEN CALL DeleteThunder

   ELSE IF FileName = 'Seamonkey'   THEN CALL DeleteSeamonkey


IF FileName7z = 'firefox-dev-24.8.1b4.en-US.os2' THEN
	ADDRESS cmd '7z x ' || String || ' -o' || MozDir || ' -aoa';

   ELSE IF FileName7z = 'thunderbird-31.6.0.en-US.os2' THEN
	ADDRESS cmd '7z x ' || String || ' -o' || MozDir || ' -aoa';

   ELSE IF FileName7z = 'thunderbird-24.8.1b3.en-US.os2' THEN
	ADDRESS cmd '7z x ' || String || ' -o' || MozDir || ' -aoa';

   ELSE IF FileName7z = 'seamonkey-2.21b3.en-US.os2' THEN
	ADDRESS cmd '7z x ' || String || ' -o' || MozDir || ' -aoa';

   ELSE
	ADDRESS cmd 'unzip -o ' || Location || ' -d ' || MozDir;


RunDir = CurrentDir
Dir    = MozDir || '\' || Filename ;

rem CALL MozRuntime
rem CALL Moz31runtime

IF FileName = 'Seamonkey' THEN CALL SeamonkeyRun
   ELSE IF FileName = 'SEAMONKEY' THEN CALL SeamonkeyRun

say ''
say color.white || 'Updated default ' || FileName || ' installation on your desktop...' || color.gray;
pause

Return


BackupMoz:

CALL DeleteBackup

Copy_Cmd = MozDir || '\' || FileName || ' ' || MozDir || '\' || FileName || '-BAK\ /S /E'
XCOPY Copy_Cmd

CALL SysPutEA MozDir || '\' || FileName || '-BAK', '.LONGNAME', ''

RETURN


DeleteFox:

fDir = ProgramsDir || '\Firefox'


/* Create Match list of do-not-deletes, upper case! */
    NoDel.1='FIREFOX.EXE'
    NoDel.2='FIREFOX!.EXE'
    NoDel.3='FIREFOX!K.EXE'
    NoDel.4='FIREFOX!L.EXE'
    NoDel.5='FIREFOX!LK.EXE'
    NoDel.6='FIREFOX!KL.EXE'
    NoDel.7='FIREFOX!ELK.EXE'
    NoDel.8='FIREFOX!.ENV'
    NoDel.9='FIREFOX.ICO'
    NoDel.10='MOZILLA'

    NoDel.0=10              /* Set stem array length */

              /* List files and delete each of them */
CALL DeleteInstall

RETURN


DeleteThunder:

fDir = ProgramsDir || '\THUNDERBIRD'


/* Create Match list of do-not-deletes, upper case! */
    NoDel.1='THUNDERBIRD.EXE'
    NoDel.2='THUNDERBIRD!.EXE'
    NoDel.3='THUNDERBIRD!K.EXE'
    NoDel.4='THUNDERBIRD!L.EXE'
    NoDel.5='THUNDERBIRD!LK.EXE'
    NoDel.6='THUNDERBIRD!KL.EXE'
    NoDel.7='THUNDERBIRD!ELK.EXE'
    NoDel.8='THUNDERBIRD!.ENV'
    NoDel.9='THUNDERBIRD.ICO'
    NoDel.10='THUNDERBIRD'

    NoDel.0=10              /* Set stem array length */

              /* List files and delete each of them */
CALL DeleteInstall

RETURN


DeleteSeamonkey:

fDir = ProgramsDir || '\SEAMONKEY'


/* Create Match list of do-not-deletes, upper case! */
    NoDel.1='SEAMONKEY.EXE'
    NoDel.2='SEAMONKEY!.EXE'
    NoDel.3='SEAMONKEY!K.EXE'
    NoDel.4='SEAMONKEY!L.EXE'
    NoDel.5='SEAMONKEY!LK.EXE'
    NoDel.6='SEAMONKEY!KL.EXE'
    NoDel.7='SEAMONKEY!ELK.EXE'
    NoDel.8='SEAMONKEY!.ENV'
    NoDel.9='SEAMONKEY.ICO'
    NoDel.10='MOZILLA'

    NoDel.0=10              /* Set stem array length */

              /* List files and delete each of them */
CALL DeleteInstall

RETURN


DeleteBackup:

/* We only care about the fully qualified path names and in subfolders as well,
 *  so use "O" option to drop dates, times, attribs, etc.
 */
    rtc = SysFileTree( STRIP( fDir, 'T', '\' )||"\*", "filelist", "SFO" )

/* Create worker loops */
    Do A = 1 to filelist.0    /* Loop through file list using count in stem base */
        rtc = SysFileDelete( filelist.A )                         /* delete file */
    End

RETURN


DeleteInstall:

/* Read directory and all sub-directories and create file list in stem array filelist,
 *  take care of possible trailing back slash.
 */

/* We only care about the fully qualified path names and in subfolders as well,
 *  so use "O" option to drop dates, times, attribs, etc.
 */
    rtc = SysFileTree( STRIP( fDir, 'T', '\' )||"\*", "filelist", "SFO" )

/* Create worker loops */
    Do A = 1 to filelist.0          /* Loop through file list using count in stem base */
        Do B = 1 to NoDel.0                    /* Compare to each value in NoDel array */
            If Pos( NoDel.B, Translate( filelist.A ) ) > 0 Then   /* found a match - using upper case to ensure proper matching */
            Iterate A /* Jump to the next file in the list and don't process this one! */
        End
        rtc = SysFileDelete( filelist.A )                               /* delete file */


        /* Add programming code here to check error codes if wanted - for instance cant delete because locked file */
        /* If rtc = 0 Then Say FileSpec( filelist.A, 'N' ) 'deleted' */
    End

RETURN


/***********************************************************************
 *   Advanced Install for Firefox, Seamokey or Thunderbird
 */


MozAdv:

FileName7z = FileName

NewVer = FileName
parse var NewVer FileName "-" .

                         /* if you want to capitalize the first letter */
FileName = translate(left(FileName,1)) || substr(FileName,2)

ADDRESS cmd 'attrib -r nspr4.dll';


CALL AdvanceBanner

ProgramsDir = MozDir


IF FileName = 'Firefox'             THEN CALL DeleteFox
   ELSE IF FileName = 'FIREFOX'     THEN CALL DeleteFox

   ELSE IF FileName = 'Thunderbird' THEN CALL DeleteThunder
   ELSE IF FileName = 'THUNDERBIRD' THEN CALL DeleteThunder

   ELSE IF FileName = 'Seamonkey'   THEN CALL DeleteSeamonkey
   ELSE IF FileName = 'SEAMONKEY'   THEN CALL DeleteSeamonkey


IF FileName7z = 'firefox-dev-24.8.1b4.en-US.os2' THEN
	ADDRESS cmd '7z x ' || String || ' -o' || MozDir || ' -aoa';

   ELSE IF FileName7z = 'thunderbird-31.6.0.en-US.os2' THEN
	ADDRESS cmd '7z x ' || String || ' -o' || MozDir || ' -aoa';

   ELSE IF FileName7z = 'thunderbird-24.8.1b3.en-US.os2' THEN
	ADDRESS cmd '7z x ' || String || ' -o' || MozDir || ' -aoa';

   ELSE IF FileName7z = 'seamonkey-2.21b3.en-US.os2' THEN
	ADDRESS cmd '7z x ' || String || ' -o' || MozDir || ' -aoa';

   ELSE
	ADDRESS cmd 'unzip -o ' || String || ' -d ' || MozDir ;


RunDir = CurrentDir
Dir    = MozDir || '\' || Filename ;

rem CALL MozRuntime
rem CALL Moz31runtime


IF FileName = 'Firefox'             THEN CALL FoxRun
   ELSE IF FileName = 'FIREFOX'     THEN CALL FoxRun

   ELSE IF FileName = 'Thunderbird' THEN CALL ThunderRun
   ELSE IF FileName = 'THUNDERBIRD' THEN CALL ThunderRun

   ELSE IF FileName = 'Seamonkey'   THEN CALL SeamonkeyRun
   ELSE IF FileName = 'SEAMONKEY'   THEN CALL SeamonkeyRun


IF FileName = 'Firefox'             THEN CALL IconsFox
   ELSE IF FileName = 'FIREFOX'     THEN CALL IconsFox

   ELSE IF FileName = 'Thunderbird' THEN CALL IconsThunder
   ELSE IF FileName = 'THUNDERBIRD' THEN CALL IconsThunder

   ELSE IF FileName = 'Seamonkey'   THEN CALL IconsSeamonkey
   ELSE IF FileName = 'SEAMONKEY'   THEN CALL IconsSeamonkey

RETURN



/***********************************************************************/




Moz31runtime:

/***********************************************************************
 *  INSTALL MOZ31 RUNTIME!
 */

IF RunDir = 'RUNDIR' 	THEN RunDir = CurrentDir
IF Dir    = 'DIR'	THEN CALL MOZ28BANNER


SAY ''
SAY color.white || 'Would you like to install Required DLLs (DO NOT INSTALL IF USING Yum/RPM)?' || color.gray
SAY ''
SAY 'This does NOT INSTALL gcc4core OR libc-0_6_x files, but does install all other required DLL files.'
SAY ''
SAY ''
SAY 'Y/n'

   key = SysGetKey()
   parse upper var key key
   if key <> 'Y' then RETURN


Copy_Run   = RunDir || '\files\fntcfg2.dll '  || Dir || '\fntcfg2.dll'

Copy_Free  = RunDir || '\files\freetyp2.dll ' || Dir || '\freetyp2.dll'

COPY  Copy_Run

COPY  Copy_Free


Copy_1 = RunDir || '\files\mmap.dll '   || Dir || '\mmap.dll'
Copy_2 = RunDir || '\files\pthr01.dll ' || Dir || '\pthr01.dll'

Copy_3 = RunDir || '\files\gcc446.dll ' || Dir || '\gcc446.dll'
Copy_4 = RunDir || '\files\gcc473.dll ' || Dir || '\gcc473.dll'

Copy_5 = RunDir || '\files\stdcpp.dll ' || Dir || '\stdcpp.dll'
Copy_6 = RunDir || '\files\stdcpp6.dll ' || Dir || '\stdcpp6.dll'
Copy_7 = RunDir || '\files\gcc1.dll ' || Dir || '\gcc1.dll'

Copy_8 = RunDir || '\files\png1616.dll ' || Dir || '\png1616.dll'
Copy_9 = RunDir || '\files\z.dll ' || Dir || '\z.dll'
Copy_10 = RunDir || '\files\urpo.dll ' || Dir || '\urpo.dll'
Copy_11 = RunDir || '\files\freetyp6.dll ' || Dir || '\freetyp6.dll'
Copy_12 = RunDir || '\files\kai0.dll ' || Dir || '\kai0.dll'


COPY  Copy_1
COPY  Copy_2

COPY  Copy_3
COPY  Copy_4

COPY  Copy_5
COPY  Copy_6
COPY  Copy_7

COPY  Copy_8
COPY  Copy_9
COPY  Copy_10
COPY  Copy_11
COPY  Copy_12


say ''
say ''
say 'MOZ28! Required DLLs installed to ' || color.white || dir || color.gray
say ''
say 'Creating objects on your desktop... Installation complete !'

RETURN


FoxRun:

/***********************************************************************
 *  INSTALL RUN! & MAKE ICONS
 */


SAY ''
SAY color.green || 'Would you like to install RUN! v0.80 ?' || color.gray
SAY '(C)Copyright 2003-2009  RL Walsh'
SAY ''
SAY 'Y/n'

   key = SysGetKey()
   parse upper var key key
   if key <> 'Y' then RETURN

Copy_Run  = RunDir || '\FILES\FIREFOX!ELK.EXE ' || dir || '\FIREFOX!ELK.EXE'
Copy_icon = RunDir || '\ICONS\FIREFOX.ICO '   || dir || '\FIREFOX.ICO'
Copy_conf = RunDir || '\FILES\FIREFOX!.ENV '   || dir || '\FIREFOX!.ENV'

COPY  Copy_Run
COPY  Copy_Icon

/*** Check if FIREFOX!.ENV exists ***/

rc=stream(dir || '\FIREFOX!.ENV',"c","query exist")

If rc="" then COPY  Copy_conf;


/* Create main folder */
rc=SysCreateObject('WPFolder',,
'Firefox',,
'<WP_DESKTOP>',,
'OBJECTID=<WARPZILLAFLDR>;'||,
'ALWAYSSORT=YES;'||,
'BACKGROUND='||BootDrive||'\OS2\BITMAP\altgry01.bmp,T,4,I;'||,
'ICONTEXTCOLOR=black;'||,
'ICONSHADOWCOLOR=black',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Firefox',,
'<WARPZILLAFLDR>',,
'EXENAME='||dir||'\FIREFOX!ELK.EXE;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<WARPZILLAEXE>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Firefox^Safe mode',,
'<WARPZILLAFLDR>',,
'EXENAME='||dir||'\FIREFOX!ELK.EXE;'||,
'PARAMETERS=-safe-mode;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<WARPZILLASAFE>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Firefox^Profile',,
'<WARPZILLAFLDR>',,
'EXENAME='||dir||'\FIREFOX!ELK.EXE;'||,
'PARAMETERS=-ProfileManager;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<WARPZILLAPROFILE>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Firefox^IRC chat',,
'<WARPZILLAFLDR>',,
'EXENAME='||dir||'\FIREFOX!ELK.EXE;'||,
'PARAMETERS=-chat;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<WARPZILLACHAT>',,
'Update' )

say ''
say ''
say 'RUN! v0.80 installed to ' || color.white || dir || color.gray
say ''
say 'Creating Firefox object on your desktop... Installation complete !'

pause

EXIT 0;


ThunderRun:

/***********************************************************************
 *  THUNDERBIRD INSTALL RUN! & MAKE ICONS
 */

SAY ''
SAY color.white || 'Would you like to install RUN! v0.80 ?' || color.gray
SAY '(C)Copyright 2003-2009  RL Walsh'
SAY ''
SAY 'Y/n'

   key = SysGetKey()
   parse upper var key key
   if key <> 'Y' then RETURN

RunDir = CurrentDir

Copy_Run  = RunDir || '\FILES\THUNDERBIRD!LK.EXE ' || dir || '\THUNDERBIRD!LK.EXE'
Copy_icon = RunDir || '\ICONS\THUNDERBIRD.ICO '    || dir || '\THUNDERBIRD.ICO'

COPY  Copy_Run
COPY  Copy_Icon


/* Create main folder */
rc=SysCreateObject('WPFolder',,
'Thunderbird',,
'<WP_DESKTOP>',,
'OBJECTID=<THUNDERBIRDFLDR>;'||,
'ALWAYSSORT=YES;'||,
'BACKGROUND='||BootDrive||'\OS2\BITMAP\altgry01.bmp,T,4,I;'||,
'ICONTEXTCOLOR=black;'||,
'ICONSHADOWCOLOR=black',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Thunderbird',,
'<THUNDERBIRDFLDR>',,
'EXENAME='||dir||'\THUNDERBIRD!LK.EXE;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<THUNDERBIRDEXE>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Thunderbird^Profile',,
'<THUNDERBIRDFLDR>',,
'EXENAME='||dir||'\THUNDERBIRD!LK.EXE;'||,
'PARAMETERS=-ProfileManager;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<THUNDERBIRDPROFILE>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Thunderbird^Safe mode',,
'<THUNDERBIRDFLDR>',,
'EXENAME='||dir||'\THUNDERBIRD!LK.EXE;'||,
'PARAMETERS=-Safe-mode;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<THUNDERBIRDSAFE>',,
'Update' )

say ''
say ''
say 'RUN! v0.80 installed to ' || color.white || dir || color.gray
say ''
say 'Creating Thunderbird object on your desktop... Installation complete !'

pause

EXIT 0;


SeamonkeyRun:

/***********************************************************************
 *  SEAMONKEY INSTALL RUN! & MAKE ICONS
 */

SAY ''
SAY color.white || 'Would you like to install RUN! v0.80 ?' || color.gray
SAY '(C)Copyright 2003-2009  RL Walsh'
SAY ''
SAY 'Y/n'

   key = SysGetKey()
   parse upper var key key
   if key <> 'Y' then RETURN

RunDir = CurrentDir

Copy_Run  = RunDir  || '\FILES\SEAMONKEY!LK.EXE ' 	|| dir || '\SEAMONKEY!LK.EXE'
Copy_icon1 = RunDir || '\ICONS\SEAMONKEY.ICO '    	|| dir || '\SEAMONKEY.ICO'
Copy_icon2 = RunDir || '\ICONS\addressbookWindow.ico '  || dir || '\addressbookWindow.ico'
Copy_icon3 = RunDir || '\ICONS\chatzilla-window.ico '   || dir || '\chatzilla-window.ico'
Copy_icon4 = RunDir || '\ICONS\editorWindow.ico '    	|| dir || '\editorWindow.ico'
Copy_icon5 = RunDir || '\ICONS\messengerWindow.ico '    || dir || '\messengerWindow.ico'

COPY  Copy_Run
COPY  Copy_Icon1
COPY  Copy_Icon2
COPY  Copy_Icon3
COPY  Copy_Icon4
COPY  Copy_Icon5



/* Create main folder */
rc=SysCreateObject('WPFolder',,
'Seamonkey',,
'<WP_DESKTOP>',,
'OBJECTID=<SEAMONKEYFLDR>;'||,
'ALWAYSSORT=YES;'||,
'BACKGROUND='||BootDrive||'\OS2\BITMAP\altgry01.bmp,T,4,I;'||,
'ICONTEXTCOLOR=black;'||,
'ICONSHADOWCOLOR=black',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Seamonkey',,
'<SEAMONKEYFLDR>',,
'EXENAME='||dir||'\SEAMONKEY!LK.EXE;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<SEAMONKEYEXE>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Seamonkey^Address',,
'<SEAMONKEYFLDR>',,
'EXENAME='||dir||'\SEAMONKEY!LK.EXE;'||,
'ICONFILE='||dir||'\addressbookWindow.ico;'||,
'PARAMETERS=-Addressbook;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<SEAMONKEYADDRESS>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Seamonkey^Mail',,
'<SEAMONKEYFLDR>',,
'EXENAME='||dir||'\SEAMONKEY!LK.EXE;'||,
'ICONFILE='||dir||'\messengerWindow.ico;'||,
'PARAMETERS=-Mail;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<SEAMONKEYMAIL>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Seamonkey^Chat',,
'<SEAMONKEYFLDR>',,
'EXENAME='||dir||'\SEAMONKEY!LK.EXE;'||,
'ICONFILE='||dir||'\chatzilla-window.ico;'||,
'PARAMETERS=-Chat;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<SEAMONKEYCHAT>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Seamonkey^Composer',,
'<SEAMONKEYFLDR>',,
'EXENAME='||dir||'\SEAMONKEY!LK.EXE;'||,
'ICONFILE='||dir||'\editorWindow.ico;'||,
'PARAMETERS=-Edit;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<SEAMONKEYCOMPOSER>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Seamonkey^Profile',,
'<SEAMONKEYFLDR>',,
'EXENAME='||dir||'\SEAMONKEY!LK.EXE;'||,
'PARAMETERS=-ProfileManager;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<SEAMONKEYPROFILE>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Seamonkey^Safe mode',,
'<SEAMONKEYFLDR>',,
'EXENAME='||dir||'\SEAMONKEY!LK.EXE;'||,
'PARAMETERS=-safe-mode;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<SEAMONKEYSAFE>',,
'Update' )

say ''
say ''
say 'RUN! v0.80 installed to ' || color.white || dir || color.gray
say ''
say 'Creating Seamonkey object on your desktop... Installation complete !'

Pause

EXIT 0;


IconsFox:

/***********************************************************************
 *  MAKE FIREFOX ICONS
 */

/* Create main folder */
rc=SysCreateObject('WPFolder',,
'Firefox',,
'<WP_DESKTOP>',,
'OBJECTID=<WARPZILLAFLDR>;'||,
'ALWAYSSORT=YES;'||,
'BACKGROUND='||BootDrive||'\OS2\BITMAP\altgry01.bmp,T,4,I;'||,
'ICONTEXTCOLOR=black;'||,
'ICONSHADOWCOLOR=black',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Firefox',,
'<WARPZILLAFLDR>',,
'EXENAME='||dir||'\FIREFOX.EXE;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<WARPZILLAEXE>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Firefox^Safe mode',,
'<WARPZILLAFLDR>',,
'EXENAME='||dir||'\FIREFOX.EXE;'||,
'PARAMETERS=-safe-mode;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<WARPZILLASAFE>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Firefox^Profile',,
'<WARPZILLAFLDR>',,
'EXENAME='||dir||'\FIREFOX.EXE;'||,
'PARAMETERS=-ProfileManager;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<WARPZILLAPROFILE>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Firefox^IRC chat',,
'<WARPZILLAFLDR>',,
'EXENAME='||dir||'\FIREFOX.EXE;'||,
'PARAMETERS=-chat;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<WARPZILLACHAT>',,
'Update' )


say ''
say 'Creating Firefox objects on your desktop... Installation complete !'

Pause

RETURN


IconsThunder:

/***********************************************************************
 *  MAKE THUNDERBIRD ICONS
 */

/* Create main folder */
rc=SysCreateObject('WPFolder',,
'Thunderbird',,
'<WP_DESKTOP>',,
'OBJECTID=<THUNDERBIRDFLDR>;'||,
'ALWAYSSORT=YES;'||,
'BACKGROUND='||BootDrive||'\OS2\BITMAP\altgry01.bmp,T,4,I;'||,
'ICONTEXTCOLOR=black;'||,
'ICONSHADOWCOLOR=black',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Thunderbird',,
'<THUNDERBIRDFLDR>',,
'EXENAME='||dir||'\THUNDERBIRD.EXE;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<THUNDERBIRDEXE>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Thunderbird^Profile',,
'<THUNDERBIRDFLDR>',,
'EXENAME='||dir||'\THUNDERBIRD.EXE;'||,
'PARAMETERS=-ProfileManager;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<THUNDERBIRDPROFILE>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Thunderbird^Safe mode',,
'<THUNDERBIRDFLDR>',,
'EXENAME='||dir||'\THUNDERBIRD.EXE;'||,
'PARAMETERS=-Safe-mode;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<THUNDERBIRDSAFE>',,
'Update' )

say ''
say 'Creating Thunderbird objects on your desktop... Installation complete !'

Pause

RETURN


IconsSeamonkey:

/***********************************************************************
 *  MAKE SEAMONKEY ICONS
 */

RunDir = CurrentDir

Copy_icon1 = RunDir || '\ICONS\SEAMONKEY.ICO '    	|| dir || '\SEAMONKEY.ICO'
Copy_icon2 = RunDir || '\ICONS\addressbookWindow.ico '  || dir || '\addressbookWindow.ico'
Copy_icon3 = RunDir || '\ICONS\chatzilla-window.ico '   || dir || '\chatzilla-window.ico'
Copy_icon4 = RunDir || '\ICONS\editorWindow.ico '    	|| dir || '\editorWindow.ico'
Copy_icon5 = RunDir || '\ICONS\messengerWindow.ico '    || dir || '\messengerWindow.ico'

COPY  Copy_Icon1
COPY  Copy_Icon2
COPY  Copy_Icon3
COPY  Copy_Icon4
COPY  Copy_Icon5


/* Create main folder */
rc=SysCreateObject('WPFolder',,
'Seamonkey',,
'<WP_DESKTOP>',,
'OBJECTID=<SEAMONKEYFLDR>;'||,
'ALWAYSSORT=YES;'||,
'BACKGROUND='||BootDrive||'\OS2\BITMAP\altgry01.bmp,T,4,I;'||,
'ICONTEXTCOLOR=black;'||,
'ICONSHADOWCOLOR=black',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Seamonkey',,
'<SEAMONKEYFLDR>',,
'EXENAME='||dir||'\SEAMONKEY.EXE;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<SEAMONKEYEXE>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Seamonkey^Address',,
'<SEAMONKEYFLDR>',,
'EXENAME='||dir||'\SEAMONKEY.EXE;'||,
'ICONFILE='||dir||'\addressbookWindow.ico;'||,
'PARAMETERS=-Addressbook;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<SEAMONKEYADDRESS>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Seamonkey^Chat',,
'<SEAMONKEYFLDR>',,
'EXENAME='||dir||'\SEAMONKEY.EXE;'||,
'ICONFILE='||dir||'\chatzilla-window.ico;'||,
'PARAMETERS=-Chat;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<SEAMONKEYCHAT>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Seamonkey^Composer',,
'<SEAMONKEYFLDR>',,
'EXENAME='||dir||'\SEAMONKEY.EXE;'||,
'ICONFILE='||dir||'\editorWindow.ico;'||,
'PARAMETERS=-Edit;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<SEAMONKEYCOMPOSER>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Seamonkey^Mail',,
'<SEAMONKEYFLDR>',,
'EXENAME='||dir||'\SEAMONKEY.EXE;'||,
'ICONFILE='||dir||'\messengerWindow.ico;'||,
'PARAMETERS=-Mail;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<SEAMONKEYMAIL>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Seamonkey^Profile',,
'<SEAMONKEYFLDR>',,
'EXENAME='||dir||'\SEAMONKEY.EXE;'||,
'PARAMETERS=-ProfileManager;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<SEAMONKEYPROFILE>',,
'Update' )

rc=SysCreateObject('WPProgram',,
'Seamonkey^Safe mode',,
'<SEAMONKEYFLDR>',,
'EXENAME='||dir||'\SEAMONKEY.EXE;'||,
'PARAMETERS=-safe-mode;'||,
'STARTUPDIR='||dir||';'||,
'OBJECTID=<SEAMONKEYSAFE>',,
'Update' )

say ''
say 'Creating Seamonkey objects on your desktop... Installation complete !'

Pause

RETURN


MultiPass:

say "Please enter the installation directory for Firefox."
pull MozDir

say ''
say 'Is this the correct path ?'
say ''
say color.white || MozDir || color.gray

key = SysGetKey('NOECHO')
parse upper var key key
if key <> 'Y' then call DontInstall


FileName7z = FileName

NewVer = FileName

parse var NewVer FileName ".en" .

                         /* if you want to capitalize the first letter */
FileName = translate(left(FileName,1)) || substr(FileName,2)


ProgramsDir = MozDir

IF FileName7z = 'firefox-dev-24.8.1b4.en-US.os2' THEN
	ADDRESS cmd '7z x ' || String || ' -o' || MozDir || ' -aoa';

   ELSE IF FileName7z = 'thunderbird-31.6.0.en-US.os2' THEN
	ADDRESS cmd '7z x ' || String || ' -o' || MozDir || ' -aoa';

   ELSE IF FileName7z = 'thunderbird-24.8.1b3.en-US.os2' THEN
	ADDRESS cmd '7z x ' || String || ' -o' || MozDir || ' -aoa';

   ELSE IF FileName7z = 'seamonkey-2.21b3.en-US.os2' THEN
	ADDRESS cmd '7z x ' || String || ' -o' || MozDir || ' -aoa';

   ELSE
	ADDRESS cmd 'unzip -o ' || String || ' -d ' || MozDir || '\' || FileName;


RunDir = CurrentDir
dir = MozDir || '\' ||  FileName || '\firefox';

parse var NewVer  FileName "-" .

                         /* if you want to capitalize the first letter */
FileName = translate(left(FileName,1)) || substr(FileName,2)



IF FileName = 'Firefox'             THEN CALL FoxRun
   ELSE IF FileName = 'FIREFOX'     THEN CALL FoxRun

   ELSE IF FileName = 'Thunderbird' THEN CALL ThunderRun
   ELSE IF FileName = 'THUNDERBIRD' THEN CALL ThunderRun

   ELSE IF FileName = 'Seamonkey'   THEN CALL SeamonkeyRun
   ELSE IF FileName = 'SEAMONKEY'   THEN CALL SeamonkeyRun


IF FileName = 'Firefox'             THEN CALL IconsFox
   ELSE IF FileName = 'FIREFOX'     THEN CALL IconsFox

   ELSE IF FileName = 'Thunderbird' THEN CALL IconsThunder
   ELSE IF FileName = 'THUNDERBIRD' THEN CALL IconsThunder

   ELSE IF FileName = 'Seamonkey'   THEN CALL IconsSeamonkey
   ELSE IF FileName = 'SEAMONKEY'   THEN CALL IconsSeamonkey


Return


CodeColor:

/***********************************************************************
 *  Set some colors, thanx to Dmitry A.Steklenev for the inspiration
 */

'@ansi on > nul'
color.brown   = "1B"x"[0;33m"
color.red     = "1B"x"[1;31m"
color.green   = "1B"x"[1;32m"
color.white   = "1B"x"[1;32m"
color.yellow  = "1B"x"[1;33m"
color.blue    = "1B"x"[1;34m"
color.magenta = "1B"x"[1;35m"
color.cyan    = "1B"x"[1;36m"
color.white   = "1B"x"[1;37m"
color.gray    = "1B"x"[0m"

RETURN


StartupBanner:

/***********************************************************************
 *  Startup Message
 */

say color.gray  || 'Thank you for using '|| color.magenta || 'FirefoxDD' ||,
color.gray || ', an automated tool for eCS or OS/2.'
say color.cyan || 'Version ' || Version || color.gray || ' -- ' || Date
say ''
say color.gray || 'This Program is released under the Gnu Public Licence',
|| '(GPL).'
say 'See the file COPYING for further information.'
say color.gray  || 'Copyright (c) 2011 by '|| color.white ||,
'Greggory Shaw'
say ''
say color.gray  || 'Default option will upgrade the default ' || color.white  || 'Firefox & Thunderbird' || color.gray || ' installations'
say '(as defined by SET PROGRAMS=' || color.white || MozDir || color.gray || ') on your eCS system.'
say ''
say 'Use the advance option to specify the install locations.'
say ''

RETURN


Banner2:

/***********************************************************************
 *  Startup Message 2
 */

say ''
say color.red  || "ERROR: DO NOT USE this file. Use 'Install.cmd', to create a WPS object first. "
say "Then 'Drag & Drop' any FF,TB or SM zip file on the WPS object to install."
say ''
say color.gray || "see the 'Readme.1st' file for complete instructions."
say ''

PAUSE

EXIT 0;


DefaultBanner:

/***********************************************************************
 *  Default option: Startup Message
 */

cls
say ''
say color.white || 'Default option:' || color.gray
say ''
say color.gray  || 'This option automatically installs' color.white || FileName || color.gray || ' to the'
say "default location " || color.white || MozDir || color.gray ||' set by eCS.'
say ''
say 'A backup of the original will be create in ' || color.white || FileName || '-Bak' || color.gray
say ''
say 'Is this the correct default path ?'
say ''
say color.white || MozDir || '\' || FileName || color.gray

   key = SysGetKey()
   parse upper var key key
   if key <> 'Y' then call DontInstall

RETURN


AdvanceBanner:

/***********************************************************************
 *  Advanced option: Startup Message
 */

cls

say ''
say color.white || 'Advanced option:' || color.gray
say ''
say 'If installing to root do not use the backslash (\)'
say 'use this format (E:)'
say ''
say ''
say '  NOTE: The directory looks like this:'
say ''
say '      \..\Programs\Firefox\'
say '                          \Firefox'
say '                          \Firefox-Bak'
say ''
say "If you DO NOT want the double directories."
say ''
say 'Enter only E:\Programs, because of the way the zip files are packed'
say ''
say ''
say 'Please enter the installation directory for ' || FileName || '.'
say ''
say '----------------------------------------------------'

PARSE PULL MozDir

cls
say ''
say 'Is this the correct path ?'
say ''
say color.white ||MozDir || color.gray
say ''
say 'y/n?'
say ''

key = SysGetKey()
parse upper var key key
if key <> 'Y' then call DontInstall

say ''
say ''
say 'If you are installing to a existing ' || FileName || ' directory'
say 'would you like to create a backup of your current installation?'
say ''
say color.white ||MozDir || color.gray

fDir = MozDir || '\' || FileName || '-BAK'

key = SysGetKey('NOECHO')
parse upper var key key
if key == 'Y' then call BackupMoz

RETURN


Moz28banner:

RunDir = Currentdir

say ''
say 'Please enter the installation directory for ' || FileName || '.'
say ''
say 'If installing to root do not use the backslash (\)'
say 'use this format (E:)'
say ''
say '----------------------------------------------------'

PARSE PULL MozDir

Dir = MozDir

RETURN


Warp:

/***********************************************************************
 *  Startup Message for OS/2 systems
 */

say ''
say color.red  || "NOTICE: One line in the script must be modified first for OS/2 users. "
say ''
say color.gray || '/***********************************************************************'
say ' * ATTENTION - For the DEFAULT option to work:                         *'
say ' *                                                                     *'
say ' * OS/2 and Warp 4 users that do not have the:                         *'
say ' *                                                                     *'
say ' *         SET PROGRAMS=E:\PROGRAMS - in the CONFIG.SYS                *'
say ' *                                                                     *'
say ' * In this case this script needs to be set to the default path,       *'
say ' * or where you previously installed Firefox                           *'
say ' *                                                                     *'
say ' *     ProgramsDir = "x:\Programs"  NOT   "x:\Programs\Firefox"        *'
say ' *                                                                     *'
say ' *                                                                     *'
say ' * eComStation user already has this set by default.                   *'
say ' *                                                                     *'
say ' ***********************************************************************/'
say ''

pause

EXIT 0;



getSelection: PROCEDURE

/***********************************************************************

 *   Selection MESSAGE
 */
QUIT=0
SAY "Select type of installation:"
SAY ""
SAY "    1: Default"
SAY "    2: Advanced"
SAY ""
SAY ""
SAY "    5: Help"
SAY "    ('q' for exit)"
SAY ""
Do UNTIL QUIT=1
  say '>'
  parse value SysCurPos() with aktzeile aktspalte
  newposition=SysCurPos(aktzeile-1,2)
  pull theChar
  IF theChar='Q' then EXIT 1
  if LENGTH(theChar)==1 & VERIFY(theChar, "12345")==0 THEN QUIT=1
  ELSE
   call beep 100, 100
  call SysCurPos aktzeile-1, 0
  SAY "1B"x || "[K"
  call SysCurPos aktzeile-1, 0
END
  SAY ""
RETURN theChar


FoxHelp:

/***********************************************************************
 *  Help Message
 */

CLS
say ''
SAY color.white || 'Default install option:' || color.gray
say ''
say color.gray  || '- This option automatically updates Firefox in the default location '
say '  on your boot drive ' || color.white || MozDir || color.gray ||' using Info-Zip.'
say ''
say '- A backup of the original will be created.'
say ''
say '- It keeps your file associations intact'
say ''
say ''
say '  NOTE: For Warp 4 users, the default location in the script can be changed:'
say ''
say '     ProgramsDir =  VALUE('PROGRAMS',,'OS2ENVIRONMENT') '
say ''
say '  Example:'
say ''
say '     ProgramsDir = ' || color.white || '[Replace with your correct path]' || color.gray
say ''
pause

CLS
say ''
say color.white || 'Advanced install option:' || color.gray
say ''
say '- Specify the location for installation of Firefox'
say '- Option to make a backup of your old Firefox version'
say '- RUN! is now included - auto setup option added !'
say ''
say '- Leaves your default Firefox installation alone.'
say ''
say '  NOTE: The directory looks like this:'
say ''
say '      \..\Programs\Firefox\'
say '                          \Firefox'
say '                          \Firefox-Bak'
say ''
say ' Usage:'
say ''
say '  I use the 'Advanced option' to test out new versions of firefox, then use'
say '  the 'Simple option' to update to the final version that I want to use.'
say ''
pause

CLS
say ''
say color.white || 'MultiPass option:' || color.gray
say ''
say '- Same as Advanced, but naming and directory struture has changed.'
say ''
say '  I like to keep my old versions of Firefox in one location:'
say ''
say ''
say '  Directory new layout looks like this:'
say ''
say '        \..\Firefox'
say '                  \Firefox-8.01'
say '                  \Firefox-6.01'
say '                  \Firefox-4.00pre'
say ''
pause
CLS

RETURN


/***********************************************************************
   Query the bootdrive                                                 *
                                                                       */
GetOS2BootDrive: PROCEDURE expose (exposeList)

                    /* install a local error handler                   */
  signal on Syntax name GetOS2BootDrive1

  boot_drive = ''
  boot_drive = SysBootDrive()

GetOS2BootDrive1:
                    /* if SysBootDrive() failed, boot_drive is still   */
                    /* empty                                           */
                    /* SysBootDrive() is only in the newer versions    */
                    /* of REXXUTIL!                                    */

  if boot_drive = '' then
  do
                    /* You should do further tests to ensure that      */
                    /* the result of this method is correct!           */

    parse upper value VALUE( "PATH",, prog.__env ) with "\OS2\SYSTEM" -2,
                        boot_drive +2
  end                                       /* if boot_drive = '' then */

return boot_drive


DontInstall:

say ''
say 'Installation was canceled.';
pause;

EXIT 0;
