/* Run this script to set up the desktop    */
/* object for Data Shield and an object     */
/* to change skins from                     */
/*                                          */
/*                                          */
/* When adding new skins you may add to     */
/* this objects parameters                  */
/*                                          */
/* Run this from the Data Shield directory  */
/*                                          */

/* Prerequisites for the desktop object     */
/* and this cmd file                        */
crlf	='0d0a'x
exe	='dshield.exe'
Title	='Data Shield'

/* Load RexxUtil DLL                        */
call RxFuncAdd 'SysLoadFuncs' , RexxUtil, 'SysLoadFuncs'
call SysLoadFuncs
Call SysCls

say crlf crlf
say 'This script sets up the desktop object for '||Title
say 'and an object to change skins from the WorkPlaceShell'||crlf
say 'Be sure you have unzipped the skins archive so the directories are'
say 'created directly under the Data Shield directory.'||crlf crlf

say 'Press [Y] to continue or [Enter] to quit'||crlf
pull approval
if approval <> 'Y' then exit
say crlf

/* Are we in the right program directory?   */
say 'Locating '||exe||'...'||crlf
TestFor=directory()||'\'||exe
CALL SysFileTree TestFor,'List','FO'
if List.0 = 0 then do
   say 'Please run this program from the same directory as the '||exe||' file'||crlf
   say 'Exiting...'||crlf
   exit
end

CALL SysFileTree directory()||'\skins\','List','DO'
if List.0 = 0 then do
   say 'You must have a '||directory()||'\Skins'||' directory and'
   say 'it must have directories created under it with skin bitmaps in them.'||crlf
   say 'Exiting...'||crlf
   exit
end
else do
   SkinList = ''
   do index = 1 to List.0
      value = right(List.index,length(List.index)-LASTPOS('\',List.index))
      if translate(value) <> 'DEFAULT' then SkinList = SkinList||' '||value
   end
end

/* Create the desktop object                */
Title    ='Data Shield'
Setup    ='OBJECTID=<DATASHIELD>;'||,
          'EXENAME=' || Directory() || '\' || exe || ';' ||,
          'STARTUPDIR=' || Directory() || ';' ||,
          'PROGTYPE=PM;'

call SysCreateObject "WPProgram", Title, "<WP_DESKTOP>", Setup, 'Update'
/* Check if the WPS object was created   */
if rc = 0 then
   say 'Object creation for 'Title ' failed!  rc='
else
   say 'Object created for' Title

/* Create the desktop object                */
Title    ='Data Shield Skins'
Setup    ='OBJECTID=<DS_SKIN>;'||,
          'EXENAME=' || Directory() || '\Skin.cmd;' ||,
          'STARTUPDIR=' || Directory() || ';' ||,
          'PARAMETERS=' || '[Choices:'||SkinList||'];' ||,
          'MINIMIZED=YES;' ||,
          'PROGTYPE=WINDOWABLEVIO;'

call SysCreateObject "WPProgram", Title, "<WP_DESKTOP>", Setup, 'Update'
/* Check if the WPS object was created   */
if rc = 0 then
   say 'Object creation for 'Title ' failed!  rc='rc||crlf crlf
else
   say 'Object created for' Title||crlf crlf

