#ifndef lint
static char Rcs_Id[] =
    "$Id: term_os2.c,v 1.3 2005/12/24 06:18:41 stream Exp $";
#endif

#include "config.h"
#include "ispell.h"
#include "proto.h"
#include "msgs.h"

#include <signal.h>
#include <errno.h>
#include <process.h>

#define INCL_ERRORS
#define INCL_DOSPROCESS
#define INCL_KBD
#define INCL_VIO
#include <os2.h>

char * last_slash (char *file); /* not prototyped in ispell.c */

jmp_buf safewritejmpbuf;
int     safewrite_active;

void ierase(void)
{
	printf("\x1B[2J");
}

void imove(int row, int col)
{
	printf("\x1B[%u;%uH", row+1, col+1);
}

void inverse(void)
{
	printf("\x1B[7m");
}

void normal(void)
{
	printf("\x1B[0m");
}

void backup(void)
{
	printf("\b");
}

void terminit(void)
{
	VIOMODEINFO mode;

	if (outfile != stdout)
		setbuf(stdout, NULL);
	setbuf(stderr, NULL);

	co = 80;
	li = 25;
	mode.cb = sizeof(mode);
	if (VioGetMode(&mode, 0) == 0)
	{
		co = mode.col;
		li = mode.row;
	}

#if MAX_SCREEN_SIZE > 0
	if (li > MAX_SCREEN_SIZE)
		li = MAX_SCREEN_SIZE;
#endif /* MAX_SCREEN_SIZE > 0 */
#if MAXCONTEXT == MINCONTEXT
	contextsize = MINCONTEXT;
#else /* MAXCONTEXT == MINCONTEXT */
	if (contextsize == 0)
#ifdef CONTEXTROUNDUP
		contextsize = (li * CONTEXTPCT + 99) / 100;
#else /* CONTEXTROUNDUP */
	contextsize = (li * CONTEXTPCT) / 100;
#endif /* CONTEXTROUNDUP */
	if (contextsize > MAXCONTEXT)
		contextsize = MAXCONTEXT;
	else if (contextsize < MINCONTEXT)
		contextsize = MINCONTEXT;
#endif /* MAX_CONTEXT == MIN_CONTEXT */
	/*
	 * Insist on 2 lines for the screen header, 2 for blank lines
	 * separating areas of the screen, 2 for word choices, and 2 for
	 * the minimenu, plus however many are needed for context.  If
	 * possible, make the context smaller to fit on the screen.
	 */
	if (li < contextsize + 8  &&  contextsize > MINCONTEXT)
	{
		contextsize = li - 8;
		if (contextsize < MINCONTEXT)
			contextsize = MINCONTEXT;
	}
	if (li < MINCONTEXT + 8)
		(void) fprintf (stderr, TERM_C_SMALL_SCREEN, MINCONTEXT + 8);

	uerasechar = 8;
	ukillchar  = 127;

	signal(SIGINT, done);
}

SIGNAL_TYPE done (int signo)
{
	(void) signo;
	/*  printf("Signal: done. Exiting\n"); */
	fcloseall();
	if (tempfile[0] != '\0')
		(void) unlink (tempfile);
	exit (0);
	// return 0; /* shall not be here */
}

int shellescape(char *buf)
{
	char *processor;
	char args[256];
	char badobj[MAXPATHLEN];
	int rc;
	RESULTCODES result;
	int ret = 1;
	int n;

	processor = getenv("COMSPEC");
	if (processor == NULL)
		processor = "CMD.EXE";

	n = sprintf(args, "%s", processor)+1;  /* create argv[0] */
	if (*buf == 0)			   /* no arguments */
		args[n++] = 0;
	else
		n += sprintf(args+n, "/C %.*s", sizeof(args)-n-4, buf)+1;
	args[n] = 0;			/* terminating NUL */

	if (rc = DosExecPgm(badobj, sizeof(badobj)-1, EXEC_SYNC, args, NULL, &result, processor))
	{
		fprintf(stderr, "DosExecPgm() failed for module '%s', rc = %d\n", badobj, rc);
		ret = 0;
	}
	fprintf(stderr, "Press any key to return...");
	GETKEYSTROKE();
	return ret;
}

#ifdef __WATCOMC__

int mkstemp(char *buf)
{
	char *p;
	int n, h;
	char localbuf[10];

	p = strstr(buf, "XXXXXX");
	if (p)
	{
		for (n = 0; n < 100; n++)
		{
			sprintf(localbuf, "%06.6d", rand());
			memcpy(p, localbuf, 6);
			h = open(buf, O_RDWR | O_CREAT | O_EXCL, S_IREAD | S_IWRITE);
			if (h != -1)
				return h;
			if (errno != ENOENT)
			{
				fprintf(stderr, "ispell: mktemp() failure, errno = %d. hit a key...\n", errno);
				GETKEYSTROKE();
				break;
			}
		}
	}

	*buf = 0;
	return -1;
}

#if __WATCOMC__ < 1200 /* popen() exist in OW and may be in 11.x */
FILE *popen(char *name, char *mode)
{
	FILE *f;

	fprintf(stderr, "ispell: executing '%s'...\n", name);

	if (mode[0] != 'r' || mode[1] != 0)
	{
		errno = EINVAL;
		return NULL;
	}

	f = tmpfile();
	if (f)
	{
		char *b;
		int rc;

		b = malloc(strlen(name) + 20);

		if (b == NULL)
			rc = -1;
		else
		{
			sprintf(b, "%s 1>&%d", name, fileno(f));

			rc = system(b);

			free(b);

			if (
				setmode(fileno(f), O_TEXT) == -1 ||
				fseek(f, 0, SEEK_SET) != 0
			   )
				rc = -1;
		}

		if (rc == -1)
		{
			fclose(f);
			f = NULL;
		}
	}
	return f;
}
#endif /* old __WATCOMC__ */
#endif /* __WATCOMC__ */

char os2_LIBDIR[MAXPATHLEN];
char os2_TEMPNAME[MAXPATHLEN];

char *os2_init(char *argv0)
{
	char *p;

	/* Randomize temporary file names */

	srand(getpid());

	/* Set os2_TEMPNAME using temp directories */

	p = getenv("TEMP");
	if (p == NULL)
	{
		p = getenv("TMP");
		if (p == NULL)
		{
			p = getenv("TEMPDIR");
			if (p == NULL)
				p = ".";
		}
	}

	p = last_slash(strcpy(os2_TEMPNAME, p)); /* append slash if not */
	if (p == NULL || p[1] != 0)
		strcat(os2_TEMPNAME, "/");
	strcat(os2_TEMPNAME, "isXXXXXX.tmp");

	/* Set os2_LIBDIR using home dir and 'lib' subdirectory */

	p = last_slash(strcpy(os2_LIBDIR, argv0));
	if (p != NULL) /* Have dir - next char will be short argv[0] */
	{
		p++;
		argv0 += (p - os2_LIBDIR);
	}
	else  /* No dir. Keep argv[0] as is */
		p = os2_LIBDIR;
	strcpy(p, "lib");

	return argv0;
}

int os2_GETKEYSTROKE(void)
{
	int rc;
	KBDKEYINFO data;

	for (;;)
	{
		if (rc = KbdCharIn(&data, IO_WAIT, 0))
		{
			fprintf(stderr, "OS/2 Keyboard error, rc = %d\n", rc);
			done(0);
		}
		if ((data.fbStatus & 2) && (data.chChar == 0 || data.chChar == 0xE0))
			continue;
		return data.chChar;
	}
}

void spaceabort(void)
{
	if (safewrite_active >= 0)
	{
		fprintf(stderr, "ispell: Disk write error (not enough disk space)\n");
		sleep(2);
	}
	if (safewrite_active > 0)
		longjmp(safewritejmpbuf, -1);
	safewrite_active = -1;
}

void safe_putc(int __c, FILE *__fp)
{
	if (putc(__c, __fp) == EOF)
		spaceabort();
}
