/*
 * $Id: local.h,v 1.2 2005/12/24 06:18:41 stream Exp $
 */

#define MINIMENU      1	 /* Display a mini-menu at the bottom of the screen */
#define USG           1	 /* Define on System V or if term.c won't compile */
#define TRUNCATEBAK   1  /* Truncate .BAK files to MAXNAMLEN characters   */
#define REGEX_LOOKUP  1  /* enable regexp vocab search */
#define MAXCONTEXT    5  /* show up to 5 lines of text on screen, also use less memory */

#define HAS_RENAME    1
#define SIGNAL_TYPE   void
#define MAXPATHLEN    _MAX_PATH
#define MAXNAMLEN     _MAX_FNAME

#define GETKEYSTROKE() os2_GETKEYSTROKE()

extern char * re_comp(const char * expr);
extern int 	  re_exec(const char * pat);

#define REGCTYPE		char *
#define REGFREE(re)		/* Do nothing */
#define REGCMP(re, str)		re_comp (str)
#define REGEX(re, str, dummy)	re_exec (str)
#define HAVE_STRING_H           1

#define IS_SLASH(c)	((c) == '/'  ||  (c) == '\\')

/*
 * Important directory paths
 */

#define TEMPNAME      os2_TEMPNAME
#define LIBDIR        os2_LIBDIR

/*
 * Place any locally-required #include statements here
 */

#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>
#include <dos.h>
#include <fcntl.h>

/*
 * Local functions
 */

void  spaceabort(void);                /* raise 'out-of-disk-space' condition */
void  safe_putc(int __c, FILE *__fp);  /* run spaceabort() on error           */
char *os2_init(char *argv0);
int   os2_GETKEYSTROKE(void);

extern char os2_TEMPNAME[MAXPATHLEN];
extern char os2_LIBDIR[MAXPATHLEN];

extern int     safewrite_active;
extern jmp_buf safewritejmpbuf;

#define beginsafewrite() (safewrite_active = 1, setjmp(safewritejmpbuf))
#define endsafewrite()   (safewrite_active = 0)

/*
 * Look like shellescape() prototype not defined under some conditions
 */

int  shellescape(char *buf);

/*
 * Local implementations of some system functions
 */

#ifdef __WATCOMC__
int   mkstemp(char *name);
#if __WATCOMC__ < 1200
FILE *popen(char *file, char *mode);
#else
#define popen _popen
#endif

#pragma disable_message(202);

#endif
