#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#define INCL_NOPM
#define INCL_DOSPROCESS
#define INCL_DOSQUEUES
#include <os2.h>

static char logname[_MAX_PATH];

static HFILE ihRead = -1, ihWrite = -1;

static void log_va(char *format, va_list args)
{
	static FILE *f;
	char timebuf[40];
	struct tm *ptm;
	time_t     ti;

	if (format == NULL)
	{
		if (f)
			fclose(f);
		f = NULL;
		return;
	}

	ti  = time(NULL);
	ptm = localtime(&ti);

	if (f == NULL)
	{
		f = fopen(logname, "at");
		if (f)
		{
			setbuf(f, NULL);
			strftime(timebuf, sizeof(timebuf), "%d %b %Y", ptm);
			fprintf(f, "\n--------  %s, ispelld 1.00\n", timebuf);
		}
	}
	if (f)
	{
		strftime(timebuf, sizeof(timebuf), "%T", ptm);
		fprintf(f, "%s  ", timebuf);
		vfprintf(f, format, args);
		va_end(args);
		fprintf(f, "\n");
	}
}

static void log(char *format, ...)
{
	va_list args;

	va_start(args, format);
	log_va(format, args);
}

static void quit(char *err, ...)
{
	va_list args;

	if (err && *err)
	{
		va_start(args, err);
		log_va(err, args);
	}
	if (ihRead != -1)
		DosClose(ihRead);
	if (ihWrite != -1)
		DosClose(ihWrite);
	log(NULL);
	exit(err ? 1 : 0);
}
#pragma aux quit aborts;

static void usage(char *text)
{
	printf("\n"
		   "ispelld: %s.\n"
		   "\n"
		   "Usage: ispelld  --ispelld-options  [ispell-exe-options]\n"
		   "\n"
		   "       --pipe   - communicate using pipe \\PIPE\\ISPELL;\n"
		   "\n"
		   "All other options are passed to ISPELL unchanged.\n",
		   text);
	quit("%s, usage screen displayed", text);
}

static int iscommand(char *s, char *command)
{
	if (s[0] == '-' && s[1] == '-')
	{
		int n = strlen(command);
		if (!memcmp(s+2, command, n) && (s[n+2] == 0 || isspace(s[n+2])))
			return 1;
	}
	return 0;
}

APIRET api(APIRET rc, char *func)
{
	if (rc)
		log("Error: %s() failed with rc = %d", func, rc);
	return rc;
}

static void xdup(HFILE pipeHandle, HFILE ioHandle)
{
	if (api(DosDupHandle(pipeHandle, &ioHandle), "DosDupHandle"))
		quit("Failed to duplicate handle %d->%d", ioHandle, pipeHandle);
	log("handle %d duplicated to %d", ioHandle, pipeHandle);
}

void main(int argc, char **argv)
{
	char ispellexe[_MAX_PATH];
	char badobj[_MAX_PATH];
	char *s, *last;
	int  n1, n2;
	PPIB ppib;
	int  pipe = 0;
	RESULTCODES res;

	if (argc == 2)
	{
	printf("%d\n", system(argv[1]));
	exit(0);
	}


	// create pathnames for log file and ispell.exe

	strcpy(logname,   argv[0]);
	strcpy(ispellexe, argv[0]);
	for (s = last = logname; *s; s++)
		if (*s == ':' || *s == '\\' || *s == '/')
			last = s+1;
	strcpy(last, "ispelld.log");
	strcpy(ispellexe + (last-logname), "ispell.exe");
	log("ispell  exe will be : '%s'", ispellexe);

	if (argc == 1)
		usage("ispell pipe daemon, version 1.00");

	// get original command line (including spaces)

	DosGetInfoBlocks(NULL, &ppib);
	s  = ppib->pib_pchcmd;
	s += strlen(s) + 1;
	log("ispelld command line: `%s'", s);

	// look for ispelld "--options"

	for (;;)
	{
		while (*s && isspace(*s))
			s++;
		if (iscommand(s, "pipe"))
			pipe = 1;
		else
			break;

		while (*s && !isspace(*s))
			s++;
	}

	if (pipe == 0)
		usage("communication method not specified");

	if (api(DosCreatePipe(&ihRead, &ihWrite, 0x10000), "DosCreatePipe"))
		quit("Cannot create pipe for ISPELL, aborting.");
	log("created control pipe: ihRead=%d ihWrite=%d", ihRead, ihWrite);

	xdup(ihRead,  1);
	xdup(ihWrite, 0);

	// s now points to options

	log("ispell  command line: `%s'", s);
	log("executing ispell...");

	// format arguments as <program><0><arguments><0><0>

	n1 = strlen(ispellexe)+1;
	n2 = strlen(s)+1;
	last = malloc(n1+n2+1);
	if (last == NULL)
		quit("out of memory!");
	strcpy(last, ispellexe);
	strcpy(last+n1, s);
	last[n1+n2] = 0;

	if (api(DosExecPgm(badobj, sizeof(badobj), EXEC_ASYNC, last, NULL, &res, ispellexe), "DosExecPgm"))
		quit("execution failed! problem with module `%s'", badobj);




	quit(NULL);
}
