/* */

signal on novalue

parse arg in
if words(in) \= 1 then do
    call lineout "STDERR:", "Usage: dosubst subst-file <input-file >output-file"
    return 1
end

if stream(in, "c", "open read") \= "READY:" then do
    call lineout "STDERR:", "dosubst: cannot open subst-file" in
    return 1
end

do while lines(in)
    s = linein(in)
    if left(s, 6) = "subst_" then do
	parse var s "subst_" . "=" data
	if data \= "" then do
	    /* kill escapes */
	    do forever
		n = pos('\', s)
		if n = 0 then
		    leave
		s = left(s, n-1) || '" || "' || c2x(substr(s, n+1, 1)) || '"x || "' || substr(s, n+2)
	    end
	/*  say s */
	    interpret s
	end
    end
end
call stream in, "c", "close"

do while lines()
    s = linein()
    do forever
	parse var s before "!!" su "!!" later
	if su = "" then
	    leave
	varname = translate("SUBST_" || su)
/*	say su */
	if value(varname) = varname then do
	    call lineout "STDERR:", "dosubst: warning:" su "is undefined"
	    call value varname, "??" || su || "??"
	end
	s = before || value(varname) || later
    end
    say s
end

return 0
