/*
 * Simple deformatter for e-mail messages - ignores quoted text.
 * Quote character is hardcoded to '>' and number of characters to
 * look forward for quote character is hardcoded to 8.
 *
 * Copyright (c) 2002 Roman Trunov, stream@ocnit.tsu.tula.ru
 *
 * Examples:
 *
 *    This line will be checked.
 *     > This line will be NOT checked
 *     You> This line will be not checked
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define LOOKUP_FORWARD 8
#define QUOTE_CHAR    '>'

enum { STATE_DETECT, STATE_NORMAL, STATE_BLANK };

/* Support for russian 'N' works very bad, so I disabled it */


/*
static void usage(void)
{
	printf("\ndeformat-mail: a deformatter for Ispell which hides quoting in mail messages.\n"
		   "Only your own text will be spell-checked.\n"
		   "Use this program with '-F' option of Ispell:\n"
		   "\n"
		   "      ispell  ....... -F deformat-mail.exe ......\n"
		   "\n"
		   "To enable support of Russian letter 'N' in FidoNet messages, use\n"
		   "\n"
		   "      ispell  ....... -F \"deformat-mail.exe -n\" .......\n"
		   "\n"
		   "Note: you may need to specify full path to 'deformat-mail.exe'\n"
		  );
	exit(1);
}

#ifdef __WATCOMC__
#  pragma aux usage aborts;
#endif
*/

int main(/* int argc, char **argv */)
{
	char lookupbuf[LOOKUP_FORWARD+1];
	int nlookup = 0;
	int state = STATE_DETECT;
	int i, c;
/*	int rus_n = 0;

	if (argc > 2)
		usage();
	if (argc == 2)
	{
		if (strcmp(argv[1], "-n"))
			usage();
		rus_n = 1;
	}
*/
	do
	{
		while ((c = getchar()) != EOF)
		{
/*			if (c == 'H' && rus_n)
				c = 0x8D;
*/
			if (c == '\n')
			{
				state = STATE_DETECT;
				break;
			}
			if (state != STATE_DETECT)
			{
				if (state == STATE_BLANK)
					c = ' ';
				putchar(c);
			}
			else
			{
				lookupbuf[nlookup] = c;
				nlookup++;
				if (c == QUOTE_CHAR)
				{
					state = STATE_BLANK;
					break;
				}
				if (nlookup >= LOOKUP_FORWARD)
				{
					state = STATE_NORMAL;
					break;
				}
			}
		}

		for (i = 0; i < nlookup; i++)
			putchar(state == STATE_BLANK ? ' ' : lookupbuf[i]);
		nlookup = 0;

		if (c == '\n')
			putchar(c);
	}
	while (c != EOF);
	return 0;
}
