/* */

vocabs   = "english.0  english.1  english.2  english.3" /* basic vocabs */
british  = "british.0  british.1  british.2"            /* british spellings */
american = "american.0 american.1 american.2"           /* american spellings */
altamer  = "altamer.0  altamer.1  altamer.2"            /* alt. american */

out_base = "english"
out_dic  = out_base || ".tmp"   /* temporary file to hold whole vocab */

signal on novalue
call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs

say
say "Setting up english dictionaries. Press Ctrl-C to cancel"
say
say "Enter one or more dictionary options:"
say "   [A] to include American spellings (e.g.: color);"
say "   [B] to include British spellings (e.g.: colour);"
say "   [L] to include some aLternative American spellings."
say
say "Note: you can enter more than one letter or even all three of them."
do forever
    say
    call charout , "Your choice: "
    pull answer
    if answer = "" then do
	say
	say "You haven't selected not a single option."
	if AskYesNo("Build basic dictionaries only [not recommended] (Y/N) ? ") then
	    leave
	iterate
    end
    if verify(answer, "ABL") \= 0 then do
	say "Incorrect letter in answer. Please re-enter."
	iterate
    end
    if pos("A", answer) \= 0 then
	vocabs = vocabs american
    if pos("B", answer) \= 0 then
	vocabs = vocabs british
    if pos("L", answer) \= 0 then
	vocabs = vocabs altamer
    leave
end

call SysFileDelete out_dic
say
say "1. Building complete dictionary..."
do voc=1 to words(vocabs)
    in = word(vocabs, voc)
    call charout , "   " || in || "... "

    call OpenFile in
    do while lines(in)
	s = linein(in)
	if lineout(out_dic, s) \= 0 then
	    call WriteError
    end
    call CloseFile in
    say "Ok."
end
if CloseFile(out_dic) \= "READY:" then
    call WriteError

say
say "2. Building hash table"
out_hash = "..\..\lib\english.hash"
"@..\..\buildhash" out_dic "english.aff" out_hash
if rc \= 0 | stream(out_hash, "C", "QUERY EXISTS") = "" then
    call Problem "Error during hash table creation!"

say
if AskYesNo("Delete temporary files (Y/N) ? ") then do
    call SysFileDelete out_base || ".cnt"
    call SysFileDelete out_base || ".stat"
    call SysFileDelete out_dic
end

say
say "Done!"

return 0

OpenFile:
    parse arg __file
    if stream(__file, "C", "OPEN READ") \= "READY:" then
	call Problem "File not found!"
    Return

CloseFile: procedure
    parse arg f
    s = stream(f, "C", "CLOSE")
    Return s

WriteError:
    call Problem "Error writing file, disk full?"
    Return

Problem:
    parse arg t
    say t
    call CloseFile out_dic
    call SysFileDelete out_dic
    exit 1

AskYesNo: procedure
    parse arg msg

    call charout ,msg
    do forever
	c = translate(SysGetKey("NOECHO"))
	select
	    when c = "00"x then call SysGetKey "NOECHO"
	    when c = "1B"x then do; say; say "Installation aborted."; exit 1; end
	    when c = "Y"   then do; say "Yes"; return 1; end
	    when c = "N"   then do; say "No";  return 0; end
	    otherwise nop
	end
    end
