/*
 * Psych0's Astrology Tool
 * (k) 1998, 1999 by Andrew Ziem <ziem@iex.net>
 * http://members.xoom.com/sdexter/psoft/
 *
 */


int read(char *fname)
{
  FILE *f;
  char line[MAX_FGETS], *ptr;


  f = fopen(fname, "rt");
  if (f == NULL)
  {
    fprintf(stderr, "  --> error: unable to open `%s' for reading\n", fname);
    return FALSE;
  }

  fgets(line, MAX_FGETS, f);

  fclose(f);

  if (strstr(line, "chart for"))
     return read_chart(fname);
  else
     if (strstr(line, DAT_HDR))
        return read_data(fname);
  else
     printf("  -- unknown file type\n");

  return FALSE;

} /* read() */


int read_chart(char *fname)
{
  FILE *f;
  CHART c;
  int x, y;
  char line[MAX_FGETS], mini[50], sign[10], *ptr;


  f = fopen(fname, "rt");

  if (NULL == f)
  {
    fprintf(stderr, "  --> error: unable to open `%s' for reading\n", fname);
    return FALSE;
  }

  /* first line with name -- "Astrolog 5.30e chart for Peter J. Carroll" */

  fgets(line, MAX_FGETS, f);

  /* strip trailing cr/lf */
  strip_trailing(line);

  ptr = strstr(line, "chart for");

  if (!ptr)
  {
     fprintf(stderr, "  --> error: unable to find person's name in chart file\n");
     return FALSE;
  }

  strcpy(c.name, ptr + 10);

  fgets(line, MAX_FGETS, f);
  strip_trailing(line);

  if (strstr(line, "Body  Locat."))
  {
     printf("  --> warning: name omitted in chart\n");
     return FALSE;
//     strcpy(c.name, "anonymous");
  }

  /* 1   2    3  4    5       6   7     8    9   x     x         last-1 last  */
  /* Wed Jul  8, 1970 11:27am (DT -3:00 GMT) New York, New York  73:57W 40:45N */

  strcpy(mini, get_seg(line, 2, ' '));
  c.born.month = locate_token(mini, abv_months_txt, MONTHS);

  c.born.mday = atoi(get_seg(line, 3, ' '));

  c.born.year = atoi(get_seg(line, 4, ' '));

  strcpy(mini, get_seg(line, 5, ' '));
//  printf("debug: %s = %s\n", c.name, mini);
  sscanf(mini, "%i:%2i", &c.born.hour, &c.born.minutes);
  {
     if (strchr(mini, 'p') && c.born.hour == 12)
        c.born.hour = 0;
     else
     if (strchr(mini, 'p'))
        c.born.hour = c.born.hour + 12;
  }

  strcpy(mini, get_seg(line, 7, ' '));
  sscanf(mini, "%i:%i", &c.born.timezone, &c.born.timezone_minutes);
  strcpy(mini, get_seg(line, 6, ' '));
  if (strstr(mini, "DT"))
    c.born.daylightsavings = TRUE;

  ptr = &line[strlen(line)];
  x = 2;

  if (ptr)
    do
    {
       ptr--;
       if (ptr[0] == ' ')
         x--;
    } while (x > 0 || ptr == NULL);

  sscanf(ptr, "%i:%i%c %i:%i%c", &c.born.longitude, &c.born.longitude_minutes, &x, &c.born.latitude, &c.born.latitude_minutes, &y);
  if (x == 'W')
    c.born.longitude -= c.born.longitude * 2;
  if (y == 'S')
    c.born.latitude -= c.born.latitude * 2;

  ptr[0] = NUL;
  ptr = strstr(line, get_seg(line, 9, ' '));
  strncpy(c.born.location, ptr, 40);

  /* pick up the planets */
  while (!feof(f))
  {
    fgets(line, MAX_FGETS, f);

    if (line[4] == ':')
      x = locate_token(line, astbodytxt, BODIES);
      else x = -1;

    if (x > -1)
    {
      /* body found, identify position using trace(CHALK_WHITE) */

/*

0     6                                                  57
|     |                                                  |
Sun : 15Can58   - 0:00' (-) [ 4th house] [--] +0.953  -  House cusp  1:  0Ari00
Moon:  9Vir56   - 0:34' (-) [ 6th house] [--] ______  -  House cusp  2:  0Tau00

House cusp  1:  0Ari00
*/
      /* search for planet */
      strncpy(mini, line, 16);
      mini[15] = NUL;

      strcpy(sign, &mini[6]);

      y = locate_token(mini, abv_sign_txt, SIGNS);

//      printf("debug: x = %i; y = %i\n", x, y);

      if (y > -1)
      {
	     char ss[10];


          c.planet[x].sign = y;
	     strcpy(ss, sign);
	     ss[2] = NUL;
	     c.planet[x].degrees = atoi(ss);
	     strcpy(ss, sign+5);
	     ss[2] = NUL;
	     c.planet[x].minutes = atoi(ss);
	     c.planet[x].retrograde = (sign[8] == 'R');
      }

    } /* if x > -1 */

    /* search for house cusp */
 /*

    strncpy(mini, line[57], 23);
    mini[15] = NUL;

    strcpy(sign, mini + 6);
  */


  }

 fclose(f);

 LLSnodeAppendFrom(ListCharts, &c);
 charts++;

// if (opts.debug)
//   printf("debug: `%s' added\n", c.name);

 return TRUE;
} /* read_chart() */


#define CHART_INACTIVE 0
#define CHART_ACTIVE   1

int read_data(char *fname)
{
 FILE *f;
 CHART c;
 char line[MAX_FGETS], *pstr;
 int x, y, chartactive, linecnt = 0;


 /* initilize reading file */
 f = fopen(fname, "rt");

 if (!f)
 {
   fprintf(stderr, "  --> error: unable to open `%s' for reading\n", fname);
   return FALSE;
 }

 chartactive = CHART_INACTIVE;

 do
 {
   fgets(line, MAX_FGETS, f);
   linecnt++;
   strip_trailing(line);

   /* first try and find these */
   x = locate_token(line, data_tokens, DATA_TOKENS);

//   printf("debug: x = %i (linecnt %i)\n", x, linecnt);

   switch (x)
   {
     case DATA_NAME:

       if (CHART_ACTIVE == chartactive)
       {
          printf("  --> warning: missing end marker; chart already active (line %i)\n", linecnt);
          /* add whatever we have, probably should do a validity check */
          LLSnodeAppendFrom(ListCharts, &c);
          charts++;
       }

       chartactive = CHART_ACTIVE;

       clear_chart(&c);

       /* filler 'er up */
       pstr = strchr(line, '=');
       strncpy(c.name, pstr + 1, 40);
       break;


     case DATA_BIRTHDATE:

       pstr = strchr(line, '=') + 1;

       c.born.month = locate_token(pstr, abv_months_txt, MONTHS);
       c.born.mday = (unsigned int) atoi(get_seg(pstr, 2, ' '));
       c.born.year = (YEAR) atoi(get_seg(pstr, 3, ' '));
       break;


     case DATA_BIRTHTIME:

       pstr = strchr(line, '=') + 1;

       sscanf(pstr, "%i:%i", &c.born.hour, &c.born.minutes);
       break;


     case DATA_TIMEZONE:

       pstr = strchr(line, '=') + 1;

       sscanf(pstr, "%i:%i", &c.born.timezone, &c.born.timezone_minutes);
       break;


     case DATA_LOCATION:

       pstr = strchr(line, '=');
       pstr[0] = NUL;
       pstr++;

       strcpy(c.born.location, pstr);
       break;


     case DATA_LATITUDE:
     case DATA_LONGITUDE:

       pstr = strchr(line, '=');
       pstr[0] = NUL;
       pstr++;

       if (x == DATA_LATITUDE) /* N/S */
       {
          sscanf(pstr, "%i:%i%c", &c.born.latitude, &c.born.latitude_minutes, &y);
          if (y == 'S')
            c.born.latitude -= c.born.latitude * 2;
       }
       else
       {
          sscanf(pstr, "%i:%i%c", &c.born.longitude, &c.born.longitude_minutes, &y);
          if (y == 'W')
            c.born.longitude -= c.born.longitude * 2 ;
       }


       break;

     case DATA_END:

       if (CHART_ACTIVE == chartactive)
       {
          LLSnodeAppendFrom(ListCharts, &c);
          charts++;
          chartactive = CHART_INACTIVE;
       }
       else printf("  --> warning: misplaced END marker detected (line %i)\n", linecnt);
       break;

     default:

       if (NULL == strchr(line, '='))
         break;
       /* then it's a celestial body */
       x = locate_token(line, bodytxt, BODIES);
#if defined(__DJGPP__)
       // printf("debug: lt=%i (%s)\n", x, line);
#endif
       if (x >= 0 && x <= BODIES)
       {
          int deg, min;
          char sign[5], rx = ' ';


          pstr = strchr(line, '=') + 1;
          sscanf(pstr, "%i%3s%i %c", &deg, &sign, &min, &rx);
          y = locate_token(sign, abv_sign_txt, SIGNS);

          if (y > 0 && y <= SIGNS )
          {
             c.planet[x].degrees = deg;
             c.planet[x].minutes = min;
             c.planet[x].sign = y /*+ 1 */;
             c.planet[x].retrograde = ('R' == rx);
          }

       }

       break;

   } /* switch */

 } while (!feof(f));

 if (CHART_ACTIVE == chartactive)
 {
    printf("  --> warning: missing END marker detected at EOF\n");
    LLSnodeAppendFrom(ListCharts, &c);
    charts++;
 }

 fclose(f);

 return TRUE;

} /* read_data() */


int read_pday(char *fname)
{
   FILE *f;
   CHART c;
   char line[MAX_LINE];

   f = fopen(fname, "rt");

   if (f == NULL)
   {
      fprintf(stderr, "  --> error: unable to open `%s' for reading\n", fname);
      return FALSE;
   }

  while (!feof(f))
  {
     char smon[4], sday[4], syear[6], *sinfo;


     fgets(line, MAX_LINE, f);

     strip_trailing(line);

     clear_chart(&c);



     if (line[0] == 'B' || line[0] == 'E')
     {
         line[9] = ' ';

         sinfo = line + 1;
         strncpy(smon, sinfo, 2);
         sinfo = sinfo + 2;
         strncpy(sday, sinfo, 2);
         sinfo = sinfo + 2;
         strncpy(syear, sinfo, 4);
         sinfo = sinfo - 4;

         sinfo = line + 10;

         if (sinfo)
         {
            c.born.month = atoi(smon);
            c.born.mday = atoi(sday);
            c.born.year = atoi(syear);
            strncpy(c.name, sinfo, 39);
            c.name[39] = NUL;
            LLSnodeAppendFrom(ListCharts, &c);
            charts++;
         }
     }
   }

 fclose(f);

 return TRUE;

}


