/*
 * Psych0's Astrology Tool
 * (k) 1998, 1999 by Andrew Ziem <ziem@iex.net>
 * http://members.xoom.com/sdexter/psoft/
 *
 */


#include "d:\c\pat\pat.h"
#include "d:\c\pat\pat_misc.c"
#include "d:\c\pat\pat_rd.c"
#include "d:\c\pat\pat_wt.c"

#ifdef INTERACTIVE
#include "d:\c\pat\pat_int.c"
#endif


int main(int argc, char *argv[])
{
  int x, y, z;
  char drive[MAXDRIVE],
       dir[MAXDIR],
       file[MAXFILE],
       ext[MAXEXT];
  DIRSTRUCT dirfile;

  printf("\n" PROG_DISP_ONE "\n");
  printf(PROG_DISP_TWO "\n\n");

  /* initilize this and initilize that */
  atexit(exitfunc);

  /* initilize linked list */
  LLSsystemInit(2); /* one for sorting, one for charts */
  ListCharts = LLScreate(SIZEOF_CHART);
  if (ListCharts == ERR_MEMORY)
  {
     fprintf(stderr, "error: unable to initilize linked list (memory error)\n");
     return FALSE;
  }

  /* process command line */
  if (argc == 1)
   usage();

  for (z = 1; z < argc; z++)
  {
    char *opt;


    opt = argv[z];

    if (opt[0] == '/' || opt[0] == '-')
       switch(toupper(opt[1]))
       {

	  case 'I':

#ifdef INTERACTIVE
          interactive_main();
#else
          printf("Sorry, this version not compiled for inactive mode.\n\n");
#endif
          break;


	  case '?':

		printf("Compiled on " __DATE__ " at " __TIME__ " using " COMPILER_NAME ".\n");
		printf(CONTACT);
          printf("\nFor commands, run program with no command line.\n");
          printf("\nFor further information, see the documentation file 'PAT.DOC'.\n");
		printf("\n");
	     break;

/*
	  case 'D':

	     opts.debug = opt[2] == '+';
	     printf("debug: debug is now %s\n", opts.debug == TRUE ? "on" : "off");

	     break;
*/

          case 'R':

            switch(toupper(opt[2]))
            {
               case 'C':

                 printf("Reading chart data files:\n");
                 break;

               case 'D':

                 printf("Reading PAT data files:\n");
                 break;

               case 'P':

                 printf("Reading Psych0Day libraries:\n");
                 break;

               default:

                 printf("Reading data files (autodetect):\n");
                 break;
            } /* switch */

            for (y = z + 1; y < argc; y++)
            {
              char newfile[MAXPATH];


              x = findfirst(argv[y], &dirfile, FINDATTR);
              fnsplit(argv[y], drive, dir, NULL, NULL);

              while (!x)
              {

                /* split and rearrange filename components */
                fnsplit(ffname(dirfile), NULL, NULL, file, ext);
                fnmerge(newfile, drive, dir, file, ext);
                printf("  %s...\n", newfile);

                switch(toupper(opt[2]))
                {
                   case 'C':

                     read_chart(newfile);
                     break;

                   case 'D':

                     read_data(newfile);
                     break;

                   case 'P':

                     read_pday(newfile);
                     break;

                   default:

                     read(newfile);
                     break;
                } /* switch */

              x = findnext(&dirfile);

              } /* while */

              if (y + 1 < argc && '-' == argv[y + 1][0])
                 break;

            } /* for */

            printf("\n");

            break; /* 'R' */


	  case 'W':

            if (/* charts < 1 || */ !LLSnodePtr2First(ListCharts))
            {
               printf("Write requested:\n");
               fprintf(stderr, "  --> error: nothing to write; no data available\n\n");

               break;
            }

            switch(toupper(opt[2]))
	    {
            case 'A':

              write_astrolog(argv[++z]);
              break;

	       case 'C':

              write_combo(argv[++z]);
              break;

	       case 'D':

              write_data(argv[++z]);
              break;

	       case 'N':

              write_numerology(argv[++z]);
              break;


	       case 'P':

              write_plain(argv[++z]);
              break;

               case 'S':

                 write_bysign(argv[++z]);
                 break;

            } /* switch */
            break;

          default:

            printf("You're typing jibberish.  What's `%s' supposed to mean anyway?\n\n", argv[z]);
            break;

    } /* switch */
  }


  printf("Done.\n");


  return 0;
} /* main() */


/* end of file "PAT.C" */
