/*******************************************************************************
* mph     : constantes, externs, and data-structures                           *
*                                                                              *
* version : 4.01                                                               *
* date    : 05/08/93                                                           *
*******************************************************************************/
#ifndef MPH
#define MPH

/* physical connector orientation  */
#define NORTH       'N' 
#define EAST        'E' 
#define SOUTH       'S' 
#define WEST        'W' 

/* physical segment type */
#define LEFT         'L'
#define UP           'U'
#define RIGHT        'R'
#define DOWN         'D'

/* physical symetry type  */
#define NOSYM        0  /* vti : standart  */
#define ROT_P        1  /* vti : Rot90cc   */
#define SYMXY        2  /* vti : Rot180    */
#define ROT_M        3  /* vti : Rot90c    */
#define SYM_X        4  /* vti : mx(x=-x)  */
#define SY_RM        5  /* vti : mxRot90cc */
#define SYM_Y        6  /* vti : my(y=-y)  */
#define SY_RP        7  /* vti : myRot90cc */

/* physical contact type  */
#define CONT_POLY    0
#define CONT_VIA     1
#define CONT_DIF_N   2
#define CONT_DIF_P   3
#define CONT_BODY_N  4
#define CONT_BODY_P  5
#define CONT_VIA2    8
#define CONT_VIA3    9
#define LAST_CONTACT 9

/* physical transistor flood fill macros */
#define C_X_N        6
#define C_X_P        7

/* physical layer code  */
#define NWELL        0
#define PWELL        1
#define NTIE         2
#define PTIE         3
#define NDIF         4
#define PDIF         5
#define NTRANS       6
#define PTRANS       7
#define POLY         8
#define ALU1         9
#define ALU2         10
#define ALU3         11
#define TPOLY        12
#define TALU1        13
#define TALU2        14
#define TALU3        15
#define LAST_LAYER   15

/*******************************************************************************
* layout structures types                                                      *
*******************************************************************************/
typedef struct phfig                           /* physical figure             */
{
struct phfig *NEXT;                            /* next figure                 */
struct chain *MODELCHAIN;                      /* list of models              */
struct phseg *PHSEG;                           /* segment list head           */
struct phvia *PHVIA;                           /* contact list head           */
struct phref *PHREF;                           /* reference list head         */
struct phins *PHINS;                           /* instance list head          */
struct phcon *PHCON;                           /* connector list head         */
char         *NAME;                            /* figure name (unique)        */
char         MODE;                             /* if 'A' all , else perif     */
long         XAB1,YAB1,XAB2,YAB2;              /* abutment box coordinates    */
struct ptype *USER;                            /* Application specific        */
}
phfig_list;

typedef struct phcon                           /* physical connector          */
{
struct phcon *NEXT;                            /* next connector              */
char         *NAME;                            /* connector name              */
long         INDEX;                            /* connector index(unique)     */
long         XCON,YCON;                        /* connector coordinates       */
long         WIDTH;                            /* connector width             */
char         ORIENT;                           /* possible values: N E S W    */
char         LAYER;                            /* physical layer              */
struct ptype *USER;                            /* Application specific        */
}
phcon_list;

typedef struct phseg                           /* physical (symbolic) segment */
{
struct phseg    *NEXT;                         /* next segment                */
char            *NAME;                         /* segment name                */
long             X1,Y1,X2,Y2;                  /* segment coordinates         */
long             WIDTH;                        /* segment width               */
char             TYPE;                         /* possibles values: L U R D   */
char             LAYER;                        /* physical layer              */
struct ptype    *USER;                         /* Application specific        */
}
phseg_list;

typedef struct phvia                           /* physical contact            */
{
struct phvia    *NEXT;                         /* next contact                */
char             TYPE;                         /* contact type: see define    */
long             XVIA,YVIA;                    /* coordinates                 */
struct ptype    *USER;                         /* Application specific        */
}
phvia_list;

typedef struct phref                           /* physical reference          */
{
struct phref    *NEXT;                         /* next reference              */
char            *FIGNAME;                      /* reference type              */
char            *NAME;                         /* reference name (unique)     */
long             XREF,YREF;                    /* coordinates                 */
struct ptype    *USER;                         /* Application specific        */
}
phref_list;

typedef struct phins                           /* physical instance           */
{
struct phins    *NEXT;                         /* next instance               */
char            *INSNAME;                      /* instance name (unique)      */
char            *FIGNAME;                      /* model name                  */
long             XINS,YINS;                    /* coordinates                 */
char             TRANSF;                       /* possible values: cf define  */
struct ptype    *USER;                         /* Application specific        */
}
phins_list;

/*******************************************************************************
* externals for physical view                                                  *
*******************************************************************************/
extern phfig_list *HEAD_PHFIG;                 /* physical figure list head   */
extern phfig_list *addphfig();
extern phins_list *addphins();
extern phvia_list *addphvia();
extern phref_list *addphref();
extern phseg_list *addphseg();
extern phcon_list *addphcon();
extern void defab();
extern phfig_list *getphfig();
extern phins_list *getphins();
extern phcon_list *getphcon();
extern phref_list *getphref();
extern int delphcon();
extern int delphins();
extern int delphfig();
extern int delphvia();
extern int delphseg();
extern int delphref();
extern void xyflat();
extern void viewph();
#endif /* !MPH */
