// pmmath.h
// (c) Petr Mikulik (mikulik@sci.muni.cz) - 1994
// Freeware version. It is distributed without any warranty.

#ifndef PMMATH_H
#define PMMATH_H

#include <math.h>
#include <float.h>

extern const double MachEps;     // = 2.3e-16;  // DBL_EPSILON
extern const double SqrtMachEps; // = 1.55e-8;  // sqrt(DBL_EPSILON)

#define M_TWO_PI        6.28318530717958647692   //  2*
#define M_TWO_PI_LESS   6.2831853                //  2**0.9999nearly
#define M_1_TWO_PI	0.159154943091895346     //  1/(2*)
#define M_SQRPI         9.86960440108935799      //  ^2
#define M_16_SQRPI      157.913670417429728      //  16*^2
#define M_SQRTPI        1.77245385090551588      //  sqrt()
#define M_SQRTPI_2      0.88622692545275794      //  sqrt()/2
#define M_SQRT2PI	2.50662827463100024	 //  sqrt(2)

// degree symbol
#ifdef __MSDOS__
  #define DEG '\xF8'
#else
  #define DEG " deg"
#endif

extern const double M_3_PI_2;      //  3*/2
extern const double M_SQRT_TWO_PI; // sqrt(2*)

extern const double sec2rad; // M_PI / (180.*3600)
extern const double min2rad; // M_PI / (180.*60)
extern const double deg2rad; // M_PI / 180.
extern const double rad2sec; // 1 / sec2rad;
extern const double rad2min; // 1 / min2rad;
extern const double rad2deg; // 1 / deg2rad;

extern const double GoldenMean;  // 0.618033988749895;

inline int round ( const double x ) { return int(x+0.5); }
inline int even ( const int x ) { return (x%2==0); }
inline int odd ( const int x ) { return (x%2==1); }
inline int sgn ( const double x )
  { if (x==0) return 0; else return x>0 ? 1 : -1; }

int OKinterval ( double from, double to, double step );
  // step must be > 0  and  from >= to
int OKinterval_noeq ( double from, double to, double step );
  // step must be > 0  and  from > to

double angle2_pipi ( double angle );
double angle2_02pi ( double angle );
int in_angles( double x, double a1, double a2 );
int in_angles( float x,  float a1,  float a2 );

#ifndef __hppa
inline int sqr ( int x ) { return x*x; }
inline double sqr ( double x ) { return x*x; }
inline double sqr ( float x ) { return x*x; }
#endif

inline double min ( double value1, double value2 )
  { return ( (value1 < value2) ? value1 : value2); }
inline double max ( double value1, double value2 )
  { return ( (value1 >= value2) ? value1 : value2); }

#ifndef __hpux
double pow ( double x, int n );
#endif

double sinc ( double x );
double sinc ( float x );

// for ANSI compilers:
#ifndef M_PI
#define M_E         2.71828182845904523536
#define M_LOG2E     1.44269504088896340736
#define M_LOG10E    0.434294481903251827651
#define M_LN2       0.693147180559945309417
#define M_LN10      2.30258509299404568402
#define M_PI        3.14159265358979323846
#define M_PI_2      1.57079632679489661923
#define M_PI_4      0.785398163397448309616
#define M_1_PI      0.318309886183790671538
#define M_2_PI      0.636619772367581343076
#define M_1_SQRTPI  0.564189583547756286948
#define M_2_SQRTPI  1.12837916709551257390
#define M_SQRT2     1.41421356237309504880
#define M_SQRT_2    0.707106781186547524401
#endif

#endif
