// LINDEF3.CPP
// original version o_lindf2, April 1994, unknown author
// enlarged by Petr Mikulik (November, June 1994)

#include <math.h>
#include <stdio.h>
#ifdef __DECCXX
  #define __STDC__
#endif
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "lindef3.h"

   char outVecleft[]   = "[ ";
   char outVecmiddle[] = ", ";
   char outVecright[]  = " ]";
   char outVecformat[] = "%g";
   char outMatchar     = ' '; // usually '\n' or ' '


/*
 *	Vector
 */

Vector operator+ (const Vector &a, const Vector &b) {
 Vector c(a.n);
 for ( int i=0; i<a.n; c.vektor[i]=a.vektor[i]+b.vektor[i], i++ );
 return c; }

Vector operator- (const Vector &a, const Vector &b) {
 Vector c(a.n);
 for ( int i=0; i<a.n; c.vektor[i]=a.vektor[i]-b.vektor[i], i++ );
 return c; }

Vector Vector::operator+= (const Vector &a) {
 for ( int i=0; i<n; vektor[i]+=a.vektor[i], i++ );
 return *this; }

Vector Vector::operator-= (const Vector &a) {
 for ( int i=0; i<n; vektor[i]-=a.vektor[i], i++ );
 return *this; }

Vector operator* (const double a, const Vector &b) {
 Vector c(b.n);
 for ( int i=0; i<b.n; c.vektor[i]=a*b.vektor[i], i++ );
 return c; }

Vector operator* (const Vector &b, const double a) {
 Vector c(b.n);
 for ( int i=0; i<b.n; c.vektor[i]=a*b.vektor[i], i++ );
 return c; }

Vector operator/ (const Vector &b, const double a) {
 Vector c(b.n);
 for ( int i=0; i<b.n; c.vektor[i]=b.vektor[i]/a, i++ );
 return c; }

double operator* (const Vector &a, const Vector &b) {
 double c=0.;
 for ( int i=0; i<a.n; c+=a.vektor[i]*b.vektor[i], i++ );
 return c; }

Vector Vector::operator*= (const double a) {
 for ( int i=0; i<n; vektor[i]*=a, i++ );
 return *this; }

Vector Vector::operator/= (const double a) {
 for ( int i=0; i<n; vektor[i]/=a, i++ );
 return *this; }

Vector vectproduct(Vector &a, Vector &b) {
 Vector c(3);
 c[1]=a[2]*b[3]-a[3]*b[2];
 c[2]=a[3]*b[1]-a[1]*b[3];
 c[3]=a[1]*b[2]-a[2]*b[1];
 return c; }


void  Vector::init (int d) {
  if (d > 0) {
    vektor = new double [d];
    if (vektor == 0) {
      perror ("Not memory for Vector");
      exit (1); }
    }
  n = (d > 0) ? d : 0;
}

Vector::Vector ( double a, double b ) {
  init(2); vektor[0]=a; vektor[1]=b; }

Vector::Vector ( double a, double b, double c ) {
  init(3); vektor[0]=a; vektor[1]=b; vektor[2]=c; }

Vector::Vector (Vector& v) { init (v.n); *this = v; }

Vector::~Vector  (void) { if (n > 0) delete [] vektor; }

Vector& Vector::operator= (Vector& v) {
  if (n == v.n) {
    for (double *v1 = vektor, *v2 = v.vektor, *end = vektor+n;
	 v1 < end; v1++, v2++)
      { *v1 = *v2; }
    }
  return *this;
}

ostream & operator << (ostream &out, const Vector &a) {
char buffer[80];
out << outVecleft;
for (int i=0; i<a.n; i++) {
  sprintf(buffer,outVecformat,a.vektor[i]); out << buffer;
  if (i<a.n-1) out << outVecmiddle; }
out << outVecright;
return out;
}

istream & operator >> (istream &inp, Vector &a) {
if (a.n<1 || !inp) return inp;
char C;
for (int i=0; i<a.n; i++) {
  inp >> a.vektor[i];
  if (!inp) // skip any letter in front of the number (if any)
    { inp.clear(0); inp >> C;
      inp >> a.vektor[i];
      if (!inp)
	{ cerr << "Bad vector (dimension "<<a.n<<" required).\n"; exit(1); }
    }
  }
do { inp.get(C); }
while (isspace(C) && C!='\n' && C!='\r'); //skip the closing char
if (strchr("0123456789+-",C)!=NULL) inp.putback(C);
return inp;
}


double Vector::norm () {
 double s, r=0.;
 for ( int i=0; i<n; s=vektor[i++], r+=s*s );
 return r; }

double Vector::length () { return sqrt(norm()); }


/************ topolar *************/

Vector topolar (Vector& a) {
  Vector c(2);
  c[1]=a.length();
  c[2]=atan2(a[2],a[1]);
  return c; }


/************  Matrix ****************/


void	Matrix::init ( int dm, int dn ) {
if ((dm > 0) && (dn > 0)) {
    matice = new Vector* [dm];
    if (matice == 0) {
      perror ("Not memory for Matrix");
      exit (1); }
    for (int i = 0; i < dm; i++) {
      matice [i] = new Vector (dn);
      if (matice[i] == 0) {
	perror ("Not memory for field Matrix");
	exit (1); }
      }
    m = dm;
    }
  else m = 0;
}


Matrix::Matrix ( Matrix& m ) {
int d1, d2;
m.dim(d1,d2);
init(d1,d2);
*this = m;
}


Matrix::~Matrix ( void ) {
if (m > 0) {
  for (int i = 0; i < m; i++)
    delete matice [i];
  delete [] matice;
  }
}


Matrix& Matrix::operator= ( Matrix& v ) {
if (m == v.m) {
  for (Vector **v1 = matice, **v2 = v.matice, **end = matice + m; v1 < end; v1++, v2++)
    **v1 = **v2;
  }
return *this;
}


Matrix Matrix::operator* ( Matrix& m ) {
int d1,d2,m1,m2;
double t;
dim(d1,d2); m.dim(m1,m2);
Matrix tem(d1,m2);
if (d2==m1) {
  for (int i=1; i<=d1; i++) {
    for (int j=1; j<=m2; j++) {
      t=0;
      for (int k=1; k<=d2; k++) t+=(*this)[i][k]*m[k][j];
      tem[i][j]=t;
      }
    }
  }
return tem;
}

/* OLD:
Matrix Matrix::operator* ( double& c ) {
int d1,d2;
dim(d1,d2);
Matrix tem(d1,d2);
if (d2>0)
  for (int i=0; i<d1; i++)
    for (int j=0; j<d2; j++) tem[i][j]+=(*this)[i][j]*c;
return tem;
}
*/


Matrix operator+ (const Matrix& a, const Matrix& b) {
Matrix c(a.dimvec(),a.dim()); // no check for correct dimensions
for ( int i=0; i<a.m; i++ )
  *c.matice[i]=*a.matice[i]+*b.matice[i];
return c; }

Matrix operator- (const Matrix& a, const Matrix& b) {
Matrix c(a.dimvec(),a.dim()); // no check for correct dimensions
for ( int i=0; i<a.m; i++ )
  *c.matice[i]=*a.matice[i]-*b.matice[i];
return c; }

Matrix Matrix::operator+= (Matrix &a) {
for ( int i=0; i<m; *matice[i]+=*a.matice[i], i++ );
return *this; }

Matrix Matrix::operator-= (Matrix &a) {
for ( int i=0; i<m; *matice[i]-=*a.matice[i], i++ );
return *this; }

Matrix operator* (const double a, const Matrix &b) {
Matrix c(b.dimvec(),b.dim());
 for ( int i=0; i<b.m; *c.matice[i]=a* (*b.matice[i]), i++ );
 return c; }

Matrix operator* (const Matrix &b, const double a) {
Matrix c(b.dimvec(),b.dim());
 for ( int i=0; i<b.m; *c.matice[i]=a* (*b.matice[i]), i++ );
 return c; }

Matrix operator/ (const Matrix &b, const double a) {
Matrix c(b.dimvec(),b.dim()); double aa=1./a;
 for ( int i=0; i<b.m; *c.matice[i]=aa*(*b.matice[i]), i++ );
 return c; }

Matrix Matrix::operator*= (const double a) {
 for ( int i=0; i<m; *matice[i]*=a, i++ );
 return *this; }

Matrix Matrix::operator/= (const double a) {
 for ( int i=0; i<m; *matice[i]/=a, i++ );
 return *this; }


void neglect_small ( Matrix& a, double Limit ) {
int i,k,m,n; a.dim(m,n); double tmp, R=fabs(a[1][1]);
for (i=1; i<=m; i++) for (k=1; k<=n; k++)  //find the greatest
  { tmp=fabs(a[i][k]); if (R<tmp) R=tmp; } //element
Limit*=R;
for (i=1; i<=m; i++) for (k=1; k<=n; k++)
  { tmp=fabs(a[i][k]); if (tmp<Limit) a[i][k]=0.; }
}

double minor3 (Matrix& a, int I, int J) {
#define L(K) (((K)-1)%3+1)
return a[L(I+1)][L(J+1)]*a[L(I+2)][L(J+2)]-a[L(I+1)][L(J+2)]*a[L(I+2)][L(J+1)];
}

Matrix transp3 ( Matrix& a ) {
Matrix b(3); int i,k;
for (i=1; i<=3; i++) for (k=1; k<=3; k++) b[i][k]=a[k][i];
return b;
}

double deter3(Matrix& A) {
return A[1][1]*minor3(A,1,1)+A[1][2]*minor3(A,1,2)+A[1][3]*minor3(A,1,3);
}

Matrix invmat3 (Matrix& A) {
int I,J; double D=deter3(A);
if (!D) { cout <<"Singular matrix: "<<A<<" !\n"; exit(1); }
Matrix B(3);
for (I=1; I<=3; I++) for (J=1; J<=3; J++) B[J][I]=minor3(A,I,J)/D;
return B;
}

ostream & operator << (ostream &out, const Matrix &a) {
for (int i=0; i<a.m; i++) out << *a.matice[i] << outMatchar;
return out;
}

istream & operator >> (istream &inp, Matrix &a) {
if (a.m<1 || !inp) return inp;
for (int i=0; inp && i<a.m; i++) {
  inp >> *a.matice[i];
  //  if (!inp) break;
  }
return inp;
}


// eof lindef3.cpp
