#include <stdio.h>

#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>

#if defined(__STDC__)
#include <stdlib.h>
#endif

#include "P_.h"
#include "astro.h"
#include "circum.h"
#include "skytoolbar.h"


extern Widget toplevel_w;
extern Colormap xe_cm;

extern Now *mm_get_now P_((void));
extern int si_ison P_((void));
extern void get_something P_((Widget w, char *resource, XtArgVal value));
extern void set_something P_((Widget w, char *resource, XtArgVal value));
extern void set_xmstring P_((Widget w, char *resource, char *txtp));
extern void sv_all P_((Now *np));
extern void svf_gettables P_((char tt[NOBJTYPES], char ct[NCLASSES]));
extern void svf_settables P_((char tt[NOBJTYPES], char ct[NCLASSES]));
extern void sf_go_cb P_((Widget w, XtPointer client, XtPointer call));
extern void sv_dspFITS P_((void));
extern void wtip P_((Widget w, char *tip));

static void svtb_ct_cb P_((Widget w, XtPointer client, XtPointer call));
static void svtb_tt_cb P_((Widget w, XtPointer client, XtPointer call));
static void svtb_cyl_cb P_((Widget w, XtPointer client, XtPointer call));
static void svtb_sph_cb P_((Widget w, XtPointer client, XtPointer call));
static void svtb_toggle_cb P_((Widget w, XtPointer client, XtPointer call));
static void svtb_monument_cb P_((Widget w, XtPointer client, XtPointer call));
static void svtb_contrast_cb P_((Widget w, XtPointer client, XtPointer call));
static void svtb_glass_cb P_((Widget w, XtPointer client, XtPointer call));
static void svtb_gauss_cb P_((Widget w, XtPointer client, XtPointer call));
static void svtb_slice_cb P_((Widget w, XtPointer client, XtPointer call));
static void svtb_roi_cb P_((Widget w, XtPointer client, XtPointer call));

/* bitmaps and basic organization for skyvnew toolbars */

#define zoomin_width 21
#define zoomin_height 21
static unsigned char zoomin_bits[] = {
   0x00, 0x00, 0x00, 0xe0, 0x0f, 0x00, 0x38, 0x38, 0x00, 0x0c, 0x60, 0x00,
   0x84, 0x43, 0x00, 0x86, 0xc3, 0x00, 0x82, 0x83, 0x00, 0xf2, 0x9f, 0x00,
   0xf2, 0x9f, 0x00, 0xf2, 0x9f, 0x00, 0x82, 0x83, 0x00, 0x86, 0xc3, 0x00,
   0x84, 0x43, 0x00, 0x0c, 0xe0, 0x00, 0x38, 0xf8, 0x00, 0xe0, 0xef, 0x03,
   0x00, 0x80, 0x07, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x1e,
   0x00, 0x00, 0x1c};

#define zoomin_ins_width 21
#define zoomin_ins_height 21
static unsigned char zoomin_ins_bits[] = {
   0x00, 0x00, 0x00, 0x60, 0x09, 0x00, 0x28, 0x28, 0x00, 0x0c, 0x40, 0x00,
   0x80, 0x02, 0x00, 0x06, 0xc1, 0x00, 0x82, 0x82, 0x00, 0x50, 0x15, 0x00,
   0xa2, 0x8a, 0x00, 0x50, 0x15, 0x00, 0x80, 0x82, 0x00, 0x06, 0x41, 0x00,
   0x80, 0x82, 0x00, 0x04, 0xa0, 0x00, 0x28, 0x08, 0x01, 0x60, 0x35, 0x02,
   0x00, 0x40, 0x05, 0x00, 0x80, 0x08, 0x00, 0x00, 0x15, 0x00, 0x00, 0x02,
   0x00, 0x00, 0x14};

#define unzoom_width 21
#define unzoom_height 21
static unsigned char unzoom_bits[] = {
   0x00, 0x00, 0x00, 0xe0, 0x0f, 0x00, 0x38, 0x38, 0x00, 0x0c, 0x60, 0x00,
   0x04, 0x40, 0x00, 0x06, 0xc0, 0x00, 0x02, 0x80, 0x00, 0xf2, 0x9f, 0x00,
   0xf2, 0x9f, 0x00, 0xf2, 0x9f, 0x00, 0x02, 0x80, 0x00, 0x06, 0xc0, 0x00,
   0x04, 0x40, 0x00, 0x0c, 0xe0, 0x00, 0x38, 0xf8, 0x00, 0xe0, 0xef, 0x03,
   0x00, 0x80, 0x07, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x1e,
   0x00, 0x00, 0x1c};

#define unzoom_ins_width 21
#define unzoom_ins_height 21
static unsigned char unzoom_ins_bits[] = {
   0x00, 0x00, 0x00, 0x60, 0x09, 0x00, 0x28, 0x28, 0x00, 0x0c, 0x40, 0x00,
   0x00, 0x00, 0x00, 0x06, 0xc0, 0x00, 0x02, 0x80, 0x00, 0x50, 0x15, 0x00,
   0xa2, 0x8a, 0x00, 0x50, 0x15, 0x00, 0x00, 0x80, 0x00, 0x06, 0x40, 0x00,
   0x00, 0x80, 0x00, 0x04, 0xa0, 0x00, 0x28, 0x08, 0x01, 0x60, 0x35, 0x02,
   0x00, 0x40, 0x05, 0x00, 0x80, 0x08, 0x00, 0x00, 0x15, 0x00, 0x00, 0x02,
   0x00, 0x00, 0x14};

#define brighter_width 21
#define brighter_height 21
static unsigned char brighter_bits[] = {
   0x88, 0x24, 0x02, 0x10, 0x15, 0x01, 0x20, 0x80, 0x10, 0x07, 0x1f, 0x0c,
   0x98, 0x3f, 0x03, 0xc0, 0x7f, 0x00, 0xc0, 0x7f, 0x00, 0xcf, 0x7f, 0x1e,
   0xc0, 0x7f, 0x00, 0xc0, 0x7f, 0x00, 0x80, 0x3f, 0x00, 0x80, 0x3f, 0x00,
   0x00, 0x1f, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x0a, 0x00,
   0x00, 0x1f, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x0e, 0x00,
   0x00, 0x00, 0x00};

#define dimmer_width 21
#define dimmer_height 21
static unsigned char dimmer_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00,
   0x80, 0x2a, 0x00, 0x40, 0x55, 0x00, 0xc0, 0x6a, 0x00, 0x40, 0x55, 0x00,
   0xc0, 0x6a, 0x00, 0x40, 0x55, 0x00, 0x80, 0x2a, 0x00, 0x80, 0x35, 0x00,
   0x00, 0x1b, 0x00, 0x00, 0x15, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x0a, 0x00,
   0x00, 0x1f, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x0e, 0x00,
   0x00, 0x00, 0x00};

#define automag_width 21
#define automag_height 21
static unsigned char automag_bits[] = {
   0x00, 0x91, 0x00, 0x00, 0xa2, 0x02, 0x30, 0x04, 0x00, 0xc0, 0xe0, 0x03,
   0x00, 0xb3, 0x04, 0x00, 0x78, 0x09, 0x00, 0xb8, 0x08, 0x00, 0x78, 0x09,
   0x00, 0xb8, 0x08, 0xf8, 0x78, 0x09, 0x06, 0xb3, 0x04, 0x02, 0x72, 0x05,
   0x89, 0xe4, 0x02, 0x01, 0xe4, 0x03, 0x01, 0xe4, 0x03, 0x89, 0x44, 0x01,
   0x71, 0xe4, 0x03, 0x02, 0xc2, 0x01, 0x06, 0xe3, 0x03, 0xf8, 0xc0, 0x01,
   0x00, 0x00, 0x00};

#define constel_width 21
#define constel_height 21
static unsigned char constel_bits[] = {
   0x00, 0x00, 0x00, 0x80, 0x03, 0x00, 0x40, 0x12, 0x0e, 0x47, 0x28, 0x01,
   0x47, 0x28, 0x06, 0x47, 0x28, 0x08, 0x82, 0x73, 0x07, 0x02, 0x00, 0x00,
   0x04, 0x00, 0x00, 0x04, 0x0e, 0x00, 0x9c, 0x0f, 0x00, 0x7c, 0x0e, 0x00,
   0x1c, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x10, 0x1c,
   0x00, 0x10, 0x1c, 0x00, 0x10, 0x1e, 0x00, 0x70, 0x01, 0x00, 0xf0, 0x00,
   0x00, 0x70, 0x00};

#define grid_width 21
#define grid_height 21
static unsigned char grid_bits[] = {
   0x82, 0x20, 0x08, 0xff, 0xff, 0x1f, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08,
   0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0xff, 0xff, 0x1f,
   0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08,
   0x82, 0x20, 0x08, 0xff, 0xff, 0x1f, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08,
   0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0x82, 0x20, 0x08, 0xff, 0xff, 0x1f,
   0x82, 0x20, 0x08};

#define what_width 50
#define what_height 21
static unsigned char what_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x42, 0x10, 0x24, 0x00, 0x00, 0x00, 0x00, 0x43, 0x10, 0x24, 0x00, 0x20,
   0x00, 0x80, 0x43, 0x28, 0x24, 0x00, 0x20, 0x00, 0xc0, 0x83, 0x28, 0xa2,
   0xc3, 0xf3, 0x00, 0xe0, 0x83, 0x28, 0x62, 0x66, 0x26, 0x00, 0xf0, 0x83,
   0x28, 0x22, 0x04, 0x24, 0x00, 0xe0, 0x03, 0x45, 0x21, 0xc4, 0x27, 0x00,
   0xc0, 0x03, 0x45, 0x21, 0x64, 0x24, 0x00, 0x80, 0x03, 0x45, 0x21, 0x24,
   0x24, 0x00, 0x00, 0x03, 0x82, 0x20, 0x64, 0x26, 0x00, 0x00, 0x02, 0x82,
   0x20, 0xc4, 0xcd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00};

#define how_width 21
#define how_height 40
static unsigned char how_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0e, 0x00,
   0x00, 0x1f, 0x00, 0x80, 0x3f, 0x00, 0xc0, 0x7f, 0x00, 0xe0, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x80, 0x03, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x60, 0x00, 0x00, 0x10, 0x00,
   0x80, 0x0f, 0x00, 0x00, 0x10, 0x00, 0x00, 0x60, 0x00, 0x00, 0x1c, 0x00,
   0x80, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x80, 0x61, 0x00,
   0x80, 0x40, 0x00, 0x80, 0x40, 0x00, 0x80, 0x61, 0x00, 0x00, 0x3f, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x7f, 0x00, 0x00, 0x02, 0x00,
   0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00,
   0x00, 0x02, 0x00, 0xf0, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define where_width 21
#define where_height 56
static unsigned char where_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0e, 0x00,
   0x00, 0x1f, 0x00, 0x80, 0x3f, 0x00, 0xc0, 0x7f, 0x00, 0xe0, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00,
   0x00, 0x1c, 0x00, 0x80, 0x03, 0x00, 0x60, 0x00, 0x00, 0x80, 0x03, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x3c, 0x00, 0x80, 0x03, 0x00,
   0x60, 0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0x1c, 0x00, 0x00, 0xe0, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x00, 0x00, 0x08, 0x00,
   0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x18, 0x00, 0xe0, 0x0f, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x0f, 0x00, 0x60, 0x1a, 0x00,
   0x20, 0x12, 0x00, 0x20, 0x12, 0x00, 0x60, 0x1a, 0x00, 0x40, 0x0e, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x1f, 0x00,
   0x00, 0x08, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0xc0, 0x0f, 0x00,
   0x60, 0x1a, 0x00, 0x20, 0x12, 0x00, 0x20, 0x12, 0x00, 0x60, 0x1a, 0x00,
   0x40, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define orient_width 21
#define orient_height 21
static unsigned char orient_bits[] = {
   0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x0e, 0x00, 0x00,
   0x1f, 0x00, 0x00, 0x15, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00,
   0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x04, 0x00, 0x00,
   0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x04, 0x00, 0x00,
   0x04, 0x80, 0x01, 0x44, 0x04, 0x07, 0xff, 0xff, 0x1f, 0x44, 0x04, 0x07,
   0x04, 0x80, 0x01};

#define orient_ins_width 21
#define orient_ins_height 21
static unsigned char orient_ins_bits[] = {
   0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x04, 0x00, 0x00,
   0x0a, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x04, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x04, 0x00, 0x00,
   0x00, 0x80, 0x00, 0x44, 0x04, 0x05, 0xaa, 0xaa, 0x12, 0x44, 0x04, 0x05,
   0x00, 0x80, 0x00};

#define magscale_width 21
#define magscale_height 21
static unsigned char magscale_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x88, 0x01, 0x30, 0x48, 0x01, 0x30, 0xc8, 0x01,
   0x00, 0x08, 0x01, 0x00, 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x30, 0xc8, 0x01, 0x78, 0x08, 0x01, 0x78, 0xc8, 0x01, 0x30, 0x48, 0x00,
   0x00, 0xc8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xc8, 0x01,
   0xf8, 0x48, 0x01, 0xf8, 0x48, 0x01, 0xf8, 0x48, 0x01, 0x70, 0xc8, 0x01,
   0x00, 0x00, 0x00};

#define planes_width 21
#define planes_height 21
static unsigned char planes_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x08, 0x06, 0x01,
   0x90, 0x01, 0x02, 0x60, 0x00, 0x02, 0x60, 0x00, 0x02, 0x90, 0x00, 0x02,
   0x10, 0x01, 0x02, 0x08, 0x02, 0x01, 0x08, 0x00, 0x01, 0x04, 0x80, 0x00,
   0x04, 0x80, 0x00, 0x04, 0x40, 0x00, 0x04, 0x20, 0x00, 0x04, 0x98, 0x00,
   0x08, 0x06, 0x01, 0xf0, 0x01, 0x02, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00};

#define fliplr_width 21
#define fliplr_height 21
static unsigned char fliplr_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x30, 0x00, 0x00, 0xe0, 0x00, 0xf0, 0xff, 0x03, 0x08, 0xe0, 0x00,
   0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x03, 0x00, 0xc0, 0x01, 0x04, 0xf0, 0xff, 0x03, 0xc0, 0x01, 0x00,
   0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00};

#define fliptb_width 21
#define fliptb_height 21
static unsigned char fliptb_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
   0x40, 0x40, 0x00, 0x40, 0x40, 0x00, 0x40, 0xe0, 0x00, 0x40, 0xe0, 0x00,
   0x40, 0xf0, 0x01, 0x40, 0x50, 0x01, 0x40, 0x40, 0x00, 0x40, 0x40, 0x00,
   0x50, 0x41, 0x00, 0xf0, 0x41, 0x00, 0xe0, 0x40, 0x00, 0xe0, 0x40, 0x00,
   0x40, 0x40, 0x00, 0x40, 0x40, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00};

#define horizon_width 21
#define horizon_height 21
static unsigned char horizon_bits[] = {
   0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0xd0, 0x00, 0x00, 0xa8, 0x00, 0x00,
   0x58, 0x03, 0x00, 0x84, 0x02, 0x00, 0x04, 0x04, 0x00, 0x02, 0x08, 0x00,
   0x01, 0x08, 0x00, 0x10, 0x10, 0x07, 0x10, 0xa4, 0x0d, 0x38, 0xe4, 0x08,
   0x10, 0x46, 0x10, 0x74, 0x4c, 0x00, 0x1c, 0x95, 0x01, 0x30, 0x0e, 0x02,
   0x9c, 0x04, 0x00, 0x70, 0x04, 0x00, 0x16, 0x00, 0x00, 0xfc, 0x00, 0x00,
   0x10, 0x00, 0x00};

#define cyl_width 21
#define cyl_height 21
static unsigned char cyl_bits[] = {
   0x00, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x38, 0x80, 0x03, 0x06, 0x00, 0x0c,
   0x01, 0x00, 0x10, 0x01, 0x00, 0x10, 0x07, 0x00, 0x1c, 0x39, 0x80, 0x1f,
   0xe1, 0xff, 0x1e, 0x01, 0x40, 0x1f, 0x01, 0x80, 0x1e, 0x01, 0x40, 0x1f,
   0x01, 0x80, 0x1e, 0x01, 0x40, 0x1f, 0x01, 0x80, 0x1e, 0x01, 0x40, 0x1f,
   0x01, 0x80, 0x1e, 0x01, 0x40, 0x1f, 0x06, 0x80, 0x0e, 0x38, 0xc0, 0x03,
   0xc0, 0x7f, 0x00};

#define cyl_ins_width 21
#define cyl_ins_height 21
static unsigned char cyl_ins_bits[] = {
   0x00, 0x00, 0x00, 0x80, 0x2a, 0x00, 0x28, 0x80, 0x02, 0x02, 0x00, 0x08,
   0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x04, 0x00, 0x08, 0x29, 0x00, 0x15,
   0x80, 0xaa, 0x0a, 0x01, 0x40, 0x15, 0x00, 0x80, 0x0a, 0x01, 0x40, 0x15,
   0x00, 0x80, 0x0a, 0x01, 0x40, 0x15, 0x00, 0x80, 0x0a, 0x01, 0x40, 0x15,
   0x00, 0x80, 0x0a, 0x01, 0x40, 0x15, 0x04, 0x80, 0x0a, 0x28, 0x40, 0x01,
   0x80, 0x2a, 0x00};

#define sph_width 21
#define sph_height 21
static unsigned char sph_bits[] = {
   0x80, 0x3f, 0x00, 0x60, 0xf0, 0x00, 0x18, 0xe0, 0x03, 0x04, 0xd0, 0x07,
   0x04, 0xa0, 0x07, 0x02, 0x40, 0x0f, 0x02, 0xa0, 0x0f, 0x01, 0x40, 0x1f,
   0x01, 0x80, 0x1e, 0x01, 0x40, 0x1f, 0x01, 0x80, 0x1e, 0x01, 0x40, 0x1f,
   0x01, 0x80, 0x1e, 0x01, 0x40, 0x1f, 0x02, 0xa0, 0x0f, 0x02, 0x40, 0x0f,
   0x04, 0xa0, 0x07, 0x04, 0xd0, 0x07, 0x18, 0xe0, 0x03, 0x60, 0xf0, 0x00,
   0x80, 0x3f, 0x00};

#define sph_ins_width 21
#define sph_ins_height 21
static unsigned char sph_ins_bits[] = {
   0x80, 0x2a, 0x00, 0x40, 0x50, 0x01, 0x10, 0xa0, 0x02, 0x04, 0x50, 0x05,
   0x00, 0xa0, 0x0a, 0x02, 0x40, 0x05, 0x00, 0xa0, 0x0a, 0x01, 0x40, 0x15,
   0x00, 0x80, 0x0a, 0x01, 0x40, 0x15, 0x00, 0x80, 0x0a, 0x01, 0x40, 0x15,
   0x00, 0x80, 0x0a, 0x01, 0x40, 0x15, 0x00, 0xa0, 0x0a, 0x02, 0x40, 0x05,
   0x00, 0xa0, 0x0a, 0x04, 0x50, 0x05, 0x10, 0xa0, 0x02, 0x40, 0x50, 0x01,
   0x80, 0x2a, 0x00};

#define names_width 21
#define names_height 21
static unsigned char names_bits[] = {
   0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00,
   0x44, 0x00, 0x00, 0x44, 0x77, 0x07, 0x44, 0x55, 0x05, 0x44, 0x55, 0x05,
   0x44, 0x57, 0x05, 0x44, 0x51, 0x05, 0x28, 0x51, 0x05, 0x10, 0x77, 0x0f,
   0x00, 0x40, 0x00, 0x00, 0x40, 0x00, 0x20, 0x40, 0x00, 0x70, 0x70, 0x00,
   0xf8, 0x00, 0x00, 0x70, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00};

#define fstars_width 21
#define fstars_height 21
static unsigned char fstars_bits[] = {
   0x80, 0x00, 0x48, 0xc4, 0x44, 0x41, 0x0a, 0x00, 0x90, 0x23, 0xb0, 0x28,
   0x62, 0x0a, 0x85, 0x10, 0xa0, 0x10, 0xb5, 0x84, 0x2a, 0x40, 0x10, 0x61,
   0x12, 0xb1, 0xb0, 0x42, 0x24, 0x01, 0x0c, 0x80, 0xc4, 0x41, 0x30, 0x02,
   0x04, 0xad, 0x04, 0x82, 0x00, 0x28, 0x24, 0xa4, 0x05, 0x18, 0x01, 0x80,
   0x62, 0xa4, 0x88, 0x12, 0x04, 0x04, 0x81, 0x18, 0x44, 0xc8, 0x80, 0xc0,
   0x00, 0x02, 0x08};

#define smallgap_width 7
#define smallgap_height 7
static unsigned char smallgap_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define clusters_width 21
#define clusters_height 21
static unsigned char clusters_bits[] = {
   0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x04, 0x80, 0x74, 0x00,
   0xc0, 0x21, 0x00, 0x88, 0x04, 0x00, 0x00, 0x5e, 0x00, 0x00, 0xe5, 0x00,
   0x44, 0x40, 0x00, 0xe0, 0x12, 0x00, 0x40, 0xb8, 0x00, 0x00, 0x12, 0x08,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x10, 0x00, 0x00,
   0x00, 0x00, 0x00};

#define galaxies_width 21
#define galaxies_height 21
static unsigned char galaxies_bits[] = {
   0x00, 0x07, 0xe0, 0xe0, 0x00, 0xe0, 0xe0, 0x00, 0xe0, 0x60, 0x00, 0xe0,
   0x10, 0x00, 0xe0, 0x70, 0x0f, 0xe0, 0x70, 0x0f, 0xe0, 0xf0, 0x1f, 0xe0,
   0xf0, 0x3f, 0xe0, 0xe0, 0x3f, 0xe0, 0xe0, 0x3f, 0xe0, 0xe0, 0xff, 0xe0,
   0x80, 0xff, 0xe0, 0x00, 0xef, 0xe0, 0x00, 0xc0, 0xe0, 0x00, 0xc0, 0xe0,
   0x00, 0x20, 0xe0, 0x00, 0x30, 0xe0, 0x00, 0x0e, 0xe0, 0x00, 0x0e, 0xe0,
   0x00, 0x00, 0xe0};

#define nebulae_width 21
#define nebulae_height 21
static unsigned char nebulae_bits[] = {
   0x00, 0x06, 0x00, 0x00, 0x7f, 0x00, 0x00, 0xff, 0x00, 0x80, 0xff, 0x01,
   0xf0, 0xff, 0x01, 0xf0, 0xff, 0x03, 0xf0, 0xf9, 0x03, 0xf0, 0xf8, 0x03,
   0x00, 0xf8, 0x07, 0x00, 0xf8, 0x03, 0x00, 0xf8, 0x07, 0x00, 0xf8, 0x03,
   0x10, 0xf8, 0x07, 0xa4, 0xfa, 0x03, 0x51, 0xfd, 0x07, 0xa4, 0xfe, 0x0b,
   0x52, 0xff, 0x05, 0xad, 0xff, 0x0b, 0xf2, 0xff, 0x17, 0xff, 0xff, 0x0b,
   0xff, 0xff, 0x1f};

#define stars_width 21
#define stars_height 21
static unsigned char stars_bits[] = {
   0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
   0x18, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00, 0x80, 0x1c, 0x00,
   0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x01, 0x82, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x40, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00,
   0x00, 0x00, 0x00};

#define solsys_width 21
#define solsys_height 21
static unsigned char solsys_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xee, 0x00, 0xc0, 0xf1, 0x00, 0x20, 0xe0, 0x00,
   0x10, 0x00, 0x01, 0x08, 0x00, 0x02, 0x04, 0x00, 0x04, 0x04, 0x00, 0x04,
   0x04, 0x0e, 0x04, 0x02, 0x1f, 0x08, 0x02, 0x1f, 0x08, 0x02, 0x1f, 0x08,
   0x04, 0x0e, 0x04, 0x04, 0x00, 0x04, 0x04, 0x00, 0x04, 0x08, 0x00, 0x02,
   0x10, 0x00, 0x01, 0x20, 0x80, 0x00, 0xc0, 0x71, 0x00, 0x00, 0x0e, 0x00,
   0x00, 0x00, 0x00};

#define dss_width 21
#define dss_height 21
static unsigned char dss_bits[] = {
   0x00, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0xe0, 0x7f, 0x00, 0x30, 0x40, 0x0f,
   0xf0, 0x7f, 0x0f, 0xfc, 0xff, 0x0b, 0x0c, 0x00, 0x0c, 0x86, 0x3f, 0x08,
   0xc6, 0x7f, 0x0c, 0xe2, 0xf1, 0x08, 0x72, 0xc0, 0x0d, 0x72, 0xc2, 0x09,
   0x32, 0x82, 0x0d, 0xb2, 0x8d, 0x09, 0x32, 0x82, 0x0d, 0x72, 0xc2, 0x09,
   0x76, 0xc0, 0x0d, 0xe6, 0xf1, 0x08, 0xdc, 0x7f, 0x07, 0x80, 0x3f, 0x00,
   0x00, 0x00, 0x00};

#define glass_width 21
#define glass_height 21
static unsigned char glass_bits[] = {
   0x88, 0x80, 0x01, 0x20, 0x80, 0x01, 0x00, 0x10, 0x04, 0xf8, 0xff, 0x00,
   0x09, 0x80, 0x02, 0x08, 0x80, 0x00, 0xc8, 0x80, 0x00, 0xe8, 0x81, 0x10,
   0xe8, 0xc1, 0x00, 0xc8, 0xe0, 0x00, 0x0a, 0xe0, 0x06, 0x08, 0xc6, 0x06,
   0x08, 0x8f, 0x00, 0x09, 0x8f, 0x08, 0x08, 0x86, 0x00, 0xfa, 0xff, 0x08,
   0x40, 0x00, 0x00, 0x00, 0x86, 0x02, 0x06, 0x06, 0x00, 0x46, 0x10, 0x08,
   0x00, 0x02, 0x01};

#define glass_ins_width 21
#define glass_ins_height 21
static unsigned char glass_ins_bits[] = {
   0x08, 0x00, 0x01, 0x20, 0x80, 0x00, 0x00, 0x10, 0x04, 0x50, 0x55, 0x00,
   0x09, 0x80, 0x02, 0x00, 0x00, 0x00, 0x48, 0x81, 0x00, 0xa0, 0x00, 0x00,
   0x48, 0xa1, 0x00, 0xa0, 0x40, 0x00, 0x08, 0xa0, 0x02, 0x00, 0x45, 0x00,
   0x08, 0x8a, 0x00, 0x01, 0x05, 0x08, 0x08, 0x8a, 0x00, 0x12, 0x55, 0x08,
   0x40, 0x00, 0x00, 0x00, 0x04, 0x02, 0x02, 0x02, 0x00, 0x44, 0x10, 0x00,
   0x00, 0x02, 0x01};

static int glass_on;

#define report_width 21
#define report_height 21
static unsigned char report_bits[] = {
   0x00, 0x00, 0x00, 0x5a, 0x60, 0x0b, 0xfa, 0x20, 0x0f, 0x00, 0x00, 0x00,
   0x64, 0x20, 0x05, 0xf6, 0x60, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xc0, 0x00, 0x00, 0x40, 0x03, 0x00, 0x80, 0x04, 0x00, 0x80, 0x02, 0x00,
   0x00, 0x05, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00};

static int report_on;

#define slice_width 21
#define slice_height 21
static unsigned char slice_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xc3, 0x03, 0xfc, 0x37, 0x04,
   0x0c, 0x1e, 0x08, 0x06, 0x0c, 0x08, 0x06, 0x00, 0x08, 0x06, 0x00, 0x04,
   0x04, 0x00, 0x04, 0x0c, 0x00, 0x04, 0x0c, 0x00, 0x04, 0x0c, 0x00, 0x04,
   0x18, 0x00, 0x02, 0x18, 0x00, 0x02, 0x18, 0x00, 0x02, 0x30, 0x00, 0x02,
   0x30, 0x00, 0x01, 0xe0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00};

#define slice_ins_width 21
#define slice_ins_height 21
static unsigned char slice_ins_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0x42, 0x01, 0x54, 0x15, 0x04,
   0x04, 0x0a, 0x00, 0x02, 0x04, 0x08, 0x04, 0x00, 0x00, 0x02, 0x00, 0x04,
   0x04, 0x00, 0x00, 0x08, 0x00, 0x04, 0x04, 0x00, 0x00, 0x08, 0x00, 0x04,
   0x10, 0x00, 0x00, 0x08, 0x00, 0x02, 0x10, 0x00, 0x00, 0x20, 0x00, 0x02,
   0x10, 0x00, 0x00, 0xa0, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00};

static int slice_on;

#define roi_width 21
#define roi_height 21
static unsigned char roi_bits[] = {
   0x00, 0x00, 0x00, 0xf8, 0x7f, 0x02, 0x08, 0x40, 0x00, 0x08, 0x4f, 0x01,
   0x88, 0x50, 0x00, 0x89, 0x43, 0x08, 0x88, 0x47, 0x01, 0x88, 0x47, 0x0c,
   0x08, 0x47, 0x0c, 0x28, 0x44, 0x00, 0xca, 0x43, 0x00, 0x08, 0x40, 0x08,
   0x08, 0x40, 0x00, 0xf8, 0xff, 0x00, 0x02, 0x40, 0x03, 0x00, 0x81, 0x04,
   0x00, 0x81, 0x02, 0x44, 0x10, 0x05, 0x0e, 0x02, 0x08, 0x04, 0x00, 0x00,
   0x00, 0x08, 0x00};

static int roi_on;

#define roi_ins_width 21
#define roi_ins_height 21
static unsigned char roi_ins_bits[] = {
   0x00, 0x00, 0x00, 0xa8, 0x2a, 0x02, 0x00, 0x40, 0x00, 0x28, 0x05, 0x01,
   0x00, 0x50, 0x02, 0x89, 0x02, 0x09, 0x00, 0x45, 0x01, 0x88, 0x02, 0x00,
   0x00, 0x45, 0x00, 0x28, 0x00, 0x02, 0x82, 0x42, 0x00, 0x08, 0x00, 0x08,
   0x00, 0x40, 0x00, 0xa8, 0xaa, 0x00, 0x02, 0x40, 0x03, 0x00, 0x81, 0x00,
   0x00, 0x81, 0x02, 0x44, 0x10, 0x00, 0x0e, 0x02, 0x08, 0x04, 0x00, 0x00,
   0x00, 0x08, 0x00};

#define snap_width 21
#define snap_height 21
static unsigned char snap_bits[] = {
   0x20, 0x00, 0x00, 0x30, 0x00, 0x00, 0x18, 0xc0, 0x00, 0x0c, 0xe0, 0x01,
   0x06, 0xe0, 0x01, 0x02, 0xc0, 0x00, 0x11, 0x00, 0x00, 0x31, 0x0f, 0x00,
   0xe3, 0x1f, 0x00, 0xfe, 0x1f, 0x00, 0xe0, 0x1f, 0x08, 0xb0, 0x1f, 0x08,
   0x10, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x06, 0x82, 0x00, 0x06, 0x07, 0x10, 0x00, 0x02, 0x00, 0x00, 0x60, 0x00,
   0x00, 0x60, 0x00};

#define snap_ins_width 21
#define snap_ins_height 21
static unsigned char snap_ins_bits[] = {
   0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x10, 0x80, 0x00, 0x08, 0x40, 0x01,
   0x04, 0x80, 0x00, 0x02, 0x00, 0x00, 0x11, 0x05, 0x00, 0xa0, 0x0a, 0x00,
   0x41, 0x15, 0x00, 0xaa, 0x0a, 0x00, 0x40, 0x15, 0x08, 0xa0, 0x0a, 0x00,
   0x10, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x04, 0x82, 0x00, 0x02, 0x05, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x60, 0x00};

static int snap_on;

#define monument_width 21
#define monument_height 21
static unsigned char monument_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x0e, 0x00,
   0x00, 0x0e, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x0e, 0x00,
   0x00, 0x1f, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x1f, 0x00,
   0x00, 0x1b, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x15, 0x00, 0x80, 0x3b, 0x00,
   0x80, 0x35, 0x00, 0x80, 0x2a, 0x00, 0x40, 0x55, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00};

#define monument_ins_width 21
#define monument_ins_height 21
static unsigned char monument_ins_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x04, 0x00,
   0x00, 0x0a, 0x00, 0x00, 0x04, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x04, 0x00,
   0x00, 0x0a, 0x00, 0x00, 0x15, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x15, 0x00,
   0x00, 0x0a, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x15, 0x00, 0x80, 0x2a, 0x00,
   0x00, 0x15, 0x00, 0x80, 0x2a, 0x00, 0x40, 0x55, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00};

static int monument_on;

#define contrast_width 21
#define contrast_height 21
static unsigned char contrast_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0xc0, 0x7c, 0x00, 0x40, 0x7c, 0x00,
   0x20, 0xfc, 0x00, 0x20, 0xfc, 0x00, 0x20, 0xfc, 0x00, 0x20, 0xfc, 0x00,
   0x20, 0xfc, 0x00, 0x40, 0x7c, 0x00, 0xc0, 0x7c, 0x00, 0x00, 0x1f, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00};

#define contrast_ins_width 21
#define contrast_ins_height 21
static unsigned char contrast_ins_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x80, 0x54, 0x00, 0x40, 0xa8, 0x00,
   0x00, 0x54, 0x00, 0x20, 0xa8, 0x00, 0x00, 0x54, 0x00, 0x20, 0xa8, 0x00,
   0x00, 0x54, 0x00, 0x40, 0xa8, 0x00, 0x80, 0x54, 0x00, 0x00, 0x2a, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00};

static int contrast_on;

#define gauss_width 21
#define gauss_height 21
static unsigned char gauss_bits[] = {
   0x03, 0x0e, 0x00, 0x00, 0x11, 0x00, 0x00, 0x11, 0x00, 0x80, 0x20, 0x00,
   0x87, 0x20, 0x00, 0x80, 0x20, 0x00, 0x40, 0x40, 0x00, 0x40, 0x40, 0x00,
   0x43, 0x40, 0x00, 0x40, 0x40, 0x00, 0x20, 0x91, 0x00, 0xe0, 0xff, 0x00,
   0x27, 0x91, 0x00, 0x20, 0x80, 0x00, 0x20, 0x80, 0x00, 0x10, 0x00, 0x01,
   0x13, 0x00, 0x01, 0x18, 0x00, 0x03, 0x0c, 0x04, 0x06, 0x4c, 0x44, 0x06,
   0x47, 0x44, 0x1c};

#define gauss_ins_width 21
#define gauss_ins_height 21
static unsigned char gauss_ins_bits[] = {
   0x02, 0x04, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x80, 0x20, 0x00,
   0x05, 0x00, 0x00, 0x80, 0x20, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
   0x02, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x11, 0x00, 0xa0, 0xaa, 0x00,
   0x05, 0x11, 0x00, 0x20, 0x80, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x01,
   0x02, 0x00, 0x00, 0x10, 0x00, 0x01, 0x00, 0x04, 0x00, 0x48, 0x40, 0x02,
   0x05, 0x04, 0x14};

static int gauss_on;

typedef enum {
    LTB, TTB, RTB
} TBWhere;

typedef struct {
    TBWhere where;		/* which toolbar */
    int tb;			/* TB, else PB (or Label if !tip) */
    int igonly;			/* 1=for images only, 2=gr only 3=either ok */
    char *tip;			/* tip text, or NULL */
    unsigned char *bits;	/* bitmap pattern */
    unsigned char *insbits;	/* bitmap pattern when insensitive, if any */
    int w, h;			/* bitmap size */
    XtCallbackProc cb;		/* callback when activated or changed */
    XtPointer client;		/* client arg, if any */
    char *ct;			/* svf class table, also implies make TB */
    ObjType_t tt[NOBJTYPES];	/* svf type table, also implies make TB */
    Widget wid;			/* widget */
    Pixmap pm, ipm;		/* normal and insensitive pixmaps */
} SVTBarItem;
static SVTBarItem svtb[] = {
    /* corner is DSS */
    {TTB, 0, 3, "Fetch and display DSS image",
	dss_bits, 0, dss_width, dss_height, sf_go_cb, 0},

    /* top bar is for "what" */
    {TTB, 0, 0, NULL, smallgap_bits, 0, smallgap_width, smallgap_height},
    {TTB, 1, 3, "Toggle coordinate grid underlay matching display mode, or Off",
	grid_bits, 0, grid_width, grid_height, svtb_grid_cb, 0},
    {TTB, 1, 3,"Toggle horizon line and cutoff (if Alt/Az mode) off or restore",
	horizon_bits, 0, horizon_width, horizon_height, svtb_hzn_cb, 0},
    {TTB, 1, 3, "Toggle constellations graphics and names off or restore",
	constel_bits, 0, constel_width, constel_height, svtb_constel_cb, 0},
    {TTB, 1, 3, "Toggle object names off or restore",
	names_bits, 0, names_width, names_height, svtb_names_cb, 0},
    {TTB, 1, 3, "Toggle magnitude key on or off",magscale_bits,0,magscale_width,
	magscale_height, svtb_magscale_cb, 0},
    {TTB, 1, 3, "Turn Equatorial, Ecliptic and Galactic planes on or off",
	planes_bits, 0, planes_width, planes_height, svtb_planes_cb, 0},

    {TTB, 0, 0, NULL, smallgap_bits, 0, smallgap_width, smallgap_height},
    {TTB, 1, 3, "Toggle Solar System objects on or off",
	solsys_bits, 0, solsys_width, solsys_height, svtb_tt_cb, 0,
	NULL, {ELLIPTICAL, HYPERBOLIC, PARABOLIC, PLANET}},
    {TTB, 1, 3, "Toggle Clusters on or off",
	clusters_bits, 0, clusters_width, clusters_height, svtb_ct_cb, 0,
	"COU"},
    {TTB, 1, 3, "Toggle Galaxies on or off",
	galaxies_bits, 0, galaxies_width, galaxies_height, svtb_ct_cb, 0,
	"GHA"},
    {TTB, 1, 3, "Toggle Nebulae on or off",
	nebulae_bits, 0, nebulae_width, nebulae_height, svtb_ct_cb, 0,
	"NFKP"},
    {TTB, 1, 3, "Toggle Stars on or off",
	stars_bits, 0, stars_width, stars_height, svtb_ct_cb, 0,
	"SBDMVT"},
    {TTB, 1, 3, "Toggle automatic Field Star loading and display on or off",
	fstars_bits, 0, fstars_width, fstars_height, svtb_fstars_cb, 0},
    {TTB, 0, 0, NULL, what_bits, 0, what_width, what_height, NULL, 0},

    /* left bar is for "how" */
    {LTB, 0, 0, NULL, smallgap_bits, 0, smallgap_width, smallgap_height},
    {LTB, 0, 3, "Set all magnitude limits one fainter",
	brighter_bits, 0, brighter_width, brighter_height, svtb_brighter_cb, 0},
    {LTB, 0, 3, "Set all magnitude limits one brighter",
	dimmer_bits, 0, dimmer_width, dimmer_height, svtb_dimmer_cb, 0},
    {LTB, 1, 3, "Toggle automatic magnitude control on or off",
	automag_bits, 0, automag_width, automag_height, svtb_automag_cb, 0},
    {LTB, 1, 1, "3d Monument image view", monument_bits, monument_ins_bits,
	monument_width, monument_height, svtb_monument_cb, NULL},
    {LTB, 1, 1, "Brightness and Contrast control", contrast_bits,
	contrast_ins_bits, contrast_width, contrast_height, svtb_contrast_cb,
	NULL},

    {LTB, 0, 0, NULL, smallgap_bits, 0, smallgap_width, smallgap_height},
    {LTB, 0, 2, "Toggle between Alt-Az and RA-Dec orientation", orient_bits,
	orient_ins_bits, orient_width, orient_height, svtb_orient_cb, 0},
    {LTB, 1, 2, "Set Spherical projection mode",
	sph_bits, sph_ins_bits, sph_width, sph_height, svtb_sph_cb, 0},
    {LTB, 1, 2, "Set Cylindrical projection mode",
	cyl_bits, cyl_ins_bits, cyl_width, cyl_height, svtb_proj_cb, 0},
    {LTB, 1, 3, "Flip Left/Right",
	fliplr_bits, 0, fliplr_width, fliplr_height, svtb_flip_cb, 0},
    {LTB, 1, 3, "Flip Top/Bottom",
	fliptb_bits, 0, fliptb_width, fliptb_height, svtb_flip_cb,(XtPointer)1},
    {LTB, 0, 0, NULL, how_bits, 0, how_width, how_height, NULL, 0},

    /* right bar is "where" */
    {RTB, 1, 3, "Toggle live report in corners", report_bits, NULL,
	report_width, report_height, svtb_toggle_cb, &report_on},

    {RTB, 0, 3, NULL, smallgap_bits, 0, smallgap_width, smallgap_height},
    {RTB, 0, 3, "Zoom in so selected region expands to fill the window",
	zoomin_bits, zoomin_ins_bits, zoomin_width, zoomin_height,
							svtb_zoomin_cb, 0},
    {RTB, 0, 3, "Undo last Zoom",
	unzoom_bits, unzoom_ins_bits, unzoom_width, unzoom_height,
							svtb_unzoom_cb, 0},
    {RTB, 1, 3, "Draw region of interest", roi_bits, roi_ins_bits,
	roi_width, roi_height, svtb_roi_cb, NULL},

    {RTB, 0, 0, NULL, smallgap_bits, 0, smallgap_width, smallgap_height},
    {RTB, 1, 1, "Enable magnifying glass", glass_bits, glass_ins_bits,
	glass_width, glass_height, svtb_glass_cb, NULL},
    {RTB, 1, 1, "Climb gradient to max", snap_bits, snap_ins_bits, snap_width,
        snap_height, svtb_toggle_cb, &snap_on},
    {RTB, 1, 1, "Plot along a cross-sectional slice", slice_bits,slice_ins_bits,
	slice_width, slice_height, svtb_slice_cb, NULL},
    {RTB, 1, 1, "Measure and compare star brightness", gauss_bits,
	gauss_ins_bits, gauss_width, gauss_height, svtb_gauss_cb, NULL},
    {RTB, 0, 0, NULL, where_bits, 0, where_width, where_height, NULL, 0},
};

/* search for the SVTBarItem containing the bitmaps bits */
static SVTBarItem *
findSVTB (bits)
unsigned char *bits;
{
	SVTBarItem *sp;

	for (sp = svtb; sp < &svtb[XtNumber(svtb)]; sp++)
	    if (sp->bits == bits)
		return (sp);

	printf ("Bug! Can not find SVTB\n");
	exit (1);
	return(0);	/* ! */
}

/* go through each toolbar TB and PB set its pixmap
 * rc_w is just any manager in Sky View we can use to make a temp TB to learn
 *   current color scheme.
 */
void
svtb_newpm (rc_w)
Widget rc_w;
{
	static Pixel last_fg, last_bg;
	Display *dsp = XtDisplay(toplevel_w);
	Window win = RootWindow (dsp, DefaultScreen(dsp));
	Arg args[20];
	Pixel fg, bg;
	Widget w;
	int n;
	int d;
	int i;

	/* make a temp TB just so we can sneak its colors and depth.
	 * turns out Motif 1.2 can not handle a Bitmap and 2.x can, but we
	 * go the conservative route.
	 */
	n = 0;
	w = XmCreateToggleButton (rc_w, "TMP", args, n);
	n = 0;
	XtSetArg (args[n], XmNforeground, &fg); n++;
	XtSetArg (args[n], XmNbackground, &bg); n++;
	XtSetArg (args[n], XmNdepth, &d); n++;
	XtGetValues (w, args, n);
	XtDestroyWidget (w);

	/* don't bother if no change .. avoids extra blinking */
	if (fg == last_fg && bg == last_bg)
	    return;
	last_fg = fg;
	last_bg = bg;

	for (i = 0; i < XtNumber(svtb); i++) {
	    SVTBarItem *ip = &svtb[i];
	    
	    if (ip->pm)
		XFreePixmap (dsp, ip->pm);
	    ip->pm = XCreatePixmapFromBitmapData (dsp, win, (char *)ip->bits,
						    ip->w, ip->h, fg, bg, d); 
	    set_something (ip->wid, XmNlabelPixmap, (XtArgVal)(ip->pm));
	    if (ip->insbits) {
		if (ip->ipm)
		    XFreePixmap (dsp, ip->ipm);
		ip->ipm = XCreatePixmapFromBitmapData (dsp, win,
			    (char *)ip->insbits, ip->w, ip->h, fg, bg, d);
		set_something (ip->wid, XmNlabelInsensitivePixmap,
							(XtArgVal)(ip->ipm));
	    }
	}

}

/* create top/left/right toolbar controls in the given RowColumn widgets */
void
svtb_create (trc_w, lrc_w, rrc_w)
Widget trc_w, lrc_w, rrc_w;
{
	SVTBarItem *ip;
	Arg args[20];
	Widget rc_w, w;
	int i;
	int n;

	/* create the widgets */
	for (i = 0; i < XtNumber(svtb); i++) {
	    ip = &svtb[i];
	    rc_w= ip->where == LTB ? lrc_w : (ip->where == RTB ? rrc_w : trc_w);

	    n = 0;
	    XtSetArg (args[n], XmNlabelType, XmPIXMAP); n++;
	    if (!ip->tip) {
		w = XmCreateLabel (rc_w, "SVTBL", args, n);
	    } else if (ip->tb) {
		XtPointer client;

		/* N.B. we rely on resources to set shadowThickness > 0 */

		XtSetArg (args[n], XmNindicatorOn, False); n++;
		w = XmCreateToggleButton (rc_w, "SVTBTB", args, n);
		if (ip->ct)
		    client = (XtPointer)ip->ct;
		else if (ip->tt[0])
		    client = (XtPointer)ip->tt;
		else
		    client = ip->client;
		if (ip->cb)
		    XtAddCallback (w, XmNvalueChangedCallback, ip->cb, client);
		wtip (w, ip->tip);
	    } else {
		w = XmCreatePushButton (rc_w, "SVTBPB", args, n);
		if (ip->cb)
		    XtAddCallback (w, XmNactivateCallback, ip->cb, ip->client);
		wtip (w, ip->tip);
	    }
	    XtManageChild (w);
	    ip->wid = w;
	}

	/* create their pixmaps */
	svtb_newpm (trc_w);

	/* no zooming until ROI defined */
	svtb_zoomok(0);
	svtb_unzoomok(0);

	/* add radio-box behavior to sph/cyl pair */
	ip = findSVTB (cyl_bits);
	XtAddCallback (ip->wid, XmNvalueChangedCallback, svtb_cyl_cb, 0);
}

/* called to desensitize those controls inappropriate to images.
 * TODO N.B. zoom/unzoom ain't this easy .. they come and go based on their
 *   stack and svtb_iszoomok() tests it directly. Need to implement non-Sen
 *   version of iszoomok then teach callbacks to tolerate stack end cases and
 *   implement image cropping.
 */
void
svtb_imMode (on)
int on;
{
	Widget zi = findSVTB(zoomin_bits)->wid;
	Widget uz = findSVTB(unzoom_bits)->wid;
	int i;

	/* important it be 1 or 0 */
	on = !!on;

	for (i = 0; i < XtNumber(svtb); i++) {
	    SVTBarItem *sp = &svtb[i];
	    /* !tip implies label */
	    if (sp->tip && sp->wid != zi && sp->wid != uz)
		XtSetSensitive(sp->wid, (on && (sp->igonly & 1)) ||
					   (!on && (sp->igonly & 2)));
	}
}

/* return 1 if zooming now is ok, else 0 */
int
svtb_iszoomok(void)
{
	return (XtIsSensitive(findSVTB(zoomin_bits)->wid));
}

/* show whether zooming now is ok */
void
svtb_zoomok(ok)
int ok;
{
	XtSetSensitive (findSVTB(zoomin_bits)->wid, ok);
}

/* set whether unzooming now is ok */
void
svtb_unzoomok(ok)
int ok;
{
	XtSetSensitive (findSVTB(unzoom_bits)->wid, ok);
}

/* call to set the Grid TB */
void
svtb_updateGrid (on)
int on;
{
	XmToggleButtonSetState (findSVTB(grid_bits)->wid, on, False);
}

/* call to set the LR flip TB */
void
svtb_updateLRFlip (on)
int on;
{
	XmToggleButtonSetState (findSVTB(fliplr_bits)->wid, on, False);
}

/* call to set the TB flip TB */
void
svtb_updateTBFlip (on)
int on;
{
	XmToggleButtonSetState (findSVTB(fliptb_bits)->wid, on, False);
}

/* call to set the Horizon TB */
void
svtb_updateHorizon (on)
int on;
{
	XmToggleButtonSetState (findSVTB(horizon_bits)->wid, on, False);
}

/* call to set the Field Stars TB */
void
svtb_updateFStars (on)
int on;
{
	XmToggleButtonSetState (findSVTB(fstars_bits)->wid, on, False);
}

/* call to set the Cns TB */
void
svtb_updateCns (on)
int on;
{
	XmToggleButtonSetState (findSVTB(constel_bits)->wid, on, False);
}

/* call to set the Automag TB */
void
svtb_updateAutoMag (on)
int on;
{
	XmToggleButtonSetState (findSVTB(automag_bits)->wid, on, False);
}

/* call to set the Cyl and Sph projection TBs */
void
svtb_updateCyl (on)
int on;
{
	XmToggleButtonSetState (findSVTB(cyl_bits)->wid, on, False);
	XmToggleButtonSetState (findSVTB(sph_bits)->wid, !on, False);
}

/* call to set the Names TB */
void
svtb_updateNames (on)
int on;
{
	XmToggleButtonSetState (findSVTB(names_bits)->wid, on, False);
}

/* call to set the Planes TB */
void
svtb_updatePlanes (on)
int on;
{
	XmToggleButtonSetState (findSVTB(planes_bits)->wid, on, False);
}

/* call to set the MagScale TB */
void
svtb_updateMagScale (on)
int on;
{
	XmToggleButtonSetState (findSVTB(magscale_bits)->wid, on, False);
}

/* call to set the Slice TB */
void
svtb_updateSlice (on)
int on;
{
	XmToggleButtonSetState (findSVTB(slice_bits)->wid, slice_on=on, False);
}

/* call to set the ROI TB */
void
svtb_updateROI (on)
int on;
{
	XmToggleButtonSetState (findSVTB(roi_bits)->wid, roi_on=on, False);
}

/* call to set the Gauss TB */
void
svtb_updateGauss (on)
int on;
{
	XmToggleButtonSetState(findSVTB(gauss_bits)->wid, gauss_on=on, False);
}

/* call to set the Contrast TB */
void
svtb_updateContrast (on)
int on;
{
	XmToggleButtonSetState(findSVTB(contrast_bits)->wid, contrast_on=on, 0);
}

/* call to set the Glass TB */
void
svtb_updateGlass (on)
int on;
{
	XmToggleButtonSetState(findSVTB(glass_bits)->wid, glass_on=on, False);
}

/* call to set the Class and Solsys TB according to svf filter tables */
void
svtb_updateCTTT(ct, tt)
char ct[NCLASSES];
char tt[NOBJTYPES];
{
	int i, j;

	/* beware being called before being initialized */
	if (!svtb[0].w)
	    return;

	/* search each TB involved with a filter */
	for (i = 0; i < XtNumber(svtb); i++) {
	    SVTBarItem *ip = &svtb[i];
	    if (ip->ct) {
		int l = strlen (ip->ct);
		int set = 0;
		/* set if any classes for this TB are set */
		for (j = 0; j < l; j++) {
		    if (ct[(int)ip->ct[j]]) {
			set = 1;
			break;
		    }
		}
		XmToggleButtonSetState (ip->wid, set, False);
	    }
	    if (ip->tt[0]) {
		int set = 0;
		/* set if any types for this TB are set */
		for (j = 0; j < NOBJTYPES; j++) {
		    if (tt[(int)ip->tt[j]]) {
			set = 1;
			break;
		    }
		}
		XmToggleButtonSetState (ip->wid, set, False);
	    }
	}
}

/* whether roaming report */
int
svtb_reportIsOn()
{
	return (report_on);
}

/* whether monument view */
int
svtb_monumentIsOn()
{
	return (monument_on);
}

/* whether snap-to-max is on */
int
svtb_snapIsOn()
{
	return (snap_on);
}

/* whether slice is on */
int
svtb_sliceIsOn()
{
	return (slice_on);
}

/* whether ROI is on */
int
svtb_ROIIsOn()
{
	return (roi_on);
}

/* whether glass is on */
int
svtb_glassIsOn()
{
	return (glass_on);
}

/* whether gauss is on */
int
svtb_gaussIsOn()
{
	return (gauss_on);
}

/* callback from any of the Class TBs.
 * client is ct list.
 */
static void
svtb_ct_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	int set = XmToggleButtonGetState(w);
	char *types = (char *)client;
	char tt[NOBJTYPES];
	char ct[NCLASSES];
	int ntypes;
	int i;

	svf_gettables (tt, ct);

	ntypes = strlen(types);
	for (i = 0; i < ntypes; i++)
	    ct[(int)types[i]] = set;

	svf_settables (tt, ct);

	sv_all(mm_get_now());
}

/* callback from the solsys TB.
 * client is tt list.
 */
static void
svtb_tt_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	int set = XmToggleButtonGetState(w);
	ObjType_t *types = (ObjType_t *)client;
	char tt[NOBJTYPES];
	char ct[NCLASSES];
	int i;

	svf_gettables (tt, ct);

	for (i = 0; i < NOBJTYPES; i++)
	    if (types[i])
		tt[(int)types[i]] = set;

	svf_settables (tt, ct);

	sv_all(mm_get_now());
}

/* called when the Sph TB changes.
 * activate the Cyl TB to the opposite state.
 */
static void
svtb_sph_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	SVTBarItem *ip = findSVTB (cyl_bits);

	XmToggleButtonSetState (ip->wid, !XmToggleButtonGetState(w), True);
}

/* called when the Cyl TB changes.
 * slace the Sph TB to the opposite state.
 */
static void
svtb_cyl_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	SVTBarItem *ip = findSVTB (sph_bits);

	XmToggleButtonSetState (ip->wid, !XmToggleButtonGetState(w), False);
}

/* fast control of a simple toggle setting.
 * client is addr of int to set.
 */
static void
svtb_toggle_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	*(int *)client = XmToggleButtonGetState(w);
}

/* monument toggle */
static void
svtb_monument_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	monument_on = XmToggleButtonGetState(w);
	if (si_ison())
	    sv_dspFITS();
}

/* contrast toggle */
static void
svtb_contrast_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	contrast_on = XmToggleButtonGetState(w);
	si_updateContrast(contrast_on);
}

/* glass toggle */
static void
svtb_glass_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	glass_on = XmToggleButtonGetState(w);
	si_updateGlass(glass_on);
}

/* roi toggle */
static void
svtb_roi_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	roi_on = XmToggleButtonGetState(w);
	si_updateROI(roi_on);
}

/* gauss toggle */
static void
svtb_gauss_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	gauss_on = XmToggleButtonGetState(w);
	si_updateGauss(gauss_on);
}

/* slice toggle */
static void
svtb_slice_cb (w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	slice_on = XmToggleButtonGetState(w);
	si_updateSlice(slice_on);
}

/* For RCS Only -- Do Not Edit */
static char *rcsid[2] = {(char *)rcsid, "@(#) $RCSfile: skytoolbar.c,v $ $Date: 2001/10/13 06:08:14 $ $Revision: 1.48 $ $Name:  $"};
