/*
     My Psion. Psion link program (Psion Series 5 (3)).
     User interface layer - header file.

     (C) Andy A. Porro (porro@cbs-edu.chel.su).
*/
#ifndef _PSIOBJ
#define _PSIOBJ

#pragma pack(1)

/*
    Interface objects desctoptions. Total four layers.

     Psion
      |
      ----> Drive
             |
             ---->Folder
                    |
                    ---->File
*/
typedef struct _fItem {
        UCHAR  name [_MAX_FNAME+1];
        ULONG  date;
        ULONG  attr;
        ULONG  size;
        }      fItem;

extern fItem _Export myPsion;
extern fItem * _Export fpsList;         // list of Psion's objects 
                                        // disks/folders/files
extern int _Export   fpsListTotal;      // total objects in list.
extern UCHAR _Export wildCard [];
extern CHAR _Export pcLocale [32];
extern CHAR _Export psionLocale [32];

APIRET psCopy2ps ( UCHAR srcName[], UCHAR dstName[] );
APIRET psCopy2os ( UCHAR srcName[], UCHAR dstName[] );
APIRET psInit ( char *comName, ULONG comBaud );
void   psSetLocale ( void );
APIRET psFolderList ( UCHAR pattern[] );
APIRET psCDir ( UCHAR path[] );
APIRET psPwd ( UCHAR path[] );
ULONG  toPsiTime ( FDATE *d, FTIME *t );
FDATE  *toOsDate ( ULONG t );
FTIME  *toOsTime ( ULONG t );
CHAR   *toPsiName ( CHAR fname[] );
CHAR   *toOsName ( CHAR fname[] );

#endif
