/* REXX PROGRAM */
/* This REXX program expects Omnifile to be the host environment */
/* It reads records from the source db and writes them to the destination db (optionally filtering or converting as go). */
/* If you are attempting to change this file, you will normally only need to change the CHANGE_FIELD_DATA subroutine. */
/* There are three external functions that Omnifile provides:
       SetHeaderLine(headerLine) - tells Omnifile to expect each data line to have this format.
       SetRexxVariables(line) - causes Omnifile to parse the line and, for each field, set a rexx variable with the data from the line.
       AddRec(Rec) - causes Omnifile to add an Item to the end of the database using the data in the rexx variables.
       GetRec(RecNum) - causes Omnifile to get the requested Item.
       */
/* The general outline is to get each record and copy it to the new database.
   If the record is an Hour record, the Person field is converted to an Integer.
   */


/* MAIN SUBROUTINE */
szEnvironment = address()
IF ((szEnvironment <> "Omnifile") & (szEnvironment <> "Contacts")) THEN DO
   SAY "This rexx file can only be run by Omnifile or Contact Connection, not directly."
   RETURN 1
   END
SAY "RUNNING REXX"

/* Load the Rexx variables based on the arguments the user passed in. */
DbOut = "item"
/* Make sure the required arguments where given. */
IF DbOut = "" THEN DO
   SAY "The following arguments are expected: DBOUT"
   RETURN 1
   END

Result = SetInputDb("item")
Result = SetOutputDb(DbOut)

/*Test for whether version has label reports or not */
GetRec(45)
Response = DeleteIconFromFolder("Avery Label 4144 Report")
if Response == "FALSE" THEN DO
   NewResponse = DeleteIconFromFolder("Avery 4144 Address Label Report")
   if NewResponse == "TRUE" THEN DO
       Version = "103"
       DisplayMessage("This Database has already been upgraded.")
       EXIT /* Since rec45 is never stored the DeleteIcon function above has no affect */
       END
   Version = "100"
   VersionOffset = 0
   END
else DO
   Version = "102"
   VersionOffset = 3
   END

/* Note: CC Users should never be running this */
GetRec(46)
Response = DeleteIconFromFolder("Expenses Print Window") /* This will be overwritten later anyway so its ok to delete */
IF Response == "TRUE" THEN DO
   /* Pro or Office user */
   dbname = "uppro"
   END
ELSE DO /* Home User */
   dbname = "uphome"
   END


IF Version == "100"
   THEN Result = SetInputDb("temp\"dbname"1")
   ELSE Result = SetInputDb("temp\"dbname"2")

/* DisplayMessage("This program will update your database for use with Omnifile version 1.03.") */

/*
Response = DisplayMessage("If no views in the individual or business modules were customized using Design Views, select <YES>. If you have customized any views, select <NO>. To exit with no changes to the database, select <CANCEL>.  Update the database?", "CHOICE")

if Response == "NO" THEN DO
   NextResponse = DisplayMessage("To overwrite your changes, select <Yes>. To keep your customizations with a selective upgrade, select <No>. To exit this program with no modifications to your database, select <Cancel>. Overwrite your modifications?", "CHOICE")
   if NextResponse == "NO" THEN CALL COPYNEWFOLDERSONLY
   if NextResponse == "YES" THEN break
   if NextResponse == "CANCEL" THEN EXIT
   EXIT
   END
if Response == "CANCEL" THEN EXIT
*/

/* Updating all records */

/* Jump List Folder, Startup Folder, and Maint Folder update */
CALL COPYNEWFOLDERSONLY


/* Getting main folder */
GetRec(1)
MergeFolders(33, 0)

/* Getting new address definition */
GetRec(7)
SavedRecNum = SaveRec(68)

/* Getting new address view */
GetRec(8)
SavedRecNum = SaveRec(69)

/* Getting new name info record */
GetRec(9)
SavedRecNum = SaveRec(82)

/* Getting business address Def */
GetRec(10)
SavedRecNum = SaveRec(84)

/* Getting business address view */
GetRec(11)
SavedRecNum = SaveRec(85)

/* Getting Print Multiple Env for Ind. definition */
GetRec(12)
SavedRecNum = SaveRec(91)

/* Getting Print Label for ind def. */
GetRec(13)
SavedRecNum = SaveRec(94)


/* Getting print multiple labels for ind def */
GetRec(14)
SavedRecNum = SaveRec(95)

/* Getting print multiple labels for ind view */
GetRec(15)
SavedRecNum = SaveRec(96)

/* use offsets for version 2 record numbers above 97 */

/* Getting new contacts TOC definition */
GetRec(16)
SavedRecNum = SaveRec(106 + VersionOffset)

/* Getting new contacts view */
GetRec(17)
SavedRecNum = SaveRec(107 + VersionOffset)

/* Getting new business contact list view */
GetRec(18)
SavedRecNum = SaveRec(109 + VersionOffset)

/* Getting new print multiple envelopes for business view */
GetRec(19)
SavedRecNum = SaveRec(111 + VersionOffset)

/* Getting new print multiple labels for business def */
GetRec(20)
SavedRecNum = SaveRec(112 + VersionOffset)

/* Getting new print multiple labels for business view */
GetRec(21)
SavedRecNum = SaveRec(113 + VersionOffset)

/* Getting new indexes etc */
Do RecNum = 22 To 27
   GetRec(RecNum)
   SavedRecNum = SaveRec(0)
   END

/* Getting new reports */
GetRec(28)
OffSetNum = SaveRec(0)

IF Version == "100" THEN DO
   Do RecNum = 29 To 40
       GetRec(RecNum)
       SavedRecNum = SaveRec(0)
       END
   END
ELSE DO
   Do RecNum = 29 To 37
       GetRec(RecNum)
       SavedRecNum = SaveRec(0)
       END
   GetRec(38)
   SaveRec(98)
   GetRec(39)
   SaveRec(99)
   GetRec(40)
   SaveRec(100)
   END

/* Need to merge Design Search Criteria folder */
GetRec(3)
MergeFolders(42, 0)

IF Version == "100" THEN DO
   /* Need to merge New Label Report Folder */
   GetRec(4)
   MergeFolders(45, 0)
   END

/* Update the recipe icon or expense icon in Report Dialogs Folder */
/* Note: This loses any new icons or changes the user has made to this folder */
GetRec(41)
SaveRec(46)

Result = SetInputDb("item.db")

/* Delete unneeded icons from main folder */
GetRec(33)
DeleteIconFromFolder("Individuals")
DeleteIconFromFolder("Businesses")
SaveRec(33)

/* Delete old reports in version 1.02 */
IF Version == "102" THEN DO
   GetRec(45)
   DeleteIconFromFolder("Avery Label 4144 Report")
   DeleteIconFromFolder("Avery Label 5662 Report")
   DeleteIconFromFolder("Dennison Label 37-100 Report")
   SaveRec(45)
   Result = SetInputDb("temp\"dbname"2")
   /* Need to merge New Label Report Folder */
   GetRec(4)
   MergeFolders(45, 0)
   Result = SetInputDb("item")
   END

/* Delete unneeded icons from Search Criteria Folder */
GetRec(42)
DeleteIconFromFolder("Individuals Table of Contents")
DeleteIconFromFolder("Businesses Table of Contents")
SaveRec(42)

/* Need to Change icon values in New Label Reports Folder */
GetRec(45)
If Version == "102" THEN DO
   OffSetNum = OffSetNum - 2
   ChangeFolderIconFunctionRecNum("Avery 5160 Address Label Report", OffSetNum)
   ChangeFolderIconFunctionRecNum("Avery 5161 Address Label Report", OffSetNum + 1)
   ChangeFolderIconFunctionRecNum("Avery 5162 Address Label Report", OffSetNum + 2)
   ChangeFolderIconFunctionRecNum("Avery 5260 Address Label Report", OffSetNum + 3)
   ChangeFolderIconFunctionRecNum("Avery 5261 Address Label Report", OffSetNum + 4)
   ChangeFolderIconFunctionRecNum("Avery 5262 Address Label Report", OffSetNum + 5)
   ChangeFolderIconFunctionRecNum("Avery 5920 Address Label Report", OffSetNum + 6)
   ChangeFolderIconFunctionRecNum("Avery 5922 Address Label Report", OffSetNum + 7)
   ChangeFolderIconFunctionRecNum("Avery 5932 Clear Address Label Report", OffSetNum + 8)
   ChangeFolderIconFunctionRecNum("Avery 5960 Address Label Report", OffSetNum + 9)
   ChangeFolderIconFunctionRecNum("Avery 5961 Address Label Report", OffSetNum + 10)
   ChangeFolderIconFunctionRecNum("Avery 5962 Address Label Report", OffSetNum + 11)
   ChangeFolderIconFunctionRecNum("Avery 5662 Clear Address Label Report", 98)
   ChangeFolderIconFunctionRecNum("Dennison Label 37-100 Report", 99)
   ChangeFolderIconFunctionRecNum("Avery 4144 Address Label Report", 100)
   END
ELSE DO
   ChangeFolderIconFunctionRecNum("Dennison Label 37-100 Report", OffSetNum - 2)
   ChangeFolderIconFunctionRecNum("Avery 4144 Address Label Report", OffSetNum - 1)
   ChangeFolderIconFunctionRecNum("Avery 5160 Address Label Report", OffSetNum)
   ChangeFolderIconFunctionRecNum("Avery 5161 Address Label Report", OffSetNum + 1)
   ChangeFolderIconFunctionRecNum("Avery 5162 Address Label Report", OffSetNum + 2)
   ChangeFolderIconFunctionRecNum("Avery 5260 Address Label Report", OffSetNum + 3)
   ChangeFolderIconFunctionRecNum("Avery 5261 Address Label Report", OffSetNum + 4)
   ChangeFolderIconFunctionRecNum("Avery 5262 Address Label Report", OffSetNum + 5)
   ChangeFolderIconFunctionRecNum("Avery 5662 Clear Address Label Report", OffSetNum + 6)
   ChangeFolderIconFunctionRecNum("Avery 5920 Address Label Report", OffSetNum + 7)
   ChangeFolderIconFunctionRecNum("Avery 5922 Address Label Report", OffSetNum + 8)
   ChangeFolderIconFunctionRecNum("Avery 5932 Clear Address Label Report", OffSetNum + 9)
   ChangeFolderIconFunctionRecNum("Avery 5960 Address Label Report", OffSetNum + 10)
   ChangeFolderIconFunctionRecNum("Avery 5961 Address Label Report", OffSetNum + 11)
   ChangeFolderIconFunctionRecNum("Avery 5962 Address Label Report", OffSetNum + 12)
   END
SaveRec(45)

/* DisplayMessage("When the upgrade process is done, please exit Omnifile and restart it for all changes to take effect. Omnifile's first startup may have a delay while new indexes are built if the database is large.") */

Return 0

/*Subroutine copy new folders only - Copies startup & jumplist folders only */
COPYNEWFOLDERSONLY:

/* New Startup Folder */
GetRec(5)
SavedRecNum = SaveRec(49)

/* New Jump List Folder */
GetRec(6)
SavedRecNum = SaveRec(50)

/* Update Maintenance Folder also */
/* Getting maintenance folder */
GetRec(2)
MergeFolders(34, 0)

return 0
