## Fleeting Password Manager

Fleeting Password Manager is a simple program that generates pseudo-random passwords
from the given <b>master password</b>, <b>URL/ID</b> (e.g. facebook, www.facebook.com,
google, my_server..) and <b>user name</b>.

The user needs to remember only her master password to recover other passwords.

Passwords are always regenerated <b>on-the-fly</b> from the given login data when needed
and are never saved. In other words, Fleeting Password Manager combines
the password creation and management.

The length of the generated password is configurable between 8 and 32 characters
and Fleeting Password Manager can remember wanted URL/User-pairs.

## Example

Your master password is "AaBbCcDd", your URL/ID is "facebook" and your user name is "troll@example.com".

With this information Fleeting Password Manager gives you a password: Nzg3NTgz.

If you change, for example, your master password to something else like "AaBbDdEe",
you will now get a password: MmM0OTEw.

If you change, for example, your user name to something else like "me@example.com",
you will now get a password: YWY5OTQw.

## Security

The password generated by Fleeting Password Manager is as secure as any other password.

In order to crack your passwords the attacker would need to know:
* The fact that you are using Fleeting Password Manager in the first place
* Your master password(s)
* The URL/ID and user names you are using

## Building the project

Fleeting Password Manager is developed in C++/Qt so it can be built on any
platform that Qt5 runs on.

Please refer to the INSTALL document for build/install instructions if you're
going to build Fleeting Password Manager from sources.

## Licence

GNU GPL v3

-- Jussi Lind <jussi.lind@iki.fi>
