CREATE DATABASE /*!32312 IF NOT EXISTS*/ voldep;

USE voldep;

#
# Table structure for table 'aktie'
#

DROP TABLE IF EXISTS aktie;
CREATE TABLE aktie (
  AktieID int(11) NOT NULL auto_increment,
  DepotID int(11) NOT NULL default '0',
  WKN char(10) NOT NULL default '',
  Symbol char(10) NOT NULL default '',
  Boerse char(3) NOT NULL default '',
  Name char(60) NOT NULL default '',
  KaufKurs decimal(10,2) NOT NULL default '0.00',
  Waehrung char(3) NOT NULL default 'EUR',
  Faktor decimal(12,6) NOT NULL default '0.000000',
  Stueck decimal(10,2) NOT NULL default '0.00',
  KaufDatum date NOT NULL default '1900-01-01',
  Gebuehr1 decimal(10,5) NOT NULL default '0.00000',
  Gebuehr2 decimal(10,5) NOT NULL default '0.00000',
  Gebuehr3 decimal(10,5) NOT NULL default '0.00000',
  Dividende decimal(10,2) NOT NULL default '0.00',
  Beobachten int(11) NOT NULL default '0',
  PRIMARY KEY  (AktieID),
  KEY IdxDepotID (DepotID),
  KEY IdxWKN (WKN),
  KEY IdxSymbol (Symbol)
) TYPE=MyISAM;

#
# Table structure for table 'depot'
#

DROP TABLE IF EXISTS depot;
CREATE TABLE depot (
  DepotID int(11) NOT NULL auto_increment,
  Nummer int(11) NOT NULL default '0',
  Name char(60) NOT NULL default '',
  PRIMARY KEY  (DepotID)
) TYPE=MyISAM;

#
# Table structure for table 'kurs'
#

DROP TABLE IF EXISTS kurs;
CREATE TABLE kurs (
  KursID int(11) NOT NULL auto_increment,
  AktieID int(11) NOT NULL default '0',
  TagHoch decimal(10,2) NOT NULL default '0.00',
  TagTief decimal(10,2) NOT NULL default '0.00',
  AktKursZeit datetime NOT NULL default '1900-01-01 00:00:00',
  AktKurs decimal(10,2) NOT NULL default '0.00',
  Handelsvolumen int(11) NOT NULL default '0',
  Vortag decimal(10,2) NOT NULL default '0',
  Faktor decimal(12,6) NOT NULL default '0.000000',
  PRIMARY KEY  (KursID),
  KEY IdxAktieID (AktieID),
  KEY IdxAktKursZeit (AktKursZeit)
) TYPE=MyISAM;

