/* REXX PROGRAM */
/* This REXX program expects CHECK+ to be the host environment */
/* It modifies an MYM Import file to make it suitable for importing to Check+. */
/* If you are attempting to change this file, you will normally only need to change the command in the CHANGE_REXX_VARIABLES subroutine. */


/* MAIN SUBROUTINE */
szEnvironment = address()
IF szEnvironment <> "Check+" THEN DO
	SAY "This rexx file can only be run by Check+, not directly."
	RETURN 1
	END

/* Load the Rexx variables based on the arguments the user passed in. */
FileIn = ARG(1)
HeaderFile = ARG(2)
Delimiter = ARG(3)
/* Make sure the required arguments where given. */
IF FileIn = "" THEN DO
	SAY "The following arguments are expected: FILEIN HEADERFILE DELIMITER"
	SAY "    FILEIN is required."
	SAY "    HEADERFILE will default to FILEIN if not given."
	SAY "    DELIMITER will default to ',' if not given."
	RETURN 1
	END
/* Set the default header file to the input file and the default delimiter to ','. */
IF HeaderFile = "" THEN HeaderFile = FileIn
IF Delimiter = "" THEN Delimiter = ','
/* Load the Header Line and pass it to Check+ in order to initialize the import. */
headerLine = LINEIN(HeaderFile)
SetHeaderLine(headerLine)
/* For each line in the input file, load the line, loads the Rexx variables, modify the Rexx variables, and tell Check+ to add the transaction. */
DO while LINES(FileIn)
	line = LINEIN(FileIn)
	memo = "" /* MYM only exports memo if it is set so we must clear it for each line. */
	SetRexxVariables(line)
	CALL CHANGE_REXX_VARIABLES
	AddTransaction()
	end
/* Close all the files. */
result = stream(FileOut, 'c', 'close')
result = stream(FileIn, 'c', 'close')
IF HeaderFile \= FileIn THEN stream(HeaderFile, 'c', 'close')
RETURN 0


/* SUBROUTINE */
CHANGE_REXX_VARIABLES:
/* Change fields from MYM output format to a format suitable for Check+ import. */
/* This subroutine is usually the only portion that the user needs to change. */

/* Change the Type to the types expected by Check+. */
if type = "Receive"
	THEN type = "Deposit"
	ELSE type = "" /* Let it default to either hand check, computer check, or withdrawal. */

/* MYM stores allocation amounts as negative numbers - make it always positive. */
IF allocationAmount < 0 THEN allocationAmount = 0 - allocationAmount

/* MYM uses R or P to indicate Reconciled or Printed.  If set, use Check date for dateCleared and datePrinted. */
IF dateCleared = "R" THEN dateCleared = date
IF datePrinted = "P" THEN datePrinted = date

RETURN

