/*
 * YV12 to YUY2, YUV420P to RGB conversion library
 * Copyright (C) 2007 by KO Myung-Hun <komh@chollian.net>
 *
 * based on WarpVision yuv2rgb
 *
 * based on mpeg2dec & MPlayer postproc & xine gamma stuff
 *
 * Copyright (C) 2000-2002 Michel Lespinasse <walken@zoy.org>
 * Copyright (C) 1999-2000 Aaron Holtzman <aholtzma@ess.engr.uvic.ca>
 *
 * 15,24 bpp and dithering from Michael Niedermayer (michaelni@gmx.at)
 * MMX/MMX2 Template stuff from Michael Niedermayer (michaelni@gmx.at) (needed for fast movntq support)
 *
 * This file is part of mpeg2dec, a free MPEG-2 video stream decoder.
 * See http://libmpeg2.sourceforge.net/ for updates.
 *
 * mpeg2dec is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * mpeg2dec is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Changes :
 *     KO Myung-Hun <komh@chollian.net> 2007/02/09
 *         - Included types.h
 */

#ifndef __YUV2RGB_H_
#define __YUV2RGB_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <types.h>

typedef void (* yuv420_fun) (uint8_t * image, uint8_t * py,
                             uint8_t * pu, uint8_t * pv,
                             int h_size, int v_size,
                             int rgb_stride, int y_stride, int uv_stride);

typedef void (* yv12toyuy2_fun) (uint8_t *dst, const uint8_t *ysrc,
                                 const uint8_t *usrc, const uint8_t *vsrc,
                                 int chromWidth);

extern yuv420_fun yuv2rgb;

void yuv420_rgb_init(int);
void yuv420_rgb_close(void);
// +-128

void yuv2rgb_set_gamma(int);

void yv12toyuy2_init(void);

void yv12toyuy2(const uint8_t *ysrc, const uint8_t *usrc, const uint8_t *vsrc,
                uint8_t *dst, unsigned int width, unsigned int height,
                unsigned int lumStride, unsigned int chromStride,
                unsigned int dstStride, int vertLumPerChroma);

void yvu9toyuy2(const uint8_t *src1, const uint8_t *src2, const uint8_t *src3,
            uint8_t *dst,
            unsigned width, unsigned height,
            unsigned srcStride1, unsigned srcStride2,
            unsigned srcStride3, unsigned dstStride);

#ifdef __cplusplus
}
#endif

#endif

