/*
    test.c
    simple test program based on avcodec_sample.0.4.9.cpp
*/

#define INCL_DOS
#define INCL_WIN
#define INCL_GPI
#include <os2.h>

#include <mmioos2.h>
#include <fourcc.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <avcodec.h>
#include <avformat.h>
#include <swscale.h>

#include <kva.h>

AVFormatContext *pFormatCtx;
AVCodecContext  *pCodecCtx;
AVFrame         *pFrame;
AVFrame         *pFrameOS2;
int             videoStream;

BOOL            fQuit = FALSE;

void MorphToPM()
{
    PPIB pib;
    PTIB tib;

    DosGetInfoBlocks(&tib, &pib);

    // Change flag from VIO to PM:
    if( pib->pib_ultype == 2 )
        pib->pib_ultype = 3;
}

MRESULT EXPENTRY WndProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
    return WinDefWindowProc( hwnd, msg, mp1, mp2 );
}

VOID Delay( ULONG ms )
{
    PTIB  ptib;
    ULONG ulClass;
    ULONG ulDelta;

    DosGetInfoBlocks( &ptib, NULL );
    ulClass = HIBYTE( ptib->tib_ptib2->tib2_ulpri );
    ulDelta = LOBYTE( ptib->tib_ptib2->tib2_ulpri );

    DosSetPriority( PRTYS_THREAD, PRTYC_TIMECRITICAL, +31, 0 );
    DosSleep( ms );
    DosSetPriority( PRTYS_THREAD, ulClass, ulDelta, 0 );
}

void VideoThread( void *arg )
{
    AVPacket    packet;
    int         frameFinished;
    ULONG       frame_delay = av_q2d( pCodecCtx->time_base ) * 1000;

    PVOID   pBuffer, pBuffer1;
    ULONG   ulBPL;

    while( !fQuit && av_read_frame( pFormatCtx, &packet ) >= 0 )
    {
        // Is this a packet from the video stream?
        if( packet.stream_index == videoStream )
        {
            // Decode video frame
            avcodec_decode_video( pCodecCtx, pFrame, &frameFinished,
                                  packet.data, packet.size );

            // Did we get a video frame?
            if(frameFinished)
            {
                kvaLockBuffer( &pBuffer, &ulBPL );

                pBuffer1 = av_malloc( pCodecCtx->height * ulBPL );

                avpicture_fill(( AVPicture * )pFrameOS2, pBuffer1, PIX_FMT_YUYV422,
                               pCodecCtx->width, pCodecCtx->height );

                img_convert(( AVPicture * )pFrameOS2, PIX_FMT_YUYV422, ( AVPicture * )pFrame,
                            pCodecCtx->pix_fmt, pCodecCtx->width, pCodecCtx->height );

                memcpy( pBuffer, pBuffer1, pCodecCtx->height * ulBPL );

                av_free( pBuffer1 );

                kvaUnlockBuffer();

                Delay( frame_delay );
            }
        }

        // Free the packet that was allocated by av_read_frame
        av_free_packet(&packet);
    }

    _endthread();
}

int main(int argc, char *argv[])
{
    HAB     hab;
    HMQ     hmq;
    ULONG   flFrameFlags;
    HWND    hwndFrame;
    HWND    hwndClient;
    QMSG    qm;
    PSZ     szWndClass = "KMP_CLASS";
    PSZ     szAppTitle = "K Movie Player";

    TID     tid_video;

    KVASETUP KvaSetup = { 0 };
    RECTL    rcl;

    int      i;
    AVCodec  *pCodec;

    int ret = 1;

    // Morph the VIO application to a PM one to be able to use Win* functions
    MorphToPM();

    // Make stdout and stderr unbuffered
    setbuf( stdout, NULL );
    setbuf( stderr, NULL );

    hab = WinInitialize( 0 );
    hmq = WinCreateMsgQueue( hab, 0);

    WinRegisterClass(
        hab,
        szWndClass,
        WndProc,
        CS_SIZEREDRAW,
        sizeof( PVOID )
    );

    flFrameFlags = FCF_SYSMENU | FCF_TITLEBAR | FCF_MINMAX | FCF_SIZEBORDER |
                   FCF_SHELLPOSITION | FCF_TASKLIST;

    hwndFrame = WinCreateStdWindow (
                HWND_DESKTOP,
                WS_VISIBLE ,
                &flFrameFlags,
                szWndClass,
                szAppTitle,
                0,
                0,
                1,
                &hwndClient);

    if( kvaInit( KVAM_AUTO, hwndClient, 0x000008 ))
    {
       WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
                      "Error",
                      "Can't init overlay!", 0, MB_ICONHAND | MB_OK);

       goto exit_frame;
    }

    // Register all formats and codecs
    av_register_all();

    // Open video file
    if( av_open_input_file( &pFormatCtx, argv[1], NULL, 0, NULL ) != 0 )
        goto exit_kva; // Couldn't open file

    // Retrieve stream information
    if( av_find_stream_info( pFormatCtx ) < 0 )
        goto exit_close_file; // Couldn't find stream information

    // Dump information about file onto standard error
    dump_format( pFormatCtx, 0, argv[ 1 ], FALSE );

    // Find the first video stream
    videoStream = -1;
    for( i = 0; i < pFormatCtx->nb_streams; i++ )
        if( pFormatCtx->streams[ i ]->codec->codec_type == CODEC_TYPE_VIDEO )
        {
            videoStream = i;
            break;
        }
    if( videoStream == -1 )
        goto exit_close_file; // Didn't find a video stream

    // Get a pointer to the codec context for the video stream
    pCodecCtx = pFormatCtx->streams[ videoStream ]->codec;

    // Find the decoder for the video stream
    pCodec = avcodec_find_decoder( pCodecCtx->codec_id );
    if( pCodec == NULL )
        goto exit_close_file; // Codec not found

    // Inform the codec that we can handle truncated bitstreams -- i.e.,
    // bitstreams where frame boundaries can fall in the middle of packets
    //if( pCodec->capabilities & CODEC_CAP_TRUNCATED )
        //pCodecCtx->flags |= CODEC_FLAG_TRUNCATED;

    // Open codec
    if( avcodec_open( pCodecCtx, pCodec ) < 0 )
        goto exit_close_file; // Could not open codec

    // Allocate video frame
    pFrame = avcodec_alloc_frame();

    // Allocate an AVFrame structure
    pFrameOS2 = avcodec_alloc_frame();

    KvaSetup.ulLength = sizeof( KVASETUP );
    KvaSetup.szlSrcSize.cx = pCodecCtx->width;
    KvaSetup.szlSrcSize.cy = pCodecCtx->height;
    KvaSetup.fccSrcColor = FOURCC_Y422;
    KvaSetup.rclSrcRect.xLeft = 0;
    KvaSetup.rclSrcRect.yTop = 0;
    KvaSetup.rclSrcRect.xRight = pCodecCtx->width;
    KvaSetup.rclSrcRect.yBottom = pCodecCtx->height;
    if( kvaSetup( &KvaSetup ))
    {
       WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
        "Error",
        "Can't setup overlay!", 0, MB_ICONHAND | MB_OK);

       goto exit_close_codec;
    }


    WinSetWindowPos( hwndFrame, HWND_TOP, 100, 100,
                     pCodecCtx->width, pCodecCtx->height,
                     SWP_SIZE | SWP_MOVE | SWP_SHOW | SWP_ZORDER | SWP_ACTIVATE );
    WinQueryWindowRect( hwndClient, &rcl );
    WinSetWindowPos( hwndFrame, HWND_TOP, 100, 100,
                     2 * pCodecCtx->width - rcl.xRight + rcl.xLeft,
                     2 * pCodecCtx->height -rcl.yTop + rcl.yBottom,
                     SWP_SIZE | SWP_MOVE | SWP_SHOW | SWP_ZORDER | SWP_ACTIVATE );

    tid_video = _beginthread( VideoThread, NULL, 32768, NULL );

    while( WinGetMsg( hab, &qm, NULLHANDLE, 0, 0 ))
          WinDispatchMsg( hab, &qm );

    fQuit = TRUE;

    DosWaitThread( &tid_video, DCWW_WAIT );

    // Free the RGB image
    av_free(pFrameOS2);

    // Free the YUV frame
    av_free(pFrame);

    ret = 0;

exit_close_codec:
    // Close the codec
    avcodec_close(pCodecCtx);

exit_close_file:
    // Close the video file
    av_close_input_file(pFormatCtx);

exit_kva:
    kvaDone();

exit_frame:
    WinDestroyWindow( hwndFrame );
    WinDestroyMsgQueue( hmq );
    WinTerminate( hab );

    return ret;
}
