/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Util;

public final class oroToApache {
    public static final String PACKAGE_PATTERN = "com\\.oroinc\\.(io|text|util)";
    public static final String PACKAGE_SUBSTITUTION = "org.apache.oro.$1";
    public static final String OLD_FILE_EXTENSION = "_old";

    public static final void main(String[] stringArray) {
        Converter converter;
        if (stringArray.length < 1) {
            System.err.println("usage: oroToApache [file ...]");
            return;
        }
        try {
            converter = new Converter(PACKAGE_PATTERN);
        }
        catch (MalformedPatternException malformedPatternException) {
            malformedPatternException.printStackTrace();
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                System.out.println("Converting " + stringArray[n]);
                converter.convertFile(stringArray[n], OLD_FILE_EXTENSION);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Error: Could not open file.  Skipping " + stringArray[n]);
            }
            catch (RenameException renameException) {
                System.err.println("Error: " + renameException.getMessage());
            }
            catch (SecurityException securityException) {
                System.err.println("Error: Could not rename a file while processing" + stringArray[n] + ".  Insufficient permission.  " + "File may not have been converted.");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.err.println("Error: I/O exception while converting " + stringArray[n] + ".  File not converted.");
            }
            ++n;
        }
    }

    public static final class RenameException
    extends IOException {
        public RenameException() {
        }

        public RenameException(String string) {
            super(string);
        }
    }

    public static final class Converter {
        Pattern _sourcePattern;
        Perl5Matcher _matcher = new Perl5Matcher();
        Perl5Substitution _substitution;

        public Converter(String string) throws MalformedPatternException {
            Perl5Compiler perl5Compiler = new Perl5Compiler();
            this._sourcePattern = perl5Compiler.compile(string);
            this._substitution = new Perl5Substitution(oroToApache.PACKAGE_SUBSTITUTION);
        }

        public void convertFile(String string, String string2) throws FileNotFoundException, RenameException, SecurityException, IOException {
            File file = new File(string);
            FileReader fileReader = new FileReader(file);
            File file2 = File.createTempFile(file.getName(), null, file.getAbsoluteFile().getParentFile());
            FileWriter fileWriter = new FileWriter(file2);
            char[] cArray = new char[(int)file.length()];
            int n = Converter.readFully(fileReader, cArray);
            fileReader.close();
            String string3 = Util.substitute(this._matcher, this._sourcePattern, this._substitution, new String(cArray), -1);
            fileWriter.write(string3);
            fileWriter.close();
            if (!file.renameTo(new File(String.valueOf(file.getAbsolutePath()) + oroToApache.OLD_FILE_EXTENSION))) {
                throw new RenameException("Could not rename " + file.getPath() + ".");
            }
            if (!file2.renameTo(file)) {
                throw new RenameException("Could not rename temporary output file.  Original file is in " + file.getAbsolutePath() + oroToApache.OLD_FILE_EXTENSION);
            }
        }

        public static final int readFully(Reader reader, char[] cArray) throws IOException {
            int n = 0;
            int n2 = cArray.length;
            while (n < cArray.length) {
                int n3 = reader.read(cArray, n, n2);
                if (n3 == -1) break;
                n += n3;
                n2 -= n3;
            }
            return n;
        }
    }
}

