/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.subtitle;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.subtitle.BMP;
import net.sourceforge.dvb.projectx.subtitle.Bitmap;
import net.sourceforge.dvb.projectx.subtitle.ColorAreas;

public class DVBSubpicture {
    private byte[] data;
    private int width = Common.getSettings().getBooleanProperty(Keys.KEY_SubtitlePanel_enableHDSub) ? 1920 : 720;
    private int height = Common.getSettings().getBooleanProperty(Keys.KEY_SubtitlePanel_enableHDSub) ? 1088 : 576;
    private int BytePosition;
    private int BitPosition;
    private Graphics2D big;
    private BufferedImage bimg;
    private Epoch epoch;
    private Page page;
    private Region region;
    private CLUT clut;
    private OBJECT object;
    private Hashtable epoches = new Hashtable();
    private int[] table_CLUT_8bit;
    private int IRD;
    private int epoch_id = 0;
    private boolean biglog;
    private int[] pixel_data;
    private int[] preview_pixel_data;
    private long pts;
    private int from_index;
    private int to_index;
    private boolean picture_saved;
    private boolean save;
    private boolean preview_visible = false;
    private int fix_page_id;
    private Hashtable user_table = new Hashtable();
    private boolean user_table_enabled;
    private boolean global_error = false;

    public DVBSubpicture() {
        this.table_CLUT_8bit = this.generateDefaultCLUT_8Bits();
        this.setIRD(8, this.user_table, false, "");
    }

    /*
     * Unable to fully structure code
     */
    private void CLUT_definition() {
        var1_1 = this.getBits(16) + this.BytePosition;
        this.clut = Epoch.access$6(this.epoch, this.getBits(8));
        CLUT.access$1(this.clut, this.getBits(4));
        this.addBigMessage("clutcomp: " + CLUT.access$0(this.clut) + " /v " + CLUT.access$2(this.clut));
        this.flushBits(4);
        if (!this.user_table_enabled) ** GOTO lbl34
        this.setUserClut();
        this.flushBits((var1_1 - this.BytePosition) * 8);
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = this.getBits(8);
            var3_3 = this.getBits(1);
            var4_4 = this.getBits(1);
            var5_5 = this.getBits(1);
            var6_6 = var5_5 << 3 | var4_4 << 2 | var3_3 << 1;
            this.flushBits(4);
            var7_7 = this.getBits(1);
            if (var7_7 == 1) {
                var9_9 = this.getBits(8);
                var10_10 = this.getBits(8);
                var11_11 = this.getBits(8);
                var12_12 = this.getBits(8);
            } else {
                var9_9 = this.getBits(6) << 2;
                var10_10 = this.getBits(4) << 4;
                var11_11 = this.getBits(4) << 4;
                var12_12 = this.getBits(2) << 6;
            }
            var8_8 = this.YUVtoRGB(var9_9, var10_10, var11_11, var12_12);
            this.addBigMessage("addclut: " + var2_2 + " /flag " + Integer.toHexString(var6_6).toUpperCase() + " /ARGB " + Integer.toHexString(var8_8).toUpperCase() + " /range " + var7_7);
            var13_13 = 0;
            while (var13_13 < 3) {
                CLUT.access$3(this.clut, this.mapColorIndex(var2_2, this.getRegionDepth(), 2 << var13_13), var6_6 & 2 << var13_13, var8_8);
                ++var13_13;
            }
lbl34:
            // 2 sources

            ** while (this.BytePosition < var1_1)
        }
lbl35:
        // 1 sources

    }

    private int Subtitle_Segment() {
        if (this.getBits(8) != 15) {
            return -1;
        }
        int n = this.getBits(8);
        int n2 = this.getBits(16);
        if (this.fix_page_id >= 0 && n2 != this.fix_page_id) {
            this.stuffing();
            return 255;
        }
        this.page = this.epoch.setPage(n2);
        this.addBigMessage("segm: 0x" + Integer.toHexString(n) + " / " + this.pts);
        switch (n) {
            case 16: {
                return this.page_composition();
            }
            case 17: {
                this.region_composition();
                return n;
            }
            case 18: {
                this.CLUT_definition();
                return n;
            }
            case 19: {
                this.object_data();
                return n;
            }
            case 128: {
                this.end_display();
                return n;
            }
            case 255: {
                this.stuffing();
                return n;
            }
        }
        this.stuffing();
        return n;
    }

    private int YUVtoRGB(int n, int n2, int n3, int n4) {
        if (n == 0) {
            return 0;
        }
        int n5 = (int)((float)n + 1.402f * (float)(n2 - 128));
        int n6 = (int)((double)n - 0.34414 * (double)(n3 - 128) - 0.71414 * (double)(n2 - 128));
        int n7 = (int)((double)n + 1.722 * (double)(n3 - 128));
        int n8 = n5 < 0 ? 0 : (n5 = n5 > 255 ? 255 : n5);
        int n9 = n6 < 0 ? 0 : (n6 = n6 > 255 ? 255 : n6);
        int n10 = n7 < 0 ? 0 : (n7 = n7 > 255 ? 255 : n7);
        n4 = 255 - (n4 < 0 ? 0 : (n4 > 255 ? 255 : n4));
        return n4 << 24 | n5 << 16 | n6 << 8 | n7;
    }

    private void addBigMessage(String string) {
        if (!this.biglog) {
            return;
        }
        System.out.println(string);
    }

    private void alignToByte() {
        this.alignToByte(1);
    }

    private void alignToByte(int n) {
        while ((7 & this.BitPosition) != 0) {
            this.flushBits(n);
        }
    }

    private void alignToWord() {
        if ((1 & this.BytePosition) != 0 && this.nextBits(8) != 15) {
            this.flushBits(8);
        }
    }

    private void clearBackground() {
        Arrays.fill(this.preview_pixel_data, 96);
        this.big.setColor(new Color(0, 0, 96));
        this.big.fillRect(this.bimg.getMinX(), this.bimg.getMinY(), this.bimg.getWidth(), this.bimg.getHeight());
    }

    public int decodeDVBSubpicture(byte[] byArray, int[] nArray, Graphics2D graphics2D, BufferedImage bufferedImage, long l, boolean bl, boolean bl2) {
        this.data = byArray;
        this.BytePosition = nArray[0];
        this.BitPosition = nArray[0] << 3;
        this.big = graphics2D;
        this.bimg = bufferedImage;
        this.pts = l;
        this.save = bl;
        this.preview_visible = bl2;
        this.picture_saved = false;
        this.global_error = false;
        this.flushBits(8);
        int n = this.getBits(8);
        int n2 = 0;
        boolean bl3 = false;
        while (this.BytePosition < this.data.length - 4) {
            int n3 = this.nextBits(8);
            this.addBigMessage("ret " + Integer.toHexString(n3) + " /bi " + this.BitPosition + " /by " + this.BytePosition);
            if (n3 == 255) break;
            if (n3 != 15) {
                this.flushBits(8);
                continue;
            }
            n2 = this.Subtitle_Segment();
            this.alignToByte();
            if (!this.global_error || this.region == null) continue;
            this.region.setError(4);
        }
        this.nextBits(8);
        if (this.picture_saved) {
            return -1;
        }
        return -2;
    }

    private void end_display() {
        int n = this.getBits(16);
        this.flushBits(n * 8);
    }

    private void flushBits(int n) {
        this.BitPosition += n;
        this.BytePosition = this.BitPosition >>> 3;
    }

    private int generateClutEntry_4Bits(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        if ((n & 8) == 0) {
            if ((n & 7) == 0) {
                n5 = 0;
                n4 = 0;
                n3 = 0;
                n2 = 0;
            } else {
                n3 = (n & 1) != 0 ? 255 : 0;
                n4 = (n & 2) != 0 ? 255 : 0;
                n5 = (n & 4) != 0 ? 255 : 0;
                n2 = 255;
            }
        } else {
            n3 = (n & 1) != 0 ? 128 : 0;
            n4 = (n & 2) != 0 ? 128 : 0;
            n5 = (n & 4) != 0 ? 128 : 0;
            n2 = 255;
        }
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    private int generateClutEntry_8Bits(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if ((n & 0x88) == 0) {
            if ((n & 0x70) == 0) {
                if ((n & 7) == 0) {
                    n5 = 0;
                    n4 = 0;
                    n3 = 0;
                    n2 = 0;
                } else {
                    n3 = (n & 1) != 0 ? 255 : 0;
                    n4 = (n & 2) != 0 ? 255 : 0;
                    n5 = (n & 4) != 0 ? 255 : 0;
                    n2 = 64;
                }
            } else {
                n3 = ((n & 1) != 0 ? 85 : 0) + ((n & 0x10) != 0 ? 170 : 0);
                n4 = ((n & 2) != 0 ? 85 : 0) + ((n & 0x20) != 0 ? 170 : 0);
                n5 = ((n & 4) != 0 ? 85 : 0) + ((n & 0x40) != 0 ? 170 : 0);
                n2 = 255;
            }
        } else if ((n & 0x88) == 8) {
            n3 = ((n & 1) != 0 ? 85 : 0) + ((n & 0x10) != 0 ? 170 : 0);
            n4 = ((n & 2) != 0 ? 85 : 0) + ((n & 0x20) != 0 ? 170 : 0);
            n5 = ((n & 4) != 0 ? 85 : 0) + ((n & 0x40) != 0 ? 170 : 0);
            n2 = 128;
        } else if ((n & 0x88) == 128) {
            n3 = ((n & 1) != 0 ? 42 : 0) + ((n & 0x10) != 0 ? 85 : 0) + 128;
            n4 = ((n & 2) != 0 ? 42 : 0) + ((n & 0x20) != 0 ? 85 : 0) + 128;
            n5 = ((n & 4) != 0 ? 42 : 0) + ((n & 0x40) != 0 ? 85 : 0) + 128;
            n2 = 255;
        } else if ((n & 0x88) == 136) {
            n3 = ((n & 1) != 0 ? 42 : 0) + ((n & 0x10) != 0 ? 85 : 0);
            n4 = ((n & 2) != 0 ? 42 : 0) + ((n & 0x20) != 0 ? 85 : 0);
            n5 = ((n & 4) != 0 ? 42 : 0) + ((n & 0x40) != 0 ? 85 : 0);
            n2 = 255;
        }
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    private int[] generateDefaultCLUT_8Bits() {
        int[] nArray = new int[256];
        int n = 0;
        while (n < 256) {
            nArray[n] = this.generateClutEntry_8Bits(n);
            ++n;
        }
        return nArray;
    }

    private int getBits(int n) {
        int n2 = this.BitPosition >>> 3;
        if (n2 >= this.data.length - 4) {
            this.global_error = true;
            this.BitPosition += n;
            this.BytePosition = this.BitPosition >>> 3;
            return 0;
        }
        int n3 = (0xFF & this.data[n2]) << 24 | (0xFF & this.data[n2 + 1]) << 16 | (0xFF & this.data[n2 + 2]) << 8 | 0xFF & this.data[n2 + 3];
        n3 <<= this.BitPosition & 7;
        this.BitPosition += n;
        this.BytePosition = this.BitPosition >>> 3;
        return n3 >>>= 32 - n;
    }

    private int getRegionDepth() {
        return this.region != null ? this.region.getDepth() : 4;
    }

    public int getTimeOut() {
        return this.page.getTimeOut();
    }

    private int mapColorIndex(int n, int n2, int n3) {
        switch (n3) {
            case 2: {
                if (n2 == 8) {
                    n >>>= 4;
                }
                if (n2 <= 2) break;
                n = 2 & n >>> 2 | 1 & n >>> 2 | 1 & n >>> 1 | 1 & n;
                break;
            }
            case 4: {
                if (n2 == 2) {
                    n = this.object != null ? this.object.getMapTable_2to4bit()[n] : n;
                    break;
                }
                if (n2 != 8) break;
                n >>>= 4;
                break;
            }
            case 8: {
                if (n2 == 2) {
                    n = this.object != null ? this.object.getMapTable_2to8bit()[n] : n;
                    break;
                }
                if (n2 != 4) break;
                n = this.object != null ? this.object.getMapTable_4to8bit()[n] : n;
            }
        }
        return n;
    }

    private int nextBits(int n) {
        int n2 = this.BitPosition >>> 3;
        if (n2 >= this.data.length - 4) {
            this.global_error = true;
            return 0;
        }
        int n3 = (0xFF & this.data[n2]) << 24 | (0xFF & this.data[n2 + 1]) << 16 | (0xFF & this.data[n2 + 2]) << 8 | 0xFF & this.data[n2 + 3];
        n3 <<= this.BitPosition & 7;
        return n3 >>>= 32 - n;
    }

    private void object_data() {
        int n;
        int n2;
        int n3 = this.getBits(16) + this.BytePosition;
        this.object = this.epoch.setObject(this.getBits(16));
        int n4 = this.object.getRegionId();
        if (n4 < 0) {
            this.flushBits((n3 - this.BytePosition) * 8);
            this.addBigMessage("object_id " + this.object.getId() + " with no region_id");
            return;
        }
        this.region = this.epoch.setRegion(n4);
        this.region.resetXY();
        this.pixel_data = this.region.getPixel();
        this.addBigMessage("objdata: reg " + this.region.getId() + " /obj " + Integer.toHexString(this.object.getId()).toUpperCase());
        this.object.setVersionNumber(this.getBits(4));
        int n5 = this.getBits(2);
        this.object.setNonModify(this.getBits(1));
        this.flushBits(1);
        this.clut = this.epoch.setCLUT(this.region.getCLUT_id());
        if (this.user_table_enabled && this.clut.getModifyFlags() == 0) {
            this.setUserClut();
        }
        if (n5 == 0) {
            n2 = this.getBits(16);
            n = this.getBits(16);
            this.object.setCopyTopFieldFlag(n);
            n2 += this.BytePosition;
            while (this.BytePosition < n2) {
                this.pixel_block();
            }
            this.region.nextField();
            n += this.BytePosition;
            while (this.BytePosition < n) {
                this.pixel_block();
            }
        }
        if (n5 == 1) {
            n2 = this.getBits(8);
            String string = "";
            int n6 = 0;
            while (n6 < n2) {
                n = this.getBits(16);
                string = String.valueOf(string) + (char)n;
                ++n6;
            }
            this.addBigMessage("chars: " + string);
            this.paintStringObjects(this.region.getX(0), this.region.getY(), string);
        }
    }

    private int page_composition() {
        int n = this.getBits(16) + this.BytePosition;
        int n2 = 16;
        int n3 = this.getBits(8) * 100;
        this.page.setVersionNumber(this.getBits(4));
        this.page.setState(this.getBits(2));
        this.flushBits(2);
        this.addBigMessage("pagecomp: state " + this.page.getState() + " /page " + this.page.getId() + " /pv " + this.page.getVersionNumber() + " /to " + n3 + "                      " + (this.page.getState() < 1 ? "" : (this.page.getState() < 2 ? "<<acquisition pt>>" : "<<new epoch>>")));
        if (this.page.getState() > 0) {
            this.clearBackground();
            this.page.clearArea();
        }
        Enumeration enumeration = this.epoch.getRegions();
        while (enumeration.hasMoreElements()) {
            this.region = this.epoch.setRegion(Integer.parseInt(enumeration.nextElement().toString()));
            if (this.region.getErrors() > 0) {
                Common.setMessage(Resource.getString("subpicture.msg.error.dvbdecoding", String.valueOf(this.region.getErrors()), String.valueOf(this.region.getId()), String.valueOf(this.page.getTimeIn())));
                if ((this.region.getErrors() & 4) != 0) {
                    Common.setMessage("!> Region ignored (VN): " + this.region.getVersionNumber());
                    this.region.setActive(false);
                }
            }
            this.addBigMessage("enum: region " + this.region.getId() + " /err " + this.region.getErrors() + " /acti " + this.region.isActive() + " /chng " + this.region.isChanged() + " /ti_o " + n3);
            if (this.page.getState() == 0 && n3 > 6000) continue;
            this.region.setError(0);
            if (!this.region.isActive() || !this.region.isChanged()) continue;
            this.region.setChanged(false);
            this.pixel_data = this.region.getPixel();
            this.page.addArea(this.region.getXBound(), this.region.getYBound(), this.region.getWidth(), this.region.getHeight());
            try {
                int n4 = 0;
                while (n4 < this.region.getHeight()) {
                    System.arraycopy(this.pixel_data, n4 * this.region.getWidth(), this.preview_pixel_data, this.region.getXBound() + (this.region.getYBound() + n4) * this.width, this.region.getWidth());
                    ++n4;
                }
            }
            catch (Exception exception) {
                this.region.setError(8);
                Common.setMessage(Resource.getString("subpicture.msg.error.dvbdecoding", String.valueOf(this.region.getErrors()), String.valueOf(this.region.getId()), String.valueOf(this.page.getTimeIn())));
            }
            n2 = 128;
            this.addBigMessage("addToBMP: region " + this.region.getId());
            this.addBigMessage("newSize: x " + this.page.getX() + " y " + this.page.getY() + " w " + this.page.getWidth() + " h " + this.page.getHeight());
        }
        if (n2 == 128) {
            this.prepare_output();
        }
        if (this.page.getState() > 0) {
            this.page = this.epoch.newPage(this.page.getId());
            this.page.setTimeIn(this.pts);
            this.page.setWriteStatus(this.save);
            this.epoch.clearRegions();
            this.epoch.clearObjects();
        }
        this.page.setTimeIn(this.pts);
        this.page.setTimeOut(n3);
        while (this.BytePosition < n) {
            this.region = this.epoch.setRegion(this.getBits(8));
            this.region.setActive(true);
            this.region.setChanged(true);
            this.flushBits(8);
            this.region.setHorizontalAddress(this.getBits(16));
            this.region.setVerticalAddress(this.getBits(16));
            this.addBigMessage("addreg: reg " + this.region.getId() + " /x " + this.region.getXBound() + " /y " + this.region.getYBound());
        }
        return n2;
    }

    private void paintCopiedField(int n, int n2, int n3) {
        System.arraycopy(this.pixel_data, n + n2 * n3, this.pixel_data, n + (n2 + 1) * n3, n3);
    }

    private void paintPixelLine(int n, int n2, int n3, int n4, int n5) {
        n += this.object.getHorizontalPosition();
        n2 += this.object.getVerticalPosition();
        int n6 = 0;
        int n7 = this.IRD;
        n4 = this.mapColorIndex(n4, n5, this.IRD);
        if (this.clut.getModifyFlags() > 0 && (this.clut.getModifyFlags() & this.IRD) == 0) {
            n4 = this.mapColorIndex(n4, this.IRD, n5);
            n7 = n5;
        }
        n6 = n7 == 2 ? this.clut.getCLUT_2bit()[n4] : (n7 == 4 ? this.clut.getCLUT_4bit()[n4] : this.clut.getCLUT_8bit()[n4]);
        if ((0xFF000000 & (n6 = this.scaleRGB(n6))) == 0) {
            return;
        }
        if (n > this.region.getWidth() - 1 || n2 > this.region.getHeight() - 1) {
            this.region.setError(2);
            return;
        }
        this.from_index = n + n2 * this.region.getWidth();
        this.to_index = this.from_index + n3;
        if (n + n3 > this.region.getWidth()) {
            this.to_index = this.from_index + this.region.getWidth() - n;
            this.region.setError(1);
        }
        if (this.from_index < 0 || this.from_index > this.pixel_data.length || this.to_index < 0 || this.to_index > this.pixel_data.length) {
            this.region.setError(1);
            return;
        }
        Arrays.fill(this.pixel_data, this.from_index, this.to_index, n6);
    }

    private void paintRegionBackground() {
        if (!this.region.isActive() || !this.region.getFillFlag()) {
            return;
        }
        int n = this.IRD == 2 ? this.clut.getCLUT_2bit()[this.mapColorIndex(this.region.getPixelCode_2bit(), 2, this.IRD)] : (this.IRD == 4 ? this.clut.getCLUT_4bit()[this.mapColorIndex(this.region.getPixelCode_4bit(), 4, this.IRD)] : this.clut.getCLUT_8bit()[this.mapColorIndex(this.region.getPixelCode_8bit(), 8, this.IRD)]);
        n = this.scaleRGB(n);
        Arrays.fill(this.pixel_data, n);
    }

    private void paintRegionBorder(int n, int n2, int n3, int n4) {
        this.big.setColor(Color.white);
        this.big.drawRect(n - 1, n2 - 1, n3 + 2, n4 + 1);
        this.big.drawString("x" + n + ", y" + n2 + " / " + n3 + "*" + n4, n, n2 - 6);
    }

    private void paintStringObjects(int n, int n2, String string) {
        this.big.setColor(Color.cyan);
        this.big.drawString(string, n += this.object.getHorizontalPosition(), (n2 += this.object.getVerticalPosition()) + 26);
    }

    private void pixel_block() {
        int n = this.getBits(8);
        if (n == 16) {
            while (this.pixel_code_string_2bit() > 0) {
            }
            this.alignToByte();
        } else if (n == 17) {
            while (this.pixel_code_string_4bit() > 0) {
            }
            this.alignToByte();
        } else if (n == 18) {
            while (this.pixel_code_string_8bit() > 0) {
            }
        } else if (n == 32) {
            int n2 = 0;
            while (n2 < 4) {
                this.object.setMapTable_2to4bit(n2, this.getBits(4));
                ++n2;
            }
        } else if (n == 33) {
            int n3 = 0;
            while (n3 < 4) {
                this.object.setMapTable_2to8bit(n3, this.getBits(8));
                ++n3;
            }
        } else if (n == 34) {
            int n4 = 0;
            while (n4 < 16) {
                this.object.setMapTable_4to8bit(n4, this.getBits(8));
                ++n4;
            }
        } else if (n == 240) {
            if (this.object.getCopyTopFieldFlag()) {
                this.paintCopiedField(this.region.getX(0), this.region.getY() + 1, this.region.getWidth());
            }
            this.region.nextLine();
        }
    }

    private int pixel_code_string_2bit() {
        if (this.nextBits(2) != 0) {
            this.paintPixelLine(this.region.getX(1), this.region.getY(), 1, this.getBits(2), 2);
        } else {
            this.flushBits(2);
            if (this.getBits(1) == 1) {
                int n = this.getBits(3) + 3;
                this.paintPixelLine(this.region.getX(n), this.region.getY(), n, this.getBits(2), 2);
            } else {
                int n = this.getBits(1);
                if (n == 1) {
                    this.paintPixelLine(this.region.getX(1), this.region.getY(), 1, 0, 2);
                } else if (n == 0) {
                    int n2 = this.getBits(2);
                    if (n2 == 0) {
                        return 0;
                    }
                    if (n2 == 1) {
                        this.paintPixelLine(this.region.getX(2), this.region.getY(), 2, 0, 2);
                    } else if (n2 == 2) {
                        int n3 = this.getBits(4) + 12;
                        this.paintPixelLine(this.region.getX(n3), this.region.getY(), n3, this.getBits(2), 2);
                    } else if (n2 == 3) {
                        int n4 = this.getBits(8) + 29;
                        this.paintPixelLine(this.region.getX(n4), this.region.getY(), n4, this.getBits(2), 2);
                    }
                }
            }
        }
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int pixel_code_string_4bit() {
        if (this.nextBits(4) != 0) {
            this.paintPixelLine(this.region.getX(1), this.region.getY(), 1, this.getBits(4), 4);
            return 1;
        } else {
            this.flushBits(4);
            if (this.getBits(1) == 0) {
                if (this.nextBits(3) == 0) return this.getBits(3);
                int n = this.getBits(3) + 2;
                this.paintPixelLine(this.region.getX(n), this.region.getY(), n, 0, 4);
                return 1;
            } else if (this.getBits(1) == 0) {
                int n = this.getBits(2) + 4;
                this.paintPixelLine(this.region.getX(n), this.region.getY(), n, this.getBits(4), 4);
                return 1;
            } else {
                int n = this.getBits(2);
                if (n < 2) {
                    int n2 = n + 1;
                    this.paintPixelLine(this.region.getX(n2), this.region.getY(), n2, 0, 4);
                    return 1;
                } else if (n == 2) {
                    int n3 = this.getBits(4) + 9;
                    this.paintPixelLine(this.region.getX(n3), this.region.getY(), n3, this.getBits(4), 4);
                    return 1;
                } else {
                    if (n != 3) return 1;
                    int n4 = this.getBits(8) + 25;
                    this.paintPixelLine(this.region.getX(n4), this.region.getY(), n4, this.getBits(4), 4);
                }
            }
        }
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int pixel_code_string_8bit() {
        if (this.nextBits(8) != 0) {
            this.paintPixelLine(this.region.getX(1), this.region.getY(), 1, this.getBits(8), 8);
            return 1;
        } else {
            this.flushBits(8);
            if (this.getBits(1) == 0) {
                if (this.nextBits(7) == 0) return this.getBits(7);
                int n = this.getBits(7);
                this.paintPixelLine(this.region.getX(n), this.region.getY(), n, 0, 8);
                return 1;
            } else {
                int n = this.getBits(7);
                this.paintPixelLine(this.region.getX(n), this.region.getY(), n, this.getBits(8), 8);
            }
        }
        return 1;
    }

    private void prepare_output() {
        long l = 1L + (this.pts - this.page.getTimeIn()) / 1024L;
        if (this.page.getTimeOut() > 0 && l > (long)this.page.getTimeOut()) {
            l = this.page.getTimeOut();
        }
        if (this.page.getTimeOut() > 0 && this.pts == -1L) {
            l = this.page.getTimeOut() / 10;
        }
        if (this.page.getTimeOut() > 0 && Common.getCollection().getSettings().getBooleanProperty(Keys.KEY_SubtitlePanel_rebuildPictPTS)) {
            l = this.page.getTimeOut() / 10;
        }
        if (this.page.getWidth() <= 0 || this.page.getHeight() <= 0 || this.page.getWidth() > this.width || this.page.getHeight() > this.height) {
            Common.setMessage("!> Page ignored (VN): " + this.page.getVersionNumber() + "; (size error) " + this.page.getWidth() + " * " + this.page.getHeight());
            return;
        }
        int[] nArray = new int[this.page.getWidth() * this.page.getHeight()];
        int n = 0;
        while (n < this.page.getHeight()) {
            System.arraycopy(this.preview_pixel_data, this.page.getX() + (this.page.getY() + n) * this.width, nArray, n * this.page.getWidth(), this.page.getWidth());
            ++n;
        }
        if (this.page.getWriteStatus()) {
            BMP.savePixels(new Bitmap(this.page.getX(), this.page.getY(), this.page.getWidth(), this.page.getHeight(), nArray, this.IRD, this.page.getId(), this.region.getId(), 0, this.page.getTimeIn(), (int)l));
        }
        if (this.preview_visible) {
            this.bimg.setRGB(this.page.getX(), this.page.getY(), this.page.getWidth(), this.page.getHeight(), nArray, 0, this.page.getWidth());
        }
        this.paintRegionBorder(this.page.getX(), this.page.getY(), this.page.getWidth(), this.page.getHeight());
        this.picture_saved = true;
        this.addBigMessage("time: in " + this.page.getTimeIn() + " /len " + l + " /save " + this.save + " /prev " + this.preview_visible + "                               <<prepare.output>>");
    }

    private void region_composition() {
        int n = this.getBits(16) + this.BytePosition;
        this.region = this.epoch.setRegion(this.getBits(8));
        this.region.setVersionNumber(this.getBits(4));
        this.region.setFillFlag(this.getBits(1));
        this.flushBits(3);
        int n2 = this.region.getWidth();
        int n3 = this.region.getHeight();
        this.region.setWidth(this.getBits(16));
        this.region.setHeight(this.getBits(16));
        this.region.setLevelOfCompatibility(this.getBits(3));
        this.region.setDepth(this.getBits(3));
        this.flushBits(2);
        int n4 = this.getBits(8);
        this.clut = this.epoch.setCLUT(n4);
        this.region.setCLUT_id(n4);
        this.region.setPixelCode_8bit(this.getBits(8));
        this.region.setPixelCode_4bit(this.getBits(4));
        this.region.setPixelCode_2bit(this.getBits(2));
        this.pixel_data = !this.region.isActive() || !this.region.getFillFlag() ? (n2 == this.region.getWidth() && n3 == this.region.getHeight() ? this.region.getPixel() : this.region.initPixel()) : this.region.initPixel();
        if (this.pixel_data == null) {
            this.pixel_data = this.region.initPixel();
        }
        this.flushBits(2);
        this.paintRegionBackground();
        this.addBigMessage("regcomp: page " + this.page.getId() + " /reg " + this.region.getId() + " /rv " + this.region.getVersionNumber() + " /rw " + this.region.getWidth() + " /rh " + this.region.getHeight() + " /pxl " + this.pixel_data.length + " /lv " + this.region.getCompatibility() + " /clut " + this.clut.getId() + " /activ " + this.region.isActive() + " /fill " + this.region.getFillFlag());
        while (this.BytePosition < n) {
            this.object = this.epoch.setObject(this.getBits(16));
            this.object.setRegionId(this.region.getId());
            this.object.setType(this.getBits(2));
            this.object.setProvider(this.getBits(2));
            this.object.setHorizontalPosition(this.getBits(12));
            this.flushBits(4);
            this.object.setVerticalPosition(this.getBits(12));
            if (this.object.getType() == 1 || this.object.getType() == 2) {
                this.object.setForegroundCode(this.getBits(8));
                this.object.setBackgroundCode(this.getBits(8));
            }
            this.addBigMessage("addobj: reg " + this.region.getId() + " /obj " + Integer.toHexString(this.object.getId()).toUpperCase() + " /x " + this.object.getHorizontalPosition() + " /y " + this.object.getVerticalPosition());
        }
    }

    private void resetEpoch() {
        this.epoches.clear();
        this.epoch = this.setEpoch(this.epoch_id);
        this.preview_pixel_data = new int[this.width * this.height];
        this.picture_saved = false;
        this.save = false;
    }

    private int scaleRGB(int n) {
        if ((n & 0xFF000000) == 0) {
            return 96;
        }
        int n2 = 15 + (0xFF & n >>> 16);
        int n3 = 15 + (0xFF & n >>> 8);
        int n4 = 15 + (0xFF & n);
        n2 = n2 > 235 ? 235 : n2;
        n3 = n3 > 235 ? 235 : n3;
        n4 = n4 > 235 ? 235 : n4;
        int n5 = 0xFF & n >>> 24;
        return n5 << 24 | n2 << 16 | n3 << 8 | n4;
    }

    private Epoch setEpoch(int n) {
        String string = String.valueOf(n);
        if (!this.epoches.containsKey(string)) {
            class Net_sourceforge_dvb_projectx_subtitle_DVBSubpicture$1 {
                /* synthetic */ Net_sourceforge_dvb_projectx_subtitle_DVBSubpicture$1() {
                }
            }
            this.epoches.put(string, new Epoch(null, n));
        }
        return (Epoch)this.epoches.get(string);
    }

    public void setIRD(int n, Hashtable hashtable, boolean bl, String string) {
        this.IRD = n;
        if (!hashtable.isEmpty()) {
            this.IRD = Integer.parseInt(hashtable.get("model").toString().trim());
        }
        ColorAreas.initialise(this.IRD, bl, hashtable);
        if ((this.IRD & 1) == 1) {
            this.IRD = 8;
            this.user_table = null;
            this.user_table_enabled = false;
        } else {
            this.user_table = hashtable;
            this.user_table_enabled = this.user_table.isEmpty() ^ true;
        }
        this.biglog = bl;
        this.resetEpoch();
        this.fix_page_id = string.trim().length() != 0 ? Integer.parseInt(string.trim()) : -1;
        this.preview_visible = false;
    }

    private void setUserClut() {
        int n;
        int n2 = Integer.parseInt(this.user_table.get("model").toString().trim());
        int n3 = n2 > 2 ? (n2 > 4 ? 256 : 16) : (n = 4);
        if (this.getRegionDepth() < n2) {
            n = this.getRegionDepth();
        }
        int n4 = 0;
        while (n4 < n) {
            if (this.user_table.containsKey(String.valueOf(n4))) {
                this.addBigMessage("addUserClut: " + n4 + " /ARGB " + this.user_table.get(String.valueOf(n4)));
                this.clut.setClutEntry(this.mapColorIndex(n4, this.getRegionDepth(), n2), n2, (int)Long.parseLong(this.user_table.get(String.valueOf(n4)).toString().trim(), 16));
            }
            ++n4;
        }
    }

    private void stuffing() {
        int n = this.getBits(16);
        this.flushBits(n * 8);
    }

    class Epoch {
        private int id;
        private Hashtable pages = new Hashtable();
        private Hashtable cluts = new Hashtable();
        private Hashtable regions = new Hashtable();
        private Hashtable objects = new Hashtable();

        private Epoch() {
        }

        private Epoch(int n) {
            this.id = n;
        }

        /* synthetic */ Epoch(1 var2_2, int n) {
            this(n);
        }

        private void clearObjects() {
            this.objects.clear();
        }

        private void clearRegions() {
            Enumeration enumeration = this.regions.keys();
            while (enumeration.hasMoreElements()) {
                ((Region)this.regions.get(enumeration.nextElement().toString())).setActive(false);
            }
        }

        private int getId() {
            return this.id;
        }

        private Enumeration getRegions() {
            return this.regions.keys();
        }

        private Page newPage(int n) {
            String string = String.valueOf(n);
            this.pages.put(string, new Page(null, n));
            return (Page)this.pages.get(string);
        }

        private CLUT setCLUT(int n) {
            String string = String.valueOf(n);
            if (!this.cluts.containsKey(string)) {
                this.cluts.put(string, new CLUT(null, n));
            }
            return (CLUT)this.cluts.get(string);
        }

        private void setId(int n) {
            this.id = n;
        }

        private OBJECT setObject(int n) {
            String string = String.valueOf(n);
            if (!this.objects.containsKey(string)) {
                this.objects.put(string, new OBJECT(null, n));
            }
            return (OBJECT)this.objects.get(string);
        }

        private Page setPage(int n) {
            String string = String.valueOf(n);
            if (!this.pages.containsKey(string)) {
                this.pages.put(string, new Page(null, n));
            }
            return (Page)this.pages.get(string);
        }

        private Region setRegion(int n) {
            String string = String.valueOf(n);
            if (!this.regions.containsKey(string)) {
                this.regions.put(string, new Region(null, n));
            }
            return (Region)this.regions.get(string);
        }
    }

    class Page {
        private int id;
        private int version_number = -1;
        private long time_in = 0L;
        private int time_out = 0;
        private int state;
        private int minX = DVBSubpicture.access$0(DVBSubpicture.this);
        private int minY = DVBSubpicture.access$1(DVBSubpicture.this);
        private int maxX = 0;
        private int maxY = 0;
        private int[] pixel;
        private boolean write = false;

        private Page() {
        }

        private Page(int n) {
            this.id = n;
        }

        /* synthetic */ Page(1 var2_2, int n) {
            this(n);
        }

        private void addArea(int n, int n2, int n3, int n4) {
            int n5;
            int n6 = n + n3;
            int n7 = n2 + n4;
            int n8 = n < this.minX ? n : this.minX;
            int n9 = n2 < this.minY ? n2 : this.minY;
            int n10 = n6 > this.maxX ? n6 : this.maxX;
            int n11 = n5 = n7 > this.maxY ? n7 : this.maxY;
            if (n8 < 0 || n9 < 0 || n10 < 0 || n5 < 0 || n10 - n8 < 0 || n5 - n9 < 0) {
                Common.setMessage("!> decoding error: page area, page_id " + this.getId() + "[" + n8 + "," + n9 + "," + n10 + "," + n5 + "] (pts " + this.getTimeIn() + ")");
                return;
            }
            this.minX = n8;
            this.minY = n9;
            this.maxX = n10;
            this.maxY = n5;
        }

        private void clearArea() {
            this.minX = DVBSubpicture.this.width;
            this.minY = DVBSubpicture.this.height;
            this.maxY = 0;
            this.maxX = 0;
        }

        private int getHeight() {
            return this.maxY - this.minY;
        }

        private int getId() {
            return this.id;
        }

        private int[] getPixel() {
            return this.pixel;
        }

        private int getState() {
            return this.state;
        }

        private long getTimeIn() {
            return this.time_in;
        }

        private int getTimeOut() {
            return this.time_out;
        }

        private int getVersionNumber() {
            return this.version_number;
        }

        private int getWidth() {
            return this.maxX - this.minX;
        }

        private boolean getWriteStatus() {
            return this.write;
        }

        private int getX() {
            return this.minX;
        }

        private int getY() {
            return this.minY;
        }

        private int[] initPixel() {
            this.pixel = new int[DVBSubpicture.this.width * DVBSubpicture.this.height];
            return this.pixel;
        }

        private void setId(int n) {
            this.id = n;
        }

        private void setState(int n) {
            this.state = n;
        }

        private void setTimeIn(long l) {
            this.time_in = l;
        }

        private void setTimeOut(int n) {
            this.time_out = n;
        }

        private void setVersionNumber(int n) {
            this.version_number = n;
        }

        private void setWriteStatus(boolean bl) {
            this.write = bl;
        }
    }

    class Region {
        private int id;
        private int horizontal_address;
        private int vertical_address;
        private int version_number = -1;
        private boolean fill_flag;
        private boolean active = false;
        private boolean changed = false;
        private int r_width;
        private int r_height;
        private int x;
        private int y;
        private int level_of_compatibility;
        private int depth;
        private int CLUT_id;
        private int pixel_code_8bit;
        private int pixel_code_4bit;
        private int pixel_code_2bit;
        private int[] pixel;
        private int error = 0;

        private Region() {
        }

        private Region(int n) {
            this.id = n;
        }

        /* synthetic */ Region(1 var2_2, int n) {
            this(n);
        }

        private int getCLUT_id() {
            return this.CLUT_id;
        }

        private int getCompatibility() {
            return this.level_of_compatibility;
        }

        private int getDepth() {
            return this.depth;
        }

        private int getErrors() {
            return this.error;
        }

        private boolean getFillFlag() {
            return this.fill_flag;
        }

        private int getHeight() {
            return this.r_height;
        }

        private int getId() {
            return this.id;
        }

        private int[] getPixel() {
            return this.pixel;
        }

        private int getPixelCode_2bit() {
            return this.pixel_code_2bit;
        }

        private int getPixelCode_4bit() {
            return this.pixel_code_4bit;
        }

        private int getPixelCode_8bit() {
            return this.pixel_code_8bit;
        }

        private int getVersionNumber() {
            return this.version_number;
        }

        private int getWidth() {
            return this.r_width;
        }

        private int getX(int n) {
            int n2 = this.x;
            this.x += n;
            return n2;
        }

        private int getXBound() {
            return this.horizontal_address;
        }

        private int getY() {
            return this.y;
        }

        private int getYBound() {
            return this.vertical_address;
        }

        private int[] initPixel() {
            this.pixel = new int[this.r_width * this.r_height];
            return this.pixel;
        }

        private boolean isActive() {
            return this.active;
        }

        private boolean isChanged() {
            return this.changed;
        }

        private void nextField() {
            this.x = 0;
            this.y = 1;
        }

        private void nextLine() {
            this.x = 0;
            this.y += 2;
        }

        private void resetXY() {
            this.x = 0;
            this.y = 0;
        }

        private void setActive(boolean bl) {
            this.active = bl;
        }

        private void setCLUT_id(int n) {
            this.CLUT_id = n;
        }

        private void setChanged(boolean bl) {
            this.changed = bl;
        }

        private void setDepth(int n) {
            this.depth = 1 << n;
        }

        private void setError(int n) {
            this.error |= n;
            if (n == 0) {
                this.error = 0;
            }
        }

        private void setFillFlag(int n) {
            this.fill_flag = n != 0;
        }

        private void setHeight(int n) {
            this.r_height = n;
        }

        private void setHorizontalAddress(int n) {
            this.horizontal_address = n;
            this.x = 0;
        }

        private void setId(int n) {
            this.id = n;
        }

        private void setLevelOfCompatibility(int n) {
            this.level_of_compatibility = n;
        }

        private void setPixelCode_2bit(int n) {
            this.pixel_code_2bit = n;
        }

        private void setPixelCode_4bit(int n) {
            this.pixel_code_4bit = n;
        }

        private void setPixelCode_8bit(int n) {
            this.pixel_code_8bit = n;
        }

        private void setVersionNumber(int n) {
            this.version_number = n;
        }

        private void setVerticalAddress(int n) {
            this.vertical_address = n;
            this.y = 0;
        }

        private void setWidth(int n) {
            this.r_width = n;
        }
    }

    class CLUT {
        private int id;
        private int version_number = -1;
        private int modify_flags = 0;
        private final int[] default_CLUT_2bit;
        private final int[] default_CLUT_4bit;
        private final int[] default_CLUT_8bit;
        private int[] CLUT_2bit;
        private int[] CLUT_4bit;
        private int[] CLUT_8bit;

        private CLUT() {
            int[] nArray = new int[4];
            nArray[1] = -1;
            nArray[2] = -16777216;
            nArray[3] = -8355712;
            this.default_CLUT_2bit = nArray;
            int[] nArray2 = new int[16];
            nArray2[1] = -65536;
            nArray2[2] = -16711936;
            nArray2[3] = -256;
            nArray2[4] = -16776961;
            nArray2[5] = -65281;
            nArray2[6] = -16711681;
            nArray2[7] = -1;
            nArray2[8] = -16777216;
            nArray2[9] = -8388608;
            nArray2[10] = -16744448;
            nArray2[11] = -8355840;
            nArray2[12] = -16777088;
            nArray2[13] = -8388480;
            nArray2[14] = -16744320;
            nArray2[15] = -8355712;
            this.default_CLUT_4bit = nArray2;
            this.default_CLUT_8bit = DVBSubpicture.this.table_CLUT_8bit;
            this.init(0);
        }

        private CLUT(int n) {
            int[] nArray = new int[4];
            nArray[1] = -1;
            nArray[2] = -16777216;
            nArray[3] = -8355712;
            this.default_CLUT_2bit = nArray;
            int[] nArray2 = new int[16];
            nArray2[1] = -65536;
            nArray2[2] = -16711936;
            nArray2[3] = -256;
            nArray2[4] = -16776961;
            nArray2[5] = -65281;
            nArray2[6] = -16711681;
            nArray2[7] = -1;
            nArray2[8] = -16777216;
            nArray2[9] = -8388608;
            nArray2[10] = -16744448;
            nArray2[11] = -8355840;
            nArray2[12] = -16777088;
            nArray2[13] = -8388480;
            nArray2[14] = -16744320;
            nArray2[15] = -8355712;
            this.default_CLUT_4bit = nArray2;
            this.default_CLUT_8bit = DVBSubpicture.this.table_CLUT_8bit;
            this.init(n);
        }

        /* synthetic */ CLUT(1 var2_2, int n) {
            this(n);
        }

        static /* synthetic */ void access$1(CLUT cLUT, int n) {
            cLUT.setVersionNumber(n);
        }

        static /* synthetic */ int access$2(CLUT cLUT) {
            return cLUT.getVersionNumber();
        }

        private int[] getCLUT_2bit() {
            return this.CLUT_2bit;
        }

        private int[] getCLUT_4bit() {
            return this.CLUT_4bit;
        }

        private int[] getCLUT_8bit() {
            return this.CLUT_8bit;
        }

        private int getId() {
            return this.id;
        }

        private int getModifyFlags() {
            return this.modify_flags;
        }

        private int getVersionNumber() {
            return this.version_number;
        }

        private void init(int n) {
            this.id = n;
            this.CLUT_2bit = this.default_CLUT_2bit;
            this.CLUT_4bit = this.default_CLUT_4bit;
            this.CLUT_8bit = this.default_CLUT_8bit;
        }

        private void setClutEntry(int n, int n2, int n3) {
            if ((n2 & 8) != 0) {
                this.CLUT_8bit[n] = n3;
            } else if ((n2 & 4) != 0) {
                this.CLUT_4bit[n] = n3;
            } else if ((n2 & 2) != 0) {
                this.CLUT_2bit[n] = n3;
            }
            this.modify_flags |= n2;
        }

        private void setId(int n) {
            this.id = n;
        }

        private void setVersionNumber(int n) {
            this.version_number = n;
        }
    }

    class OBJECT {
        private int id;
        private int version_number = -1;
        private int type;
        private int region_id = -1;
        private int provider_flag;
        private int horizontal_position;
        private int vertical_position;
        private int foreground_pixel_code;
        private int background_pixel_code;
        private boolean non_modifying_color_flag;
        private boolean copy_top_field_flag;
        private final int[] default_map_table_2to4bit;
        private final int[] default_map_table_2to8bit;
        private final int[] default_map_table_4to8bit;
        private int[] map_table_2to4bit;
        private int[] map_table_2to8bit;
        private int[] map_table_4to8bit;
        private Hashtable regions;

        private OBJECT() {
            int[] nArray = new int[4];
            nArray[1] = 7;
            nArray[2] = 8;
            nArray[3] = 15;
            this.default_map_table_2to4bit = nArray;
            int[] nArray2 = new int[4];
            nArray2[1] = 119;
            nArray2[2] = 136;
            nArray2[3] = 255;
            this.default_map_table_2to8bit = nArray2;
            int[] nArray3 = new int[16];
            nArray3[1] = 17;
            nArray3[2] = 34;
            nArray3[3] = 51;
            nArray3[4] = 68;
            nArray3[5] = 85;
            nArray3[6] = 102;
            nArray3[7] = 119;
            nArray3[8] = 136;
            nArray3[9] = 153;
            nArray3[10] = 170;
            nArray3[11] = 187;
            nArray3[12] = 204;
            nArray3[13] = 221;
            nArray3[14] = 238;
            nArray3[15] = 255;
            this.default_map_table_4to8bit = nArray3;
            this.regions = new Hashtable();
            this.init();
        }

        private OBJECT(int n) {
            int[] nArray = new int[4];
            nArray[1] = 7;
            nArray[2] = 8;
            nArray[3] = 15;
            this.default_map_table_2to4bit = nArray;
            int[] nArray2 = new int[4];
            nArray2[1] = 119;
            nArray2[2] = 136;
            nArray2[3] = 255;
            this.default_map_table_2to8bit = nArray2;
            int[] nArray3 = new int[16];
            nArray3[1] = 17;
            nArray3[2] = 34;
            nArray3[3] = 51;
            nArray3[4] = 68;
            nArray3[5] = 85;
            nArray3[6] = 102;
            nArray3[7] = 119;
            nArray3[8] = 136;
            nArray3[9] = 153;
            nArray3[10] = 170;
            nArray3[11] = 187;
            nArray3[12] = 204;
            nArray3[13] = 221;
            nArray3[14] = 238;
            nArray3[15] = 255;
            this.default_map_table_4to8bit = nArray3;
            this.regions = new Hashtable();
            this.id = n;
            this.init();
        }

        /* synthetic */ OBJECT(1 var2_2, int n) {
            this(n);
        }

        private boolean getCopyTopFieldFlag() {
            return this.copy_top_field_flag;
        }

        private int getHorizontalPosition() {
            return this.horizontal_position;
        }

        private int getId() {
            return this.id;
        }

        private int[] getMapTable_2to4bit() {
            return this.map_table_2to4bit;
        }

        private int[] getMapTable_2to8bit() {
            return this.map_table_2to8bit;
        }

        private int[] getMapTable_4to8bit() {
            return this.map_table_4to8bit;
        }

        private int getRegionId() {
            return this.region_id;
        }

        private int getType() {
            return this.type;
        }

        private int getVersionNumber() {
            return this.version_number;
        }

        private int getVerticalPosition() {
            return this.vertical_position;
        }

        private void init() {
            this.map_table_2to4bit = this.default_map_table_2to4bit;
            this.map_table_2to8bit = this.default_map_table_2to8bit;
            this.map_table_4to8bit = this.default_map_table_4to8bit;
        }

        private void resetRegionId() {
            this.region_id = -1;
        }

        private void setBackgroundCode(int n) {
            this.background_pixel_code = n;
        }

        private void setCopyTopFieldFlag(int n) {
            this.copy_top_field_flag = n == 0;
        }

        private void setForegroundCode(int n) {
            this.foreground_pixel_code = n;
        }

        private void setHorizontalPosition(int n) {
            this.horizontal_position = n;
        }

        private void setId(int n) {
            this.id = n;
        }

        private void setMapTable_2to4bit(int n, int n2) {
            this.map_table_2to4bit[n] = n2;
        }

        private void setMapTable_2to8bit(int n, int n2) {
            this.map_table_2to8bit[n] = n2;
        }

        private void setMapTable_4to8bit(int n, int n2) {
            this.map_table_4to8bit[n] = n2;
        }

        private void setNonModify(int n) {
            this.non_modifying_color_flag = n != 0;
        }

        private void setProvider(int n) {
            this.provider_flag = n;
        }

        private void setRegionId(int n) {
            this.region_id = n;
        }

        private void setType(int n) {
            this.type = n;
        }

        private void setVersionNumber(int n) {
            this.version_number = n;
        }

        private void setVerticalPosition(int n) {
            this.vertical_position = n;
        }
    }
}

