/******************************************************************************
 *                                                                          
 * This software module was originally developed by 
 *
 * Noel O'Connor (TELTEC IRELAND / ACTS-MoMuSys).                   	
 *
 * and edited by 
 *
 * Robert Danielsen (Telenor / ACTS-MoMuSys). 	    	              	
 * Bruno Loret (CNET / ACTS-MoMuSys).
 * Bob Eifrig (NextLevel Systems)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4 
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free 
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original 
 * developer of this software module and his/her company, the subsequent 
 * editors and their companies, and ISO/IEC have no liability for use of this 
 * software module or modifications thereof in an implementation. Copyright is 
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) standard conforming 
 * products. 
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own 
 * purpose, assign or donate the code to a third party and to inhibit third 
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works. 
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/


/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	vm_stats.h
 *
 * Author:	Noel O'Connor
 * Created:	19-Feb-96 
 *                                                                         
 * Description: 
 *
 * Notes: 	
 *
 * Modified:	21.04.96 Robert Danielsen: New header.
 *              23.04.96 Bruno Loret: Non reentrant ifndef
 *              11.12.97 Bob Eifrig:  Added text_bits
 *
 ***********************************************************HeaderEnd*********/


#ifndef _VM_STATS_H_
#define _VM_STATS_H_


#include "momusys.h"
#include "text_bits.h"

#define STATS_FILE 1
#define DISPLAY 0

struct bit_count {
  Char		stats_file[100];
	Int			sep_mot_shape_text;
	UInt		vol;
	UInt		time;
	UInt		vop;
	UInt		syntax;
	UInt		shape;
	UInt		texture;
	UInt		sprite_piece;
	UInt		motion;
	UInt		mot_shape_text;
	Float		psnr_y;
	Float		psnr_u;
	Float		psnr_v;
	Float		psnr_y_ave;
	Float		psnr_u_ave;
	Float		psnr_v_ave;
	Float		average;
    Float       average_shape; 
	Int			occurrence;
    Bits        text_bits;
};

#ifdef NLSSTATS
FILE *fpstats_file;
#endif

typedef struct bit_count BitCount;

#include "vm_stats.p"


#endif /* _VM_STATS_H_ */
