/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Noel Brady (TELTEC IRELAND / ACTS-MoMuSys)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/

#ifndef __AR_DECODE_H
#define __AR_DECODE_H

#include "momusys.h"
#include "mom_bitstream_d.h"

/* HALF AND QUARTER POINTS IN THE CODE VALUE RANGE */

#define CODE_BITS 32
#define	HALF ((U_Int) 1 << (CODE_BITS-1))
#define QUARTER (1 << (CODE_BITS-2))
#define 	MAX_BITS_OUTSTANDING	256


#define MAXHEADING 8
#define MAXMIDDLE 16
#define MAXTRAILING 8

#define MAXHEADING_ER 3
#define MAXMIDDLE_ER 10
#define MAXTRAILING_ER 2

struct arcodec {
  UInt L; /* lower bound */
  UInt R; /* code range */
  UInt V; /* current code value */
  UInt arpipe;
  Int bits_to_follow; /* follow bit count */
  Int first_bit;
  Int nzeros;
  Int nonzero;
  Int nzerosf;
  Int extrabits;
	Int mh;
	Int mm;
	Int mt;
};

typedef struct arcodec ArCoder;	
typedef struct arcodec ArDecoder;

#include "bin_ar_decode.p"
#endif
