/* $Id: read_image.c,v 1.5 1998/03/18 19:18:30 hatrack Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was developed by                                         */
/*   Sarnoff Coporation                   and    Texas Instruments          */
/*   Iraj Sodagar   (iraj@sarnoff.com)           Jie Liang (liang@ti.com)   */
/*   Hung-Ju Lee    (hjlee@sarnoff.com)                                     */
/*   Paul Hatrack   (hatrack@sarnoff.com)                                   */
/*   Shipeng Li     (shipeng@sarnoff.com)                                   */
/*   Bing-Bing Chai (bchai@sarnoff.com)                                     */
/*                                                                          */
/* In the course of development of the MPEG-4 standard. This software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG memebers to use, copy, modify,             */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright (C) 1998  Sarnoff Coporation and Texas Instruments             */ 
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "dataStruct.h"
#include "errorHandler.h"
#include "read_image.h"

/*--------------------------------------------------------------------
  read_image()
  
  Return Values
  -------------
  None.
  
  Comments
  --------
  Exits program if error occurs.
  --------------------------------------------------------------------*/

Void read_image(Char *img_path, Int img_width, Int img_height, 
		Int img_colors, Int img_bit_depth,
		PICTURE *img)
{
  File *infptr = NULL;
  Int  img_size;
   /* chroma  width and height  to handle odd image size */
  Int img_cwidth  = (img_width+1)/2, 
      img_cheight = (img_height+1)/2; 
  Int wordsize = (img_bit_depth>8)?2:1;
  UChar *srcimg; /* SL: to handle 1-16 bit */
  Int  i,k,status;
  
  if (img_colors==MONO) { /*SL: image size for mono */
     img_size = img_width*img_height; /* bit_depth>8 occupies 2 bytes */
  }
  else { /* only for 420 color for now */
    img_size = img_width*img_height+2*img_cwidth*img_cheight; 
  }
  
  if ((srcimg = (UChar *)malloc(sizeof(UChar)*
					img_size*wordsize)) == NULL) 
    errorHandler("Couldn't allocate memory to image\n");

  if ((infptr = fopen(img_path,"rb")) == NULL) 
    errorHandler("Unable to open image_file: %s\n",img_path);

  /* Read image */
  if ((status=fread(srcimg, sizeof(UChar)*wordsize, img_size, infptr))
       != img_size)
    errorHandler("Error in reading image file: %s\n",img_path);

  fclose(infptr);
  
  /* put Into VM structure */
  img[0].width  = img_width;
  img[0].height = img_height;
  if(img_colors != MONO) { /* SL: only for color image */
    img[1].width  = img_cwidth; /* to handle odd image size */
    img[1].height = img_cheight;
    img[2].width  = img_cwidth;
    img[2].height = img_cheight;
  }
  if ((img[0].data=(Void *)
       malloc(sizeof(UChar)*img_width*img_height*wordsize)) == NULL)
    errorHandler("Couldn't allocate memory to image->Y->data\n");
  img[0].mask = NULL;
  if (img_colors != MONO) { /* SL: only for color image */
    if ((img[1].data = (Void *)
	 malloc(sizeof(UChar)*img_cwidth*img_cheight*wordsize))==NULL) 
      errorHandler("Couldn't allocate memory to image->U->data\n");
    img[1].mask = NULL;
    if ((img[2].data = (Void *)
	 malloc(sizeof(UChar)*img_cwidth*img_cheight*wordsize))==NULL)
      errorHandler("Couldn't allocate memory to image->V->data\n");
    img[2].mask = NULL;
  }


  k=0;
  for (i=0; i<img_width*img_height*wordsize; i++) { 
    if (img_bit_depth > 8){ /* mask the input */
      if (i%2==0)
        ((UChar *)img[0].data)[i] =
	      (UChar) (srcimg[k++]&((1<<(img_bit_depth-8))-1));
      else
        ((UChar *)img[0].data)[i] = srcimg[k++];
    }
    else {
      ((UChar *)img[0].data)[i] = 
	(UChar) (srcimg[k++]&((1<<img_bit_depth)-1));
    }
  }
  if (img_colors != MONO) { /* SL: only for color image */
    for (i=0; i<img_cwidth*img_cheight*wordsize; i++) {
      if (img_bit_depth > 8) { /* mask the input */
        if (i%2==0) 
           ((UChar *)img[1].data)[i] = 
	     (UChar) (srcimg[k++]&((1<<(img_bit_depth-8))-1));
        else
           ((UChar *)img[1].data)[i] = srcimg[k++];
      }
      else {
        ((UChar *)img[1].data)[i] = 
	  (UChar) (srcimg[k++]&((1<<img_bit_depth)-1));
      }
    }
    for (i=0; i<img_cwidth*img_cheight*wordsize; i++){
      if (img_bit_depth > 8) { /* mask the input */
        if (i%2==0) 
           ((UChar *)img[2].data)[i] = 
	     (UChar) (srcimg[k++]&((1<<(img_bit_depth-8))-1));
        else
          ((UChar *)img[2].data)[i] = srcimg[k++];
      }
      else {
        ((UChar *)img[2].data)[i] = 
	  (UChar) (srcimg[k++]&((1<<img_bit_depth)-1));
      }
    }
  }
  if (srcimg) free(srcimg);

}
