/* $Id: Utils.c,v 1.16 1998/03/18 16:34:20 hatrack Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was developed by                                         */
/*   Sarnoff Coporation                   and    Texas Instruments          */
/*   Iraj Sodagar   (iraj@sarnoff.com)           Jie Liang (liang@ti.com)   */
/*   Hung-Ju Lee    (hjlee@sarnoff.com)                                     */
/*   Paul Hatrack   (hatrack@sarnoff.com)                                   */
/*   Shipeng Li     (shipeng@sarnoff.com)                                   */
/*   Bing-Bing Chai (bchai@sarnoff.com)                                     */
/*                                                                          */
/* In the course of development of the MPEG-4 standard. This software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG memebers to use, copy, modify,             */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright (C) 1998  Sarnoff Coporation and Texas Instruments             */ 
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

#include <stdio.h>
#include "dataStruct.h"
#include "globals.h"
#include "Utils.h"

Void setSpatialLevelAndDimensions(Int spLayer, Int c)
{
  mzte_codec.curSpatialLev = spLayer;
  mzte_codec.SPlayer[c].height = 
    (mzte_codec.height >> (c>0)) 
      >> (mzte_codec.spatial_scalability_levels-1-mzte_codec.curSpatialLev);
  mzte_codec.SPlayer[c].width =
    (mzte_codec.width>> (c>0)) 
      >> (mzte_codec.spatial_scalability_levels-1-mzte_codec.curSpatialLev);
}

Void updateResidMaxAndAssignSkips(Int c)
{
  Int rLev;
  Int i;
  Int x, y, spX, spY, spHeight, spWidth;

  RESID_MAX(c)=0;

  for (i = 0; i <= mzte_codec.curSpatialLev; ++i)
  {
    prevQList2[c][i] = prevQList[c][i];

    if (prevQList[c][i] == 0)
      prevQList[c][i] = USER_Q(c);

    rLev=quantRefLev(USER_Q(c), prevQList[c]+i, scaleLev[c][i]++)-1;

    if (rLev > RESID_MAX(c))
      RESID_MAX(c) = rLev;

    /*--- Set skip mode all coefficients in spatial level ---*/
    if (i < mzte_codec.curSpatialLev)
    {
      /* Get spatial level dimensions of i^{th} spatial layer */
      spHeight = 
	(mzte_codec.height >> (c>0)) 
			   >> (mzte_codec.spatial_scalability_levels-1-i);
      
      spWidth =
	(mzte_codec.width  >> (c>0)) 
			   >> (mzte_codec.spatial_scalability_levels-1-i);

      if (i==0)
      {
	spY = mzte_codec.dcHeight;
	spX = mzte_codec.dcWidth;
      }
      else
      {
	spY = spHeight >> 1;
	spX = spWidth >> 1;
      }

      /* HL */
      for (y = 0; y < spY; ++y)
	for (x = spX; x < spWidth; ++x)
	{
	  if (rLev > 0)
	    COEFF_SKIP(x,y,c) = 0;
	  else if (COEFF_SKIP(x,y,c)==0)	    
	    COEFF_SKIP(x,y,c)=SKIP_TNYC;
	}
      
      /* LH */
      for (y = spY; y < spHeight; ++y)
	for (x = 0; x < spX; ++x)
	{
	  if (rLev > 0)
	    COEFF_SKIP(x,y,c) = 0;
	  else if (COEFF_SKIP(x,y,c)==0)	    
	    COEFF_SKIP(x,y,c)=SKIP_TNYC;
	}
      
      /* HH */
      for (y = spY; y < spHeight; ++y)
	for (x = spX; x < spWidth; ++x)
	{
	  if (rLev > 0)
	    COEFF_SKIP(x,y,c) = 0;
	  else if (COEFF_SKIP(x,y,c)==0)	    
	    COEFF_SKIP(x,y,c)=SKIP_TNYC;
	}
    } 
  }
}


#ifdef _WRITE_COEFF_MAP_
/* 
   Function Name
   -------------
   Void dumpACMap(Char *fn, Int c)

   Arguments 
   ---------
   Char *fn - Name of file to dump the map to.
   Int c - Color component to dump.

   Description
   -----------
   dumpACMap will append the current value, state, and type of all coefficients
   in all AC bands to the file pointed to by 'fn'. It will overwrite any
   existing file.

   Functions Called
   ----------------
   none.

   Return Value
   ------------
   none.

   Source File
   -----------
   Utils.c
*/

Void dumpACMap(Char *fn, Int c)
{
  File *fp;
  Int x,y;
  Int err;
  Char fname[256];

  /* dump map of coeffinfo */
  if (fn == NULL)
    noteProgress("Note: No QM map written (disabled).");
  else
  {
    /* form file name suffix */
    sprintf(fname, "%sAC.%02d.%02d.%d", fn, mzte_codec.curSpatialLev, 
	    mzte_codec.curSNRLev, mzte_codec.curColor);
    fn = fname;

    if ((fp = fopen(fn,"w")) == NULL)
    {
      noteError("Can't open map file '%s' for writing in QM", fn);
      err = ERR_QM_MAP_WRITE;
    }
    else
    {	
      noteProgress("Writing QM map to '%s'....", fn);
     
      /* Write 'header' info */
      fprintf(fp, "\n----- AC Band: Spatial Layer %3d, SNR Layer %3d, "\
	      "Color %3d -----\n\n", 
	      mzte_codec.curSpatialLev, mzte_codec.curSNRLev, 
	      mzte_codec.curColor);
      fprintf(fp, "Width = %5d, Height = %5d\n\n", 
	      mzte_codec.SPlayer[c].width, mzte_codec.SPlayer[c].height);

      /* Write coeffinfo */
      for (y = 0; y < mzte_codec.SPlayer[c].height; ++y)
	for (x = 0; x < mzte_codec.SPlayer[c].width; ++x)
	  if (x >= mzte_codec.dcWidth || y >=  mzte_codec.dcHeight)
	    fprintf(fp,"%5d, %5d: %6d %11s %11s  %s\n",
		    x, y, COEFF_VAL(x,y,c),
		    mapStateToText[COEFF_STATE(x, y, c)],
		    mapTypeToText[COEFF_TYPE(x, y, c)],
		    COEFF_SKIP(x,y,c) ? "Skipped" : "");

      fclose(fp);
      noteProgress("Writing of QM map finished.");
    }
  }
}


/* 
   Function Name
   -------------
   Void dumpDCMap(Char *fn, Int c)

   Arguments 
   ---------
   Char *fn - Name of file to dump the map to.
   Int c - Color component to dump.

   Description
   -----------
   dumpDCMap will write the current value, state, and type of all coefficients
   in the DC band to the file pointed to by 'fn'. It will overwrite any
   existing file.

   Functions Called
   ----------------
   none.

   Return Value
   ------------
   none.

   Source File
   -----------
   Utils.c
*/

Void dumpDCMap(Char *fn, Int c)
{
  File *fp;
  Int x,y;
  Int err;
  Char fname[256];

  /* dump map of coeffinfo */
  if (fn == NULL)
    noteProgress("Note: No QM map written (disabled).");
  else
  {
    /* form file name suffix */
    sprintf(fname, "%sDC.%d", fn, mzte_codec.curColor);
    fn = fname;

    if ((fp = fopen(fn,"w")) == NULL)
    {
      noteError("Can't open map file '%s' for writing in QM", fn);
      err = ERR_QM_MAP_WRITE;
    }
    else
    {	
      noteProgress("Writing QM map to '%s'....", fn);
     
      /* Write 'header' info */
      fprintf(fp, 
	      "\n----- DC Band: Color %3d -----\n\n", mzte_codec.curColor);
      fprintf(fp, "Width = %5d, Height = %5d\n\n", 
	      mzte_codec.dcWidth,mzte_codec.dcHeight);

      /* Write coeffinfo */
      for (y = 0; y < mzte_codec.dcHeight; ++y)
	for (x = 0; x < mzte_codec.dcWidth; ++x)
	  fprintf(fp,"%5d, %5d: %6d %11s %11s\n",
		  x, y, COEFF_VAL(x,y,c),
		  mapStateToText[COEFF_STATE(x, y,c)],
		  mapTypeToText[COEFF_TYPE(x, y,c)]);

      fclose(fp);
      noteProgress("Writing of QM map finished.");
    }
  }
}

#endif /*_WRITE_COEFF_MAP_*/

#ifdef _WRITE_ORV_MAP_

Void dumpACORVMap(Char *fn, Int c, Int rec)
{
  File *fp;
  Int x,y;
  Int err;
  Char fname[256];

  /* dump map of coeffinfo */
  if (fn == NULL)
    noteProgress("Note: No ORV map written (disabled).");
  else
  {
    /* form file name suffix */
    sprintf(fname, "%sAC.ORV.%02d.%02d.%d", fn, mzte_codec.curSpatialLev, 
	    mzte_codec.curSNRLev, mzte_codec.curColor);
    fn = fname;

    if ((fp = fopen(fn,"w")) == NULL)
    {
      noteError("Can't open map file '%s' for writing.", fn);
      err = ERR_QM_MAP_WRITE;
    }
    else
    {	
      noteProgress("Writing ORV map to '%s'....", fn);
     
      /* Write 'header' info */
      fprintf(fp, 
	      "\n----- AC Band: Spatial Layer %3d, SNR Layer %3d, Color %3d \
-----\n\n", 
	      mzte_codec.curSpatialLev, mzte_codec.curSNRLev, 
	      mzte_codec.curColor);
      fprintf(fp, "Width = %5d, Height = %5d\n\n", 
	      mzte_codec.SPlayer[c].width, mzte_codec.SPlayer[c].height);

      /* Write coeffinfo */
      for (y = 0; y < mzte_codec.SPlayer[c].height; ++y)
	for (x = 0; x < mzte_codec.SPlayer[c].width; ++x)
	  if (x >= mzte_codec.dcWidth || y >=  mzte_codec.dcHeight)
	    fprintf(fp,"%5d, %5d: %6d\n",
		    x, y, rec ? COEFF_RECVAL(x,y,c) : COEFF_ORGVAL(x,y,c));

      fclose(fp);
      noteProgress("Writing of ORV map finished.");
    }
  }
}



Void dumpDCORVMap(Char *fn, Int c, Int rec)
{
  File *fp;
  Int x,y;
  Int err;
  Char fname[256];

  /* dump map of coeffinfo */
  if (fn == NULL)
    noteProgress("Note: No ORV map written (disabled).");
  else
  {
    /* form file name suffix */
    sprintf(fname, "%s.ORV.DC.%d", fn, mzte_codec.curColor);
    fn = fname;

    if ((fp = fopen(fn,"w")) == NULL)
    {
      noteError("Can't open ORV map file '%s' for writing.", fn);
      err = ERR_QM_MAP_WRITE;
    }
    else
    {	
      noteProgress("Writing ORV map to '%s'....", fn);
     
      /* Write 'header' info */
      fprintf(fp, 
	      "\n----- DC Band: Color %3d -----\n\n", mzte_codec.curColor);
      fprintf(fp, "Width = %5d, Height = %5d\n\n", 
	      mzte_codec.dcWidth,mzte_codec.dcHeight);

      /* Write coeffinfo */
      for (y = 0; y < mzte_codec.dcHeight; ++y)
	for (x = 0; x < mzte_codec.dcWidth; ++x)
	  fprintf(fp,"%5d, %5d: %6d\n",
		  x, y, rec ? COEFF_RECVAL(x,y,c) : COEFF_ORGVAL(x,y,c));

      fclose(fp);
      noteProgress("Writing of ORV map finished.");
    }
  }
}

#endif /*_WRITE_ORV_MAP_*/
