/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Michael Wollborn (TUH / ACTS-MoMuSyS)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *
 * File:        text_quant_mat_def.h
 *
 * Author:      Michael Wollborn, TUH
 * Created:     April 23, 1997
 *
 * Description:
 *
 *	The file contains the default quantization matrices for 
 *	MPEG-like quantization
 *
 * Notes:
 *
 * Modified: 04.09.1997 Minhua Zhou:  changed default matrices to non-flat
 *
 ***********************************************************HeaderEnd*********/


#ifndef _TEXT_QUANT_MAT_DEF_H_ 
#define _TEXT_QUANT_MAT_DEF_H_


/* Default quantization matrices (non-flat) */

/* INTRA */
static Int mpeg_iqmat_def[64]  =
					{  8,17,18,19,21,23,25,27,
                                          17,18,19,21,23,25,27,28,
                                          20,21,22,23,24,26,28,30,
                                          21,22,23,24,26,28,30,32,
                                          22,23,24,26,28,30,32,35,
                                          23,24,26,28,30,32,35,38,
                                          25,26,28,30,32,35,38,41,
                                          27,28,30,32,35,38,41,45 };

/* INTER */
static Int mpeg_nqmat_def[64]  =
					{ 16,17,18,19,20,21,22,23,
                                          17,18,19,20,21,22,23,24,
                                          18,19,20,21,22,23,24,25,
                                          19,20,21,22,23,24,26,27,
                                          20,21,22,23,25,26,27,28,
                                          21,22,23,24,26,27,28,30,
                                          22,23,24,26,27,28,30,31,
                                          23,24,25,27,28,30,31,33 };

/* GRAY INTRA */
static Int mpeg_giqmat_def[64]  =	{  8,17,18,19,21,23,25,27,
                                          17,18,19,21,23,25,27,28,
                                          20,21,22,23,24,26,28,30,
                                          21,22,23,24,26,28,30,32,
                                          22,23,24,26,28,30,32,35,
                                          23,24,26,28,30,32,35,38,
                                          25,26,28,30,32,35,38,41,
                                          27,28,30,32,35,38,41,45 };
/* GRAY INTER */
static Int mpeg_gnqmat_def[64]  =    	{ 16,17,18,19,20,21,22,23,
                                          17,18,19,20,21,22,23,24,
                                          18,19,20,21,22,23,24,25,
                                          19,20,21,22,23,24,26,27,
                                          20,21,22,23,25,26,27,28,
                                          21,22,23,24,26,27,28,30,
                                          22,23,24,26,27,28,30,31,
                                          23,24,25,27,28,30,31,33 };


#endif /* _TEXT_QUANT_MAT_DEF_H_ */
