/* $Id: ac.h,v 1.8 1998/03/16 16:51:35 hatrack Exp $ */

/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was developed by                                         */
/*   Sarnoff Coporation                   and    Texas Instruments          */
/*   Iraj Sodagar   (iraj@sarnoff.com)           Jie Liang (liang@ti.com)   */
/*   Hung-Ju Lee    (hjlee@sarnoff.com)                                     */
/*   Paul Hatrack   (hatrack@sarnoff.com)                                   */
/*   Shipeng Li     (shipeng@sarnoff.com)                                   */
/*   Bing-Bing Chai (bchai@sarnoff.com)                                     */
/*                                                                          */
/* In the course of development of the MPEG-4 standard. This software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG memebers to use, copy, modify,             */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright (C) 1998  Sarnoff Coporation and Texas Instruments             */ 
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

/************************************************************/
/*  Filename: ac.h                                          */
/*                                                          */
/*  Descriptions:                                           */
/*    This is the header file of ac.c containing arithmetic */
/*    coding routines.                                      */
/*                                                          */
/************************************************************/

#ifndef _AC_H_
#define _AC_H_

#include <stdio.h>
#include "momusys.h"
#define MAX_BUFFER 1024

typedef struct {
  File *fp;
  LInt low;
  LInt high;
  LInt fbits;
  Int buffer;
  Int bits_to_go;
  LInt total_bits;
  UChar *bitstream;
  LInt  bitstream_len;
} ac_encoder;

typedef struct {
  FILE *fp;
  LInt value;
  LInt low;
  LInt high;
  Int buffer;
  Int bits_to_go;
  UChar *bitstream;
  LInt total_bits;
  LInt  bitstream_ptr;
  Int  dc_band;
} ac_decoder;

typedef struct {
  Int nsym;   /* the number of symbols in the symbol set to be encoded */
  Int adapt;  /* 0 => non-adaptive, !0 => adaptive */
  Int inc;

  /* for zeroth and mixed order models only */
  UShort *freq;
  UShort *cfreq;

  UShort Max_frequency;

} ac_model;

typedef struct
{
  ac_model *contextModelList;
  UShort numContexts;
  UShort nsym;
  UShort curContext;
}
 ac_context;

#include "ac.p"

#endif

