//  file drvlib.h
//   This header file contains definitions intended to go along with
//   DRVLIB.LIB, a C-callable subroutine library.
//
//   This file is for OS/2 2.0

typedef unsigned char   UCHAR;
typedef unsigned short  USHORT;
typedef unsigned short  BOOLEAN;
typedef unsigned long   ULONG;
typedef UCHAR near      *PUCHAR;
typedef UCHAR far       *FPUCHAR;
typedef USHORT near     *PUSHORT;
typedef USHORT far      *FPUSHORT;
typedef ULONG near      *PULONG;
typedef ULONG far       *FPULONG;
typedef char near       *PCHAR;
typedef short near      *PSHORT;
typedef long near       *PLONG; 
typedef void near       *POINTER;
typedef POINTER near    *PPOINTER;
typedef void far        *FARPOINTER;
typedef FARPOINTER near *PFARPOINTER;
typedef FARPOINTER far  *FPFARPOINTER;

typedef USHORT          ERRCODE;    // error code returned                 
typedef ERRCODE far     *PERRCODE;  // pointer to an error code            
typedef UCHAR           FLAG;       // 8-bit flag                          
typedef FLAG far        *PFLAG;     // pointer to 8-bit flag               
typedef USHORT          SEL;        // 16-bit selector                     
typedef SEL near        *PSEL;      // pointer to a selector               
typedef SEL far         *FPSEL;     // far pointer to selector             
typedef USHORT          SEG;        // 16-bit segment                      
typedef USHORT          OFF;        // 16-bit offset                       
typedef ULONG           LOFF;       // 32-bit offset                       
typedef USHORT          PID;        // Process ID                          
typedef USHORT          TID;        // Thread ID                           
typedef ULONG           PHYSADDR;   // 32-bit physical address             
typedef ULONG           LINADDR;    // 32-bit linear address               
typedef LINADDR  far    *PLINADDR;  // pointer to 32 bit linear address    
typedef PLINADDR far    *PPLINADDR; // pointer to linear address pointer   
typedef PHYSADDR far    *PPHYSADDR; // pointer to 32-bit physical address  
typedef char near       *PSTRING;   // pointer to character string         
typedef char far        *FPSTRING;// far pointer to string               
typedef USHORT          SHANDLE;    // short (16-bit) handle               
typedef SHANDLE far     *PSHANDLE;  // pointer to a short handle           
typedef ULONG           LHANDLE;    // long  (32-bit) handle               
typedef LHANDLE far     *PLHANDLE;  // pointer to a long handle            

//  pointers to functions 

typedef int (pascal near          *PFUNCTION) ();
typedef int (pascal near * near  *PPFUNCTION) ();
typedef int (pascal far          *FPFUNCTION) ();
typedef int (pascal far  * near *PFPFUNCTION) ();

// macros 

#define FALSE   0
#define TRUE    1

#define NP near pascal

// far pointer from selector-offset 

#define MAKEP(sel, off)     ( (void far *) MAKEULONG(off, sel) )

// get selector or offset from far pointer 

#define SELECTOROF(p)       ( ((USHORT far *) &(p)) [1])
#define OFFSETOF(p)         ( ((USHORT far *) &(p)) [0])

// Combine l(ow) & h(igh) to form a 32 bit quantity. 

#define MAKEULONG(l, h)  ((ULONG)(((USHORT)(l)) | ((ULONG)((USHORT)(h))) << 16))
#define MAKELONG(l, h)   ((LONG)MAKEULONG(l, h))
#define MAKEBIGOFFSETOF(p) ((ULONG) (OFFSETOF (p)))

// Combine l(ow) & h(igh) to form a 16 bit quantity. 

#define MAKEUSHORT(l, h) (((USHORT)(l)) | ((USHORT)(h)) << 8)
#define MAKESHORT(l, h)  ((SHORT)MAKEUSHORT(l, h))

// get high and low order parts of a 16 and 32 bit quantity 

#define LOBYTE(w)       LOUCHAR(w)
#define HIBYTE(w)       HIUCHAR(w)
#define LOUCHAR(w)      ((UCHAR)(w))
#define HIUCHAR(w)      (((USHORT)(w) >> 8) & 0xff)
#define LOUSHORT(l)     ((USHORT)(l))
#define HIUSHORT(l)     ((USHORT)(((ULONG)(l) >> 16) & 0xffff))

//  the driver device header 

typedef struct DeviceHdr {
   struct DeviceHdr far *DHnext;    // pointer to next header, or FFFF     
   USHORT DHattribute;              // device attribute word               
   OFF    DHstrategy;               // offset of strategy routine          
   OFF    DHidc;                    // offset of IDC routine               
   UCHAR  DHname[8];                // dev name (char) or #units (blk)     
   char   reserved[8];
   ULONG  bit_strip;                // bit 0 DevIOCtl2, bit 1 32 bit addr  
   } DEVICEHDR;
typedef DEVICEHDR near *PDEVICEHDR;

