/* RXMMIO.CMD */
/* Written by Lone Peak Automation, LLC */

/* Load RXMMIO.DLL */
CALL RXFuncAdd 'rxMIOLoadFuncs', 'RXMMIO', 'rxMIOLoadFuncs'
CALL rxMIOLoadFuncs

SAY ''
SAY '--- Sample REXX Program for Image Conversion using built-in MM IOProcs. ---'
SAY ''

rc = rxMIODllVersion()
SAY "RXMMIO.DLL version is: " || rc

IF Stream( 'test1.bmp', 'C', 'Query Exists' ) = '' THEN    /* image not found */
  DO
    SAY ''
    SAY 'Image TEST1.BMP not found.'
    SAY ''
    SAY 'Provide sample image files TEST1.BMP, TEST1NC.BMP, TEST1.GIF, TEST1.PCX'
    SAY 'TEST1.TIF and TEST1.JPG or adjust rxMIOConvert parameters accodingly.'
    EXIT
  END

rc = rxMIOImgInfo('test1.bmp', -1)
SAY 'test1.bmp Image Info; rc = ' || rc

rc = rxMIOConvert('test1.bmp', 'testbmp2.gif', 0, -1)
SAY 'testbmp2.gif created; rc = ' || rc

rc = rxMIOConvert('test1.bmp', 'testbmp2.pcx', 0, -1)
SAY 'testbmp2.pcx created; rc = ' || rc

rc = rxMIOConvert('test1.bmp', 'testbmp2.jpg', 0, -1)
SAY 'testbmp2.jpg created; rc = ' || rc

rc = rxMIOConvert('test1.gif', 'testgif2.bmp', 0, -1)
SAY 'testgif2.bmp created; rc = ' || rc

rc = rxMIOConvert('test1.gif', 'testgif2.jpg', 0, -1)
SAY 'testgif2.jpg created; rc = ' || rc

rc = rxMIOConvert('test1.gif', 'testgif2.pcx', 0, -1)
SAY 'testgif2.pcx created; rc = ' || rc

rc = rxMIOConvert('test1.pcx', 'testpcx2.bmp', 0, -1)
SAY 'testpcx2.bmp created; rc = ' || rc

rc = rxMIOConvert('test1.pcx', 'testpcx2.jpg', 0, -1)
SAY 'testpcx2.jpg created; rc = ' || rc

rc = rxMIOConvert('test1.pcx', 'testpcx2.gif', 0, -1)
SAY 'testpcx2.gif created; rc = ' || rc

rc = rxMIOConvert('test1.jpg', 'testjpg2.bmp', 0, -1)
SAY 'testjpg2.bmp created; rc = ' || rc

rc = rxMIOConvert('test1.jpg', 'testjpg2.pcx', 0, -1)
SAY 'testjpg2.pcx created; rc = ' || rc

rc = rxMIOConvert('test1.jpg', 'testjpg2.gif', 0, -1)
SAY 'testjpg2.gif created; rc = ' || rc

rc = rxMIOConvert('test1.bmp', 'testbmp2.vid', 0, -1)
SAY 'testbmp2.vid created; rc = ' || rc

rc = rxMIOConvert('test1.bmp', 'testbmp2.tga', 0, -1)
SAY 'testbmp2.tga created; rc = ' || rc

rc = rxMIOConvert('test1.tif', 'testtif2.bmp', 0, -1)
SAY 'testtif2.bmp created; rc = ' || rc

rc = rxMIOConvert('test1.bmp', 'testbmp2.tif', 0, -1)
SAY 'testbmp2.tif created; rc = ' || rc

rc = rxMIOConvert('test1.gif', '', 0, -1)  /* note: outfile is supplied as an empty string */
SAY 'Is test1.gif image format supported? (rc = 400 = yes); rc = ' || rc

SAY 'Forcing an error with a non-existing image file:'
rc = rxMIOConvert('xxyyzz.png', '', 0, -1)
SAY 'Is xxyyzz.png image format supported? (rc = 100 = no); rc = ' || rc

rc = rxBMPGrayscale('test1nc.bmp', 'test1gray.bmp')
SAY 'Converting test1.bmp to grayscale rc = ' || rc

rc = rxBMPTrim('test1nc.bmp', 'test1trim.bmp', 10, 15, 20, 25)
SAY 'Trim test1.bmp by 25 pixels top-bottom and 45 pixels left-right; rc = ' || rc

rc = rxBMPBright('test1nc.bmp', 'test1bri.bmp', 30)
SAY 'Brighten test1.bmp by 50 (20%); rc = ' || rc

rc = rxBMPBright('test1nc.bmp', 'test1dark.bmp', -30)
SAY 'Darken test1.bmp by -50 (20%); rc = ' || rc

rc = rxBMPNeg('test1nc.bmp', 'test1neg.bmp')
SAY 'Created negative of test1nc.bmp and stored as test1neg.bmp; rc = ' || rc

rc = rxBMPNoRLE('testrle.bmp', 'testnorle.bmp')
SAY 'Converted RLE24 testrle.bmp to no compression testnorle.bmp; rc = ' || rc

SAY 'Rxmmio test complete.'
CALL rxMIODROPFuncs
SAY 'RXMMIO.DLL dropped.'

EXIT
