#ifndef UNIAUD_PRINTINFO
#define UNIAUD_PRINTINFO

#include "uniaud.h"

int PrintControl(int card_id, UniaudControlInfo *ctl_info, UniaudControlValue *ctl_val)
{
    int i;
    if (ctl_info == NULL || ctl_val == NULL) return -1;

    printf("Control ID: %i\n",ctl_info->id.numid);
    printf("Interface: ");
    switch(ctl_info->id.iface)
    {
    case SNDRV_CTL_ELEM_IFACE_CARD:
        printf("global control\n"); break;
    case SNDRV_CTL_ELEM_IFACE_HWDEP:
        printf("hardware dependent device\n");break;
    case SNDRV_CTL_ELEM_IFACE_MIXER:
        printf("virtual mixer device\n"); break;
    case SNDRV_CTL_ELEM_IFACE_PCM:
        printf("PCM device\n"); break;
    case SNDRV_CTL_ELEM_IFACE_RAWMIDI:
        printf("RawMidi device\n"); break;
    case SNDRV_CTL_ELEM_IFACE_TIMER:
        printf("timer device\n"); break;
    case SNDRV_CTL_ELEM_IFACE_SEQUENCER:
        printf("sequencer client\n"); break;
    }
    printf("Device(client): %i, subdevice (substream) %i\n",
           ctl_info->id.device, ctl_info->id.subdevice);
    printf("Name: [%s]\n",ctl_info->id.name);
    printf("Index: %i\n", ctl_info->id.index);
    printf("Element type: ");

    switch(ctl_info->type)
    {
    case SNDRV_CTL_ELEM_TYPE_NONE:
        printf("invalid\n");break;
    case SNDRV_CTL_ELEM_TYPE_BOOLEAN:
        printf("boolean type\n");break;
    case SNDRV_CTL_ELEM_TYPE_INTEGER:
        printf("integer type\n");break;
    case SNDRV_CTL_ELEM_TYPE_ENUMERATED:
        printf("enumerated type\n");break;
    case SNDRV_CTL_ELEM_TYPE_BYTES:
        printf("byte array\n");break;
    case SNDRV_CTL_ELEM_TYPE_IEC958:
        printf("IEC958 (S/PDIF) setup\n");break;
    case SNDRV_CTL_ELEM_TYPE_INTEGER64:
        printf("64-bit integer type\n");break;
    }

    printf("Count of values: %i\n", ctl_info->count);
    printf("Value: \n");
    switch(ctl_info->type)
    {
    case SNDRV_CTL_ELEM_TYPE_BOOLEAN:
    case SNDRV_CTL_ELEM_TYPE_INTEGER:
        printf(" Bounds: min: %i, max: %i, step: %i\n",
               ctl_info->value.integer.min,
               ctl_info->value.integer.max,
               ctl_info->value.integer.step);
        for (i=0; i < ctl_info->count; i++)
            printf("  value %d: %i\n",i+1, ctl_val->value.integer.value[i]);
        break;
    case SNDRV_CTL_ELEM_TYPE_INTEGER64:
        printf(" Bounds: min: %i, max: %i, step: %i\n",
               ctl_info->value.integer64.minlo,
               ctl_info->value.integer64.maxlo,
               ctl_info->value.integer64.steplo);
        for (i=0; i < ctl_info->count; i++)
            printf("  value %d: %i\n",i+1, ctl_val->value.integer64.value[i]);
        break;
    case SNDRV_CTL_ELEM_TYPE_ENUMERATED:
        printf(" Bounds: items: %i, item: %i, name: [%s]\n",
               ctl_info->value.enumerated.items,
               ctl_info->value.enumerated.item,
               ctl_info->value.enumerated.name);
        for (i=0; i < ctl_info->count; i++) {
          printf("  value %d: %i\n",i+1, ctl_val->value.enumerated.item[i]);
        }
        for (i=0; i < ctl_info->value.enumerated.items; i++) {
          int id=ctl_info->id.numid;
          memset(ctl_info,0,sizeof(UniaudControlInfo));
          ctl_info->value.enumerated.item=i;
          uniaud_mixer_get_ctl_info(card_id, id, ctl_info);
          printf("  item %d: %s\n",i+1, ctl_info->value.enumerated.name);
        }

        break;
    case SNDRV_CTL_ELEM_TYPE_BYTES:
        break;
    case SNDRV_CTL_ELEM_TYPE_IEC958:
        break;
    }

    printf("\n");
    return 0;
}

#endif UNIAUD_PRINTINFO

