/** Read information from a music file and pass it back to the main program
 * This file is part of Plogg, the Ogg Vorbis/mp3 player.
 * Copyright (C)2003 Jeff Robinson
 */


#define INCL_DOSMODULEMGR
#include <os2.h>
#include <stdio.h>
#include <sys/fcntl.h>
#include <vorbis/codec.h>
#include <vorbis/vorbisfile.h>
#include <string.h>
#include <io.h>
#include <stdlib.h>

#include "plogg.h"

#define IGNORE_ORDINAL_NUMBER   0

/* This line is already included in vorbisfile.h
 * extern vorbiscomment ov_comment(OggVorbis_File, int);
 */

/* Return the title of the Vorbis file */
void oggData(char *passedName, struct songInfo *currentSong) {

    OggVorbis_File vf;
    FILE *ovf;

    // First thing we do is set the title of the song to the passed name
    // incase we don't find anything else suitable to fill it with
    strcpy(currentSong->songTitle, passedName);
    strcpy(currentSong->songArtist, "");

    /* Check to see if we can access the file we've been passed */
    if (access(passedName, R_OK) != 0) {
        return;
    }

    ovf = fopen(passedName, "r");        // ov_close takes care of closing this file after
    _fsetmode(ovf, "b");

    HMODULE hmod;
    APIRET loadrc = 0;
    UCHAR szErrorName[CCHMAXPATH]; /* CCHMAXPATH defined in bsedos.h */
    loadrc = DosLoadModule(szErrorName,
                           CCHMAXPATH-1,
                           "vorbis.dll",
                           &hmod);
    if (loadrc) {
        fprintf(stderr, "\n Could not load vorbis.dll successfully, bad %s, rc = %i\n",
                szErrorName,
                (int)loadrc);
        return;
    }

    PFN ov_open, ov_clear, ov_comment, ov_time_total, ov_info, ov_streams, ov_seekable;


    loadrc = DosQueryProcAddr(hmod,
                              IGNORE_ORDINAL_NUMBER,
                              "ov_open",
                              &ov_open);

    loadrc = DosQueryProcAddr(hmod,
                              IGNORE_ORDINAL_NUMBER,
                              "ov_clear",
                              &ov_clear);

    if (loadrc) {
        fprintf(stderr, "\n Could not find address for ov_clear, rc = %i\n",
                (int)loadrc);
        DosFreeModule(hmod);
        exit(0);
    }

    loadrc = DosQueryProcAddr(hmod,
                              IGNORE_ORDINAL_NUMBER,
                              "ov_comment",
                              &ov_comment);

    loadrc = DosQueryProcAddr(hmod,
                              IGNORE_ORDINAL_NUMBER,
                              "ov_streams",
                              &ov_streams);

    loadrc = DosQueryProcAddr(hmod,
                              IGNORE_ORDINAL_NUMBER,
                              "ov_seekable",
                              &ov_seekable);

    loadrc = DosQueryProcAddr(hmod,
                              IGNORE_ORDINAL_NUMBER,
                              "ov_time_total",
                              &ov_time_total);
    if (loadrc) {
        fprintf(stderr, "\n Could not find address for ov_time_total, rc = %i\n",
                (int)loadrc);
        DosFreeModule(hmod);
        exit(0);
    }

    loadrc = DosQueryProcAddr(hmod,
                              IGNORE_ORDINAL_NUMBER,
                              "ov_info",
                              &ov_info);

    if (loadrc) {
        fprintf(stderr, "\n Could not find address for ov_open, rc = %i\n",
                (int)loadrc);
        DosFreeModule(hmod);
        exit(0);
    }

    int rc = 0;
    rc = ov_open(ovf, &vf, NULL, 0);

    if (rc < 0) {
        fprintf(stderr,"Input does not appear to be an Ogg bitstream.\n");
        fclose(ovf);
        fprintf(stderr, "Our return code is %i .\n", rc);
        switch (rc) {
        case OV_EREAD:
            fprintf(stderr, "OV_EREAD - A read from media returned an error.\n");
        case OV_ENOTVORBIS:
            fprintf(stderr, "OV_ENOTVORBIS - Bitstream is not Vorbis data.\n");
        case OV_EVERSION:
            fprintf(stderr, "OV_EVERSION - Vorbis version mismatch.\n");
        case OV_EBADHEADER:
            fprintf(stderr, "OV_EBADHEADER - Invalid Vorbis bitstream header.\n");
        case OV_EFAULT:
            fprintf(stderr, "OV_EFAULT - Internal logic fault; indicates a bug or heap/stack corruption.\n");
        }

        // DosFreeModule(hmod);

        return;
    }

    /* Throw the comments plus a few lines about the bitstream we're
     decoding */

    int nameLength;
    vorbis_comment *ovc;
    ovc = ov_comment(&vf, -1);
    char **ptr=ovc->user_comments;

    // vorbis_info *vi=ov_info(&vf,-1);

    while(*ptr){
        if (strstr(*ptr, "TITLE=") || strstr(*ptr, "title=")) {
            nameLength = strlen(*ptr) - 6;
            if (nameLength > 0) {
                strcpy(currentSong->songTitle, *ptr + 6);
            }
        }

        if (strstr(*ptr, "ARTIST=") || strstr(*ptr, "artist=")) {
            nameLength = strlen(*ptr) - 7;
            if (nameLength > 0) {
                strcpy(currentSong->songArtist, *ptr + 7);
            }
        }

        if (strstr(*ptr, "ALBUM=") || strstr(*ptr, "album=")) {
            nameLength = strlen(*ptr) - 6;
            if (nameLength > 0) {
                strcpy(currentSong->songAlbum, *ptr + 6);
            }
        }

        if (strstr(*ptr, "YEAR=") || strstr(*ptr, "year=")) {
            nameLength = strlen(*ptr) - 5;
            if (nameLength > 0) {
                strcpy(currentSong->songYear, *ptr + 5);
            }
        }

        ++ptr;
    }

    if(ov_seekable(&vf)){
        // fprintf(stderr, "Input bitstream contained %ld logical bitstream section(s).\n",
        // ov_streams(&vf));
        fprintf(stderr, "Input bitstream contained %d logical bitstream section(s).\n",
               ov_streams(&vf));
        //fprintf(stderr, "Total bitstream playing time: %ld seconds\n\n",
        // (double)ov_time_total(&vf,-1));
        fprintf(stderr, "Total bitstream playing time: %i seconds\n\n",
                ov_time_total(&vf,-1));

    }else{
        fprintf(stderr, "Standard input was not seekable.\n"
               "First logical bitstream information:\n\n");
    }

    // currentSong->songTime = (int)ov_time_total(&vf, -1);
    // fprintf(stderr, "songTime is %i\n", currentSong->songTime);
    // fprintf(stderr, "Straight from the source %i\n", ov_time_total(&vf, -1) * 1000);

    ov_clear(&vf);

    // DosFreeModule(hmod);

    return;
}

