.486p
model flat
ideal

Adapter = 3 ; 1,2,3,4,5,6,7,8

BitsPerSample = 32 ; 8,16,24,32
Channels = 2 ; 1=mono 2=stereo
FormatTag = 1 ; 1=PCM,301h=DSD

SamplesPerSec = 192000 ; Hz.
Frequency = 1000 ; Hz.

extrn DosClose:near
extrn DosCloseEventSem:near
extrn DosCreateEventSem:near
extrn DosExit:near
extrn DosExitList:near
extrn DosOpen:near
extrn DosPostEventSem:near
extrn DosResetEventSem:near
extrn DosSetFilePtr:near
extrn DosSleep:near
extrn DosWaitEventSem:near
extrn DosWrite:near

extrn MciGetErrorString:near
extrn MciSendCommand:near

stack 8192

dataseg
szOutput db 'test.wav',0

BufferSize = 0
NumBuffers = 8

dataseg
AmpMixer db 'Ampmix0','0'+Adapter,0
AmpOpenParms dd 0,0,offset(AmpMixer),0,0,0
MixerAllocParms dd 0,32,NumBuffers,BufferSize,0,0,0,offset(MixerBuffer1)
MixerSetupParms dd 0,BitsPerSample,FormatTag,SamplesPerSec,Channels,4,7,0,0,0,offset(SoundMixerEvent),0,BufferSize,NumBuffers

dataseg
FreeBuffers dd NumBuffers
MixerBuffer1 dd 0,0,0,0,offset(MixerBuffer2),0,0,0
MixerBuffer2 dd 0,0,0,0,offset(MixerBuffer3),0,0,0
MixerBuffer3 dd 0,0,0,0,offset(MixerBuffer4),0,0,0
MixerBuffer4 dd 0,0,0,0,offset(MixerBuffer5),0,0,0
MixerBuffer5 dd 0,0,0,0,offset(MixerBuffer6),0,0,0
MixerBuffer6 dd 0,0,0,0,offset(MixerBuffer7),0,0,0
MixerBuffer7 dd 0,0,0,0,offset(MixerBuffer8),0,0,0
MixerBuffer8 dd 0,0,0,0,offset(MixerBuffer1),0,0,0
MixerBuffer dd offset(MixerBuffer1)

udataseg
DartSem dd ?
FreeCnt dd ?
MciMessage db 128 dup(?)
Written dd ?

dataseg
sGood0 db 'started.',13,10
sGood1 db 'stopped.',13,10
sGood2 db 'waiting...',13,10
label sGood3 byte

dataseg
sInfo0 db ' opening ampmixer device',13,10
sInfo1 db ' informing dart being used',13,10
sInfo2 db ' allocating dart buffers',13,10
sInfo3 db ' creating event semaphore',13,10
sInfo4 db ' closing event semaphore',13,10
sInfo5 db ' deallocating dart buffers',13,10
sInfo6 db ' informing dart use ended',13,10
sInfo7 db ' closing ampmixer device',13,10
label sInfo8 byte

dataseg
sTest0 db ' opening audio output file',13,10
sTest1 db ' writing audio output file',13,10
sTest2 db ' closing audio output file',13,10
label sTest3 byte

SampleSize=BitsPerSample*Channels/8
AudioHeader db 'RIFF',36,0,15,0,'WAVEfmt '
            dd 16,65536*Channels+1,SamplesPerSec,SamplesPerSec*SampleSize
            db SampleSize,0,BitsPerSample,0,'data',0,0,15,0

udataseg
ActionTaken dd ?
BytesDone dd ?
fhDevice dd ?
fhOutput dd ?

codeseg
proc MainRoutine c near
arg @@Mod,@@Nul,@@Env,@@Arg
; determine begin of arguments
  cld ; operate foreward scan
  mov ecx,512 ; max scan length
  mov edi,[@@Arg] ; start address
  repne scasb ; find terminator
; process passed arguments
  call ProcessArguments
; show application started message
  call DosWrite c,1,offset(sGood0),sGood1-sGood0,offset(BytesDone)
; initialize sound device
  call SoundDeviceInit
  cmp [RecordingTime],0
  je EndOpenOutputFile
; open pcm audio data output file
  call DosWrite c,1,offset(sTest0),sTest1-sTest0,offset(BytesDone)
  call DosOpen c,offset(szOutput),offset(fhOutput),offset(ActionTaken),0,0,012h,0191h,0
  call ShowReturnCode
  jnz NotRecordSound
label EndOpenOutputFile near
; register termination processing;
  call DosExitList c,1,offset(ProcessComplete)
; invoke sound processing
  call SoundProcessing
; force process complete
  sub eax,eax ; success
  ret ; uses exit list
label NotRecordSound near
; finalize sound device
  call SoundDeviceExit
; show application stopped message
  call DosWrite c,1,offset(sGood1),10,offset(BytesDone)
; exit the program
  call DosExit c,1,0
endp MainRoutine

codeseg
proc dec2bin near
; decimal to binary
  sub eax,eax ; input
  sub edx,edx ; output
label ConvertInput near
  inc edi ; next position
  mov al,[edi] ; digit
; convert decimal digit
  cmp al,'0' ; minimum
  jb Enddec2bin ; done
  cmp al,'9' ; maximum
  ja Enddec2bin ; done
  sub al,'0' ; digit
  lea edx,[edx*4+edx]
  lea edx,[edx*2+eax]
  jmp ConvertInput
label Enddec2bin Near
  ret ; return
endp dec2bin

codeseg
proc ProcessArguments near
; scan for forward slash
  mov al,[edi] ; character
  inc edi ; next position
  cmp al,00h ; terminator
  je EndScanString ; done
  cmp al,'/' ; parameter
  jne ProcessArguments
; adapter number
  cmp [byte(edi)],'a'
  jne NotAdapter
  call dec2bin ; convert
; verify adapter number
  cmp edx,8 ; maximum
  jna UpdateAdapter
  mov dl,8 ; maximum
label UpdateAdapter near
; update adapter number
  add dl,"0" ; ascii
  mov [AmpMixer+7],dl
  jmp ProcessArguments
label NotAdapter near
; bits per sample
  cmp [byte(edi)],'b'
  jne NotBits
  call dec2bin ; convert
; store BitsPerSample value
  mov [MixerSetupParms+04],edx
  mov [word(AudioHeader)+34],dx
  jmp ProcessArguments
label NotBits near
; channels argument
  cmp [byte(edi)],'c'
  jne NotChannels
  call dec2bin ; convert
; store Channels value
  mov [MixerSetupParms+16],edx
  mov [word(AudioHeader)+22],dx
  jmp ProcessArguments
label NotChannels near
; frequency argument
  cmp [byte(edi)],'f'
  jne NotSignalFreq
  call dec2bin ; convert
  mov [SignalFreq],edx
  jmp ProcessArguments
label NotSignalFreq near
; invert channnel argument
  cmp [byte(edi)],'i'
  jne NotInvertChannel
  call dec2bin ; convert
  cmp edx,3 ; maximum
  ja ProcessArguments
  mov [XorValue],dl
  jmp ProcessArguments
label NotInvertChannel near
; mute channel argument
  cmp [byte(edi)],'m'
  jne NotMuteChannel
  call dec2bin ; convert
  cmp edx,3 ; maximum
  ja ProcessArguments
  mov [NotValue],dl
  jmp ProcessArguments
label NotMuteChannel near
; sampling rate argument
  cmp [byte(edi)],'s'
  jne NotSamplingRate
  call dec2bin ; convert
; verify sampling rate
  test edx,edx ; zero
  jna ProcessArguments
; store SamplesPerSec value
  mov [MixerSetupParms+12],edx
  mov [dword(AudioHeader)+24],edx
  jmp ProcessArguments
label NotSamplingRate near
; recording time argument
  cmp [byte(edi)],'r'
  jne NotRecordingTime
  call dec2bin ; convert
; verify recording time
  cmp edx,300 ; seconds
  jna UpdateRecordTime
  mov edx,300 ; maximum
label UpdateRecordTime near
  mov [RecordingTime],edx
  jmp ProcessArguments
label NotRecordingTime near
; volume control argument
  cmp [byte(edi)],'v'
  jne NotVolumeControl
  call dec2bin ; convert
; verify volume control
  cmp edx,192 ; maximum
  jna UpdateVolume
  mov dl,192 ; maximum
label UpdateVolume near
  mov [CurValue],dl
  jmp ProcessArguments
label NotVolumeControl near
; waveform type argument
  cmp [byte(edi)],'w'
  jne NotWaveForm
  call dec2bin ; convert
; verify waveform number
  cmp edx,4 ; maximum
  ja ProcessArguments
  mov [WaveForm],dl
  jmp ProcessArguments
label NotWaveform near
  jmp ProcessArguments
label EndScanString near
; respect nyquist frequency
  mov eax,[MixerSetupParms+12]
  shr eax,1 ; now at nyquist
  sub eax,1 ; just below
  cmp [SignalFreq],eax
  jna  EndNyquist ; accept
; force nyquist frequency
  mov [SignalFreq],eax
label EndNyquist near
; update AudioHeader
  mov edx,[MixerSetupParms+04]
  shr edx,3 ; BytesPerSample
  mov eax,[MixerSetupParms+16]
  mul edx ; BytesPerSample*Channels
  mov [word(AudioHeader)+32],ax
  mov edx,[MixerSetupParms+12]
  mul edx ; SamplesPerSec*SampleSize
  mov [dword(AudioHeader)+28],eax
; convert recording time to bytes
  mov edx,[RecordingTime] ; seconds
  mul edx ; BytesPerSecond*Seconds
  mov [RecordingTime],eax ; bytes
  ret ; return
endp ProcessArguments

codeseg
proc ProcessComplete c near
arg @@ReasonCode
; report reason code
; mov eax,[@@ReasonCode]
; call ShowReturnCode
  cmp [RecordingTime],0
  je EndCloseOutputFile
; update riff/wave audio file header
  mov eax,[FileSize] ; data chunk size
  mov [dword(AudioHeader+28h)],eax
  add eax,36 ; RIFF chunk size
  mov [dword(AudioHeader+04h)],eax
; rewrite riff/wave audio file header
  call DosWrite c,1,offset(sTest1),sTest2-sTest1,offset(BytesDone)
  call DosSetFilePtr c,[fhOutput],0,0,offset(ActionTaken)
  call ShowReturnCode
  jnz CloseAudioRecordFile
  call DosWrite c,[fhOutput],offset(AudioHeader),44,offset(BytesDone)
  call ShowReturnCode
label CloseAudioRecordFile near
; close pcm audio data output file
  call DosWrite c,1,offset(sTest2),sTest3-sTest2,offset(BytesDone)
  call DosClose c,[fhOutput]
  call ShowReturnCode
label EndCloseOutputFile near
; finalize sound device
  call SoundDeviceExit
; show application stopped message
  call DosWrite c,1,offset(sGood1),10,offset(BytesDone)
; exit termination process
  call DosExitList c,3,0)
  endp ProcessComplete

codeseg
proc ShowMultimediaMessage near
  test eax,eax ; skip success
  jz EndShowMultimediaMessage
  call MciGetErrorString c,eax,offset(MciMessage),80
  call DosWrite c,1,offset(MciMessage),80,offset(Written)
label EndShowMultimediaMessage near
  ret ; return
endp ShowMultimediaMessage

dataseg
hex2ascii db '0123456789ABCDEF'
szStatus db '[????????]',13,10

codeseg
proc ShowReturnCode near
; skip zero return code
  test eax,eax ; zero
  jz EndShowCode ; done
  push eax ; save register
; convert return code
  mov ecx,8 ; code length
label ConvertDigit near
  mov edx,eax ; error code
  and edx,0000000Fh ; digit
  mov dl,[hex2ascii+edx]
  mov [szStatus+ecx],dl
  shr eax,4 ; next one
  loop ConvertDigit
; show appropriate info message
  call DosWrite c,1,offset(szStatus),12,offset(BytesDone)
  pop eax ; restore register
  test eax,eax ; check
label EndShowCode near
  ret ; return
endp ShowReturnCode

codeseg
public SoundDeviceExit
proc SoundDeviceExit near
; close dart event semaphore
  call DosWrite c,1,offset(sInfo4),sInfo5-sInfo4,offset(BytesDone)
  call DosCloseEventSem c,[DartSem]
; deallocate dart communication buffers and wait
; 62=MCI_BUFFER,80002h=MCI_DEALLOCATE_MEMORY+MCI_WAIT
  call DosWrite c,1,offset(sInfo5),sInfo6-sInfo5,offset(BytesDone)
  call MciSendCommand c,[AmpOpenParms+04h],62,80002h,offset(MixerAllocParms),0
  call ShowMultimediaMessage
; inform ampmixer that dart is no longer used and wait
; 63=MCI_MIXSETUP,20002h=MCI_MIXSETUP_DEINIT+MCI_WAIT
  call DosWrite c,1,offset(sInfo6),sInfo7-sInfo6,offset(BytesDone)
  call MciSendCommand c,[AmpOpenParms+04h],63,20002h,offset(MixerSetupParms),0
  call ShowMultimediaMessage
; close the waveaudio device and wait
; 02=MCI_CLOSE,00002h=MCI_WAIT
  call DosWrite c,1,offset(sInfo7),sInfo8-sInfo7,offset(BytesDone)
  call MciSendCommand c,[AmpOpenParms+04h],02,00002h,offset(AmpOpenParms),0
  call ShowMultimediaMessage
  ret ; return
endp SoundDeviceExit

codeseg
public SoundDeviceInit
proc SoundDeviceInit near
; open the ampmixer device shared and wait
; 01=MCI_OPEN,02002h=MCI_OPEN_TYPE_ID+MCI_WAIT
  call DosWrite c,1,offset(sInfo0),sInfo1-sInfo0,offset(BytesDone)
  call MciSendCommand c,[AmpOpenParms+04h],01,02002h,offset(AmpOpenParms),0
  test eax,eax ; any error
  jnz MultimediaMessage
; inform ampmixer that dart is used and wait
; 63=MCI_MIXSETUP,10002h=MCI_MIXSETUP_INIT+MCI_WAIT
  call DosWrite c,1,offset(sInfo1),sInfo2-sInfo1,offset(BytesDone)
  call MciSendCommand c,[AmpOpenParms+04h],63,10002h,offset(MixerSetupParms),0
  test eax,eax ; any error
  jnz MultimediaMessage
; use recommended BufferSize
  mov eax,[MixerSetupParms+12*4]
  mov [MixerAllocParms+3*4],eax
; use recommended NumBuffers
; mov eax,[MixerSetupParms+13*4]
; mov [MixerAllocParms+2*4],eax
; allocate dart communication buffers and wait
; 62=MCI_BUFFER,40002h=MCI_ALLOCATE_MEMORY+MCI_WAIT
  call DosWrite c,1,offset(sInfo2),sInfo3-sInfo2,offset(BytesDone)
  call MciSendCommand c,[AmpOpenParms+04h],62,40002h,offset(MixerAllocParms),0
  test eax,eax ; any error
  jnz MultimediaMessage
; create dart event semaphore
  call DosWrite c,1,offset(sInfo3),sInfo4-sInfo3,offset(BytesDone)
  call DosCreateEventSem c,0,offset(DartSem),1,0
  ret ; return
label MultimediaMessage near
; write multimedia error message
  call ShowMultimediaMessage
; exit the program
  call DosExit c,1,0
endp SoundDeviceInit

codeseg
proc SoundMixerEvent c near
arg @@Status,@@Buffer,@@Flags
; handle write complete condition
; cmp [@@Flags],02h ; write complete
; jne EndSoundMixerEvent ; other
; report mixer write completion
  call DosPostEventSem c,[DartSem]
label EndSoundMixerEvent near
  ret ; return
endp SoundMixerEvent

dataseg
FileSize dd 0

dataseg
RecordingTime dd 0

dataseg
SampleFreq dd SamplesPerSec
SignalFreq dd Frequency

dataseg
WaveForm db 0

dataseg
Position dd 0
Fraction dd 0

udataseg
Increment dd ?
Remainder dd ?

dataseg
MaxValue dd 7FFFFFFFh
CurValue db 0 ; -0dB

dataseg
Factor1dB dq 0.8912509381337 ; -1dB

udataseg
OutValue dd ?
VolValue dd ?

dataseg
NotValue db 0
XorValue db 0

codeseg
proc SoundProcessing near
  cmp [RecordingTime],0
  je EndWriteAudioHeader
; write riff/wave audio file header
  call DosWrite c,1,offset(sTest1),sTest2-sTest1,offset(BytesDone)
  call DosWrite c,[fhOutput],offset(AudioHeader),44,offset(BytesDone)
  call ShowReturnCode
  jnz EndRecordSound
  add [FileSize],44
label EndWriteAudioHeader near
; set sampling frequency
  mov eax,[MixerSetupParms+12]
  mov [SampleFreq],eax
; calculate increment
  sub eax,eax ; zeroes
  mov edx,[SignalFreq]
  div [SampleFreq]
  mov [Increment],eax
; calculate remainder
  sub eax,eax ; zeroes
  div [SampleFreq]
  mov [Remainder],eax
; set signal phase
  mov eax,[Position]
; switch waveform
  mov dl,[WaveForm]
  cmp dl,3
  ja PhiSawtooth
  je PhiTriangle
  cmp dl,1
  ja PhiSquare
; je PhiSine
label PhiSine near
  jmp EndPhi
label PhiSawtooth near
  mov eax,80000000h
  jmp EndPhi
label PhiSquare near
  mov eax,7FFFFFFFh
  jmp EndPhi
label PhiTriangle near
  mov eax,40000000h
; jmp EndPhi
label EndPhi near
  mov [Position],eax
; initialize fpu
  finit ; reset
; attenuate volume
  mov dl,[CurValue]
  fld1 ; max volume
  fld [Factor1dB]
label Attenuate near
  shr dl,1 ; next bit
  jnc AdjustFactor
; adjust attenuation
  fmul st(1),st(0)
label AdjustFactor near
; adjust factor here
  fmul st(0),st(0)
  test dl,dl ; more
  jnz Attenuate
  fstp [Factor1dB]
; apply factor here
  fimul [MaxValue]
  fistp [VolValue]
label MixerBufferProcess near
; call DosWrite c,1,offset(sTest1),sTest2-sTest1,offset(BytesDone)
; address first sample position
  mov eax,[MixerBuffer] ; current
  mov edi,[MixerAllocParms+12] ; size
  mov esi,[eax+4] ; buffer pointer
label FillSoundBuffer near
; fill pcm sound buffer
  mov eax,[position]
; switch waveform
  mov dl,[WaveForm]
  cmp dl,3
  ja sawtooth
  je triangle
  cmp dl,1
  ja square
; je sine
label sine near
; pcm sine sample
  fldpi ; radian
  fimul [Position]
  fidiv [MaxValue]
  fsin ; radian
  fimul [VolValue]
  fistp [OutValue]
  jmp WriteValue
label sawtooth near
; pcm sawtooth sample
  jmp WriteSample
label square near
; pcm square sample
  sar eax,31 ; sign
  jmp WriteSample
label triangle near
; pcm triangle sample
  mov edx,[Fraction]
  shld eax,edx,1
  jnc WriteSample
  not eax ; inverse
label WriteSample near
  sub eax,80000000h
; apply chosen volume
  mov [OutValue],eax
  fild [OutValue]
  fidiv [MaxValue]
  fimul [VolValue]
  fistp [OutValue]
label WriteValue near
  mov bh,[NotValue]
  mov bl,[XorValue]
  mov cl,[byte(MixerSetupParms)+16]
  mov dl,[byte(MixerSetupParms)+04]
; check bits per sample
  cmp dl,24 ; bits
  ja Write32Bits
  je Write24Bits
  cmp dl,16 ; bits
  je Write16Bits
; jb Write8Bits
label Write8Bits near
; channel 1 silent
  sub edx,edx ; mute
  add dh,80h ; signed
  test bh,1 ; silent
  jnz c1w8 ; yup
; channel 1 invert
  mov eax,[OutValue]
  shld edx,eax,16
  add dh,80h ; signed
  test bl,1 ; invert
  jz c1w8 ; nope
  not edx ; invert
label c1w8 near
; write 8 bits
  mov [esi+0],dh
  sub edi,1 ; bytes
  add esi,1 ; bytes
; check channels
  cmp cl,1 ; mono
  jna NextCycle
; channel 2 silent
  sub edx,edx ; mute
  add dh,80h ; signed
  test bh,2 ; silent
  jnz c2w8 ; yup
; channel 2 invert
  mov eax,[OutValue]
  shld edx,eax,16
  add dh,80h ; signed
  test bl,2 ; invert
  jz c2w8 ; nope
  not edx ; invert
label c2w8 near
; write 8 bits
  mov [esi+0],dh
  sub edi,1 ; bytes
  add esi,1 ; bytes
  jmp NextCycle
label Write16Bits near
; channel 1 silent
  sub edx,edx ; mute
  test bh,1 ; silent
  jnz c1w16 ; yup
; channel 1 invert
  mov eax,[OutValue]
  shld edx,eax,16
  test bl,1 ; invert
  jz c1w16 ; nope
  not edx ; invert
label c1w16 near
; write 16 bits
  mov [esi+0],dx
  sub edi,2 ; bytes
  add esi,2 ; bytes
; check channels
  cmp cl,1 ; mono
  jna NextCycle
; channel 2 silent
  sub edx,edx ; mute
  test bh,2 ; silent
  jnz c2w16 ; yup
; channel 2 invert
  mov eax,[OutValue]
  shld edx,eax,16
  test bl,2 ; invert
  jz c2w16 ; nope
  not edx ; invert
label c2w16 near
; write 16 bits
  mov [esi+0],dx
  sub edi,2 ; bytes
  add esi,2 ; bytes
  jmp NextCycle
label Write24Bits near
; channel 1 silent
  sub eax,eax ; mute
  sub edx,edx ; mute
  test bh,1 ; silent
  jnz c1w24 ; yup
; channel 1 invert
  mov eax,[OutValue]
  shld edx,eax,16
  test bl,1 ; invert
  jz c1w24 ; nope
  not eax ; invert
  not edx ; invert
label c1w24 near
; write 24 bits
  mov [esi+0],ah
  mov [esi+1],dx
  sub edi,3 ; bytes
  add esi,3 ; bytes
; check channels
  cmp cl,1 ; mono
  jna NextCycle
; channel 2 silent
  sub eax,eax ; mute
  sub edx,edx ; mute
  test bh,2 ; silent
  jnz c2w24 ; yup
; channel 2 invert
  mov eax,[OutValue]
  shld edx,eax,16
  test bl,2 ; invert
  jz c2w24 ; nope
  not eax ; invert
  not edx ; invert
label c2w24 near
; write 24 bits
  mov [esi+0],ah
  mov [esi+1],dx
  sub edi,3 ; bytes
  add esi,3 ; bytes
  jmp NextCycle
label Write32Bits near
; channel 1 silent
  sub eax,eax ; mute
  test bh,1 ; silent
  jnz c1w32 ; yup
; channel 1 invert
  mov eax,[OutValue]
  test bl,1 ; invert
  jz c1w32 ; nope
  not eax ; invert
label c1w32 near
; write 32 bits
  mov [esi+0],eax
  sub edi,4 ; bytes
  add esi,4 ; bytes
; check channels
  cmp cl,1 ; mono
  jna NextCycle
; channel 2 silent
  sub eax,eax ; mute
  test bh,2 ; silent
  jnz c2w32 ; yup
; channel 2 invert
  mov eax,[OutValue]
  test bl,2 ; invert
  jz c2w32 ; nope
  not eax ; invert
label c2w32 near
; write 32 bits
  mov [esi+0],eax
  sub edi,4 ; bytes
  add esi,4 ; bytes
; jmp NextCycle
label NextCycle near
; update fraction
  mov eax,[Fraction]
  add eax,[Remainder]
  mov [Fraction],eax
; update position
  mov eax,[Position]
  adc eax,[Increment]
  mov [Position],eax
  test edi,edi ; counter
  jnz FillSoundBuffer
  cmp [RecordingTime],0
  je EndWriteAudioData
; write pcm audio output data from buffer
; call DosWrite c,1,offset(sTest1),sTest2-sTest1,offset(BytesDone)
  mov eax,[MixerBuffer] ; this
  mov esi,[eax+4] ; buffer pointer
  call DosWrite c,[fhOutput],esi,[MixerAllocParms+12],offset(BytesDone)
  call ShowReturnCode
  jnz EndRecordSound
  mov eax,[MixerAllocParms+12]
  add [FileSize],eax
label EndWriteAudioData near
; write this filled mixer buffer
; 32=pmixWrite(PMIXERPROC) entry point
  call [MixerSetupParms+32] c,[MixerSetupParms+28],[MixerBuffer],1
  dec [FreeBuffers] ; buffer used
label UpdateCurrentFreeBuffers near
; update currently available mixer buffers
  call DosResetEventSem c,[DartSem],offset(FreeCnt)
  mov eax,[FreeCnt] ; buffers freed
  add [FreeBuffers],eax ; current
  jnz FillMixerBuffer ; available
; show application waiting message
; call DosWrite c,1,offset(sGood2),sGood3-sGood2,offset(BytesDone)
; await 2 seconds mixer buffer available
  call DosWaitEventSem c,[DartSem],2000
  call ShowReturnCode
  jnz EndReplaySound
  jmp UpdateCurrentFreeBuffers
label FillMixerBuffer near
; address next mixer buffer
  mov eax,[MixerBuffer] ; last
  mov eax,[eax+16] ; user parms
  mov [MixerBuffer],eax ; next
  cmp [RecordingTime],0
  je MixerBufferProcess
; verify recording time
  mov eax,[FileSize]
  cmp eax,[RecordingTime]
  jb MixerBufferProcess
label EndRecordSound near
label EndReplaySound near
; hang in here for 3 seconds
  call DosSleep c,3000
  ret ; return
endp SoundProcessing

end MainRoutine
