/* Rexx utility to add the playlist icon to the desktop */

 cmdname ='install.CMD'
 progname = 'playlist.exe'
 DllName = 'VROBJ.DLL'

 If RxFuncQuery('SysLoadFuncs') <> 0 Then Do
   Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   Call SysLoadFuncs
   End

/* Attempt to copy Dll to \os2\dll */
copy 'vrobj.dll \os2\dll'

/* Get path  */
 Parse Upper Source . . path
 path = Left(path,Lastpos('\',path))

/* Must be in same dir    */
 program = path || progname
 If Stream( program, 'C', 'QUERY EXISTS') = '' then do
   Say ''
   Say 'This utility must be in the same directory as' progname
   Exit 1
   end

/* Set up Playlist object */
 class = 'WPProgram'
 title = 'Playlist 2.0'
 location = '<WP_DESKTOP>'
 setup = 'ObjectID=<PLAYLIST>;ExeName=' || program || ';ProgType=PM;'
 option = 'UPDATE'
 rc = SysCreateObject( class, title, location, setup, option)
 If rc = 0 then do
   Say ''
   Say 'Error.  Unable to create Playlist program object.'
   Exit 1
   end

 Say 'Playlist object has been placed on your Desktop.'
 Say 'Double-click on the icon to start the program.'
 Exit
