/* REVERB */
signal on error name fineko
signal on failure name fineko
signal on halt name fineko

parse value init() with rcy
if rcy \= 0 then signal fineko

parse upper arg filein ritardo ampiezza

if (filein == "") | (ritardo == "") then do
  say "REVERB:"
  say "Aggiunge il riverbero ad un file audio WAV stereo"
  say ""
  say "Uso:"
  say "      REVERB nome_file ritardo ampiezza"
  say ""
  say "Parametri:"
  say "      nome_file    il nome di un file WAV (con estenzione)"
  say "      ritardo      il tempo di riverbero (secondi) oppure..."
  say "                   una combinazione predefinita ('MIN', 'MED' o 'MAX')"
  say "      ampiezza     l'ampiezza del suono riverberato (decibel)"
  return 1
  end


select
  when ritardo=="MIN"
    then do
     r.0 = 3
     a.0 = 3
     r.1 = 0.027
     a.1 = 19
     r.2 = 0.066
     a.2 = 21
     r.3 = 0.103
     a.3 = 24
    end
  when ritardo=="MED"
    then do
     r.0 = 6
     a.0 = 6
     r.1 = 0.024
     a.1 = 14
     r.2 = 0.035
     a.2 = 16
     r.3 = 0.060
     a.3 = 18
     r.4 = 0.087
     a.4 = 20
     r.5 = 0.133
     a.5 = 21
     r.6 = 0.275
     a.6 = 23
    end
  when ritardo=="MAX"
    then do
     r.0 = 12
     a.0 = 12
     r.1 = 0.021
     a.1 = 13
     r.2 = 0.026
     a.2 = 15
     r.3 = 0.032
     a.3 = 16
     r.4 = 0.047
     a.4 = 18
     r.5 = 0.085
     a.5 = 20
     r.6 = 0.131
     a.6 = 23
     r.7 = 0.232
     a.7 = 28
     r.8 = 0.292
     a.8 = 29
     r.9 = 0.313
     a.9 = 31
     r.10 = 0.432
     a.10 = 32
     r.11 = 0.522
     a.11 = 32
     r.12 = 0.684
     a.12 = 35
    end
  otherwise do
     if ampiezza == "" then signal fineko
     r.0 = 1
     a.0 = 1
     r.1 = ritardo
     a.1 = ampiezza
    end
  end


call SysCls
fc=44100
filetmp="tmp.wav"
t=time(R)

max_r=0
do i=1 to r.0
   if r.i > max_r then max_r=r.i
   end

c = trunc(chkwav(filein) + (max_r*fc))
say "REVERB:"
say ""
say "   filein       :" filein
say ""
say "Ci sono" r.0 "componenti di ritardo con un rit. massimo di" max_r
say ""

tr1 = WavAllocTrac(c)
tr2 = WavAllocTrac(c)
say time(E) ":" c*4 "bytes memoria allocata"
rcy = WavReadStereo(filein, tr1, tr2)
say time(E) ":" filein "caricato in memoria"

do i=1 to r.0
   if a.i>0 then a.i = a.i * -1
   kv = 1 * pow(10, (a.i/20))
   say "   componente   :" i "  ritardo (sec):" r.i "  ampiezza (db):" a.i "    kv=" trunc(kv*100)
   a.i = kv
   r.i = r.i * fc
   end

rcy = WavReverb(tr1, c, r., a.)
rcy = WavReverb(tr2, c, r., a.)

/* preview */
ctmp = fc * 10
if c<ctmp then ctmp = c
rcy = WavWriteStereo(filetmp, tr1, tr2, ctmp)
say time(E) ":" ctmp*4 "bytes scritti in" filetmp
call play "FILE="filetmp
say "OK? [s/N]"
pull resp

if ((resp=="s") | (resp=="S")) then do
   rcy = WavWriteStereo(filein, tr1, tr2, c)
   say time(E) ":" c*4 "bytes scritti in" filein
   end

fine:
rcy = WavDropTrac(tr1)
rcy = WavDropTrac(tr2)
say time(E) ": memoria rilasciata"
return 0



fineko:
say "fine ko !!!"
pull k
"exit"
/**********************************************************************/


