/* CUT */
signal on error name fineko
signal on failure name fineko
signal on halt name fineko

parse value init() with rcy
if rcy \= 0 then signal fineko

parse upper arg filein offset durata

if (filein == "") | (offset == "") | (durata == "") then do
  say "CUT:"
  say "Elimina un segmento all'interno di file audio WAV stereo,"
  say ""
  say "Uso:"
  say "      CUT nome_file offset durata"
  say ""
  say "Parametri:"
  say "      nome_file    il nome di un file WAV stereo (con estenzione)"
  say "      offset       l'offset di inizio del segmento (secondi)"
  say "      durata       la durata del segmento da eliminare (secondi)"
  return 1
  end


fc=44100

call SysCls
t=time(R)
c = chkwav(filein)
if offset>(c/fc) then signal fineko

say "CUT:"
say ""
say "   filein      :" filein
say "   offset (sec):" offset
say "   durata (sec):" durata
say ""


tr1 = WavAllocTrac(c)
tr2 = WavAllocTrac(c)
say time(E) ":" c*4 "bytes memoria allocata"

rcy = WavReadStereo(filein, tr1, tr2)
say time(E) ":" filein "caricato in memoria"

tri1=tr1 + (offset*fc)
tri2=tr2 + (offset*fc)
rcy = WavCopyTrac(tri1 + (durata*fc), tri1, (c-((offset+durata)*fc)), 1, 1, 'COST', 'NOMIX')
rcy = WavCopyTrac(tri2 + (durata*fc), tri2, (c-((offset+durata)*fc)), 1, 1, 'COST', 'NOMIX')

say time(E) ": segmento eliminato"

rcy = WavWriteStereo(filein, tr1, tr2, (c-(durata*fc)))
say time(E) ":" (c-(durata*fc))*4 "bytes scritti in" filein


fine:
rcy = WavDropTrac(tr1)
rcy = WavDropTrac(tr2)
say time(E) ": memoria rilasciata"
return 0



fineko:
say "fine ko !!!"
pull k
"exit"
/**********************************************************************/


