/*
 * filters.h
 *
 * Description:	 TTAv1 filters functions
 * Developed by: Alexander Djourik <ald@true-audio.com>
 *               Pavel Zhilin <pzh@true-audio.com>
 *
 * Copyright (c) 1999-2005 Alexander Djourik. All rights reserved.
 *
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * aint with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Please see the file COPYING in this directory for full copyright
 * information.
 */

#ifndef FILTERS_H
#define FILTERS_H

///////// Filter Settings //////////
static long flt_set [4][2] = {
	{10,1}, {9,1}, {10,1}, {12,0}
};

#if defined(__WATCOMC__)
extern void memshl32(long *p);
#pragma aux memshl32 = \
	"mov eax, [esi+4]" \
	"mov ebx, [esi+8]" \
	"mov ecx, [esi+12]" \
	"mov edx, [esi+16]" \
	"mov [esi], eax" \
	"mov [esi+4], ebx" \
	"mov [esi+8], ecx]" \
	"mov [esi+12], edx]" \
	"mov eax, [esi+20]" \
	"mov ebx, [esi+24]" \
	"mov ecx, [esi+28]" \
	"mov edx, [esi+32]" \
	"mov [esi+16], eax" \
	"mov [esi+20], ebx" \
	"mov [esi+24], ecx" \
	"mov [esi+28], edx" \
	parm [esi] \
	modify [eax ebx ecx edx];

extern long filer_noerr(long *pA, long *pB);
#pragma aux filter_noerr = \
	"mov eax, [esi]" \
	"mov edx, [edi]" \
	"imul edx" \
	"mov ecx, eax" \
	"mov eax, [esi+4]" \
	"mov edx, [edi+4]" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [esi+8]" \
	"mov edx, [edi+8]" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [esi+12]" \
	"mov edx, [edi+12]" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [esi+16]" \
	"mov edx, [edi+16]" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [esi+20]" \
	"mov edx, [edi+20]" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [esi+24]" \
	"mov edx, [edi+24]" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [esi+28]" \
	"mov edx, [edi+28]" \
	"imul edx" \
	"add eax, ecx" \
	parm [esi] [edi] \
	value [eax] \
	modify [ecx edx];

extern long filer_err_m(long *pA, long *pB, long *pM);
#pragma aux filter_err_m = \
	"mov eax, [edi]" \
	"sub eax, [ebx]" \
	"mov edx, [esi]" \
	"mov [edi], eax" \
	"imul edx" \
	"mov ecx, eax" \
	"mov eax, [edi+4]" \
	"sub eax, [ebx+4]" \
	"mov edx, [esi+4]" \
	"mov [edi+4], eax" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [edi+8]" \
	"sub eax, [ebx+8]" \
	"mov edx, [esi+8]" \
	"mov [edi+8], eax" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [edi+12]" \
	"sub eax, [ebx+12]" \
	"mov edx, [esi+12]" \
	"mov [edi+12], eax" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [edi+16]" \
	"sub eax, [ebx+16]" \
	"mov edx, [esi+16]" \
	"mov [edi+16], eax" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [edi+20]" \
	"sub eax, [ebx+20]" \
	"mov edx, [esi+20]" \
	"mov [edi+20], eax" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [edi+24]" \
	"sub eax, [ebx+24]" \
	"mov edx, [esi+24]" \
	"mov [edi+24], eax" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [edi+28]" \
	"sub eax, [ebx+28]" \
	"mov edx, [esi+28]" \
	"mov [edi+28], eax" \
	"imul edx" \
	"add eax, ecx" \
	parm [esi] [edi] [ebx] \
	value [eax] \
	modify [ecx edx];

extern long filer_err_p(long *pA, long *pB, long *pM);
#pragma aux filter_err_p = \
	"mov eax, [edi]" \
	"add eax, [ebx]" \
	"mov edx, [esi]" \
	"mov [edi], eax" \
	"imul edx" \
	"mov ecx, eax" \
	"mov eax, [edi+4]" \
	"add eax, [ebx+4]" \
	"mov edx, [esi+4]" \
	"mov [edi+4], eax" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [edi+8]" \
	"add eax, [ebx+8]" \
	"mov edx, [esi+8]" \
	"mov [edi+8], eax" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [edi+12]" \
	"add eax, [ebx+12]" \
	"mov edx, [esi+12]" \
	"mov [edi+12], eax" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [edi+16]" \
	"add eax, [ebx+16]" \
	"mov edx, [esi+16]" \
	"mov [edi+16], eax" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [edi+20]" \
	"add eax, [ebx+20]" \
	"mov edx, [esi+20]" \
	"mov [edi+20], eax" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [edi+24]" \
	"add eax, [ebx+24]" \
	"mov edx, [esi+24]" \
	"mov [edi+24], eax" \
	"imul edx" \
	"add ecx, eax" \
	"mov eax, [edi+28]" \
	"add eax, [ebx+28]" \
	"mov edx, [esi+28]" \
	"mov [edi+28], eax" \
	"imul edx" \
	"add eax, ecx" \
	parm [esi] [edi] [ebx] \
	value [eax] \
	modify [ecx edx];
#else
__inline void
memshl (register long *pA, register long *pB) {
	*pA++ = *pB++;
	*pA++ = *pB++;
	*pA++ = *pB++;
	*pA++ = *pB++;
	*pA++ = *pB++;
	*pA++ = *pB++;
	*pA++ = *pB++;
	*pA   = *pB;
}
#endif


__inline void
hybrid_filter (fltst *fs, long *in, long mode) {
	register long *pA = fs->dl;
	register long *pB = fs->qm;
	register long *pM = fs->dx;
	register long sum = fs->round;

	if (!fs->error) {
#if defined(__WATCOMC__)
		sum += filter_noerr(pA, pB);
		pA += 8;
		pB += 8;
		pM += 8;
#else
		sum += *pA++ * *pB, pB++;
		sum += *pA++ * *pB, pB++;
		sum += *pA++ * *pB, pB++;
		sum += *pA++ * *pB, pB++;
		sum += *pA++ * *pB, pB++;
		sum += *pA++ * *pB, pB++;
		sum += *pA++ * *pB, pB++;
		sum += *pA++ * *pB, pB++; pM += 8;
#endif
	} else if (fs->error < 0) {
#if defined(__WATCOMC__)
		sum += filter_err_m(pA, pB, pM);
		pA += 8;
		pB += 8;
		pM += 8;
#else
		sum += *pA++ * (*pB -= *pM++), pB++;
		sum += *pA++ * (*pB -= *pM++), pB++;
		sum += *pA++ * (*pB -= *pM++), pB++;
		sum += *pA++ * (*pB -= *pM++), pB++;
		sum += *pA++ * (*pB -= *pM++), pB++;
		sum += *pA++ * (*pB -= *pM++), pB++;
		sum += *pA++ * (*pB -= *pM++), pB++;
		sum += *pA++ * (*pB -= *pM++), pB++;
#endif
	} else {
#if defined(__WATCOMC__)
		sum += filter_err_p(pA, pB, pM);
		pA += 8;
		pB += 8;
		pM += 8;
#else
		sum += *pA++ * (*pB += *pM++), pB++;
		sum += *pA++ * (*pB += *pM++), pB++;
		sum += *pA++ * (*pB += *pM++), pB++;
		sum += *pA++ * (*pB += *pM++), pB++;
		sum += *pA++ * (*pB += *pM++), pB++;
		sum += *pA++ * (*pB += *pM++), pB++;
		sum += *pA++ * (*pB += *pM++), pB++;
		sum += *pA++ * (*pB += *pM++), pB++;
#endif
	}

	*(pM-0) = ((*(pA-1) >> 30) | 1) << 2;
	*(pM-1) = ((*(pA-2) >> 30) | 1) << 1;
	*(pM-2) = ((*(pA-3) >> 30) | 1) << 1;
	*(pM-3) = ((*(pA-4) >> 30) | 1);

	if (mode) {
		*pA = *in;
		*in -= (sum >> fs->shift);
		fs->error = *in;
	} else {
		fs->error = *in;
		*in += (sum >> fs->shift);
		*pA = *in;
	}

	if (fs->mutex) {
		*(pA-1) = *(pA-0) - *(pA-1);
		*(pA-2) = *(pA-1) - *(pA-2);
		*(pA-3) = *(pA-2) - *(pA-3);
	}

#if defined(__WATCOMC__)
	memshl32(fs->dl);
	memshl32(fs->dx);
#else
	memshl (fs->dl, fs->dl + 1);
	memshl (fs->dx, fs->dx + 1);
#endif
}

void
filter_init (fltst *fs, long shift, long mode) {
	memset (fs, 0, sizeof(fltst));
	fs->shift = shift;
	fs->round = 1 << (shift - 1);
	fs->mutex = mode;
}

#endif	/* FILTERS_H */
