/* REXX deinstallation script for WarpTuner
 * Copyright (C) 1998 by Dmitry Malenok
 *
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/*------------------------------------------------------------------
 * Initialization 
 *------------------------------------------------------------------*/

installdir = directory()"\"
installlog = installdir"install.log"

if RxMessageBox( "Uninstall WarpTuner ?", "", "YesNo", "Query" ) == 7 then
   exit

/*------------------------------------------------------------------
 * Delete WarpTuner objects
 *------------------------------------------------------------------*/

rc = SysDestroyObject("<WTFolder>")

if rc then
   call log "WarpTuner objects removed from desktop..."
else 
   call log "ERROR: WarpTuner object removing failed!"

/*------------------------------------------------------------------
 * Remove DEVICE statement from CONFIG.SYS
 *------------------------------------------------------------------*/

/*------------------------------------------------------------------
 * Remove Driver
 *------------------------------------------------------------------*/

rc = SysIni( "BOTH", "FolderWorkareaRunningObjects", "ALL:", "objects" );
configsys = left( objects.1, 2 )"\CONFIG.SYS"
call log "CONFIG.SYS found as: "configsys"..."

configbak = SysTempFileName( left( objects.1, 2 )"\CONFIG.???" )
"@copy "configsys" "configbak" 1>NUL 2>NUL"

if rc == 0 then
   call log "Backup copy of "configsys" is placed in "configbak"..."
else 
   call log "ERROR: Creating backup copy of "configsys" failed!"

i = 1
do while lines(configsys)
   config.i = linein(configsys)
   parse value translate(config.i) with  command "=" devpath
   
   if command \= "DEVICE" | lastpos( "TURNON.SYS", devpath ) == 0 then
      i = i + 1
end
config.0 = i - 1
rc = stream( configsys, 'c', 'close' )
'@del 'configsys

rc = lineout( configsys,,1 )
do i = 1 to config.0
   rc = lineout( configsys, config.i )
end
rc = stream( configsys, 'c', 'close' )

call log "Driver removed from "configsys"..."

rc = SysIni( ,'Mini WarpTuner',, 'DELETE:')
call log "Mini WarpTuner record removed from OS2.INI..."
call log "------------------ Done! -----------------------"
exit

/*------------------------------------------------------------------
 * Get Yes or No
 *------------------------------------------------------------------*/
GetYesNo: procedure

   ok = 0

   do until ok
      call charout, arg(1) || "? "
      pull reply
      reply = left(reply, 1)
      ok = (reply = "Y") | (reply = "N")
      if \ok then do
         say 'Huh? Please enter "Y" or "N".'
      end
   end

return (reply = "Y")

/*------------------------------------------------------------------
 * Write log message
 *------------------------------------------------------------------*/
Log: procedure expose installlog; parse arg msg

   say  " "msg
   call lineout installlog, "UNINSTL: "msg

return
